/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class AquaMenuItemUI
extends BasicMenuItemUI
implements AquaMenuPainter.Client {
    static final int kPlain = 0;
    static final int kCheckBox = 1;
    static final int kRadioButton = 2;
    static final String[] sPropertyPrefixes = new String[]{"MenuItem", "CheckBoxMenuItem", "RadioButtonMenuItem"};
    boolean fIsScreenMenuItem = false;
    boolean fIsIndeterminate = false;
    int fType;
    static final IndeterminateListener INDETERMINATE_LISTENER = new IndeterminateListener();

    AquaMenuItemUI(int type) {
        this.fType = type;
    }

    public static ComponentUI createUI(JComponent c) {
        int type = 0;
        if (c instanceof JCheckBoxMenuItem) {
            type = 1;
        }
        if (c instanceof JRadioButtonMenuItem) {
            type = 2;
        }
        return new AquaMenuItemUI(type);
    }

    @Override
    protected String getPropertyPrefix() {
        return sPropertyPrefixes[this.fType];
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        IndeterminateListener.install(this.menuItem);
    }

    @Override
    protected void uninstallListeners() {
        IndeterminateListener.uninstall(this.menuItem);
        super.uninstallListeners();
    }

    public void updateListenersForScreenMenuItem() {
        this.setIsScreenMenu(true);
    }

    protected void setIsScreenMenu(boolean isScreenMenuItem) {
        if (this.fIsScreenMenuItem != isScreenMenuItem) {
            this.fIsScreenMenuItem = isScreenMenuItem;
            if (this.fIsScreenMenuItem) {
                this.removeListeners();
            } else {
                this.addListeners();
            }
        }
    }

    protected void removeListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void addListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon localCheckIcon, Icon localArrowIcon, Color background, Color foreground, int localDefaultTextIconGap) {
        AquaMenuPainter.instance().paintMenuItem(this, g, c, localCheckIcon, localArrowIcon, background, foreground, this.disabledForeground, this.selectionForeground, localDefaultTextIconGap, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon localCheckIcon, Icon localArrowIcon, int localDefaultTextIconGap) {
        return AquaMenuPainter.instance().getPreferredMenuItemSize(c, localCheckIcon, localArrowIcon, localDefaultTextIconGap, this.acceleratorFont);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Color oldColor = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(oldColor);
        }
        this.paint(g, c);
    }

    @Override
    public void paintBackground(Graphics g, JComponent c, int menuWidth, int menuHeight) {
        if (c.getParent() instanceof JMenuBar) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, menuWidth, menuHeight);
        if (((JMenuItem)c).isBorderPainted()) {
            if (((JMenuItem)c).getModel().isArmed()) {
                AquaMenuPainter.instance().paintSelectedMenuItemBackground(g, menuWidth, menuHeight);
            }
        } else if (((JMenuItem)c).getModel().isArmed()) {
            Color holdc = g.getColor();
            g.setColor(Color.black);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(holdc);
        } else {
            g.setColor(Color.green);
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    @Override
    protected void doClick(MenuSelectionManager msm) {
        final Dimension size = this.menuItem.getSize();
        AquaUtils.blinkMenu(new AquaUtils.Selectable(){

            @Override
            public void paintSelected(boolean selected) {
                AquaMenuItemUI.this.menuItem.setArmed(selected);
                AquaMenuItemUI.this.menuItem.paintImmediately(0, 0, size.width, size.height);
            }
        });
        super.doClick(msm);
    }

    static class IndeterminateListener
    implements PropertyChangeListener {
        static final String CLIENT_PROPERTY_KEY = "JMenuItem.selectedState";

        IndeterminateListener() {
        }

        static void install(JMenuItem menuItem) {
            menuItem.addPropertyChangeListener(CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
            IndeterminateListener.apply(menuItem, menuItem.getClientProperty(CLIENT_PROPERTY_KEY));
        }

        static void uninstall(JMenuItem menuItem) {
            menuItem.removePropertyChangeListener(CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String key = evt.getPropertyName();
            if (!CLIENT_PROPERTY_KEY.equalsIgnoreCase(key)) {
                return;
            }
            Object source = evt.getSource();
            if (!(source instanceof JMenuItem)) {
                return;
            }
            JMenuItem c = (JMenuItem)source;
            IndeterminateListener.apply(c, evt.getNewValue());
        }

        static void apply(JMenuItem menuItem, Object value) {
            ButtonUI ui = menuItem.getUI();
            if (!(ui instanceof AquaMenuItemUI)) {
                return;
            }
            AquaMenuItemUI aquaUI = (AquaMenuItemUI)ui;
            aquaUI.fIsIndeterminate = "indeterminate".equals(value);
            if (aquaUI.fIsIndeterminate) {
                aquaUI.checkIcon = UIManager.getIcon(aquaUI.getPropertyPrefix() + ".dashIcon");
            } else {
                aquaUI.checkIcon = UIManager.getIcon(aquaUI.getPropertyPrefix() + ".checkIcon");
            }
        }

        public static boolean isIndeterminate(JMenuItem menuItem) {
            return "indeterminate".equals(menuItem.getClientProperty(CLIENT_PROPERTY_KEY));
        }
    }
}

