/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaComboBoxRenderer;
import com.apple.laf.AquaFocusHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class AquaListUI
extends BasicListUI {
    public static ComponentUI createUI(JComponent c) {
        return new AquaListUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    JList<Object> getComponent() {
        return this.list;
    }

    protected void repaintCell(Object value, int selectedIndex, boolean selected) {
        AquaComboBoxRenderer aquaRenderer;
        Rectangle rowBounds = this.getCellBounds(this.list, selectedIndex, selectedIndex);
        if (rowBounds == null) {
            return;
        }
        ListCellRenderer<Object> renderer = this.list.getCellRenderer();
        if (renderer == null) {
            return;
        }
        Component rendererComponent = renderer.getListCellRendererComponent(this.list, value, selectedIndex, selected, true);
        if (rendererComponent == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer = aquaRenderer = renderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)renderer : null;
        if (aquaRenderer != null) {
            aquaRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), rendererComponent, this.list, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
        if (aquaRenderer != null) {
            aquaRenderer.setDrawCheckedItem(true);
        }
    }

    public static Border getSourceListBackgroundPainter() {
        ComponentPainter border = new ComponentPainter();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR);
        return border;
    }

    public static Border getSourceListSelectionBackgroundPainter() {
        ComponentPainter border = new ComponentPainter();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_SELECTION);
        return border;
    }

    public static Border getSourceListFocusedSelectionBackgroundPainter() {
        ComponentPainter border = new ComponentPainter();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Variant.GRADIENT_SIDE_BAR_FOCUSED_SELECTION);
        return border;
    }

    public static Border getListEvenBackgroundPainter() {
        ComponentPainter border = new ComponentPainter();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_EVEN);
        return border;
    }

    public static Border getListOddBackgroundPainter() {
        ComponentPainter border = new ComponentPainter();
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Widget.GRADIENT);
        ((JRSUIState)border.painter.state).set(JRSUIConstants.Variant.GRADIENT_LIST_BACKGROUND_ODD);
        return border;
    }

    static class ComponentPainter
    extends AquaBorder.Default {
        ComponentPainter() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent jc;
            JComponent jComponent = jc = c instanceof JComponent ? (JComponent)c : null;
            if (jc != null && !AquaFocusHandler.isActive(jc)) {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.State.INACTIVE);
            } else {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.State.ACTIVE);
            }
            super.paintBorder(c, g, x, y, w, h);
        }
    }

    class MouseInputHandler
    extends BasicListUI.MouseInputHandler {
        MouseInputHandler() {
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("Frame.active".equals(prop)) {
                AquaBorder.repaintBorder(AquaListUI.this.getComponent());
                AquaFocusHandler.swapSelectionColors("List", AquaListUI.this.getComponent(), e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }
    }

    class FocusHandler
    extends BasicListUI.FocusHandler {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            AquaBorder.repaintBorder(AquaListUI.this.getComponent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            AquaBorder.repaintBorder(AquaListUI.this.getComponent());
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction = false;

        protected AquaHomeEndAction(boolean isHomeAction) {
            this.fHomeAction = isHomeAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = (JList)e.getSource();
            if (this.fHomeAction) {
                list.ensureIndexIsVisible(0);
            } else {
                int size = list.getModel().getSize();
                list.ensureIndexIsVisible(size - 1);
            }
        }
    }
}

