/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaInternalFramePaneUI;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.JInternalFrame;

public class AquaInternalFrameManager
extends DefaultDesktopManager {
    JInternalFrame fCurrentFrame;
    JInternalFrame fInitialFrame;
    AquaInternalFramePaneUI fCurrentPaneUI;
    Vector<JInternalFrame> fChildFrames = new Vector(1);

    @Override
    public void closeFrame(JInternalFrame f) {
        if (f == this.fCurrentFrame) {
            this.activateNextFrame();
        }
        this.fChildFrames.removeElement(f);
        super.closeFrame(f);
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        f.reshape(desktopIcon.getX(), desktopIcon.getY(), f.getWidth(), f.getHeight());
        super.deiconifyFrame(f);
    }

    void addIcon(Container c, JInternalFrame.JDesktopIcon desktopIcon) {
        c.add(desktopIcon);
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        Container c;
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        Rectangle r = this.getBoundsForIconOf(f);
        desktopIcon.setBounds(r.x, r.y, r.width, r.height);
        if (!this.wasIcon(f)) {
            this.setWasIcon(f, Boolean.TRUE);
        }
        if ((c = f.getParent()) == null) {
            return;
        }
        c.remove(f);
        this.addIcon(c, desktopIcon);
        c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        try {
            if (f != null) {
                super.activateFrame(f);
            }
            if (this.fChildFrames.indexOf(f) == -1) {
                this.fChildFrames.addElement(f);
            }
            if (this.fCurrentFrame != null && f != this.fCurrentFrame && this.fCurrentFrame.isSelected()) {
                this.fCurrentFrame.setSelected(false);
            }
            if (f != null && !f.isSelected()) {
                f.setSelected(true);
            }
            this.fCurrentFrame = f;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void switchFrame(boolean next) {
        int nextIndex;
        if (this.fCurrentFrame == null) {
            if (this.fInitialFrame != null) {
                this.activateFrame(this.fInitialFrame);
            }
            return;
        }
        int count = this.fChildFrames.size();
        if (count <= 1) {
            return;
        }
        int currentIndex = this.fChildFrames.indexOf(this.fCurrentFrame);
        if (currentIndex == -1) {
            this.fCurrentFrame = null;
            return;
        }
        if (next) {
            nextIndex = currentIndex + 1;
            if (nextIndex == count) {
                nextIndex = 0;
            }
        } else {
            nextIndex = currentIndex - 1;
            if (nextIndex == -1) {
                nextIndex = count - 1;
            }
        }
        JInternalFrame f = this.fChildFrames.elementAt(nextIndex);
        this.activateFrame(f);
        this.fCurrentFrame = f;
    }

    public void activateNextFrame() {
        this.switchFrame(true);
    }

    public void activateNextFrame(JInternalFrame f) {
        this.fInitialFrame = f;
        this.switchFrame(true);
    }

    public void activatePreviousFrame() {
        this.switchFrame(false);
    }
}

