/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.UIManager;

public class AquaFocus {
    static boolean paintFocus(Graphics g, Drawable drawable) {
        return false;
    }

    public static Icon createFocusedIcon(Icon tmpIcon, Component c, int slack) {
        return new FocusedIcon(tmpIcon, slack);
    }

    static class FocusedIcon
    extends AquaUtils.ShadowBorder
    implements Icon {
        final Icon icon;
        final int slack;

        public FocusedIcon(final Icon icon, final int slack) {
            super(new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    Graphics2D imgG = (Graphics2D)g;
                    imgG.setComposite(AlphaComposite.Src);
                    imgG.setColor(UIManager.getColor("Focus.color"));
                    imgG.fillRect(x, y, w - slack * 2, h - slack * 2);
                    imgG.setComposite(AlphaComposite.DstAtop);
                    icon.paintIcon(null, imgG, x, y);
                }
            }, new AquaUtils.Painter(){

                @Override
                public void paint(Graphics g, int x, int y, int w, int h) {
                    ((Graphics2D)g).setComposite(AlphaComposite.SrcAtop);
                    icon.paintIcon(null, g, x, y);
                }
            }, slack, slack, 0.0f, 1.8f, 7);
            this.icon = icon;
            this.slack = slack;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight() + this.slack + this.slack;
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.slack + this.slack;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintBorder(c, g, x, y, this.getIconWidth(), this.getIconHeight());
            this.icon.paintIcon(c, g, x + this.slack, y + this.slack);
        }
    }

    static interface Drawable {
        public void draw(Graphics2D var1);
    }
}

