/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import java.awt.GraphicsEnvironment;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaEditorPaneUI
extends BasicEditorPaneUI {
    boolean oldDragState = false;
    FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new AquaEditorPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = this.createFocusListener();
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings bindings = AquaKeyBindings.instance();
        bindings.setDefaultAction(this.getKeymapName());
        JTextComponent c = this.getComponent();
        bindings.installAquaUpDownActions(c);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        super.uninstallListeners();
    }

    protected FocusListener createFocusListener() {
        return new AquaFocusHandler();
    }

    @Override
    protected Caret createCaret() {
        return new AquaCaret();
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

