/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonLabeledUI;
import com.apple.laf.AquaNativeResources;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;

public class AquaButtonRadioUI
extends AquaButtonLabeledUI {
    private KeyListener keyListener = null;
    private static final AquaUtils.RecyclableSingleton<AquaButtonRadioUI> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonRadioUI>(AquaButtonRadioUI.class);
    private static final AquaUtils.RecyclableSingleton<ImageIcon> sizingIcon = new AquaUtils.RecyclableSingleton<ImageIcon>(){

        @Override
        protected ImageIcon getInstance() {
            return new ImageIcon(AquaNativeResources.getRadioButtonSizerImage());
        }
    };

    public static ComponentUI createUI(JComponent b) {
        return instance.get();
    }

    public static Icon getSizingRadioButtonIcon() {
        return sizingIcon.get();
    }

    @Override
    protected String getPropertyPrefix() {
        return "RadioButton.";
    }

    @Override
    protected AquaButtonBorder getPainter() {
        return new RadioButtonBorder();
    }

    private KeyListener createKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyHandler();
        }
        return this.keyListener;
    }

    private boolean isValidRadioButtonObj(Object obj) {
        return obj instanceof JRadioButton && ((JRadioButton)obj).isVisible() && ((JRadioButton)obj).isEnabled();
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
        if (!(button instanceof JRadioButton)) {
            return;
        }
        this.keyListener = this.createKeyListener();
        button.addKeyListener(this.keyListener);
        button.setFocusTraversalKeysEnabled(false);
        button.getActionMap().put("Previous", new SelectPreviousBtn());
        button.getActionMap().put("Next", new SelectNextBtn());
        button.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        if (!(button instanceof JRadioButton)) {
            return;
        }
        button.getActionMap().remove("Previous");
        button.getActionMap().remove("Next");
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
        if (this.keyListener != null) {
            button.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    private void selectRadioButton(ActionEvent event, boolean next) {
        Object eventSrc = event.getSource();
        if (!this.isValidRadioButtonObj(eventSrc)) {
            return;
        }
        ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo((JRadioButton)eventSrc);
        btnGroupInfo.selectNewButton(next);
    }

    private class KeyHandler
    implements KeyListener {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JRadioButton source;
            boolean next;
            AWTKeyStroke stroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
            if (stroke != null && e.getSource() instanceof JRadioButton && ((next = this.isFocusTraversalKey(source = (JRadioButton)e.getSource(), 0, stroke)) || this.isFocusTraversalKey(source, 1, stroke))) {
                e.consume();
                ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo(source);
                btnGroupInfo.jumpToNextComponent(next);
            }
        }

        private boolean isFocusTraversalKey(JComponent c, int id, AWTKeyStroke stroke) {
            Set<AWTKeyStroke> keys = c.getFocusTraversalKeys(id);
            return keys != null && keys.contains(stroke);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class ButtonGroupInfo {
        JRadioButton activeBtn = null;
        JRadioButton firstBtn = null;
        JRadioButton lastBtn = null;
        JRadioButton previousBtn = null;
        JRadioButton nextBtn = null;
        HashSet<JRadioButton> btnsInGroup = null;
        boolean srcFound = false;

        public ButtonGroupInfo(JRadioButton btn) {
            this.activeBtn = btn;
            this.btnsInGroup = new HashSet();
        }

        boolean containsInGroup(Object obj) {
            return this.btnsInGroup.contains(obj);
        }

        Component getFocusTransferBaseComponent(boolean next) {
            return this.firstBtn;
        }

        boolean getButtonGroupInfo() {
            if (this.activeBtn == null) {
                return false;
            }
            this.btnsInGroup.clear();
            ButtonModel model = this.activeBtn.getModel();
            if (!(model instanceof DefaultButtonModel)) {
                return false;
            }
            DefaultButtonModel bm = (DefaultButtonModel)model;
            ButtonGroup group = bm.getGroup();
            if (group == null) {
                return false;
            }
            Enumeration<AbstractButton> e = group.getElements();
            if (e == null) {
                return false;
            }
            while (e.hasMoreElements()) {
                AbstractButton curElement = e.nextElement();
                if (!AquaButtonRadioUI.this.isValidRadioButtonObj(curElement)) continue;
                this.btnsInGroup.add((JRadioButton)curElement);
                if (null == this.firstBtn) {
                    this.firstBtn = (JRadioButton)curElement;
                }
                if (this.activeBtn == curElement) {
                    this.srcFound = true;
                } else if (!this.srcFound) {
                    this.previousBtn = (JRadioButton)curElement;
                } else if (this.nextBtn == null) {
                    this.nextBtn = (JRadioButton)curElement;
                }
                this.lastBtn = (JRadioButton)curElement;
            }
            return true;
        }

        void selectNewButton(boolean next) {
            if (!this.getButtonGroupInfo()) {
                return;
            }
            if (this.srcFound) {
                JRadioButton newSelectedBtn = null;
                if (next) {
                    newSelectedBtn = null == this.nextBtn ? this.firstBtn : this.nextBtn;
                } else {
                    JRadioButton jRadioButton = newSelectedBtn = null == this.previousBtn ? this.lastBtn : this.previousBtn;
                }
                if (newSelectedBtn != null && newSelectedBtn != this.activeBtn) {
                    newSelectedBtn.requestFocusInWindow();
                    newSelectedBtn.setSelected(true);
                }
            }
        }

        void jumpToNextComponent(boolean next) {
            Component focusBase;
            if (!this.getButtonGroupInfo()) {
                if (this.activeBtn != null) {
                    this.lastBtn = this.activeBtn;
                    this.firstBtn = this.activeBtn;
                } else {
                    return;
                }
            }
            if ((focusBase = this.getFocusTransferBaseComponent(next)) != null) {
                if (next) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(focusBase);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(focusBase);
                }
            }
        }
    }

    public static class RadioButtonBorder
    extends AquaButtonLabeledUI.LabeledButtonBorder {
        public RadioButtonBorder() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().replaceMargins("RadioButton.margin")));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_RADIO);
        }

        public RadioButtonBorder(RadioButtonBorder other) {
            super(other);
        }
    }

    private class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaButtonRadioUI.this.selectRadioButton(e, true);
        }
    }

    private class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaButtonRadioUI.this.selectRadioButton(e, false);
        }
    }
}

