/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import com.apple.laf.AquaImageFactory;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class JRSUIUtils {
    static boolean isLeopard = JRSUIUtils.isMacOSXLeopard();
    static boolean isSnowLeopardOrBelow = JRSUIUtils.isMacOSXSnowLeopardOrBelow();

    static boolean isMacOSXLeopard() {
        return JRSUIUtils.isCurrentMacOSXVersion(5);
    }

    static boolean isMacOSXSnowLeopardOrBelow() {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(6, true, true, false);
    }

    static boolean isCurrentMacOSXVersion(int version) {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(version, true, false, false);
    }

    static boolean currentMacOSXVersionMatchesGivenVersionRange(int version, boolean inclusive, boolean matchBelow, boolean matchAbove) {
        String osVersion = AccessController.doPrivileged(new GetPropertyAction("os.version"));
        String[] fragments = osVersion.split("\\.");
        if (!fragments[0].equals("10")) {
            return false;
        }
        if (fragments.length < 2) {
            return false;
        }
        try {
            int minorVers = Integer.parseInt(fragments[1]);
            if (inclusive && minorVers == version) {
                return true;
            }
            if (matchBelow && minorVers < version) {
                return true;
            }
            if (matchAbove && minorVers > version) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static interface NineSliceMetricsProvider {
        public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState var1);
    }

    public static class HitDetection {
        public static JRSUIConstants.Hit getHitForPoint(JRSUIControl control, int x, int y, int w, int h, int hitX, int hitY) {
            return control.getHitForPoint(x, y, w, h, hitX, hitY);
        }
    }

    public static class Images {
        public static boolean shouldUseLegacySecurityUIPath() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class ScrollBar {
        private static native boolean shouldUseScrollToClick();

        public static boolean useScrollToClick() {
            return ScrollBar.shouldUseScrollToClick();
        }

        public static void getPartBounds(double[] rect, JRSUIControl control, int x, int y, int w, int h, JRSUIConstants.ScrollBarPart part) {
            control.getPartBounds(rect, x, y, w, h, part.ordinal);
        }

        public static double getNativeOffsetChange(JRSUIControl control, int x, int y, int w, int h, int offset, int visibleAmount, int extent) {
            return control.getScrollBarOffsetChange(x, y, w, h, offset, visibleAmount, extent);
        }
    }

    public static class Tree {
        public static boolean useLegacyTreeKnobs() {
            return isLeopard;
        }
    }

    public static class InternalFrame {
        public static boolean shouldUseLegacyBorderMetrics() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class TabbedPane {
        public static boolean useLegacyTabs() {
            return isLeopard;
        }

        public static boolean shouldUseTabbedPaneContrastUI() {
            return !isSnowLeopardOrBelow;
        }
    }
}

