/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;

public class JRSUIState {
    final long encodedState;
    long derivedEncodedState;
    static JRSUIState prototype = new JRSUIState(0L);

    public static JRSUIState getInstance() {
        return prototype.derive();
    }

    JRSUIState(JRSUIConstants.Widget widget) {
        this(widget.apply(0L));
    }

    JRSUIState(long encodedState) {
        this.encodedState = this.derivedEncodedState = encodedState;
    }

    boolean isDerivationSame() {
        return this.encodedState == this.derivedEncodedState;
    }

    public <T extends JRSUIState> T derive() {
        if (this.isDerivationSame()) {
            return (T)this;
        }
        T derivation = this.createDerivation();
        return derivation;
    }

    public <T extends JRSUIState> T createDerivation() {
        return (T)new JRSUIState(this.derivedEncodedState);
    }

    public void reset() {
        this.derivedEncodedState = this.encodedState;
    }

    public void set(JRSUIConstants.Property property) {
        this.derivedEncodedState = property.apply(this.derivedEncodedState);
    }

    public void apply(JRSUIControl control) {
        control.setEncodedState(this.encodedState);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JRSUIState)) {
            return false;
        }
        return this.encodedState == ((JRSUIState)obj).encodedState && this.getClass().equals(obj.getClass());
    }

    public boolean is(JRSUIConstants.Property property) {
        return (byte)((this.derivedEncodedState & property.encoding.mask) >> property.encoding.shift) == property.ordinal;
    }

    public int hashCode() {
        return (int)(this.encodedState ^ this.encodedState >>> 32) ^ this.getClass().hashCode();
    }

    public static class ScrollBarState
    extends ValueState {
        final double thumbProportion;
        double derivedThumbProportion;
        final double thumbStart;
        double derivedThumbStart;

        ScrollBarState(long encodedState, double value, double thumbProportion, double thumbStart) {
            super(encodedState, value);
            this.thumbProportion = this.derivedThumbProportion = thumbProportion;
            this.thumbStart = this.derivedThumbStart = thumbStart;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.thumbProportion == this.derivedThumbProportion && this.thumbStart == this.derivedThumbStart;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new ScrollBarState(this.derivedEncodedState, this.derivedValue, this.derivedThumbProportion, this.derivedThumbStart);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedThumbProportion = this.thumbProportion;
            this.derivedThumbStart = this.thumbStart;
        }

        public void setThumbPercent(double thumbPercent) {
            this.derivedThumbProportion = thumbPercent;
        }

        public void setThumbStart(double thumbStart) {
            this.derivedThumbStart = thumbStart;
        }

        @Override
        public void apply(JRSUIControl control) {
            super.apply(control);
            control.set(JRSUIConstants.Key.THUMB_PROPORTION, this.thumbProportion);
            control.set(JRSUIConstants.Key.THUMB_START, this.thumbStart);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ScrollBarState)) {
                return false;
            }
            return this.thumbProportion == ((ScrollBarState)obj).thumbProportion && this.thumbStart == ((ScrollBarState)obj).thumbStart && super.equals(obj);
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToRawLongBits(this.thumbProportion) ^ Double.doubleToRawLongBits(this.thumbStart);
            return super.hashCode() ^ (int)bits ^ (int)(bits >>> 32);
        }
    }

    public static class TitleBarHeightState
    extends ValueState {
        TitleBarHeightState(long encodedState, double value) {
            super(encodedState, value);
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new TitleBarHeightState(this.derivedEncodedState, this.derivedValue);
        }

        @Override
        public void apply(JRSUIControl control) {
            super.apply(control);
            control.set(JRSUIConstants.Key.WINDOW_TITLE_BAR_HEIGHT, this.value);
        }
    }

    public static class ValueState
    extends JRSUIState {
        final double value;
        double derivedValue;

        ValueState(long encodedState, double value) {
            super(encodedState);
            this.value = this.derivedValue = value;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.value == this.derivedValue;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new ValueState(this.derivedEncodedState, this.derivedValue);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedValue = this.value;
        }

        public void setValue(double value) {
            this.derivedValue = value;
        }

        @Override
        public void apply(JRSUIControl control) {
            super.apply(control);
            control.set(JRSUIConstants.Key.VALUE, this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValueState)) {
                return false;
            }
            return this.value == ((ValueState)obj).value && super.equals(obj);
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToRawLongBits(this.value);
            return super.hashCode() ^ (int)bits ^ (int)(bits >>> 32);
        }
    }

    public static class AnimationFrameState
    extends JRSUIState {
        final int animationFrame;
        int derivedAnimationFrame;

        AnimationFrameState(long encodedState, int animationFrame) {
            super(encodedState);
            this.animationFrame = this.derivedAnimationFrame = animationFrame;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.animationFrame == this.derivedAnimationFrame;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new AnimationFrameState(this.derivedEncodedState, this.derivedAnimationFrame);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedAnimationFrame = this.animationFrame;
        }

        public void setAnimationFrame(int frame) {
            this.derivedAnimationFrame = frame;
        }

        @Override
        public void apply(JRSUIControl control) {
            super.apply(control);
            control.set(JRSUIConstants.Key.ANIMATION_FRAME, this.animationFrame);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof AnimationFrameState)) {
                return false;
            }
            return this.animationFrame == ((AnimationFrameState)obj).animationFrame && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.animationFrame;
        }
    }
}

