/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import com.sun.imageio.plugins.common.StandardMetadataFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;

public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private static IIOMetadataFormat standardFormat = null;
    private String resourceBaseName = this.getClass().getName() + "Resources";
    private String rootName;
    private HashMap<String, Element> elementMap = new HashMap();

    public IIOMetadataFormatImpl(String rootName, int childPolicy) {
        if (rootName == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (childPolicy < 0 || childPolicy > 5 || childPolicy == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        this.rootName = rootName;
        Element root = new Element();
        root.elementName = rootName;
        root.childPolicy = childPolicy;
        this.elementMap.put(rootName, root);
    }

    public IIOMetadataFormatImpl(String rootName, int minChildren, int maxChildren) {
        if (rootName == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (minChildren < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (minChildren > maxChildren) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element root = new Element();
        root.elementName = rootName;
        root.childPolicy = 5;
        root.minChildren = minChildren;
        root.maxChildren = maxChildren;
        this.rootName = rootName;
        this.elementMap.put(rootName, root);
    }

    protected void setResourceBaseName(String resourceBaseName) {
        if (resourceBaseName == null) {
            throw new IllegalArgumentException("resourceBaseName == null!");
        }
        this.resourceBaseName = resourceBaseName;
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    private Element getElement(String elementName, boolean mustAppear) {
        if (mustAppear && elementName == null) {
            throw new IllegalArgumentException("element name is null!");
        }
        Element element = this.elementMap.get(elementName);
        if (mustAppear && element == null) {
            throw new IllegalArgumentException("No such element: " + elementName);
        }
        return element;
    }

    private Element getElement(String elementName) {
        return this.getElement(elementName, true);
    }

    private Attribute getAttribute(String elementName, String attrName) {
        Element element = this.getElement(elementName);
        Attribute attr = element.attrMap.get(attrName);
        if (attr == null) {
            throw new IllegalArgumentException("No such attribute \"" + attrName + "\"!");
        }
        return attr;
    }

    protected void addElement(String elementName, String parentName, int childPolicy) {
        Element parent = this.getElement(parentName);
        if (childPolicy < 0 || childPolicy > 5 || childPolicy == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        Element element = new Element();
        element.elementName = elementName;
        element.childPolicy = childPolicy;
        parent.childList.add(elementName);
        element.parentList.add(parentName);
        this.elementMap.put(elementName, element);
    }

    protected void addElement(String elementName, String parentName, int minChildren, int maxChildren) {
        Element parent = this.getElement(parentName);
        if (minChildren < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (minChildren > maxChildren) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element = new Element();
        element.elementName = elementName;
        element.childPolicy = 5;
        element.minChildren = minChildren;
        element.maxChildren = maxChildren;
        parent.childList.add(elementName);
        element.parentList.add(parentName);
        this.elementMap.put(elementName, element);
    }

    protected void addChildElement(String elementName, String parentName) {
        Element parent = this.getElement(parentName);
        Element element = this.getElement(elementName);
        parent.childList.add(elementName);
        element.parentList.add(parentName);
    }

    protected void removeElement(String elementName) {
        Element element = this.getElement(elementName, false);
        if (element != null) {
            for (String parentName : element.parentList) {
                Element parent = this.getElement(parentName, false);
                if (parent == null) continue;
                parent.childList.remove(elementName);
            }
            this.elementMap.remove(elementName);
        }
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue) {
        Element element = this.getElement(elementName);
        if (attrName == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attr = new Attribute();
        attr.attrName = attrName;
        attr.valueType = 1;
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        element.attrList.add(attrName);
        element.attrMap.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, List<String> enumeratedValues) {
        Element element = this.getElement(elementName);
        if (attrName == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (enumeratedValues == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (enumeratedValues.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        for (String o : enumeratedValues) {
            if (o == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (o instanceof String) continue;
            throw new IllegalArgumentException("enumeratedValues contains a non-String value!");
        }
        Attribute attr = new Attribute();
        attr.attrName = attrName;
        attr.valueType = 16;
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        attr.enumeratedValues = enumeratedValues;
        element.attrList.add(attrName);
        element.attrMap.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, String defaultValue, String minValue, String maxValue, boolean minInclusive, boolean maxInclusive) {
        Element element = this.getElement(elementName);
        if (attrName == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attr = new Attribute();
        attr.attrName = attrName;
        attr.valueType = 2;
        if (minInclusive) {
            attr.valueType |= 4;
        }
        if (maxInclusive) {
            attr.valueType |= 8;
        }
        attr.dataType = dataType;
        attr.required = required;
        attr.defaultValue = defaultValue;
        attr.minValue = minValue;
        attr.maxValue = maxValue;
        element.attrList.add(attrName);
        element.attrMap.put(attrName, attr);
    }

    protected void addAttribute(String elementName, String attrName, int dataType, boolean required, int listMinLength, int listMaxLength) {
        Element element = this.getElement(elementName);
        if (attrName == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (dataType < 0 || dataType > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (listMinLength < 0 || listMinLength > listMaxLength) {
            throw new IllegalArgumentException("Invalid list bounds!");
        }
        Attribute attr = new Attribute();
        attr.attrName = attrName;
        attr.valueType = 32;
        attr.dataType = dataType;
        attr.required = required;
        attr.listMinLength = listMinLength;
        attr.listMaxLength = listMaxLength;
        element.attrList.add(attrName);
        element.attrMap.put(attrName, attr);
    }

    protected void addBooleanAttribute(String elementName, String attrName, boolean hasDefaultValue, boolean defaultValue) {
        ArrayList<String> values = new ArrayList<String>();
        values.add("TRUE");
        values.add("FALSE");
        String dval = null;
        if (hasDefaultValue) {
            dval = defaultValue ? "TRUE" : "FALSE";
        }
        this.addAttribute(elementName, attrName, 1, true, dval, values);
    }

    protected void removeAttribute(String elementName, String attrName) {
        Element element = this.getElement(elementName);
        element.attrList.remove(attrName);
        element.attrMap.remove(attrName);
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, boolean required, T defaultValue) {
        Element element = this.getElement(elementName);
        ObjectValue obj = new ObjectValue();
        obj.valueType = 1;
        obj.classType = classType;
        obj.defaultValue = defaultValue;
        element.objectValue = obj;
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, boolean required, T defaultValue, List<? extends T> enumeratedValues) {
        Element element = this.getElement(elementName);
        if (enumeratedValues == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (enumeratedValues.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        for (T o : enumeratedValues) {
            if (o == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (classType.isInstance(o)) continue;
            throw new IllegalArgumentException("enumeratedValues contains a value not of class classType!");
        }
        ObjectValue obj = new ObjectValue();
        obj.valueType = 16;
        obj.classType = classType;
        obj.defaultValue = defaultValue;
        obj.enumeratedValues = enumeratedValues;
        element.objectValue = obj;
    }

    protected <T> void addObjectValue(String elementName, Class<T> classType, T defaultValue, Comparable<? super T> minValue, Comparable<? super T> maxValue, boolean minInclusive, boolean maxInclusive) {
        Element element = this.getElement(elementName);
        ObjectValue obj = new ObjectValue();
        obj.valueType = 2;
        if (minInclusive) {
            obj.valueType |= 4;
        }
        if (maxInclusive) {
            obj.valueType |= 8;
        }
        obj.classType = classType;
        obj.defaultValue = defaultValue;
        obj.minValue = minValue;
        obj.maxValue = maxValue;
        element.objectValue = obj;
    }

    protected void addObjectValue(String elementName, Class<?> classType, int arrayMinLength, int arrayMaxLength) {
        Element element = this.getElement(elementName);
        ObjectValue obj = new ObjectValue();
        obj.valueType = 32;
        obj.classType = classType;
        obj.arrayMinLength = arrayMinLength;
        obj.arrayMaxLength = arrayMaxLength;
        element.objectValue = obj;
    }

    protected void removeObjectValue(String elementName) {
        Element element = this.getElement(elementName);
        element.objectValue = null;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    @Override
    public int getElementMinChildren(String elementName) {
        Element element = this.getElement(elementName);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.minChildren;
    }

    @Override
    public int getElementMaxChildren(String elementName) {
        Element element = this.getElement(elementName);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.maxChildren;
    }

    private String getResource(String key, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBaseName, locale, this.getClass().getModule());
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Override
    public String getElementDescription(String elementName, Locale locale) {
        Element element = this.getElement(elementName);
        return this.getResource(elementName, locale);
    }

    @Override
    public int getChildPolicy(String elementName) {
        Element element = this.getElement(elementName);
        return element.childPolicy;
    }

    @Override
    public String[] getChildNames(String elementName) {
        Element element = this.getElement(elementName);
        if (element.childPolicy == 0) {
            return null;
        }
        return element.childList.toArray(new String[0]);
    }

    @Override
    public String[] getAttributeNames(String elementName) {
        Element element = this.getElement(elementName);
        List<String> names = element.attrList;
        String[] result = new String[names.size()];
        return names.toArray(result);
    }

    @Override
    public int getAttributeValueType(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        return attr.valueType;
    }

    @Override
    public int getAttributeDataType(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        return attr.dataType;
    }

    @Override
    public boolean isAttributeRequired(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        return attr.required;
    }

    @Override
    public String getAttributeDefaultValue(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        return attr.defaultValue;
    }

    @Override
    public String[] getAttributeEnumerations(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        if (attr.valueType != 16) {
            throw new IllegalArgumentException("Attribute not an enumeration!");
        }
        List<String> values = attr.enumeratedValues;
        String[] result = new String[values.size()];
        return values.toArray(result);
    }

    @Override
    public String getAttributeMinValue(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        if (attr.valueType != 2 && attr.valueType != 6 && attr.valueType != 10 && attr.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attr.minValue;
    }

    @Override
    public String getAttributeMaxValue(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        if (attr.valueType != 2 && attr.valueType != 6 && attr.valueType != 10 && attr.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attr.maxValue;
    }

    @Override
    public int getAttributeListMinLength(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        if (attr.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attr.listMinLength;
    }

    @Override
    public int getAttributeListMaxLength(String elementName, String attrName) {
        Attribute attr = this.getAttribute(elementName, attrName);
        if (attr.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attr.listMaxLength;
    }

    @Override
    public String getAttributeDescription(String elementName, String attrName, Locale locale) {
        Element element = this.getElement(elementName);
        if (attrName == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        Attribute attr = element.attrMap.get(attrName);
        if (attr == null) {
            throw new IllegalArgumentException("No such attribute!");
        }
        String key = elementName + "/" + attrName;
        return this.getResource(key, locale);
    }

    private ObjectValue<?> getObjectValue(String elementName) {
        Element element = this.getElement(elementName);
        ObjectValue<?> objv = element.objectValue;
        if (objv == null) {
            throw new IllegalArgumentException("No object within element " + elementName + "!");
        }
        return objv;
    }

    @Override
    public int getObjectValueType(String elementName) {
        Element element = this.getElement(elementName);
        ObjectValue<?> objv = element.objectValue;
        if (objv == null) {
            return 0;
        }
        return objv.valueType;
    }

    @Override
    public Class<?> getObjectClass(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        return objv.classType;
    }

    @Override
    public Object getObjectDefaultValue(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        return objv.defaultValue;
    }

    @Override
    public Object[] getObjectEnumerations(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        if (objv.valueType != 16) {
            throw new IllegalArgumentException("Not an enumeration!");
        }
        List<Object> vlist = objv.enumeratedValues;
        Object[] values = new Object[vlist.size()];
        return vlist.toArray(values);
    }

    @Override
    public Comparable<?> getObjectMinValue(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        if ((objv.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objv.minValue;
    }

    @Override
    public Comparable<?> getObjectMaxValue(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        if ((objv.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objv.maxValue;
    }

    @Override
    public int getObjectArrayMinLength(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        if (objv.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objv.arrayMinLength;
    }

    @Override
    public int getObjectArrayMaxLength(String elementName) {
        ObjectValue<?> objv = this.getObjectValue(elementName);
        if (objv.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objv.arrayMaxLength;
    }

    private static synchronized void createStandardFormat() {
        if (standardFormat == null) {
            standardFormat = new StandardMetadataFormat();
        }
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        IIOMetadataFormatImpl.createStandardFormat();
        return standardFormat;
    }

    class ObjectValue<T> {
        int valueType = 0;
        Class<? extends T> classType = null;
        T defaultValue = null;
        List<? extends T> enumeratedValues = null;
        Comparable<? super T> minValue = null;
        Comparable<? super T> maxValue = null;
        int arrayMinLength = 0;
        int arrayMaxLength = 0;

        ObjectValue() {
        }
    }

    class Attribute {
        String attrName;
        int valueType = 1;
        int dataType;
        boolean required;
        String defaultValue = null;
        List<String> enumeratedValues;
        String minValue;
        String maxValue;
        int listMinLength;
        int listMaxLength;

        Attribute() {
        }
    }

    class Element {
        String elementName;
        int childPolicy;
        int minChildren = 0;
        int maxChildren = 0;
        List<String> childList = new ArrayList<String>();
        List<String> parentList = new ArrayList<String>();
        List<String> attrList = new ArrayList<String>();
        Map<String, Attribute> attrMap = new HashMap<String, Attribute>();
        ObjectValue<?> objectValue;

        Element() {
        }
    }
}

