/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.awt.color.ProfileDataException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.java2d.cmm.CMSManager;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.Profile;
import sun.java2d.cmm.ProfileActivator;
import sun.java2d.cmm.ProfileDataVerifier;
import sun.java2d.cmm.ProfileDeferralInfo;
import sun.java2d.cmm.ProfileDeferralMgr;

public class ICC_Profile
implements Serializable {
    private static final long serialVersionUID = -3938515861990936766L;
    private transient Profile cmmProfile;
    private transient ProfileDeferralInfo deferralInfo;
    private transient ProfileActivator profileActivator;
    private static ICC_Profile sRGBprofile;
    private static ICC_Profile XYZprofile;
    private static ICC_Profile PYCCprofile;
    private static ICC_Profile GRAYprofile;
    private static ICC_Profile LINEAR_RGBprofile;
    public static final int CLASS_INPUT = 0;
    public static final int CLASS_DISPLAY = 1;
    public static final int CLASS_OUTPUT = 2;
    public static final int CLASS_DEVICELINK = 3;
    public static final int CLASS_COLORSPACECONVERSION = 4;
    public static final int CLASS_ABSTRACT = 5;
    public static final int CLASS_NAMEDCOLOR = 6;
    public static final int icSigXYZData = 1482250784;
    public static final int icSigLabData = 1281450528;
    public static final int icSigLuvData = 1282766368;
    public static final int icSigYCbCrData = 1497588338;
    public static final int icSigYxyData = 1501067552;
    public static final int icSigRgbData = 1380401696;
    public static final int icSigGrayData = 1196573017;
    public static final int icSigHsvData = 1213421088;
    public static final int icSigHlsData = 1212961568;
    public static final int icSigCmykData = 1129142603;
    public static final int icSigCmyData = 1129142560;
    public static final int icSigSpace2CLR = 843271250;
    public static final int icSigSpace3CLR = 860048466;
    public static final int icSigSpace4CLR = 876825682;
    public static final int icSigSpace5CLR = 893602898;
    public static final int icSigSpace6CLR = 910380114;
    public static final int icSigSpace7CLR = 927157330;
    public static final int icSigSpace8CLR = 943934546;
    public static final int icSigSpace9CLR = 960711762;
    public static final int icSigSpaceACLR = 1094929490;
    public static final int icSigSpaceBCLR = 1111706706;
    public static final int icSigSpaceCCLR = 1128483922;
    public static final int icSigSpaceDCLR = 1145261138;
    public static final int icSigSpaceECLR = 1162038354;
    public static final int icSigSpaceFCLR = 1178815570;
    public static final int icSigInputClass = 1935896178;
    public static final int icSigDisplayClass = 1835955314;
    public static final int icSigOutputClass = 1886549106;
    public static final int icSigLinkClass = 1818848875;
    public static final int icSigAbstractClass = 1633842036;
    public static final int icSigColorSpaceClass = 1936744803;
    public static final int icSigNamedColorClass = 1852662636;
    public static final int icPerceptual = 0;
    public static final int icRelativeColorimetric = 1;
    public static final int icMediaRelativeColorimetric = 1;
    public static final int icSaturation = 2;
    public static final int icAbsoluteColorimetric = 3;
    public static final int icICCAbsoluteColorimetric = 3;
    public static final int icSigHead = 1751474532;
    public static final int icSigAToB0Tag = 1093812784;
    public static final int icSigAToB1Tag = 1093812785;
    public static final int icSigAToB2Tag = 1093812786;
    public static final int icSigBlueColorantTag = 1649957210;
    public static final int icSigBlueMatrixColumnTag = 1649957210;
    public static final int icSigBlueTRCTag = 1649693251;
    public static final int icSigBToA0Tag = 1110589744;
    public static final int icSigBToA1Tag = 1110589745;
    public static final int icSigBToA2Tag = 1110589746;
    public static final int icSigCalibrationDateTimeTag = 1667329140;
    public static final int icSigCharTargetTag = 1952543335;
    public static final int icSigCopyrightTag = 1668313716;
    public static final int icSigCrdInfoTag = 1668441193;
    public static final int icSigDeviceMfgDescTag = 1684893284;
    public static final int icSigDeviceModelDescTag = 0x646D6464;
    public static final int icSigDeviceSettingsTag = 1684371059;
    public static final int icSigGamutTag = 1734438260;
    public static final int icSigGrayTRCTag = 1800688195;
    public static final int icSigGreenColorantTag = 1733843290;
    public static final int icSigGreenMatrixColumnTag = 1733843290;
    public static final int icSigGreenTRCTag = 1733579331;
    public static final int icSigLuminanceTag = 1819635049;
    public static final int icSigMeasurementTag = 1835360627;
    public static final int icSigMediaBlackPointTag = 1651208308;
    public static final int icSigMediaWhitePointTag = 0x77747074;
    public static final int icSigNamedColor2Tag = 1852009522;
    public static final int icSigOutputResponseTag = 1919251312;
    public static final int icSigPreview0Tag = 1886545200;
    public static final int icSigPreview1Tag = 1886545201;
    public static final int icSigPreview2Tag = 1886545202;
    public static final int icSigProfileDescriptionTag = 1684370275;
    public static final int icSigProfileSequenceDescTag = 1886610801;
    public static final int icSigPs2CRD0Tag = 1886610480;
    public static final int icSigPs2CRD1Tag = 1886610481;
    public static final int icSigPs2CRD2Tag = 1886610482;
    public static final int icSigPs2CRD3Tag = 1886610483;
    public static final int icSigPs2CSATag = 1886597747;
    public static final int icSigPs2RenderingIntentTag = 1886597737;
    public static final int icSigRedColorantTag = 1918392666;
    public static final int icSigRedMatrixColumnTag = 1918392666;
    public static final int icSigRedTRCTag = 1918128707;
    public static final int icSigScreeningDescTag = 1935897188;
    public static final int icSigScreeningTag = 1935897198;
    public static final int icSigTechnologyTag = 1952801640;
    public static final int icSigUcrBgTag = 1650877472;
    public static final int icSigViewingCondDescTag = 1987405156;
    public static final int icSigViewingConditionsTag = 1986618743;
    public static final int icSigChromaticityTag = 1667789421;
    public static final int icSigChromaticAdaptationTag = 1667785060;
    public static final int icSigColorantOrderTag = 1668051567;
    public static final int icSigColorantTableTag = 1668051572;
    public static final int icHdrSize = 0;
    public static final int icHdrCmmId = 4;
    public static final int icHdrVersion = 8;
    public static final int icHdrDeviceClass = 12;
    public static final int icHdrColorSpace = 16;
    public static final int icHdrPcs = 20;
    public static final int icHdrDate = 24;
    public static final int icHdrMagic = 36;
    public static final int icHdrPlatform = 40;
    public static final int icHdrFlags = 44;
    public static final int icHdrManufacturer = 48;
    public static final int icHdrModel = 52;
    public static final int icHdrAttributes = 56;
    public static final int icHdrRenderingIntent = 64;
    public static final int icHdrIlluminant = 68;
    public static final int icHdrCreator = 80;
    public static final int icHdrProfileID = 84;
    public static final int icTagType = 0;
    public static final int icTagReserved = 4;
    public static final int icCurveCount = 8;
    public static final int icCurveData = 12;
    public static final int icXYZNumberX = 8;
    private int iccProfileSerializedDataVersion = 1;
    private transient ICC_Profile resolvedDeserializedProfile;

    ICC_Profile(Profile p) {
        this.cmmProfile = p;
    }

    ICC_Profile(ProfileDeferralInfo pdi) {
        this.deferralInfo = pdi;
        this.profileActivator = new ProfileActivator(){

            public void activate() throws ProfileDataException {
                ICC_Profile.this.activateDeferredProfile();
            }
        };
        ProfileDeferralMgr.registerDeferral((ProfileActivator)this.profileActivator);
    }

    @Deprecated(since="9")
    protected void finalize() {
        if (this.cmmProfile != null) {
            CMSManager.getModule().freeProfile(this.cmmProfile);
        } else if (this.profileActivator != null) {
            ProfileDeferralMgr.unregisterDeferral((ProfileActivator)this.profileActivator);
        }
    }

    public static ICC_Profile getInstance(byte[] data) {
        ICC_Profile thisProfile;
        Profile p = null;
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        ProfileDataVerifier.verify(data);
        try {
            p = CMSManager.getModule().loadProfile(data);
        }
        catch (CMMException c) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        try {
            thisProfile = ICC_Profile.getColorSpaceType(p) == 6 && ICC_Profile.getData(p, 0x77747074) != null && ICC_Profile.getData(p, 1800688195) != null ? new ICC_ProfileGray(p) : (ICC_Profile.getColorSpaceType(p) == 5 && ICC_Profile.getData(p, 0x77747074) != null && ICC_Profile.getData(p, 1918392666) != null && ICC_Profile.getData(p, 1733843290) != null && ICC_Profile.getData(p, 1649957210) != null && ICC_Profile.getData(p, 1918128707) != null && ICC_Profile.getData(p, 1733579331) != null && ICC_Profile.getData(p, 1649693251) != null ? new ICC_ProfileRGB(p) : new ICC_Profile(p));
        }
        catch (CMMException c) {
            thisProfile = new ICC_Profile(p);
        }
        return thisProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICC_Profile getInstance(int cspace) {
        ICC_Profile thisProfile = null;
        switch (cspace) {
            case 1000: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (sRGBprofile != null) return sRGBprofile;
                    ProfileDeferralInfo pInfo = new ProfileDeferralInfo("sRGB.pf", 5, 3, 1);
                    sRGBprofile = ICC_Profile.getDeferredInstance(pInfo);
                    return sRGBprofile;
                }
            }
            case 1001: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (XYZprofile != null) return XYZprofile;
                    ProfileDeferralInfo pInfo = new ProfileDeferralInfo("CIEXYZ.pf", 0, 3, 1);
                    XYZprofile = ICC_Profile.getDeferredInstance(pInfo);
                    return XYZprofile;
                }
            }
            case 1002: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (PYCCprofile != null) return PYCCprofile;
                    if (!ICC_Profile.standardProfileExists("PYCC.pf")) throw new IllegalArgumentException("Can't load standard profile: PYCC.pf");
                    ProfileDeferralInfo pInfo = new ProfileDeferralInfo("PYCC.pf", 13, 3, 1);
                    PYCCprofile = ICC_Profile.getDeferredInstance(pInfo);
                    return PYCCprofile;
                }
            }
            case 1003: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (GRAYprofile != null) return GRAYprofile;
                    ProfileDeferralInfo pInfo = new ProfileDeferralInfo("GRAY.pf", 6, 1, 1);
                    GRAYprofile = ICC_Profile.getDeferredInstance(pInfo);
                    return GRAYprofile;
                }
            }
            case 1004: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (LINEAR_RGBprofile != null) return LINEAR_RGBprofile;
                    ProfileDeferralInfo pInfo = new ProfileDeferralInfo("LINEAR_RGB.pf", 5, 3, 1);
                    LINEAR_RGBprofile = ICC_Profile.getDeferredInstance(pInfo);
                    return LINEAR_RGBprofile;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
    }

    private static ICC_Profile getStandardProfile(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ICC_Profile>(){

            @Override
            public ICC_Profile run() {
                ICC_Profile p = null;
                try {
                    p = ICC_Profile.getInstance(name);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Can't load standard profile: " + name);
                }
                return p;
            }
        });
    }

    public static ICC_Profile getInstance(String fileName) throws IOException {
        InputStream is = null;
        File f = ICC_Profile.getProfileFile(fileName);
        is = f != null ? new FileInputStream(f) : ICC_Profile.getStandardProfileInputStream(fileName);
        if (is == null) {
            throw new IOException("Cannot open file " + fileName);
        }
        ICC_Profile thisProfile = ICC_Profile.getInstance(is);
        is.close();
        return thisProfile;
    }

    public static ICC_Profile getInstance(InputStream s) throws IOException {
        if (s instanceof ProfileDeferralInfo) {
            return ICC_Profile.getDeferredInstance((ProfileDeferralInfo)((Object)s));
        }
        byte[] profileData = ICC_Profile.getProfileDataFromStream(s);
        if (profileData == null) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        return ICC_Profile.getInstance(profileData);
    }

    static byte[] getProfileDataFromStream(InputStream s) throws IOException {
        int bytestoread;
        int n;
        byte[] header = new byte[128];
        int bytesread = 0;
        for (bytestoread = 128; bytestoread != 0; bytestoread -= n) {
            n = s.read(header, bytesread, bytestoread);
            if (n < 0) {
                return null;
            }
            bytesread += n;
        }
        if (header[36] != 97 || header[37] != 99 || header[38] != 115 || header[39] != 112) {
            return null;
        }
        int profileSize = (header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
        byte[] profileData = new byte[profileSize];
        System.arraycopy(header, 0, profileData, 0, 128);
        bytesread = 128;
        for (bytestoread = profileSize - 128; bytestoread != 0; bytestoread -= n) {
            n = s.read(profileData, bytesread, bytestoread);
            if (n < 0) {
                return null;
            }
            bytesread += n;
        }
        return profileData;
    }

    static ICC_Profile getDeferredInstance(ProfileDeferralInfo pdi) {
        if (!ProfileDeferralMgr.deferring) {
            return ICC_Profile.getStandardProfile(pdi.filename);
        }
        if (pdi.colorSpaceType == 5) {
            return new ICC_ProfileRGB(pdi);
        }
        if (pdi.colorSpaceType == 6) {
            return new ICC_ProfileGray(pdi);
        }
        return new ICC_Profile(pdi);
    }

    void activateDeferredProfile() throws ProfileDataException {
        byte[] profileData;
        String fileName = this.deferralInfo.filename;
        this.profileActivator = null;
        this.deferralInfo = null;
        InputStream is = ICC_Profile.getStandardProfileInputStream(fileName);
        if (is == null) {
            throw new ProfileDataException("Cannot open file " + fileName);
        }
        try {
            profileData = ICC_Profile.getProfileDataFromStream(is);
            is.close();
        }
        catch (IOException e) {
            ProfileDataException pde = new ProfileDataException("Invalid ICC Profile Data" + fileName);
            pde.initCause(e);
            throw pde;
        }
        if (profileData == null) {
            throw new ProfileDataException("Invalid ICC Profile Data" + fileName);
        }
        try {
            this.cmmProfile = CMSManager.getModule().loadProfile(profileData);
        }
        catch (CMMException c) {
            ProfileDataException pde = new ProfileDataException("Invalid ICC Profile Data" + fileName);
            pde.initCause(c);
            throw pde;
        }
    }

    public int getMajorVersion() {
        byte[] theHeader = this.getData(1751474532);
        return theHeader[8];
    }

    public int getMinorVersion() {
        byte[] theHeader = this.getData(1751474532);
        return theHeader[9];
    }

    public int getProfileClass() {
        int theClass;
        if (this.deferralInfo != null) {
            return this.deferralInfo.profileClass;
        }
        byte[] theHeader = this.getData(1751474532);
        int theClassSig = ICC_Profile.intFromBigEndian(theHeader, 12);
        switch (theClassSig) {
            case 1935896178: {
                theClass = 0;
                break;
            }
            case 1835955314: {
                theClass = 1;
                break;
            }
            case 1886549106: {
                theClass = 2;
                break;
            }
            case 1818848875: {
                theClass = 3;
                break;
            }
            case 1936744803: {
                theClass = 4;
                break;
            }
            case 1633842036: {
                theClass = 5;
                break;
            }
            case 1852662636: {
                theClass = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown profile class");
            }
        }
        return theClass;
    }

    public int getColorSpaceType() {
        if (this.deferralInfo != null) {
            return this.deferralInfo.colorSpaceType;
        }
        return ICC_Profile.getColorSpaceType(this.cmmProfile);
    }

    static int getColorSpaceType(Profile p) {
        byte[] theHeader = ICC_Profile.getData(p, 1751474532);
        int theColorSpaceSig = ICC_Profile.intFromBigEndian(theHeader, 16);
        int theColorSpace = ICC_Profile.iccCStoJCS(theColorSpaceSig);
        return theColorSpace;
    }

    public int getPCSType() {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        return ICC_Profile.getPCSType(this.cmmProfile);
    }

    static int getPCSType(Profile p) {
        byte[] theHeader = ICC_Profile.getData(p, 1751474532);
        int thePCSSig = ICC_Profile.intFromBigEndian(theHeader, 20);
        int thePCS = ICC_Profile.iccCStoJCS(thePCSSig);
        return thePCS;
    }

    public void write(String fileName) throws IOException {
        byte[] profileData = this.getData();
        FileOutputStream outputFile = new FileOutputStream(fileName);
        outputFile.write(profileData);
        outputFile.close();
    }

    public void write(OutputStream s) throws IOException {
        byte[] profileData = this.getData();
        s.write(profileData);
    }

    public byte[] getData() {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        PCMM mdl = CMSManager.getModule();
        int profileSize = mdl.getProfileSize(this.cmmProfile);
        byte[] profileData = new byte[profileSize];
        mdl.getProfileData(this.cmmProfile, profileData);
        return profileData;
    }

    public byte[] getData(int tagSignature) {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        return ICC_Profile.getData(this.cmmProfile, tagSignature);
    }

    static byte[] getData(Profile p, int tagSignature) {
        byte[] tagData;
        try {
            PCMM mdl = CMSManager.getModule();
            int tagSize = mdl.getTagSize(p, tagSignature);
            tagData = new byte[tagSize];
            mdl.getTagData(p, tagSignature, tagData);
        }
        catch (CMMException c) {
            tagData = null;
        }
        return tagData;
    }

    public void setData(int tagSignature, byte[] tagData) {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        CMSManager.getModule().setTagData(this.cmmProfile, tagSignature, tagData);
    }

    void setRenderingIntent(int renderingIntent) {
        byte[] theHeader = this.getData(1751474532);
        ICC_Profile.intToBigEndian(renderingIntent, theHeader, 64);
        this.setData(1751474532, theHeader);
    }

    int getRenderingIntent() {
        byte[] theHeader = this.getData(1751474532);
        int renderingIntent = ICC_Profile.intFromBigEndian(theHeader, 64);
        return 0xFFFF & renderingIntent;
    }

    public int getNumComponents() {
        int theNumComponents;
        if (this.deferralInfo != null) {
            return this.deferralInfo.numComponents;
        }
        byte[] theHeader = this.getData(1751474532);
        int theColorSpaceSig = ICC_Profile.intFromBigEndian(theHeader, 16);
        switch (theColorSpaceSig) {
            case 1196573017: {
                theNumComponents = 1;
                break;
            }
            case 843271250: {
                theNumComponents = 2;
                break;
            }
            case 860048466: 
            case 1129142560: 
            case 1212961568: 
            case 1213421088: 
            case 1281450528: 
            case 1282766368: 
            case 1380401696: 
            case 1482250784: 
            case 1497588338: 
            case 1501067552: {
                theNumComponents = 3;
                break;
            }
            case 876825682: 
            case 1129142603: {
                theNumComponents = 4;
                break;
            }
            case 893602898: {
                theNumComponents = 5;
                break;
            }
            case 910380114: {
                theNumComponents = 6;
                break;
            }
            case 927157330: {
                theNumComponents = 7;
                break;
            }
            case 943934546: {
                theNumComponents = 8;
                break;
            }
            case 960711762: {
                theNumComponents = 9;
                break;
            }
            case 1094929490: {
                theNumComponents = 10;
                break;
            }
            case 1111706706: {
                theNumComponents = 11;
                break;
            }
            case 1128483922: {
                theNumComponents = 12;
                break;
            }
            case 1145261138: {
                theNumComponents = 13;
                break;
            }
            case 1162038354: {
                theNumComponents = 14;
                break;
            }
            case 1178815570: {
                theNumComponents = 15;
                break;
            }
            default: {
                throw new ProfileDataException("invalid ICC color space");
            }
        }
        return theNumComponents;
    }

    float[] getMediaWhitePoint() {
        return this.getXYZTag(0x77747074);
    }

    float[] getXYZTag(int theTagSignature) {
        byte[] theData = this.getData(theTagSignature);
        float[] theXYZNumber = new float[3];
        int i1 = 0;
        int i2 = 8;
        while (i1 < 3) {
            int theS15Fixed16 = ICC_Profile.intFromBigEndian(theData, i2);
            theXYZNumber[i1] = (float)theS15Fixed16 / 65536.0f;
            ++i1;
            i2 += 4;
        }
        return theXYZNumber;
    }

    float getGamma(int theTagSignature) {
        byte[] theTRCData = this.getData(theTagSignature);
        if (ICC_Profile.intFromBigEndian(theTRCData, 8) != 1) {
            throw new ProfileDataException("TRC is not a gamma");
        }
        int theU8Fixed8 = ICC_Profile.shortFromBigEndian(theTRCData, 12) & 0xFFFF;
        float theGamma = (float)theU8Fixed8 / 256.0f;
        return theGamma;
    }

    short[] getTRC(int theTagSignature) {
        byte[] theTRCData = this.getData(theTagSignature);
        int nElements = ICC_Profile.intFromBigEndian(theTRCData, 8);
        if (nElements == 1) {
            throw new ProfileDataException("TRC is not a table");
        }
        short[] theTRC = new short[nElements];
        int i1 = 0;
        int i2 = 12;
        while (i1 < nElements) {
            theTRC[i1] = ICC_Profile.shortFromBigEndian(theTRCData, i2);
            ++i1;
            i2 += 2;
        }
        return theTRC;
    }

    static int iccCStoJCS(int theColorSpaceSig) {
        int theColorSpace;
        switch (theColorSpaceSig) {
            case 1482250784: {
                theColorSpace = 0;
                break;
            }
            case 1281450528: {
                theColorSpace = 1;
                break;
            }
            case 1282766368: {
                theColorSpace = 2;
                break;
            }
            case 1497588338: {
                theColorSpace = 3;
                break;
            }
            case 1501067552: {
                theColorSpace = 4;
                break;
            }
            case 1380401696: {
                theColorSpace = 5;
                break;
            }
            case 1196573017: {
                theColorSpace = 6;
                break;
            }
            case 1213421088: {
                theColorSpace = 7;
                break;
            }
            case 1212961568: {
                theColorSpace = 8;
                break;
            }
            case 1129142603: {
                theColorSpace = 9;
                break;
            }
            case 1129142560: {
                theColorSpace = 11;
                break;
            }
            case 843271250: {
                theColorSpace = 12;
                break;
            }
            case 860048466: {
                theColorSpace = 13;
                break;
            }
            case 876825682: {
                theColorSpace = 14;
                break;
            }
            case 893602898: {
                theColorSpace = 15;
                break;
            }
            case 910380114: {
                theColorSpace = 16;
                break;
            }
            case 927157330: {
                theColorSpace = 17;
                break;
            }
            case 943934546: {
                theColorSpace = 18;
                break;
            }
            case 960711762: {
                theColorSpace = 19;
                break;
            }
            case 1094929490: {
                theColorSpace = 20;
                break;
            }
            case 1111706706: {
                theColorSpace = 21;
                break;
            }
            case 1128483922: {
                theColorSpace = 22;
                break;
            }
            case 1145261138: {
                theColorSpace = 23;
                break;
            }
            case 1162038354: {
                theColorSpace = 24;
                break;
            }
            case 1178815570: {
                theColorSpace = 25;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
        return theColorSpace;
    }

    static int intFromBigEndian(byte[] array, int index) {
        return (array[index] & 0xFF) << 24 | (array[index + 1] & 0xFF) << 16 | (array[index + 2] & 0xFF) << 8 | array[index + 3] & 0xFF;
    }

    static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }

    static short shortFromBigEndian(byte[] array, int index) {
        return (short)((array[index] & 0xFF) << 8 | array[index + 1] & 0xFF);
    }

    static void shortToBigEndian(short value, byte[] array, int index) {
        array[index] = (byte)(value >> 8);
        array[index + 1] = (byte)value;
    }

    private static File getProfileFile(String fileName) {
        String fullPath;
        String dir;
        StringTokenizer st;
        String path;
        File f = new File(fileName);
        if (f.isAbsolute()) {
            return f.isFile() ? f : null;
        }
        if (!f.isFile() && (path = System.getProperty("java.iccprofile.path")) != null) {
            st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens() && (f == null || !f.isFile())) {
                dir = st.nextToken();
                fullPath = dir + File.separatorChar + fileName;
                f = new File(fullPath);
                if (ICC_Profile.isChildOf(f, dir)) continue;
                f = null;
            }
        }
        if (!(f != null && f.isFile() || (path = System.getProperty("java.class.path")) == null)) {
            st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens() && (f == null || !f.isFile())) {
                dir = st.nextToken();
                fullPath = dir + File.separatorChar + fileName;
                f = new File(fullPath);
            }
        }
        if (f != null && !f.isFile()) {
            f = null;
        }
        return f;
    }

    private static InputStream getStandardProfileInputStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return PCMM.class.getResourceAsStream("profiles/" + fileName);
            }
        }, null, new FilePermission("<<ALL FILES>>", "read"), new RuntimePermission("accessSystemModules"));
    }

    private static boolean isChildOf(File f, String dirName) {
        try {
            File dir = new File(dirName);
            Object canonicalDirName = dir.getCanonicalPath();
            if (!((String)canonicalDirName).endsWith(File.separator)) {
                canonicalDirName = (String)canonicalDirName + File.separator;
            }
            String canonicalFileName = f.getCanonicalPath();
            return canonicalFileName.startsWith((String)canonicalDirName);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean standardProfileExists(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PCMM.class.getResource("profiles/" + fileName) != null;
            }
        });
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        String csName = null;
        if (this == sRGBprofile) {
            csName = "CS_sRGB";
        } else if (this == XYZprofile) {
            csName = "CS_CIEXYZ";
        } else if (this == PYCCprofile) {
            csName = "CS_PYCC";
        } else if (this == GRAYprofile) {
            csName = "CS_GRAY";
        } else if (this == LINEAR_RGBprofile) {
            csName = "CS_LINEAR_RGB";
        }
        byte[] data = null;
        if (csName == null) {
            data = this.getData();
        }
        s.writeObject(csName);
        s.writeObject(data);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String csName = (String)s.readObject();
        byte[] data = (byte[])s.readObject();
        int cspace = 0;
        boolean isKnownPredefinedCS = false;
        if (csName != null) {
            isKnownPredefinedCS = true;
            if (csName.equals("CS_sRGB")) {
                cspace = 1000;
            } else if (csName.equals("CS_CIEXYZ")) {
                cspace = 1001;
            } else if (csName.equals("CS_PYCC")) {
                cspace = 1002;
            } else if (csName.equals("CS_GRAY")) {
                cspace = 1003;
            } else if (csName.equals("CS_LINEAR_RGB")) {
                cspace = 1004;
            } else {
                isKnownPredefinedCS = false;
            }
        }
        this.resolvedDeserializedProfile = isKnownPredefinedCS ? ICC_Profile.getInstance(cspace) : ICC_Profile.getInstance(data);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.resolvedDeserializedProfile;
    }
}

