/*
 * USB vendors, by VID
 * This file is autogenerated from http://www.linux-usb.org/usb.ids
 * See http://www.linux-usb.org/usb-ids.html to submit new VIDs or PIDs
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdlib.h>
#include "libwdi.h"

struct vendor_name {
	unsigned short vid;
	const char* name;
};

/*
 * http://www.linux-usb.org/usb.ids
 * Version: 2021.10.24
 */
static struct vendor_name usb_vendor[] = {
	{ 0x0001, "Fry's Electronics" },
	{ 0x0002, "Ingram" },
	{ 0x0003, "Club Mac" },
	{ 0x0004, "Nebraska Furniture Mart" },
	{ 0x0011, "Unknown" },
	{ 0x0053, "Planex" },
	{ 0x0078, "Microntek" },
	{ 0x0079, "DragonRise Inc." },
	{ 0x0080, "Unknown" },
	{ 0x0085, "Boeye Technology Co., Ltd." },
	{ 0x0102, "miniSTREAK" },
	{ 0x0105, "Trust International B.V." },
	{ 0x0127, "IBP" },
	{ 0x0145, "Unknown" },
	{ 0x017c, "MLK" },
	{ 0x0200, "TP-Link" },
	{ 0x0204, "Chipsbank Microelectronics Co., Ltd" },
	{ 0x0218, "Hangzhou Worlde" },
	{ 0x02ad, "HUMAX Co., Ltd." },
	{ 0x0303, "Mini Automation Controller" },
	{ 0x0324, "OCZ Technology Inc" },
	{ 0x0325, "OCZ Technology Inc" },
	{ 0x0386, "LTS" },
	{ 0x03c3, "ZWO" },
	{ 0x03d9, "Shenzhen Sinote Tech-Electron Co., Ltd" },
	{ 0x03da, "Bernd Walter Computer Technology" },
	{ 0x03e7, "Intel" },
	{ 0x03e8, "EndPoints, Inc." },
	{ 0x03e9, "Thesys Microelectronics" },
	{ 0x03ea, "Data Broadcasting Corp." },
	{ 0x03eb, "Atmel Corp." },
	{ 0x03ec, "Iwatsu America, Inc." },
	{ 0x03ed, "Mitel Corp." },
	{ 0x03ee, "Mitsumi" },
	{ 0x03f0, "HP, Inc" },
	{ 0x03f1, "Genoa Technology" },
	{ 0x03f2, "Oak Technology, Inc." },
	{ 0x03f3, "Adaptec, Inc." },
	{ 0x03f4, "Diebold, Inc." },
	{ 0x03f5, "Siemens Electromechanical" },
	{ 0x03f8, "Epson Imaging Technology Center" },
	{ 0x03f9, "KeyTronic Corp." },
	{ 0x03fb, "OPTi, Inc." },
	{ 0x03fc, "Elitegroup Computer Systems" },
	{ 0x03fd, "Xilinx, Inc." },
	{ 0x03fe, "Farallon Comunications" },
	{ 0x0400, "National Semiconductor Corp." },
	{ 0x0401, "National Registry, Inc." },
	{ 0x0402, "ALi Corp." },
	{ 0x0403, "Future Technology Devices International, Ltd" },
	{ 0x0404, "NCR Corp." },
	{ 0x0405, "Synopsys, Inc." },
	{ 0x0406, "Fujitsu-ICL Computers" },
	{ 0x0407, "Fujitsu Personal Systems, Inc." },
	{ 0x0408, "Quanta Computer, Inc." },
	{ 0x0409, "NEC Corp." },
	{ 0x040a, "Kodak Co." },
	{ 0x040b, "Weltrend Semiconductor" },
	{ 0x040c, "VTech Computers, Ltd" },
	{ 0x040d, "VIA Technologies, Inc." },
	{ 0x040e, "MCCI" },
	{ 0x040f, "Echo Speech Corp." },
	{ 0x0411, "BUFFALO INC. (formerly MelCo., Inc.)" },
	{ 0x0412, "Award Software International" },
	{ 0x0413, "Leadtek Research, Inc." },
	{ 0x0414, "Giga-Byte Technology Co., Ltd" },
	{ 0x0416, "Winbond Electronics Corp." },
	{ 0x0417, "Symbios Logic" },
	{ 0x0418, "AST Research" },
	{ 0x0419, "Samsung Info. Systems America, Inc." },
	{ 0x041a, "Phoenix Technologies, Ltd" },
	{ 0x041b, "d'TV" },
	{ 0x041d, "S3, Inc." },
	{ 0x041e, "Creative Technology, Ltd" },
	{ 0x041f, "LCS Telegraphics" },
	{ 0x0420, "Chips and Technologies" },
	{ 0x0421, "Nokia Mobile Phones" },
	{ 0x0422, "ADI Systems, Inc." },
	{ 0x0423, "Computer Access Technology Corp." },
	{ 0x0424, "Microchip Technology, Inc. (formerly SMSC)" },
	{ 0x0425, "Motorola Semiconductors HK, Ltd" },
	{ 0x0426, "Integrated Device Technology, Inc." },
	{ 0x0427, "Motorola Electronics Taiwan, Ltd" },
	{ 0x0428, "Advanced Gravis Computer Tech, Ltd" },
	{ 0x0429, "Cirrus Logic" },
	{ 0x042a, "Ericsson Austrian, AG" },
	{ 0x042b, "Intel Corp." },
	{ 0x042c, "Innovative Semiconductors, Inc." },
	{ 0x042d, "Micronics" },
	{ 0x042e, "Acer, Inc." },
	{ 0x042f, "Molex, Inc." },
	{ 0x0430, "Fujitsu Component Limited" },
	{ 0x0431, "Itac Systems, Inc." },
	{ 0x0432, "Unisys Corp." },
	{ 0x0433, "Alps Electric, Inc." },
	{ 0x0434, "Samsung Info. Systems America, Inc." },
	{ 0x0435, "Hyundai Electronics America" },
	{ 0x0436, "Taugagreining HF" },
	{ 0x0437, "Framatome Connectors USA" },
	{ 0x0438, "Advanced Micro Devices, Inc." },
	{ 0x0439, "Voice Technologies Group" },
	{ 0x043d, "Lexmark International, Inc." },
	{ 0x043e, "LG Electronics USA, Inc." },
	{ 0x043f, "RadiSys Corp." },
	{ 0x0440, "Eizo Nanao Corp." },
	{ 0x0441, "Winbond Systems Lab." },
	{ 0x0442, "Ericsson, Inc." },
	{ 0x0443, "Gateway, Inc." },
	{ 0x0445, "Lucent Technologies, Inc." },
	{ 0x0446, "NMB Technologies Corp." },
	{ 0x0447, "Momentum Microsystems" },
	{ 0x0449, "Duta Multi Robotik" },
	{ 0x044a, "Shamrock Tech. Co., Ltd" },
	{ 0x044b, "WSI" },
	{ 0x044c, "CCL/ITRI" },
	{ 0x044d, "Siemens Nixdorf AG" },
	{ 0x044e, "Alps Electric Co., Ltd" },
	{ 0x044f, "ThrustMaster, Inc." },
	{ 0x0450, "DFI, Inc." },
	{ 0x0451, "Texas Instruments, Inc." },
	{ 0x0452, "Mitsubishi Electronics America, Inc." },
	{ 0x0453, "CMD Technology" },
	{ 0x0454, "Vobis Microcomputer AG" },
	{ 0x0455, "Telematics International, Inc." },
	{ 0x0456, "Analog Devices, Inc." },
	{ 0x0457, "Silicon Integrated Systems Corp." },
	{ 0x0458, "KYE Systems Corp. (Mouse Systems)" },
	{ 0x0459, "Adobe Systems, Inc." },
	{ 0x045a, "SONICblue, Inc." },
	{ 0x045b, "Hitachi, Ltd" },
	{ 0x045d, "Nortel Networks, Ltd" },
	{ 0x045e, "Microsoft Corp." },
	{ 0x0460, "Ace Cad Enterprise Co., Ltd" },
	{ 0x0461, "Primax Electronics, Ltd" },
	{ 0x0463, "MGE UPS Systems" },
	{ 0x0464, "AMP/Tycoelectronics Corp." },
	{ 0x0467, "AT&T Paradyne" },
	{ 0x0468, "Wieson Technologies Co., Ltd" },
	{ 0x046a, "Cherry GmbH" },
	{ 0x046b, "American Megatrends, Inc." },
	{ 0x046c, "Toshiba Corp., Digital Media Equipment" },
	{ 0x046d, "Logitech, Inc." },
	{ 0x046e, "Behavior Tech. Computer Corp." },
	{ 0x046f, "Crystal Semiconductor" },
	{ 0x0471, "Philips (or NXP)" },
	{ 0x0472, "Chicony Electronics Co., Ltd" },
	{ 0x0473, "Sanyo Information Business Co., Ltd" },
	{ 0x0474, "Sanyo Electric Co., Ltd" },
	{ 0x0475, "Relisys/Teco Information System" },
	{ 0x0476, "AESP" },
	{ 0x0477, "Seagate Technology, Inc." },
	{ 0x0478, "Connectix Corp." },
	{ 0x0479, "Advanced Peripheral Laboratories" },
	{ 0x047a, "Semtech Corp." },
	{ 0x047b, "Silitek Corp." },
	{ 0x047c, "Dell Computer Corp." },
	{ 0x047d, "Kensington" },
	{ 0x047e, "Agere Systems, Inc. (Lucent)" },
	{ 0x047f, "Plantronics, Inc." },
	{ 0x0480, "Toshiba America Inc" },
	{ 0x0481, "Zenith Data Systems" },
	{ 0x0482, "Kyocera Corp." },
	{ 0x0483, "STMicroelectronics" },
	{ 0x0484, "Specialix" },
	{ 0x0485, "Nokia Monitors" },
	{ 0x0486, "ASUS Computers, Inc." },
	{ 0x0487, "Stewart Connector" },
	{ 0x0488, "Cirque Corp." },
	{ 0x0489, "Foxconn / Hon Hai" },
	{ 0x048a, "S-MOS Systems, Inc." },
	{ 0x048c, "Alps Electric Ireland, Ltd" },
	{ 0x048d, "Integrated Technology Express, Inc." },
	{ 0x048f, "Eicon Tech." },
	{ 0x0490, "United Microelectronics Corp." },
	{ 0x0491, "Capetronic" },
	{ 0x0492, "Samsung SemiConductor, Inc." },
	{ 0x0493, "MAG Technology Co., Ltd" },
	{ 0x0495, "ESS Technology, Inc." },
	{ 0x0496, "Micron Electronics" },
	{ 0x0497, "Smile International" },
	{ 0x0498, "Capetronic (Kaohsiung) Corp." },
	{ 0x0499, "Yamaha Corp." },
	{ 0x049a, "Gandalf Technologies, Ltd" },
	{ 0x049b, "Curtis Computer Products" },
	{ 0x049c, "Acer Advanced Labs, Inc." },
	{ 0x049d, "VLSI Technology" },
	{ 0x049f, "Compaq Computer Corp." },
	{ 0x04a0, "Digital Equipment Corp." },
	{ 0x04a1, "SystemSoft Corp." },
	{ 0x04a2, "FirePower Systems" },
	{ 0x04a3, "Trident Microsystems, Inc." },
	{ 0x04a4, "Hitachi, Ltd" },
	{ 0x04a5, "Acer Peripherals Inc. (now BenQ Corp.)" },
	{ 0x04a6, "Nokia Display Products" },
	{ 0x04a7, "Visioneer" },
	{ 0x04a8, "Multivideo Labs, Inc." },
	{ 0x04a9, "Canon, Inc." },
	{ 0x04aa, "DaeWoo Telecom, Ltd" },
	{ 0x04ab, "Chromatic Research" },
	{ 0x04ac, "Micro Audiometrics Corp." },
	{ 0x04ad, "Dooin Electronics" },
	{ 0x04af, "Winnov L.P." },
	{ 0x04b0, "Nikon Corp." },
	{ 0x04b1, "Pan International" },
	{ 0x04b3, "IBM Corp." },
	{ 0x04b4, "Cypress Semiconductor Corp." },
	{ 0x04b5, "ROHM LSI Systems USA, LLC" },
	{ 0x04b6, "Hint Corp." },
	{ 0x04b7, "Compal Electronics, Inc." },
	{ 0x04b8, "Seiko Epson Corp." },
	{ 0x04b9, "Rainbow Technologies, Inc." },
	{ 0x04ba, "Toucan Systems, Ltd" },
	{ 0x04bb, "I-O Data Device, Inc." },
	{ 0x04bd, "Toshiba Electronics Taiwan Corp." },
	{ 0x04be, "Telia Research AB" },
	{ 0x04bf, "TDK Corp." },
	{ 0x04c1, "U.S. Robotics (3Com)" },
	{ 0x04c2, "Methode Electronics Far East PTE, Ltd" },
	{ 0x04c3, "Maxi Switch, Inc." },
	{ 0x04c4, "Lockheed Martin Energy Research" },
	{ 0x04c5, "Fujitsu, Ltd" },
	{ 0x04c6, "Toshiba America Electronic Components" },
	{ 0x04c7, "Micro Macro Technologies" },
	{ 0x04c8, "Konica Corp." },
	{ 0x04ca, "Lite-On Technology Corp." },
	{ 0x04cb, "Fuji Photo Film Co., Ltd" },
	{ 0x04cc, "ST-Ericsson" },
	{ 0x04cd, "Tatung Co. Of America" },
	{ 0x04ce, "ScanLogic Corp." },
	{ 0x04cf, "Myson Century, Inc." },
	{ 0x04d0, "Digi International" },
	{ 0x04d1, "ITT Canon" },
	{ 0x04d2, "Altec Lansing Technologies" },
	{ 0x04d3, "VidUS, Inc." },
	{ 0x04d4, "LSI Logic, Inc." },
	{ 0x04d5, "Forte Technologies, Inc." },
	{ 0x04d6, "Mentor Graphics" },
	{ 0x04d7, "Oki Semiconductor" },
	{ 0x04d8, "Microchip Technology, Inc." },
	{ 0x04d9, "Holtek Semiconductor, Inc." },
	{ 0x04da, "Panasonic (Matsushita)" },
	{ 0x04db, "Hypertec Pty, Ltd" },
	{ 0x04dc, "Huan Hsin Holdings, Ltd" },
	{ 0x04dd, "Sharp Corp." },
	{ 0x04de, "MindShare, Inc." },
	{ 0x04df, "Interlink Electronics" },
	{ 0x04e1, "Iiyama North America, Inc." },
	{ 0x04e2, "Exar Corp." },
	{ 0x04e3, "Zilog, Inc." },
	{ 0x04e4, "ACC Microelectronics" },
	{ 0x04e5, "Promise Technology" },
	{ 0x04e6, "SCM Microsystems, Inc." },
	{ 0x04e7, "Elo TouchSystems" },
	{ 0x04e8, "Samsung Electronics Co., Ltd" },
	{ 0x04e9, "PC-Tel, Inc." },
	{ 0x04ea, "Brooktree Corp." },
	{ 0x04eb, "Northstar Systems, Inc." },
	{ 0x04ec, "Tokyo Electron Device, Ltd" },
	{ 0x04ed, "Annabooks" },
	{ 0x04ef, "Pacific Electronic International, Inc." },
	{ 0x04f0, "Daewoo Electronics Co., Ltd" },
	{ 0x04f1, "Victor Company of Japan, Ltd" },
	{ 0x04f2, "Chicony Electronics Co., Ltd" },
	{ 0x04f3, "Elan Microelectronics Corp." },
	{ 0x04f4, "Harting Elektronik, Inc." },
	{ 0x04f5, "Fujitsu-ICL Systems, Inc." },
	{ 0x04f6, "Norand Corp." },
	{ 0x04f7, "Newnex Technology Corp." },
	{ 0x04f8, "FuturePlus Systems" },
	{ 0x04f9, "Brother Industries, Ltd" },
	{ 0x04fa, "Dallas Semiconductor" },
	{ 0x04fb, "Biostar Microtech International Corp." },
	{ 0x04fc, "Sunplus Technology Co., Ltd" },
	{ 0x04fd, "Soliton Systems, K.K." },
	{ 0x04fe, "PFU, Ltd" },
	{ 0x04ff, "E-CMOS Corp." },
	{ 0x0500, "Siam United Hi-Tech" },
	{ 0x0501, "Fujikura DDK, Ltd" },
	{ 0x0502, "Acer, Inc." },
	{ 0x0503, "Hitachi America, Ltd" },
	{ 0x0504, "Hayes Microcomputer Products" },
	{ 0x0506, "3Com Corp." },
	{ 0x0507, "Hosiden Corp." },
	{ 0x0508, "Clarion Co., Ltd" },
	{ 0x0509, "Aztech Systems, Ltd" },
	{ 0x050a, "Cinch Connectors" },
	{ 0x050b, "Cable System International" },
	{ 0x050c, "InnoMedia, Inc." },
	{ 0x050d, "Belkin Components" },
	{ 0x050e, "Neon Technology, Inc." },
	{ 0x050f, "KC Technology, Inc." },
	{ 0x0510, "Sejin Electron, Inc." },
	{ 0x0511, "N'Able (DataBook) Technologies, Inc." },
	{ 0x0512, "Hualon Microelectronics Corp." },
	{ 0x0513, "digital-X, Inc." },
	{ 0x0514, "FCI Electronics" },
	{ 0x0515, "ACTC" },
	{ 0x0516, "Longwell Electronics" },
	{ 0x0517, "Butterfly Communications" },
	{ 0x0518, "EzKEY Corp." },
	{ 0x0519, "Star Micronics Co., Ltd" },
	{ 0x051a, "WYSE Technology" },
	{ 0x051b, "Silicon Graphics" },
	{ 0x051c, "Shuttle, Inc." },
	{ 0x051d, "American Power Conversion" },
	{ 0x051e, "Scientific Atlanta, Inc." },
	{ 0x051f, "IO Systems (Elite Electronics), Inc." },
	{ 0x0520, "Taiwan Semiconductor Manufacturing Co." },
	{ 0x0521, "Airborn Connectors" },
	{ 0x0522, "Advanced Connectek, Inc." },
	{ 0x0523, "ATEN GmbH" },
	{ 0x0524, "Sola Electronics" },
	{ 0x0525, "Netchip Technology, Inc." },
	{ 0x0526, "Temic MHS S.A." },
	{ 0x0527, "ALTRA" },
	{ 0x0528, "ATI Technologies, Inc." },
	{ 0x0529, "Aladdin Knowledge Systems" },
	{ 0x052a, "Crescent Heart Software" },
	{ 0x052b, "Tekom Technologies, Inc." },
	{ 0x052c, "Canon Information Systems, Inc." },
	{ 0x052d, "Avid Electronics Corp." },
	{ 0x052e, "Standard Microsystems Corp." },
	{ 0x052f, "Unicore Software, Inc." },
	{ 0x0530, "American Microsystems, Inc." },
	{ 0x0531, "Wacom Technology Corp." },
	{ 0x0532, "Systech Corp." },
	{ 0x0533, "Alcatel Mobile Phones" },
	{ 0x0534, "Motorola, Inc." },
	{ 0x0535, "LIH TZU Electric Co., Ltd" },
	{ 0x0536, "Hand Held Products (Welch Allyn, Inc.)" },
	{ 0x0537, "Inventec Corp." },
	{ 0x0538, "Caldera International, Inc. (SCO)" },
	{ 0x0539, "Shyh Shiun Terminals Co., Ltd" },
	{ 0x053a, "PrehKeyTec GmbH" },
	{ 0x053b, "Global Village Communication" },
	{ 0x053c, "Institut of Microelectronic & Mechatronic Systems" },
	{ 0x053d, "Silicon Architect" },
	{ 0x053e, "Mobility Electronics" },
	{ 0x053f, "Synopsys, Inc." },
	{ 0x0540, "UniAccess AB" },
	{ 0x0541, "Sirf Technology, Inc." },
	{ 0x0543, "ViewSonic Corp." },
	{ 0x0544, "Cristie Electronics, Ltd" },
	{ 0x0545, "Xirlink, Inc." },
	{ 0x0546, "Polaroid Corp." },
	{ 0x0547, "Anchor Chips, Inc." },
	{ 0x0548, "Tyan Computer Corp." },
	{ 0x0549, "Pixera Corp." },
	{ 0x054a, "Fujitsu Microelectronics, Inc." },
	{ 0x054b, "New Media Corp." },
	{ 0x054c, "Sony Corp." },
	{ 0x054d, "Try Corp." },
	{ 0x054e, "Proside Corp." },
	{ 0x054f, "WYSE Technology Taiwan" },
	{ 0x0550, "Fuji Xerox Co., Ltd" },
	{ 0x0551, "CompuTrend Systems, Inc." },
	{ 0x0552, "Philips Monitors" },
	{ 0x0553, "STMicroelectronics Imaging Division (VLSI Vision)" },
	{ 0x0554, "Dictaphone Corp." },
	{ 0x0555, "ANAM S&T Co., Ltd" },
	{ 0x0556, "Asahi Kasei Microsystems Co., Ltd" },
	{ 0x0557, "ATEN International Co., Ltd" },
	{ 0x0558, "Truevision, Inc." },
	{ 0x0559, "Cadence Design Systems, Inc." },
	{ 0x055a, "Kenwood USA" },
	{ 0x055b, "KnowledgeTek, Inc." },
	{ 0x055c, "Proton Electronic Ind." },
	{ 0x055d, "Samsung Electro-Mechanics Co." },
	{ 0x055e, "CTX Opto-Electronics Corp." },
	{ 0x055f, "Mustek Systems, Inc." },
	{ 0x0560, "Interface Corp." },
	{ 0x0561, "Oasis Design, Inc." },
	{ 0x0562, "Telex Communications, Inc." },
	{ 0x0563, "Immersion Corp." },
	{ 0x0564, "Kodak Digital Product Center, Japan Ltd. (formerly Chinon Industries Inc.)" },
	{ 0x0565, "Peracom Networks, Inc." },
	{ 0x0566, "Monterey International Corp." },
	{ 0x0567, "Xyratex International, Ltd" },
	{ 0x0568, "Quartz Ingenierie" },
	{ 0x0569, "SegaSoft" },
	{ 0x056a, "Wacom Co., Ltd" },
	{ 0x056b, "Decicon, Inc." },
	{ 0x056c, "eTEK Labs" },
	{ 0x056d, "EIZO Corp." },
	{ 0x056e, "Elecom Co., Ltd" },
	{ 0x056f, "Korea Data Systems Co., Ltd" },
	{ 0x0570, "Epson America" },
	{ 0x0571, "Interex, Inc." },
	{ 0x0572, "Conexant Systems (Rockwell), Inc." },
	{ 0x0573, "Zoran Co. Personal Media Division (Nogatech)" },
	{ 0x0574, "City University of Hong Kong" },
	{ 0x0575, "Philips Creative Display Solutions" },
	{ 0x0576, "BAFO/Quality Computer Accessories" },
	{ 0x0577, "ELSA" },
	{ 0x0578, "Intrinsix Corp." },
	{ 0x0579, "GVC Corp." },
	{ 0x057a, "Samsung Electronics America" },
	{ 0x057b, "Y-E Data, Inc." },
	{ 0x057c, "AVM GmbH" },
	{ 0x057d, "Shark Multimedia, Inc." },
	{ 0x057e, "Nintendo Co., Ltd" },
	{ 0x057f, "QuickShot, Ltd" },
	{ 0x0580, "Denron, Inc." },
	{ 0x0581, "Racal Data Group" },
	{ 0x0582, "Roland Corp." },
	{ 0x0583, "Padix Co., Ltd (Rockfire)" },
	{ 0x0584, "RATOC System, Inc." },
	{ 0x0585, "FlashPoint Technology, Inc." },
	{ 0x0586, "ZyXEL Communications Corp." },
	{ 0x0587, "America Kotobuki Electronics Industries, Inc." },
	{ 0x0588, "Sapien Design" },
	{ 0x0589, "Victron" },
	{ 0x058a, "Nohau Corp." },
	{ 0x058b, "Infineon Technologies" },
	{ 0x058c, "In Focus Systems" },
	{ 0x058d, "Micrel Semiconductor" },
	{ 0x058e, "Tripath Technology, Inc." },
	{ 0x058f, "Alcor Micro Corp." },
	{ 0x0590, "Omron Corp." },
	{ 0x0591, "Questra Consulting" },
	{ 0x0592, "Powerware Corp." },
	{ 0x0593, "Incite" },
	{ 0x0594, "Princeton Graphic Systems" },
	{ 0x0595, "Zoran Microelectronics, Ltd" },
	{ 0x0596, "MicroTouch Systems, Inc." },
	{ 0x0597, "Trisignal Communications" },
	{ 0x0598, "Niigata Canotec Co., Inc." },
	{ 0x0599, "Brilliance Semiconductor, Inc." },
	{ 0x059a, "Spectrum Signal Processing, Inc." },
	{ 0x059b, "Iomega Corp." },
	{ 0x059c, "A-Trend Technology Co., Ltd" },
	{ 0x059d, "Advanced Input Devices" },
	{ 0x059e, "Intelligent Instrumentation" },
	{ 0x059f, "LaCie, Ltd" },
	{ 0x05a0, "Vetronix Corp." },
	{ 0x05a1, "USC Corp." },
	{ 0x05a2, "Fuji Film Microdevices Co., Ltd" },
	{ 0x05a3, "ARC International" },
	{ 0x05a4, "Ortek Technology, Inc." },
	{ 0x05a5, "Sampo Technology Corp." },
	{ 0x05a6, "Cisco Systems, Inc." },
	{ 0x05a7, "Bose Corp." },
	{ 0x05a8, "Spacetec IMC Corp." },
	{ 0x05a9, "OmniVision Technologies, Inc." },
	{ 0x05aa, "Utilux South China, Ltd" },
	{ 0x05ab, "In-System Design" },
	{ 0x05ac, "Apple, Inc." },
	{ 0x05ad, "Y.C. Cable U.S.A., Inc." },
	{ 0x05ae, "Synopsys, Inc." },
	{ 0x05af, "Jing-Mold Enterprise Co., Ltd" },
	{ 0x05b0, "Fountain Technologies, Inc." },
	{ 0x05b1, "First International Computer, Inc." },
	{ 0x05b4, "LG Semicon Co., Ltd" },
	{ 0x05b5, "Dialogic Corp." },
	{ 0x05b6, "Proxima Corp." },
	{ 0x05b7, "Medianix Semiconductor, Inc." },
	{ 0x05b8, "SYSGRATION" },
	{ 0x05b9, "Philips Research Laboratories" },
	{ 0x05ba, "DigitalPersona, Inc." },
	{ 0x05bb, "Grey Cell Systems" },
	{ 0x05bc, "3G Green Green Globe Co., Ltd" },
	{ 0x05bd, "RAFI GmbH & Co. KG" },
	{ 0x05be, "Tyco Electronics (Raychem)" },
	{ 0x05bf, "S & S Research" },
	{ 0x05c0, "Keil Software" },
	{ 0x05c1, "Kawasaki Microelectronics, Inc." },
	{ 0x05c2, "Media Phonics (Suisse) S.A." },
	{ 0x05c5, "Digi International, Inc." },
	{ 0x05c6, "Qualcomm, Inc." },
	{ 0x05c7, "Qtronix Corp." },
	{ 0x05c8, "Cheng Uei Precision Industry Co., Ltd (Foxlink)" },
	{ 0x05c9, "Semtech Corp." },
	{ 0x05ca, "Ricoh Co., Ltd" },
	{ 0x05cb, "PowerVision Technologies, Inc." },
	{ 0x05cc, "ELSA AG" },
	{ 0x05cd, "Silicom, Ltd" },
	{ 0x05ce, "sci-worx GmbH" },
	{ 0x05cf, "Sung Forn Co., Ltd" },
	{ 0x05d0, "GE Medical Systems Lunar" },
	{ 0x05d1, "Brainboxes, Ltd" },
	{ 0x05d2, "Wave Systems Corp." },
	{ 0x05d3, "Tohoku Ricoh Co., Ltd" },
	{ 0x05d5, "Super Gate Technology Co., Ltd" },
	{ 0x05d6, "Philips Semiconductors, CICT" },
	{ 0x05d7, "Thomas & Betts Corp." },
	{ 0x05d8, "Ultima Electronics Corp." },
	{ 0x05d9, "Axiohm Transaction Solutions" },
	{ 0x05da, "Microtek International, Inc." },
	{ 0x05db, "Sun Corp. (Suntac?)" },
	{ 0x05dc, "Lexar Media, Inc." },
	{ 0x05dd, "Delta Electronics, Inc." },
	{ 0x05df, "Silicon Vision, Inc." },
	{ 0x05e0, "Symbol Technologies" },
	{ 0x05e1, "Syntek Semiconductor Co., Ltd" },
	{ 0x05e2, "ElecVision, Inc." },
	{ 0x05e3, "Genesys Logic, Inc." },
	{ 0x05e4, "Red Wing Corp." },
	{ 0x05e5, "Fuji Electric Co., Ltd" },
	{ 0x05e6, "Keithley Instruments" },
	{ 0x05e8, "ICC, Inc." },
	{ 0x05e9, "Kawasaki LSI" },
	{ 0x05eb, "FFC, Ltd" },
	{ 0x05ec, "COM21, Inc." },
	{ 0x05ee, "Cytechinfo Inc." },
	{ 0x05ef, "AVB, Inc. [anko?]" },
	{ 0x05f0, "Canopus Co., Ltd" },
	{ 0x05f1, "Compass Communications" },
	{ 0x05f2, "Dexin Corp., Ltd" },
	{ 0x05f3, "PI Engineering, Inc." },
	{ 0x05f5, "Unixtar Technology, Inc." },
	{ 0x05f6, "AOC International" },
	{ 0x05f7, "RFC Distribution(s) PTE, Ltd" },
	{ 0x05f9, "PSC Scanning, Inc." },
	{ 0x05fa, "Siemens Telecommunications Systems, Ltd" },
	{ 0x05fc, "Harman" },
	{ 0x05fd, "InterAct, Inc." },
	{ 0x05fe, "Chic Technology Corp." },
	{ 0x05ff, "LeCroy Corp." },
	{ 0x0600, "Barco Display Systems" },
	{ 0x0601, "Jazz Hipster Corp." },
	{ 0x0602, "Vista Imaging, Inc." },
	{ 0x0603, "Novatek Microelectronics Corp." },
	{ 0x0604, "Jean Co., Ltd" },
	{ 0x0605, "Anchor C&C Co., Ltd" },
	{ 0x0606, "Royal Information Electronics Co., Ltd" },
	{ 0x0607, "Bridge Information Co., Ltd" },
	{ 0x0608, "Genrad Ads" },
	{ 0x0609, "SMK Manufacturing, Inc." },
	{ 0x060a, "Worthington Data Solutions, Inc." },
	{ 0x060b, "Solid Year" },
	{ 0x060c, "EEH Datalink GmbH" },
	{ 0x060d, "Auctor Corp." },
	{ 0x060e, "Transmonde Technologies, Inc." },
	{ 0x060f, "Joinsoon Electronics Mfg. Co., Ltd" },
	{ 0x0610, "Costar Electronics, Inc." },
	{ 0x0611, "Totoku Electric Co., Ltd" },
	{ 0x0613, "TransAct Technologies, Inc." },
	{ 0x0614, "Bio-Rad Laboratories" },
	{ 0x0615, "Quabbin Wire & Cable Co., Inc." },
	{ 0x0616, "Future Techno Designs PVT, Ltd" },
	{ 0x0617, "Swiss Federal Insitute of Technology" },
	{ 0x0618, "MacAlly" },
	{ 0x0619, "Seiko Instruments, Inc." },
	{ 0x061a, "Veridicom International, Inc." },
	{ 0x061b, "Promptus Communications, Inc." },
	{ 0x061c, "Act Labs, Ltd" },
	{ 0x061d, "Quatech, Inc." },
	{ 0x061e, "Nissei Electric Co." },
	{ 0x0620, "Alaris, Inc." },
	{ 0x0621, "ODU-Steckverbindungssysteme GmbH & Co. KG" },
	{ 0x0622, "Iotech, Inc." },
	{ 0x0623, "Littelfuse, Inc." },
	{ 0x0624, "Avocent Corp." },
	{ 0x0625, "TiMedia Technology Co., Ltd" },
	{ 0x0626, "Nippon Systems Development Co., Ltd" },
	{ 0x0627, "Adomax Technology Co., Ltd" },
	{ 0x0628, "Tasking Software, Inc." },
	{ 0x0629, "Zida Technologies, Ltd" },
	{ 0x062a, "MosArt Semiconductor Corp." },
	{ 0x062b, "Greatlink Electronics Taiwan, Ltd" },
	{ 0x062c, "Institute for Information Industry" },
	{ 0x062d, "Taiwan Tai-Hao Enterprises Co., Ltd" },
	{ 0x062e, "Mainsuper Enterprises Co., Ltd" },
	{ 0x062f, "Sin Sheng Terminal & Machine, Inc." },
	{ 0x0631, "JUJO Electronics Corp." },
	{ 0x0633, "Cyrix Corp." },
	{ 0x0634, "Micron Technology, Inc." },
	{ 0x0635, "Methode Electronics, Inc." },
	{ 0x0636, "Sierra Imaging, Inc." },
	{ 0x0638, "Avision, Inc." },
	{ 0x0639, "Chrontel, Inc." },
	{ 0x063a, "Techwin Corp." },
	{ 0x063b, "Taugagreining HF" },
	{ 0x063c, "Yamaichi Electronics Co., Ltd (Sakura)" },
	{ 0x063d, "Fong Kai Industrial Co., Ltd" },
	{ 0x063e, "RealMedia Technology, Inc." },
	{ 0x063f, "New Technology Cable, Ltd" },
	{ 0x0640, "Hitex Development Tools" },
	{ 0x0641, "Woods Industries, Inc." },
	{ 0x0642, "VIA Medical Corp." },
	{ 0x0644, "TEAC Corp." },
	{ 0x0645, "Who? Vision Systems, Inc." },
	{ 0x0646, "UMAX" },
	{ 0x0647, "Acton Research Corp." },
	{ 0x0648, "Inside Out Networks" },
	{ 0x0649, "Weli Science Co., Ltd" },
	{ 0x064b, "Analog Devices, Inc. (White Mountain DSP)" },
	{ 0x064c, "Ji-Haw Industrial Co., Ltd" },
	{ 0x064d, "TriTech Microelectronics, Ltd" },
	{ 0x064e, "Suyin Corp." },
	{ 0x064f, "WIBU-Systems AG" },
	{ 0x0650, "Dynapro Systems" },
	{ 0x0651, "Likom Technology Sdn. Bhd." },
	{ 0x0652, "Stargate Solutions, Inc." },
	{ 0x0653, "CNF, Inc." },
	{ 0x0654, "Granite Microsystems, Inc." },
	{ 0x0655, "Space Shuttle Hi-Tech Co., Ltd" },
	{ 0x0656, "Glory Mark Electronic, Ltd" },
	{ 0x0657, "Tekcon Electronics Corp." },
	{ 0x0658, "Sigma Designs, Inc." },
	{ 0x0659, "Aethra" },
	{ 0x065a, "Optoelectronics Co., Ltd" },
	{ 0x065b, "Tracewell Systems" },
	{ 0x065e, "Silicon Graphics" },
	{ 0x065f, "Good Way Technology Co., Ltd & GWC technology Inc." },
	{ 0x0660, "TSAY-E (BVI) International, Inc." },
	{ 0x0661, "Hamamatsu Photonics K.K." },
	{ 0x0662, "Kansai Electric Co., Ltd" },
	{ 0x0663, "Topmax Electronic Co., Ltd" },
	{ 0x0664, "ET&T Technology Co., Ltd." },
	{ 0x0665, "Cypress Semiconductor" },
	{ 0x0667, "Aiwa Co., Ltd" },
	{ 0x0668, "WordWand" },
	{ 0x0669, "Oce' Printing Systems GmbH" },
	{ 0x066a, "Total Technologies, Ltd" },
	{ 0x066b, "Linksys, Inc." },
	{ 0x066d, "Entrega, Inc." },
	{ 0x066e, "Acer Semiconductor America, Inc." },
	{ 0x066f, "SigmaTel, Inc." },
	{ 0x0670, "Sequel Imaging" },
	{ 0x0672, "Labtec, Inc." },
	{ 0x0673, "HCL" },
	{ 0x0674, "Key Mouse Electronic Enterprise Co., Ltd" },
	{ 0x0675, "DrayTek Corp." },
	{ 0x0676, "Teles AG" },
	{ 0x0677, "Aiwa Co., Ltd" },
	{ 0x0678, "ACard Technology Corp." },
	{ 0x067b, "Prolific Technology, Inc." },
	{ 0x067c, "Efficient Networks, Inc." },
	{ 0x067d, "Hohner Corp." },
	{ 0x067e, "Intermec Technologies Corp." },
	{ 0x067f, "Virata, Ltd" },
	{ 0x0680, "Realtek Semiconductor Corp., CPP Div. (Avance Logic)" },
	{ 0x0681, "Siemens Information and Communication Products" },
	{ 0x0682, "Victor Company of Japan, Ltd" },
	{ 0x0684, "Actiontec Electronics, Inc." },
	{ 0x0685, "ZD Incorporated" },
	{ 0x0686, "Minolta Co., Ltd" },
	{ 0x068a, "Pertech, Inc." },
	{ 0x068b, "Potrans International, Inc." },
	{ 0x068e, "CH Products, Inc." },
	{ 0x068f, "Nihon KOHDEN" },
	{ 0x0690, "Golden Bridge Electech, Inc." },
	{ 0x0693, "Hagiwara Sys-Com Co., Ltd" },
	{ 0x0694, "Lego Group" },
	{ 0x0698, "Chuntex (CTX)" },
	{ 0x0699, "Tektronix, Inc." },
	{ 0x069a, "Askey Computer Corp." },
	{ 0x069b, "Thomson, Inc." },
	{ 0x069d, "Hughes Network Systems (HNS)" },
	{ 0x069e, "Welcat Inc." },
	{ 0x069f, "Allied Data Technologies BV" },
	{ 0x06a2, "Topro Technology, Inc." },
	{ 0x06a3, "Saitek PLC" },
	{ 0x06a4, "Xiamen Doowell Electron Co., Ltd" },
	{ 0x06a5, "Divio" },
	{ 0x06a7, "MicroStore, Inc." },
	{ 0x06a8, "Topaz Systems, Inc." },
	{ 0x06a9, "Westell" },
	{ 0x06aa, "Sysgration, Ltd" },
	{ 0x06ac, "Fujitsu Laboratories of America, Inc." },
	{ 0x06ad, "Greatland Electronics Taiwan, Ltd" },
	{ 0x06ae, "Professional Multimedia Testing Centre" },
	{ 0x06af, "Harting, Inc. of North America" },
	{ 0x06b8, "Pixela Corp." },
	{ 0x06b9, "Alcatel Telecom" },
	{ 0x06ba, "Smooth Cord & Connector Co., Ltd" },
	{ 0x06bb, "EDA, Inc." },
	{ 0x06bc, "Oki Data Corp." },
	{ 0x06bd, "AGFA-Gevaert NV" },
	{ 0x06be, "AME Optimedia Technology Co., Ltd" },
	{ 0x06bf, "Leoco Corp." },
	{ 0x06c2, "Phidgets Inc. (formerly GLAB)" },
	{ 0x06c4, "Bizlink International Corp." },
	{ 0x06c5, "Hagenuk, GmbH" },
	{ 0x06c6, "Infowave Software, Inc." },
	{ 0x06c8, "SIIG, Inc." },
	{ 0x06c9, "Taxan (Europe), Ltd" },
	{ 0x06ca, "Newer Technology, Inc." },
	{ 0x06cb, "Synaptics, Inc." },
	{ 0x06cc, "Terayon Communication Systems" },
	{ 0x06cd, "Keyspan" },
	{ 0x06ce, "Contec" },
	{ 0x06cf, "SpheronVR AG" },
	{ 0x06d0, "LapLink, Inc." },
	{ 0x06d1, "Daewoo Electronics Co., Ltd" },
	{ 0x06d3, "Mitsubishi Electric Corp." },
	{ 0x06d4, "Cisco Systems" },
	{ 0x06d5, "Toshiba" },
	{ 0x06d6, "Aashima Technology B.V." },
	{ 0x06d7, "Network Computing Devices (NCD)" },
	{ 0x06d8, "Technical Marketing Research, Inc." },
	{ 0x06da, "Phoenixtec Power Co., Ltd" },
	{ 0x06db, "Paradyne" },
	{ 0x06dc, "Foxlink Image Technology Co., Ltd" },
	{ 0x06de, "Heisei Electronics Co., Ltd" },
	{ 0x06e0, "Multi-Tech Systems, Inc." },
	{ 0x06e1, "ADS Technologies, Inc." },
	{ 0x06e4, "Alcatel Microelectronics" },
	{ 0x06e6, "Tiger Jet Network, Inc." },
	{ 0x06ea, "Sirius Technologies" },
	{ 0x06eb, "PC Expert Tech. Co., Ltd" },
	{ 0x06ef, "I.A.C. Geometrische Ingenieurs B.V." },
	{ 0x06f0, "T.N.C Industrial Co., Ltd" },
	{ 0x06f1, "Opcode Systems, Inc." },
	{ 0x06f2, "Emine Technology Co." },
	{ 0x06f6, "Wintrend Technology Co., Ltd" },
	{ 0x06f7, "Wailly Technology Ltd" },
	{ 0x06f8, "Guillemot Corp." },
	{ 0x06f9, "ASYST electronic d.o.o." },
	{ 0x06fa, "HSD S.r.L" },
	{ 0x06fc, "Motorola Semiconductor Products Sector" },
	{ 0x06fd, "Boston Acoustics" },
	{ 0x06fe, "Gallant Computer, Inc." },
	{ 0x0701, "Supercomal Wire & Cable SDN. BHD." },
	{ 0x0703, "Bvtech Industry, Inc." },
	{ 0x0705, "NKK Corp." },
	{ 0x0706, "Ariel Corp." },
	{ 0x0707, "Standard Microsystems Corp." },
	{ 0x0708, "Putercom Co., Ltd" },
	{ 0x0709, "Silicon Systems, Ltd (SSL)" },
	{ 0x070a, "Oki Electric Industry Co., Ltd" },
	{ 0x070d, "Comoss Electronic Co., Ltd" },
	{ 0x070e, "Excel Cell Electronic Co., Ltd" },
	{ 0x0710, "Connect Tech, Inc." },
	{ 0x0711, "Magic Control Technology Corp." },
	{ 0x0713, "Interval Research Corp." },
	{ 0x0714, "NewMotion, Inc." },
	{ 0x0717, "ZNK Corp." },
	{ 0x0718, "Imation Corp." },
	{ 0x0719, "Tremon Enterprises Co., Ltd" },
	{ 0x071b, "Domain Technologies, Inc." },
	{ 0x071c, "Xionics Document Technologies, Inc." },
	{ 0x071d, "Eicon Networks Corp." },
	{ 0x071e, "Ariston Technologies" },
	{ 0x0720, "Keyence Corp." },
	{ 0x0723, "Centillium Communications Corp." },
	{ 0x0726, "Vanguard International Semiconductor-America" },
	{ 0x0729, "Amitm" },
	{ 0x072e, "Sunix Co., Ltd" },
	{ 0x072f, "Advanced Card Systems, Ltd" },
	{ 0x0731, "Susteen, Inc." },
	{ 0x0732, "Goldfull Electronics & Telecommunications Corp." },
	{ 0x0733, "ViewQuest Technologies, Inc." },
	{ 0x0734, "Lasat Communications A/S" },
	{ 0x0735, "Asuscom Network" },
	{ 0x0736, "Lorom Industrial Co., Ltd" },
	{ 0x0738, "Mad Catz, Inc." },
	{ 0x073a, "Chaplet Systems, Inc." },
	{ 0x073b, "Suncom Technologies" },
	{ 0x073c, "Industrial Electronic Engineers, Inc." },
	{ 0x073d, "Eutron S.p.a." },
	{ 0x073e, "NEC, Inc." },
	{ 0x0742, "Stollmann" },
	{ 0x0745, "Syntech Information Co., Ltd" },
	{ 0x0746, "Onkyo Corp." },
	{ 0x0747, "Labway Corp." },
	{ 0x0748, "Strong Man Enterprise Co., Ltd" },
	{ 0x0749, "EVer Electronics Corp." },
	{ 0x074a, "Ming Fortune Industry Co., Ltd" },
	{ 0x074b, "Polestar Tech. Corp." },
	{ 0x074c, "C-C-C Group PLC" },
	{ 0x074d, "Micronas GmbH" },
	{ 0x074e, "Digital Stream Corp." },
	{ 0x0755, "Aureal Semiconductor" },
	{ 0x0757, "Network Technologies, Inc." },
	{ 0x0758, "Carl Zeiss Microscopy GmbH" },
	{ 0x075b, "Sophisticated Circuits, Inc." },
	{ 0x0763, "M-Audio" },
	{ 0x0764, "Cyber Power System, Inc." },
	{ 0x0765, "X-Rite, Inc." },
	{ 0x0766, "Jess-Link Products Co., Ltd" },
	{ 0x0767, "Tokheim Corp." },
	{ 0x0768, "Camtel Technology Corp." },
	{ 0x0769, "Surecom Technology Corp." },
	{ 0x076a, "Smart Technology Enablers, Inc." },
	{ 0x076b, "OmniKey AG" },
	{ 0x076c, "Partner Tech" },
	{ 0x076d, "Denso Corp." },
	{ 0x076e, "Kuan Tech Enterprise Co., Ltd" },
	{ 0x076f, "Jhen Vei Electronic Co., Ltd" },
	{ 0x0770, "Welch Allyn, Inc - Medical Division" },
	{ 0x0771, "Observator Instruments BV" },
	{ 0x0772, "Your data Our Care" },
	{ 0x0774, "AmTRAN Technology Co., Ltd" },
	{ 0x0775, "Longshine Electronics Corp." },
	{ 0x0776, "Inalways Corp." },
	{ 0x0777, "Comda Enterprise Corp." },
	{ 0x0778, "Volex, Inc." },
	{ 0x0779, "ON Semiconductor (formerly Fairchild)" },
	{ 0x077a, "Sankyo Seiki Mfg. Co., Ltd" },
	{ 0x077b, "Linksys" },
	{ 0x077c, "Forward Electronics Co., Ltd" },
	{ 0x077d, "Griffin Technology" },
	{ 0x077e, "Softing AG" },
	{ 0x077f, "Well Excellent & Most Corp." },
	{ 0x0780, "Sagem Monetel GmbH" },
	{ 0x0781, "SanDisk Corp." },
	{ 0x0782, "Trackerball" },
	{ 0x0783, "C3PO" },
	{ 0x0784, "Vivitar, Inc." },
	{ 0x0785, "NTT-ME" },
	{ 0x0789, "Logitec Corp." },
	{ 0x078b, "Happ Controls, Inc." },
	{ 0x078c, "GTCO/CalComp" },
	{ 0x078e, "Brincom, Inc." },
	{ 0x0790, "Pro-Image Manufacturing Co., Ltd" },
	{ 0x0791, "Copartner Wire and Cable Mfg. Corp." },
	{ 0x0792, "Axis Communications AB" },
	{ 0x0793, "Wha Yu Industrial Co., Ltd" },
	{ 0x0794, "ABL Electronics Corp." },
	{ 0x0795, "RealChip, Inc." },
	{ 0x0796, "Certicom Corp." },
	{ 0x0797, "Grandtech Semiconductor Corp." },
	{ 0x0798, "Optelec" },
	{ 0x0799, "Altera" },
	{ 0x079b, "Sagem" },
	{ 0x079d, "Alfadata Computer Corp." },
	{ 0x07a1, "Digicom S.p.A." },
	{ 0x07a2, "National Technical Systems" },
	{ 0x07a3, "Onnto Corp." },
	{ 0x07a4, "Be, Inc." },
	{ 0x07a6, "ADMtek, Inc." },
	{ 0x07aa, "Corega K.K." },
	{ 0x07ab, "Freecom Technologies" },
	{ 0x07af, "Microtech" },
	{ 0x07b0, "Trust Technologies" },
	{ 0x07b1, "IMP, Inc." },
	{ 0x07b2, "Motorola BCS, Inc." },
	{ 0x07b3, "Plustek, Inc." },
	{ 0x07b4, "Olympus Optical Co., Ltd" },
	{ 0x07b5, "Mega World International, Ltd" },
	{ 0x07b6, "Marubun Corp." },
	{ 0x07b7, "TIME Interconnect, Ltd" },
	{ 0x07b8, "AboCom Systems Inc" },
	{ 0x07bc, "Canon Computer Systems, Inc." },
	{ 0x07bd, "Webgear, Inc." },
	{ 0x07be, "Veridicom" },
	{ 0x07c0, "Code Mercenaries Hard- und Software GmbH" },
	{ 0x07c1, "Keisokugiken" },
	{ 0x07c4, "Datafab Systems, Inc." },
	{ 0x07c5, "APG Cash Drawer" },
	{ 0x07c6, "ShareWave, Inc." },
	{ 0x07c7, "Powertech Industrial Co., Ltd" },
	{ 0x07c8, "B.U.G., Inc." },
	{ 0x07c9, "Allied Telesyn International" },
	{ 0x07ca, "AVerMedia Technologies, Inc." },
	{ 0x07cb, "Kingmax Technology, Inc." },
	{ 0x07cc, "Carry Computer Eng., Co., Ltd" },
	{ 0x07cd, "Elektor" },
	{ 0x07ce, "Nidec Copal" },
	{ 0x07cf, "Casio Computer Co., Ltd" },
	{ 0x07d0, "Dazzle" },
	{ 0x07d1, "D-Link System" },
	{ 0x07d2, "Aptio Products, Inc." },
	{ 0x07d3, "Cyberdata Corp." },
	{ 0x07d5, "Radiant Systems" },
	{ 0x07d7, "GCC Technologies, Inc." },
	{ 0x07da, "Arasan Chip Systems" },
	{ 0x07de, "Diamond Multimedia" },
	{ 0x07df, "David Electronics Co., Ltd" },
	{ 0x07e0, "NCP engineering GmbH" },
	{ 0x07e1, "Ambient Technologies, Inc." },
	{ 0x07e2, "Elmeg GmbH & Co., Ltd" },
	{ 0x07e3, "Planex Communications, Inc." },
	{ 0x07e4, "Movado Enterprise Co., Ltd" },
	{ 0x07e5, "QPS, Inc." },
	{ 0x07e6, "Allied Cable Corp." },
	{ 0x07e7, "Mirvo Toys, Inc." },
	{ 0x07e8, "Labsystems" },
	{ 0x07ea, "Iwatsu Electric Co., Ltd" },
	{ 0x07eb, "Double-H Technology Co., Ltd" },
	{ 0x07ec, "Taiyo Electric Wire & Cable Co., Ltd" },
	{ 0x07ee, "Torex Retail (formerly Logware)" },
	{ 0x07ef, "STSN" },
	{ 0x07f2, "Microcomputer Applications, Inc." },
	{ 0x07f6, "Circuit Assembly Corp." },
	{ 0x07f7, "Century Corp." },
	{ 0x07f9, "Dotop Technology, Inc." },
	{ 0x07fa, "DrayTek Corp." },
	{ 0x07fc, "Thomann" },
	{ 0x07fd, "Mark of the Unicorn" },
	{ 0x07ff, "Unknown" },
	{ 0x0801, "MagTek" },
	{ 0x0802, "Mako Technologies, LLC" },
	{ 0x0803, "Zoom Telephonics, Inc." },
	{ 0x0809, "Genicom Technology, Inc." },
	{ 0x080a, "Evermuch Technology Co., Ltd" },
	{ 0x080b, "Cross Match Technologies" },
	{ 0x080c, "Datalogic S.p.A." },
	{ 0x080d, "Teco Image Systems Co., Ltd" },
	{ 0x0810, "Personal Communication Systems, Inc." },
	{ 0x0813, "Mattel, Inc." },
	{ 0x0819, "eLicenser" },
	{ 0x081a, "MG Logic" },
	{ 0x081b, "Indigita Corp." },
	{ 0x081c, "Mipsys" },
	{ 0x081e, "AlphaSmart, Inc." },
	{ 0x081f, "Manta" },
	{ 0x0822, "Reudo Corp." },
	{ 0x0825, "GC Protronics" },
	{ 0x0826, "Data Transit" },
	{ 0x0827, "BroadLogic, Inc." },
	{ 0x0828, "Sato Corp." },
	{ 0x0829, "DirecTV Broadband, Inc. (Telocity)" },
	{ 0x082d, "Handspring" },
	{ 0x0830, "Palm, Inc." },
	{ 0x0832, "Kouwell Electronics Corp." },
	{ 0x0833, "Sourcenext Corp." },
	{ 0x0835, "Action Star Enterprise Co., Ltd" },
	{ 0x0836, "TrekStor" },
	{ 0x0839, "Samsung Techwin Co., Ltd" },
	{ 0x083a, "Accton Technology Corp." },
	{ 0x083f, "Global Village" },
	{ 0x0840, "Argosy Research, Inc." },
	{ 0x0841, "Rioport.com, Inc." },
	{ 0x0844, "Welland Industrial Co., Ltd" },
	{ 0x0846, "NetGear, Inc." },
	{ 0x084d, "Minton Optic Industry Co., Inc." },
	{ 0x084e, "KB Gear" },
	{ 0x084f, "Empeg" },
	{ 0x0850, "Fast Point Technologies, Inc." },
	{ 0x0851, "Macronix International Co., Ltd" },
	{ 0x0852, "CSEM" },
	{ 0x0853, "Topre Corporation" },
	{ 0x0854, "ActiveWire, Inc." },
	{ 0x0856, "B&B Electronics" },
	{ 0x0858, "Hitachi Maxell, Ltd" },
	{ 0x0859, "Minolta Systems Laboratory, Inc." },
	{ 0x085a, "Xircom" },
	{ 0x085c, "ColorVision, Inc." },
	{ 0x0862, "Teletrol Systems, Inc." },
	{ 0x0863, "Filanet Corp." },
	{ 0x0864, "NetGear, Inc." },
	{ 0x0867, "Data Translation, Inc." },
	{ 0x086a, "Emagic Soft- und Hardware GmbH" },
	{ 0x086c, "DeTeWe - Deutsche Telephonwerke AG & Co." },
	{ 0x086e, "System TALKS, Inc." },
	{ 0x086f, "MEC IMEX, Inc." },
	{ 0x0870, "Metricom" },
	{ 0x0871, "SanDisk, Inc." },
	{ 0x0873, "Xpeed, Inc." },
	{ 0x0874, "A-Tec Subsystem, Inc." },
	{ 0x0879, "Comtrol Corp." },
	{ 0x087c, "Adesso/Kbtek America, Inc." },
	{ 0x087d, "Jaton Corp." },
	{ 0x087e, "Fujitsu Computer Products of America" },
	{ 0x087f, "QualCore Logic Inc." },
	{ 0x0880, "APT Technologies, Inc." },
	{ 0x0883, "Recording Industry Association of America (RIAA)" },
	{ 0x0885, "Boca Research, Inc." },
	{ 0x0886, "XAC Automation Corp." },
	{ 0x0887, "Hannstar Electronics Corp." },
	{ 0x088a, "TechTools" },
	{ 0x088b, "MassWorks, Inc." },
	{ 0x088c, "Swecoin AB" },
	{ 0x088e, "iLok" },
	{ 0x0892, "DioGraphy, Inc." },
	{ 0x0894, "TSI Incorporated" },
	{ 0x0897, "Lauterbach" },
	{ 0x089c, "United Technologies Research Cntr." },
	{ 0x089d, "Icron Technologies Corp." },
	{ 0x089e, "NST Co., Ltd" },
	{ 0x089f, "Primex Aerospace Co." },
	{ 0x08a5, "e9, Inc." },
	{ 0x08a6, "Toshiba TEC" },
	{ 0x08a8, "Andrea Electronics" },
	{ 0x08a9, "CWAV Inc." },
	{ 0x08ac, "Macraigor Systems LLC" },
	{ 0x08ae, "Macally (Mace Group, Inc.)" },
	{ 0x08b0, "Metrohm" },
	{ 0x08b4, "Sorenson Vision, Inc." },
	{ 0x08b7, "NATSU" },
	{ 0x08b8, "J. Gordon Electronic Design, Inc." },
	{ 0x08b9, "RadioShack Corp. (Tandy)" },
	{ 0x08bb, "Texas Instruments" },
	{ 0x08bd, "Citizen Watch Co., Ltd" },
	{ 0x08c3, "Precise Biometrics" },
	{ 0x08c4, "Proxim, Inc." },
	{ 0x08c7, "Key Nice Enterprise Co., Ltd" },
	{ 0x08c8, "2Wire, Inc." },
	{ 0x08c9, "Nippon Telegraph and Telephone Corp." },
	{ 0x08ca, "Aiptek International, Inc." },
	{ 0x08cd, "Jue Hsun Ind. Corp." },
	{ 0x08ce, "Long Well Electronics Corp." },
	{ 0x08cf, "Productivity Enhancement Products" },
	{ 0x08d1, "smartBridges, Inc." },
	{ 0x08d3, "Virtual Ink" },
	{ 0x08d4, "Fujitsu Siemens Computers" },
	{ 0x08d8, "IXXAT Automation GmbH" },
	{ 0x08d9, "Increment P Corp." },
	{ 0x08dd, "Billionton Systems, Inc." },
	{ 0x08de, "?" },
	{ 0x08df, "Spyrus, Inc." },
	{ 0x08e3, "Olitec, Inc." },
	{ 0x08e4, "Pioneer Corp." },
	{ 0x08e5, "Litronic" },
	{ 0x08e6, "Gemalto (was Gemplus)" },
	{ 0x08e7, "Pan-International Wire & Cable" },
	{ 0x08e8, "Integrated Memory Logic" },
	{ 0x08e9, "Extended Systems, Inc." },
	{ 0x08ea, "Ericsson, Inc., Blue Ridge Labs" },
	{ 0x08ec, "M-Systems Flash Disk Pioneers" },
	{ 0x08ed, "MediaTek Inc." },
	{ 0x08ee, "CCSI/Hesso" },
	{ 0x08f0, "Corex Technologies" },
	{ 0x08f1, "CTI Electronics Corp." },
	{ 0x08f2, "Gotop Information Inc." },
	{ 0x08f5, "SysTec Co., Ltd" },
	{ 0x08f6, "Logic 3 International, Ltd" },
	{ 0x08f7, "Vernier" },
	{ 0x08f8, "Keen Top International Enterprise Co., Ltd" },
	{ 0x08f9, "Wipro Technologies" },
	{ 0x08fa, "Caere" },
	{ 0x08fb, "Socket Communications" },
	{ 0x08fc, "Sicon Cable Technology Co., Ltd" },
	{ 0x08fd, "Digianswer A/S" },
	{ 0x08ff, "AuthenTec, Inc." },
	{ 0x0900, "Pinnacle Systems, Inc." },
	{ 0x0901, "VST Technologies" },
	{ 0x0906, "Faraday Technology Corp." },
	{ 0x0908, "Siemens AG" },
	{ 0x0909, "Audio-Technica Corp." },
	{ 0x090a, "Trumpion Microelectronics, Inc." },
	{ 0x090b, "Neurosmith" },
	{ 0x090c, "Silicon Motion, Inc. - Taiwan (formerly Feiya Technology Corp.)" },
	{ 0x090d, "Multiport Computer Vertriebs GmbH" },
	{ 0x090e, "Shining Technology, Inc." },
	{ 0x090f, "Fujitsu Devices, Inc." },
	{ 0x0910, "Alation Systems, Inc." },
	{ 0x0911, "Philips Speech Processing" },
	{ 0x0912, "Voquette, Inc." },
	{ 0x0915, "GlobeSpan, Inc." },
	{ 0x0917, "SmartDisk Corp." },
	{ 0x0919, "Tiger Electronics" },
	{ 0x091e, "Garmin International" },
	{ 0x0920, "Echelon Co." },
	{ 0x0921, "GoHubs, Inc." },
	{ 0x0922, "Dymo-CoStar Corp." },
	{ 0x0923, "IC Media Corp." },
	{ 0x0924, "Xerox" },
	{ 0x0925, "Lakeview Research" },
	{ 0x0927, "Summus, Ltd" },
	{ 0x0928, "PLX Technology, Inc. (formerly Oxford Semiconductor, Ltd)" },
	{ 0x0929, "American Biometric Co." },
	{ 0x092a, "Toshiba Information & Industrial Sys. And Services" },
	{ 0x092b, "Sena Technologies, Inc." },
	{ 0x092f, "Northern Embedded Science/CAVNEX" },
	{ 0x0930, "Toshiba Corp." },
	{ 0x0931, "Harmonic Data Systems, Ltd" },
	{ 0x0932, "Crescentec Corp." },
	{ 0x0933, "Quantum Corp." },
	{ 0x0934, "Spirent Communications" },
	{ 0x0936, "NuTesla" },
	{ 0x0939, "Lumberg, Inc." },
	{ 0x093a, "Pixart Imaging, Inc." },
	{ 0x093b, "Plextor Corp." },
	{ 0x093c, "Intrepid Control Systems, Inc." },
	{ 0x093d, "InnoSync, Inc." },
	{ 0x093e, "J.S.T. Mfg. Co., Ltd" },
	{ 0x093f, "Olympia Telecom Vertriebs GmbH" },
	{ 0x0940, "Japan Storage Battery Co., Ltd" },
	{ 0x0941, "Photobit Corp." },
	{ 0x0942, "i2Go.com, LLC" },
	{ 0x0943, "HCL Technologies India Private, Ltd" },
	{ 0x0944, "KORG, Inc." },
	{ 0x0945, "Pasco Scientific" },
	{ 0x0948, "Kronauer music in digital" },
	{ 0x094b, "Linkup Systems Corp." },
	{ 0x094d, "Cable Television Laboratories" },
	{ 0x094f, "Yano" },
	{ 0x0951, "Kingston Technology" },
	{ 0x0954, "RPM Systems Corp." },
	{ 0x0955, "NVIDIA Corp." },
	{ 0x0956, "BSquare Corp." },
	{ 0x0957, "Agilent Technologies, Inc." },
	{ 0x0958, "CompuLink Research, Inc." },
	{ 0x0959, "Cologne Chip AG" },
	{ 0x095a, "Portsmith" },
	{ 0x095b, "Medialogic Corp." },
	{ 0x095c, "K-Tec Electronics" },
	{ 0x095d, "Polycom, Inc." },
	{ 0x0964, "BITRAN" },
	{ 0x0967, "Acer NeWeb Corp." },
	{ 0x0968, "Catalyst Enterprises, Inc." },
	{ 0x096e, "Feitian Technologies, Inc." },
	{ 0x0971, "Gretag-Macbeth AG" },
	{ 0x0973, "Schlumberger" },
	{ 0x0974, "Datagraphix, a business unit of Anacomp" },
	{ 0x0975, "OL'E Communications, Inc." },
	{ 0x0976, "Adirondack Wire & Cable" },
	{ 0x0977, "Lightsurf Technologies" },
	{ 0x0978, "Beckhoff GmbH" },
	{ 0x0979, "Jeilin Technology Corp., Ltd" },
	{ 0x097a, "Minds At Work LLC" },
	{ 0x097b, "Knudsen Engineering, Ltd" },
	{ 0x097c, "Marunix Co., Ltd" },
	{ 0x097d, "Rosun Technologies, Inc." },
	{ 0x097e, "Biopac Systems Inc." },
	{ 0x097f, "Barun Electronics Co., Ltd" },
	{ 0x0981, "Oak Technology, Ltd" },
	{ 0x0984, "Apricorn" },
	{ 0x0985, "cab Produkttechnik GmbH & Co KG" },
	{ 0x0986, "Matsushita Electric Works, Ltd." },
	{ 0x098c, "Vitana Corp." },
	{ 0x098d, "INDesign" },
	{ 0x098e, "Integrated Intellectual Property, Inc." },
	{ 0x098f, "Kenwood TMI Corp." },
	{ 0x0993, "Gemstar eBook Group, Ltd" },
	{ 0x0996, "Integrated Telecom Express, Inc." },
	{ 0x099a, "Zippy Technology Corp." },
	{ 0x099e, "Trimble Navigation, Ltd" },
	{ 0x09a3, "PairGain Technologies" },
	{ 0x09a4, "Contech Research, Inc." },
	{ 0x09a5, "VCON Telecommunications" },
	{ 0x09a6, "Poinchips" },
	{ 0x09a7, "Data Transmission Network Corp." },
	{ 0x09a8, "Lin Shiung Enterprise Co., Ltd" },
	{ 0x09a9, "Smart Card Technologies Co., Ltd" },
	{ 0x09aa, "Intersil Corp." },
	{ 0x09ab, "Japan Cash Machine Co., Ltd." },
	{ 0x09ae, "Tripp Lite" },
	{ 0x09b0, "Fargo" },
	{ 0x09b2, "Franklin Electronic Publishers, Inc." },
	{ 0x09b3, "Altius Solutions, Inc." },
	{ 0x09b4, "MDS Telephone Systems" },
	{ 0x09b5, "Celltrix Technology Co., Ltd" },
	{ 0x09bc, "Grundig" },
	{ 0x09be, "MySmart.Com" },
	{ 0x09bf, "Auerswald GmbH & Co. KG" },
	{ 0x09c0, "Genpix Electronics, LLC" },
	{ 0x09c1, "Arris Interactive LLC" },
	{ 0x09c2, "Nisca Corp." },
	{ 0x09c3, "HID Global" },
	{ 0x09c4, "ACTiSYS Corp." },
	{ 0x09c5, "Memory Corp." },
	{ 0x09ca, "BMC Messsysteme GmbH" },
	{ 0x09cb, "FLIR Systems" },
	{ 0x09cc, "Workbit Corp." },
	{ 0x09cd, "Psion Dacom Home Networks, Ltd" },
	{ 0x09ce, "City Electronics, Ltd" },
	{ 0x09cf, "Electronics Testing Center, Taiwan" },
	{ 0x09d1, "NeoMagic, Inc." },
	{ 0x09d2, "Vreelin Engineering, Inc." },
	{ 0x09d3, "Com One" },
	{ 0x09d7, "Hexagon NovAtel Inc." },
	{ 0x09d8, "ELATEC GmbH" },
	{ 0x09d9, "KRF Tech, Ltd" },
	{ 0x09da, "A4Tech Co., Ltd." },
	{ 0x09db, "Measurement Computing Corp." },
	{ 0x09dc, "Aimex Corp." },
	{ 0x09dd, "Fellowes, Inc." },
	{ 0x09df, "Addonics Technologies Corp." },
	{ 0x09e1, "Intellon Corp." },
	{ 0x09e5, "Jo-Dan International, Inc." },
	{ 0x09e6, "Silutia, Inc." },
	{ 0x09e7, "Real 3D, Inc." },
	{ 0x09e8, "AKAI  Professional M.I. Corp." },
	{ 0x09e9, "Chen-Source, Inc." },
	{ 0x09eb, "IM Networks, Inc." },
	{ 0x09ef, "Xitel" },
	{ 0x09f3, "GoFlight, Inc." },
	{ 0x09f5, "AresCom" },
	{ 0x09f6, "RocketChips, Inc." },
	{ 0x09f7, "Edu-Science (H.K.), Ltd" },
	{ 0x09f8, "SoftConnex Technologies, Inc." },
	{ 0x09f9, "Bay Associates" },
	{ 0x09fa, "Mtek Vision" },
	{ 0x09fb, "Altera" },
	{ 0x09ff, "Gain Technology Corp." },
	{ 0x0a00, "Liquid Audio" },
	{ 0x0a01, "ViA, Inc." },
	{ 0x0a05, "Unknown Manufacturer" },
	{ 0x0a07, "Ontrak Control Systems Inc." },
	{ 0x0a0b, "Cybex Computer Products Co." },
	{ 0x0a0d, "Servergy, Inc" },
	{ 0x0a11, "Xentec, Inc." },
	{ 0x0a12, "Cambridge Silicon Radio, Ltd" },
	{ 0x0a13, "Telebyte, Inc." },
	{ 0x0a14, "Spacelabs Medical, Inc." },
	{ 0x0a15, "Scalar Corp." },
	{ 0x0a16, "Trek Technology (S) PTE, Ltd" },
	{ 0x0a17, "Pentax Corp." },
	{ 0x0a18, "Heidelberger Druckmaschinen AG" },
	{ 0x0a19, "Hua Geng Technologies, Inc." },
	{ 0x0a21, "Medtronic Physio Control Corp." },
	{ 0x0a22, "Century Semiconductor USA, Inc." },
	{ 0x0a27, "Datacard Group" },
	{ 0x0a2c, "AK-Modul-Bus Computer GmbH" },
	{ 0x0a34, "TG3 Electronics, Inc." },
	{ 0x0a35, "Radikal Technologies" },
	{ 0x0a39, "Gilat Satellite Networks, Ltd" },
	{ 0x0a3a, "PentaMedia Co., Ltd" },
	{ 0x0a3c, "NTT DoCoMo, Inc." },
	{ 0x0a3d, "Varo Vision" },
	{ 0x0a3f, "Swissonic AG" },
	{ 0x0a43, "Boca Systems, Inc." },
	{ 0x0a46, "Davicom Semiconductor, Inc." },
	{ 0x0a47, "Hirose Electric" },
	{ 0x0a48, "I/O Interconnect" },
	{ 0x0a4a, "Ploytec GmbH" },
	{ 0x0a4b, "Fujitsu Media Devices, Ltd" },
	{ 0x0a4c, "Computex Co., Ltd" },
	{ 0x0a4d, "Evolution Electronics, Ltd" },
	{ 0x0a4e, "Steinberg Soft-und Hardware GmbH" },
	{ 0x0a4f, "Litton Systems, Inc." },
	{ 0x0a50, "Mimaki Engineering Co., Ltd" },
	{ 0x0a51, "Sony Electronics, Inc." },
	{ 0x0a52, "Jebsee Electronics Co., Ltd" },
	{ 0x0a53, "Portable Peripheral Co., Ltd" },
	{ 0x0a5a, "Electronics For Imaging, Inc." },
	{ 0x0a5b, "EAsics NV" },
	{ 0x0a5c, "Broadcom Corp." },
	{ 0x0a5d, "Diatrend Corp." },
	{ 0x0a5f, "Zebra" },
	{ 0x0a62, "MPMan" },
	{ 0x0a66, "ClearCube Technology" },
	{ 0x0a67, "Medeli Electronics Co., Ltd" },
	{ 0x0a68, "Comaide Corp." },
	{ 0x0a69, "Chroma ate, Inc." },
	{ 0x0a6b, "Green House Co., Ltd" },
	{ 0x0a6c, "Integrated Circuit Systems, Inc." },
	{ 0x0a6d, "UPS Manufacturing" },
	{ 0x0a6e, "Benwin" },
	{ 0x0a6f, "Core Technology, Inc." },
	{ 0x0a70, "International Game Technology" },
	{ 0x0a71, "VIPColor Technologies USA, Inc." },
	{ 0x0a72, "Sanwa Denshi" },
	{ 0x0a73, "Mackie Designs" },
	{ 0x0a7d, "NSTL, Inc." },
	{ 0x0a7e, "Octagon Systems Corp." },
	{ 0x0a80, "Rexon Technology Corp., Ltd" },
	{ 0x0a81, "Chesen Electronics Corp." },
	{ 0x0a82, "Syscan" },
	{ 0x0a83, "NextComm, Inc." },
	{ 0x0a84, "Maui Innovative Peripherals" },
	{ 0x0a85, "Idexx Labs" },
	{ 0x0a86, "NITGen Co., Ltd" },
	{ 0x0a89, "Aktiv" },
	{ 0x0a8d, "Picturetel" },
	{ 0x0a8e, "Japan Aviation Electronics Industry, Ltd" },
	{ 0x0a90, "Candy Technology Co., Ltd" },
	{ 0x0a91, "Globlink Technology, Inc." },
	{ 0x0a92, "EGO SYStems, Inc." },
	{ 0x0a93, "C Technologies AB" },
	{ 0x0a94, "Intersense" },
	{ 0x0aa3, "Lava Computer Mfg., Inc." },
	{ 0x0aa4, "Develco Elektronik" },
	{ 0x0aa5, "First International Digital" },
	{ 0x0aa6, "Perception Digital, Ltd" },
	{ 0x0aa7, "Wincor Nixdorf International GmbH" },
	{ 0x0aa8, "TriGem Computer, Inc." },
	{ 0x0aa9, "Baromtec Co." },
	{ 0x0aaa, "Japan CBM Corp." },
	{ 0x0aab, "Vision Shape Europe SA" },
	{ 0x0aac, "iCompression, Inc." },
	{ 0x0aad, "Rohde & Schwarz GmbH & Co. KG" },
	{ 0x0aae, "NEC infrontia Corp. (Nitsuko)" },
	{ 0x0aaf, "Digitalway Co., Ltd" },
	{ 0x0ab0, "Arrow Strong Electronics Co., Ltd" },
	{ 0x0ab1, "FEIG ELECTRONIC GmbH" },
	{ 0x0aba, "Ellisys" },
	{ 0x0abe, "Stereo-Link" },
	{ 0x0abf, "Diolan" },
	{ 0x0ac3, "Sanyo Semiconductor Company Micro" },
	{ 0x0ac4, "Leco Corp." },
	{ 0x0ac5, "I & C Corp." },
	{ 0x0ac6, "Singing Electrons, Inc." },
	{ 0x0ac7, "Panwest Corp." },
	{ 0x0ac8, "Z-Star Microelectronics Corp." },
	{ 0x0ac9, "Micro Solutions, Inc." },
	{ 0x0aca, "OPEN Networks Ltd" },
	{ 0x0acc, "Koga Electronics Co." },
	{ 0x0acd, "ID Tech" },
	{ 0x0ace, "ZyDAS" },
	{ 0x0acf, "Intoto, Inc." },
	{ 0x0ad0, "Intellix Corp." },
	{ 0x0ad1, "Remotec Technology, Ltd" },
	{ 0x0ad2, "Service & Quality Technology Co., Ltd" },
	{ 0x0ada, "Data Encryption Systems Ltd." },
	{ 0x0ae3, "Allion Computer, Inc." },
	{ 0x0ae4, "Taito Corp." },
	{ 0x0ae7, "Neodym Systems, Inc." },
	{ 0x0ae8, "System Support Co., Ltd" },
	{ 0x0ae9, "North Shore Circuit Design L.L.P." },
	{ 0x0aea, "SciEssence, LLC" },
	{ 0x0aeb, "TTP Communications, Ltd" },
	{ 0x0aec, "Neodio Technologies Corp." },
	{ 0x0af0, "Option" },
	{ 0x0af6, "Silver I Co., Ltd" },
	{ 0x0af7, "B2C2, Inc." },
	{ 0x0af9, "Hama, Inc." },
	{ 0x0afa, "DMC Co., Ltd." },
	{ 0x0afc, "Zaptronix Ltd" },
	{ 0x0afd, "Tateno Dennou, Inc." },
	{ 0x0afe, "Cummins Engine Co." },
	{ 0x0aff, "Jump Zone Network Products, Inc." },
	{ 0x0b00, "INGENICO" },
	{ 0x0b05, "ASUSTek Computer, Inc." },
	{ 0x0b0b, "Datamax-O'Neil" },
	{ 0x0b0c, "Todos AB" },
	{ 0x0b0d, "ProjectLab" },
	{ 0x0b0e, "GN Netcom" },
	{ 0x0b0f, "AVID Technology" },
	{ 0x0b10, "Pcally" },
	{ 0x0b11, "I Tech Solutions Co., Ltd" },
	{ 0x0b1e, "Electronic Warfare Assoc., Inc. (EWA)" },
	{ 0x0b1f, "Insyde Software Corp." },
	{ 0x0b20, "TransDimension, Inc." },
	{ 0x0b21, "Yokogawa Electric Corp." },
	{ 0x0b22, "Japan System Development Co., Ltd" },
	{ 0x0b23, "Pan-Asia Electronics Co., Ltd" },
	{ 0x0b24, "Link Evolution Corp." },
	{ 0x0b27, "Ritek Corp." },
	{ 0x0b28, "Kenwood Corp." },
	{ 0x0b2c, "Village Center, Inc." },
	{ 0x0b30, "PNY Technologies, Inc." },
	{ 0x0b33, "Contour Design, Inc." },
	{ 0x0b37, "Hitachi ULSI Systems Co., Ltd" },
	{ 0x0b38, "Gear Head" },
	{ 0x0b39, "Omnidirectional Control Technology, Inc." },
	{ 0x0b3a, "IPaxess" },
	{ 0x0b3b, "Tekram Technology Co., Ltd" },
	{ 0x0b3c, "Olivetti Techcenter" },
	{ 0x0b3e, "Kikusui Electronics Corp." },
	{ 0x0b41, "Hal Corp." },
	{ 0x0b43, "Play.com, Inc." },
	{ 0x0b47, "Sportbug.com, Inc." },
	{ 0x0b48, "TechnoTrend AG" },
	{ 0x0b49, "ASCII Corp." },
	{ 0x0b4b, "Pine Corp. Ltd." },
	{ 0x0b4d, "Graphtec America, Inc." },
	{ 0x0b4e, "Musical Electronics, Ltd" },
	{ 0x0b50, "Dumpries Co., Ltd" },
	{ 0x0b51, "Comfort Keyboard Co." },
	{ 0x0b52, "Colorado MicroDisplay, Inc." },
	{ 0x0b54, "Sinbon Electronics Co., Ltd" },
	{ 0x0b56, "TYI Systems, Ltd" },
	{ 0x0b57, "Beijing HanwangTechnology Co., Ltd" },
	{ 0x0b59, "Lake Communications, Ltd" },
	{ 0x0b5a, "Corel Corp." },
	{ 0x0b5f, "Green Electronics Co., Ltd" },
	{ 0x0b60, "Nsine, Ltd" },
	{ 0x0b61, "NEC Viewtechnology, Ltd" },
	{ 0x0b62, "Orange Micro, Inc." },
	{ 0x0b63, "ADLink Technology, Inc." },
	{ 0x0b64, "Wonderful Wire Cable Co., Ltd" },
	{ 0x0b65, "Expert Magnetics Corp." },
	{ 0x0b66, "Cybiko Inc." },
	{ 0x0b67, "Fairbanks Scales" },
	{ 0x0b69, "CacheVision" },
	{ 0x0b6a, "Maxim Integrated Products" },
	{ 0x0b6f, "Nagano Japan Radio Co., Ltd" },
	{ 0x0b70, "PortalPlayer, Inc." },
	{ 0x0b71, "SHIN-EI Sangyo Co., Ltd" },
	{ 0x0b72, "Embedded Wireless Technology Co., Ltd" },
	{ 0x0b73, "Computone Corp." },
	{ 0x0b75, "Roland DG Corp." },
	{ 0x0b79, "Sunrise Telecom, Inc." },
	{ 0x0b7a, "Zeevo, Inc." },
	{ 0x0b7b, "Taiko Denki Co., Ltd" },
	{ 0x0b7c, "ITRAN Communications, Ltd" },
	{ 0x0b7d, "Astrodesign, Inc." },
	{ 0x0b81, "id3 Technologies" },
	{ 0x0b84, "Rextron Technology, Inc." },
	{ 0x0b85, "Elkat Electronics, Sdn., Bhd." },
	{ 0x0b86, "Exputer Systems, Inc." },
	{ 0x0b87, "Plus-One I & T, Inc." },
	{ 0x0b88, "Sigma Koki Co., Ltd, Technology Center" },
	{ 0x0b89, "Advanced Digital Broadcast, Ltd" },
	{ 0x0b8c, "SMART Technologies Inc." },
	{ 0x0b95, "ASIX Electronics Corp." },
	{ 0x0b96, "Sewon Telecom" },
	{ 0x0b97, "O2 Micro, Inc." },
	{ 0x0b98, "Playmates Toys, Inc." },
	{ 0x0b99, "Audio International, Inc." },
	{ 0x0b9b, "Dipl.-Ing. Stefan Kunde" },
	{ 0x0b9d, "Softprotec Co." },
	{ 0x0b9f, "Chippo Technologies" },
	{ 0x0baf, "U.S. Robotics" },
	{ 0x0bb0, "Concord Camera Corp." },
	{ 0x0bb1, "Infinilink Corp." },
	{ 0x0bb2, "Ambit Microsystems Corp." },
	{ 0x0bb3, "Ofuji Technology" },
	{ 0x0bb4, "HTC (High Tech Computer Corp.)" },
	{ 0x0bb5, "Murata Manufacturing Co., Ltd" },
	{ 0x0bb6, "Network Alchemy" },
	{ 0x0bb7, "Joytech Computer Co., Ltd" },
	{ 0x0bb8, "Hitachi Semiconductor and Devices Sales Co., Ltd" },
	{ 0x0bb9, "Eiger M&C Co., Ltd" },
	{ 0x0bba, "ZAccess Systems" },
	{ 0x0bbb, "General Meters Corp." },
	{ 0x0bbc, "Assistive Technology, Inc." },
	{ 0x0bbd, "System Connection, Inc." },
	{ 0x0bc0, "Knilink Technology, Inc." },
	{ 0x0bc1, "Fuw Yng Electronics Co., Ltd" },
	{ 0x0bc2, "Seagate RSS LLC" },
	{ 0x0bc3, "IPWireless, Inc." },
	{ 0x0bc4, "Microcube Corp." },
	{ 0x0bc5, "JCN Co., Ltd" },
	{ 0x0bc6, "ExWAY, Inc." },
	{ 0x0bc7, "X10 Wireless Technology, Inc." },
	{ 0x0bc8, "Telmax Communications" },
	{ 0x0bc9, "ECI Telecom, Ltd" },
	{ 0x0bca, "Startek Engineering, Inc." },
	{ 0x0bcb, "Perfect Technic Enterprise Co., Ltd" },
	{ 0x0bd7, "Andrew Pargeter & Associates" },
	{ 0x0bda, "Realtek Semiconductor Corp." },
	{ 0x0bdb, "Ericsson Business Mobile Networks BV" },
	{ 0x0bdc, "Y Media Corp." },
	{ 0x0bdd, "Orange PCS" },
	{ 0x0be2, "Kanda Tsushin Kogyo Co., Ltd" },
	{ 0x0be3, "TOYO Corp." },
	{ 0x0be4, "Elka International, Ltd" },
	{ 0x0be5, "DOME imaging systems, Inc." },
	{ 0x0be6, "Dong Guan Humen Wonderful Wire Cable Factory" },
	{ 0x0bed, "MEI" },
	{ 0x0bee, "LTK Industries, Ltd" },
	{ 0x0bef, "Way2Call Communications" },
	{ 0x0bf0, "Pace Micro Technology PLC" },
	{ 0x0bf1, "Intracom S.A." },
	{ 0x0bf2, "Konexx" },
	{ 0x0bf6, "Addonics Technologies, Inc." },
	{ 0x0bf7, "Sunny Giken, Inc." },
	{ 0x0bf8, "Fujitsu Siemens Computers" },
	{ 0x0bfb, "Grass Valley Group" },
	{ 0x0bfd, "Kvaser AB" },
	{ 0x0c00, "FireFly Mouse Mat" },
	{ 0x0c04, "MOTO Development Group, Inc." },
	{ 0x0c05, "Appian Graphics" },
	{ 0x0c06, "Hasbro Games, Inc." },
	{ 0x0c07, "Infinite Data Storage, Ltd" },
	{ 0x0c08, "Agate" },
	{ 0x0c09, "Comjet Information System" },
	{ 0x0c0a, "Highpoint Technologies, Inc." },
	{ 0x0c0b, "Dura Micro, Inc. (Acomdata)" },
	{ 0x0c12, "Zeroplus" },
	{ 0x0c15, "Iris Graphics" },
	{ 0x0c16, "Gyration, Inc." },
	{ 0x0c17, "Cyberboard A/S" },
	{ 0x0c18, "SynerTek Korea, Inc." },
	{ 0x0c19, "cyberPIXIE, Inc." },
	{ 0x0c1a, "Silicon Motion, Inc." },
	{ 0x0c1b, "MIPS Technologies" },
	{ 0x0c1c, "Hang Zhou Silan Electronics Co., Ltd" },
	{ 0x0c1f, "Magicard" },
	{ 0x0c22, "Tally Printer Corp." },
	{ 0x0c23, "Lernout + Hauspie" },
	{ 0x0c24, "Taiyo Yuden" },
	{ 0x0c25, "Sampo Corp." },
	{ 0x0c26, "Prolific Technology Inc." },
	{ 0x0c27, "RFIDeas, Inc" },
	{ 0x0c2e, "Metrologic Instruments" },
	{ 0x0c30, "Mutoh Industries Ltd" },
	{ 0x0c35, "Eagletron, Inc." },
	{ 0x0c36, "E Ink Corp." },
	{ 0x0c37, "e.Digital" },
	{ 0x0c38, "Der An Electric Wire & Cable Co., Ltd" },
	{ 0x0c39, "IFR" },
	{ 0x0c3a, "Furui Precise Component (Kunshan) Co., Ltd" },
	{ 0x0c3b, "Komatsu, Ltd" },
	{ 0x0c3c, "Radius Co., Ltd" },
	{ 0x0c3d, "Innocom, Inc." },
	{ 0x0c3e, "Nextcell, Inc." },
	{ 0x0c40, "ELMCU" },
	{ 0x0c44, "Motorola iDEN" },
	{ 0x0c45, "Microdia" },
	{ 0x0c46, "WaveRider Communications, Inc." },
	{ 0x0c4a, "ALGE-TIMING GmbH" },
	{ 0x0c4b, "Reiner SCT Kartensysteme GmbH" },
	{ 0x0c4c, "Needham's Electronics" },
	{ 0x0c52, "Sealevel Systems, Inc." },
	{ 0x0c53, "ViewPLUS, Inc." },
	{ 0x0c54, "Glory, Ltd" },
	{ 0x0c55, "Spectrum Digital, Inc." },
	{ 0x0c56, "Billion Bright, Ltd" },
	{ 0x0c57, "Imaginative Design Operation Co., Ltd" },
	{ 0x0c58, "Vidar Systems Corp." },
	{ 0x0c59, "Dong Guan Shinko Wire Co., Ltd" },
	{ 0x0c5a, "TRS International Mfg., Inc." },
	{ 0x0c5e, "Xytronix Research & Design" },
	{ 0x0c60, "Apogee Electronics Corp." },
	{ 0x0c62, "Chant Sincere Co., Ltd" },
	{ 0x0c63, "Toko, Inc." },
	{ 0x0c64, "Signality System Engineering Co., Ltd" },
	{ 0x0c65, "Eminence Enterprise Co., Ltd" },
	{ 0x0c66, "Rexon Electronics Corp." },
	{ 0x0c67, "Concept Telecom, Ltd" },
	{ 0x0c6a, "ACS" },
	{ 0x0c6c, "JETI Technische Instrumente GmbH" },
	{ 0x0c70, "MCT Elektronikladen" },
	{ 0x0c72, "PEAK System" },
	{ 0x0c74, "Optronic Laboratories Inc." },
	{ 0x0c76, "JMTek, LLC." },
	{ 0x0c77, "Sipix Group, Ltd" },
	{ 0x0c78, "Detto Corp." },
	{ 0x0c79, "NuConnex Technologies Pte., Ltd" },
	{ 0x0c7a, "Wing-Span Enterprise Co., Ltd" },
	{ 0x0c86, "NDA Technologies, Inc." },
	{ 0x0c88, "Kyocera Wireless Corp." },
	{ 0x0c89, "Honda Tsushin Kogyo Co., Ltd" },
	{ 0x0c8a, "Pathway Connectivity, Inc." },
	{ 0x0c8b, "Wavefly Corp." },
	{ 0x0c8c, "Coactive Networks" },
	{ 0x0c8d, "Tempo" },
	{ 0x0c8e, "Cesscom Co., Ltd" },
	{ 0x0c8f, "Applied Microsystems" },
	{ 0x0c94, "Cryptera" },
	{ 0x0c98, "Berkshire Products, Inc." },
	{ 0x0c99, "Innochips Co., Ltd" },
	{ 0x0c9a, "Hanwool Robotics Corp." },
	{ 0x0c9b, "Jobin Yvon, Inc." },
	{ 0x0c9c, "Brand Innovators BV" },
	{ 0x0c9d, "SemTek" },
	{ 0x0ca2, "Zyfer" },
	{ 0x0ca3, "Sega Corp." },
	{ 0x0ca4, "ST&T Instrument Corp." },
	{ 0x0ca5, "BAE Systems Canada, Inc." },
	{ 0x0ca6, "Castles Technology Co., Ltd" },
	{ 0x0ca7, "Information Systems Laboratories" },
	{ 0x0caa, "Allied Telesis KK." },
	{ 0x0cad, "Motorola CGISS" },
	{ 0x0cae, "Ascom Business Systems, Ltd" },
	{ 0x0caf, "Buslink" },
	{ 0x0cb0, "Flying Pig Systems" },
	{ 0x0cb1, "Innovonics, Inc." },
	{ 0x0cb6, "Celestix Networks, Pte., Ltd" },
	{ 0x0cb7, "Singatron Enterprise Co., Ltd" },
	{ 0x0cb8, "Opticis Co., Ltd" },
	{ 0x0cba, "Trust Electronic (Shanghai) Co., Ltd" },
	{ 0x0cbb, "Shanghai Darong Electronics Co., Ltd" },
	{ 0x0cbc, "Palmax Technology Co., Ltd" },
	{ 0x0cbd, "Pentel Co., Ltd (Electronics Equipment Div.)" },
	{ 0x0cbe, "Keryx Technologies, Inc." },
	{ 0x0cbf, "Union Genius Computer Co., Ltd" },
	{ 0x0cc0, "Kuon Yi Industrial Corp." },
	{ 0x0cc1, "Given Imaging, Ltd" },
	{ 0x0cc2, "Timex Corp." },
	{ 0x0cc3, "Rimage Corp." },
	{ 0x0cc4, "emsys GmbH" },
	{ 0x0cc5, "Sendo" },
	{ 0x0cc6, "Intermagic Corp." },
	{ 0x0cc8, "Technotools Corp." },
	{ 0x0cc9, "BroadMAX Technologies, Inc." },
	{ 0x0cca, "Amphenol" },
	{ 0x0ccb, "SKNet Co., Ltd" },
	{ 0x0ccc, "Domex Technology Corp." },
	{ 0x0ccd, "TerraTec Electronic GmbH" },
	{ 0x0cd4, "Bang Olufsen" },
	{ 0x0cd5, "LabJack Corporation" },
	{ 0x0cd6, "Scheidt & Bachmann" },
	{ 0x0cd7, "NewChip S.r.l." },
	{ 0x0cd8, "JS Digitech, Inc." },
	{ 0x0cd9, "Hitachi Shin Din Cable, Ltd" },
	{ 0x0cde, "Z-Com" },
	{ 0x0ce5, "Validation Technologies International" },
	{ 0x0ce9, "Pico Technology" },
	{ 0x0cf1, "e-Conn Electronic Co., Ltd" },
	{ 0x0cf2, "ENE Technology, Inc." },
	{ 0x0cf3, "Qualcomm Atheros Communications" },
	{ 0x0cf4, "Fomtex Corp." },
	{ 0x0cf5, "Cellink Co., Ltd" },
	{ 0x0cf6, "Compucable Corp." },
	{ 0x0cf7, "ishoni Networks" },
	{ 0x0cf8, "Clarisys, Inc." },
	{ 0x0cf9, "Central System Research Co., Ltd" },
	{ 0x0cfa, "Inviso, Inc." },
	{ 0x0cfc, "Minolta-QMS, Inc." },
	{ 0x0cff, "SAFA MEDIA Co., Ltd." },
	{ 0x0d06, "telos EDV Systementwicklung GmbH" },
	{ 0x0d08, "UTStarcom" },
	{ 0x0d0b, "Contemporary Controls" },
	{ 0x0d0c, "Astron Electronics Co., Ltd" },
	{ 0x0d0d, "MKNet Corp." },
	{ 0x0d0e, "Hybrid Networks, Inc." },
	{ 0x0d0f, "Feng Shin Cable Co., Ltd" },
	{ 0x0d10, "Elastic Networks" },
	{ 0x0d11, "Maspro Denkoh Corp." },
	{ 0x0d12, "Hansol Electronics, Inc." },
	{ 0x0d13, "BMF Corp." },
	{ 0x0d14, "Array Comm, Inc." },
	{ 0x0d15, "OnStream b.v." },
	{ 0x0d16, "Hi-Touch Imaging Technologies Co., Ltd" },
	{ 0x0d17, "NALTEC, Inc." },
	{ 0x0d18, "coaXmedia" },
	{ 0x0d19, "Hank Connection Industrial Co., Ltd" },
	{ 0x0d28, "NXP" },
	{ 0x0d2f, "Andamiro" },
	{ 0x0d32, "Leo Hui Electric Wire & Cable Co., Ltd" },
	{ 0x0d33, "AirSpeak, Inc." },
	{ 0x0d34, "Rearden Steel Technologies" },
	{ 0x0d35, "Dah Kun Co., Ltd" },
	{ 0x0d3a, "Posiflex Technologies, Inc." },
	{ 0x0d3c, "Sri Cable Technology, Ltd" },
	{ 0x0d3d, "Tangtop Technology Co., Ltd" },
	{ 0x0d3e, "Fitcom, inc." },
	{ 0x0d3f, "MTS Systems Corp." },
	{ 0x0d40, "Ascor, Inc." },
	{ 0x0d41, "Ta Yun Terminals Industrial Co., Ltd" },
	{ 0x0d42, "Full Der Co., Ltd" },
	{ 0x0d46, "Kobil Systems GmbH" },
	{ 0x0d48, "Promethean Limited" },
	{ 0x0d49, "Maxtor" },
	{ 0x0d4a, "NF Corp." },
	{ 0x0d4b, "Grape Systems, Inc." },
	{ 0x0d4c, "Tedas AG" },
	{ 0x0d4d, "Coherent, Inc." },
	{ 0x0d4e, "Agere Systems Netherland BV" },
	{ 0x0d4f, "EADS Airbus France" },
	{ 0x0d50, "Cleware GmbH" },
	{ 0x0d51, "Volex (Asia) Pte., Ltd" },
	{ 0x0d53, "HMI Co., Ltd" },
	{ 0x0d54, "Holon Corp." },
	{ 0x0d55, "ASKA Technologies, Inc." },
	{ 0x0d56, "AVLAB Technology, Inc." },
	{ 0x0d57, "Solomon Microtech, Ltd" },
	{ 0x0d59, "TRC Simulators b.v." },
	{ 0x0d5c, "SMC Networks, Inc." },
	{ 0x0d5e, "Myacom, Ltd" },
	{ 0x0d5f, "CSI, Inc." },
	{ 0x0d60, "IVL Technologies, Ltd" },
	{ 0x0d61, "Meilu Electronics (Shenzhen) Co., Ltd" },
	{ 0x0d62, "Darfon Electronics Corp." },
	{ 0x0d63, "Fritz Gegauf AG" },
	{ 0x0d64, "DXG Technology Corp." },
	{ 0x0d65, "KMJP Co., Ltd" },
	{ 0x0d66, "TMT" },
	{ 0x0d67, "Advanet, Inc." },
	{ 0x0d68, "Super Link Electronics Co., Ltd" },
	{ 0x0d69, "NSI" },
	{ 0x0d6a, "Megapower International Corp." },
	{ 0x0d6b, "And-Or Logic" },
	{ 0x0d70, "Try Computer Co., Ltd" },
	{ 0x0d71, "Hirakawa Hewtech Corp." },
	{ 0x0d72, "Winmate Communication, Inc." },
	{ 0x0d73, "Hit's Communications, Inc." },
	{ 0x0d76, "MFP Korea, Inc." },
	{ 0x0d77, "Power Sentry/Newpoint" },
	{ 0x0d78, "Japan Distributor Corp." },
	{ 0x0d7a, "MARX Datentechnik GmbH" },
	{ 0x0d7b, "Wellco Technology Co., Ltd" },
	{ 0x0d7c, "Taiwan Line Tek Electronic Co., Ltd" },
	{ 0x0d7d, "Phison Electronics Corp." },
	{ 0x0d7e, "American Computer & Digital Components" },
	{ 0x0d7f, "Essential Reality LLC" },
	{ 0x0d80, "H.R. Silvine Electronics, Inc." },
	{ 0x0d81, "TechnoVision" },
	{ 0x0d83, "Think Outside, Inc." },
	{ 0x0d87, "Dolby Laboratories Inc." },
	{ 0x0d89, "Oz Software" },
	{ 0x0d8a, "King Jim Co., Ltd" },
	{ 0x0d8b, "Ascom Telecommunications, Ltd" },
	{ 0x0d8c, "C-Media Electronics, Inc." },
	{ 0x0d8d, "Promotion & Display Technology, Ltd" },
	{ 0x0d8e, "Global Sun Technology, Inc." },
	{ 0x0d8f, "Pitney Bowes" },
	{ 0x0d90, "Sure-Fire Electrical Corp." },
	{ 0x0d96, "Skanhex Technology, Inc." },
	{ 0x0d97, "Santa Barbara Instrument Group" },
	{ 0x0d98, "Mars Semiconductor Corp." },
	{ 0x0d99, "Trazer Technologies, Inc." },
	{ 0x0d9a, "RTX AS" },
	{ 0x0d9b, "Tat Shing Electrical Co." },
	{ 0x0d9c, "Chee Chen Hi-Technology Co., Ltd" },
	{ 0x0d9d, "Sanwa Supply, Inc." },
	{ 0x0d9e, "Avaya" },
	{ 0x0d9f, "Powercom Co., Ltd" },
	{ 0x0da0, "Danger Research" },
	{ 0x0da1, "Suzhou Peter's Precise Industrial Co., Ltd" },
	{ 0x0da2, "Land Instruments International, Ltd" },
	{ 0x0da3, "Nippon Electro-Sensory Devices Corp." },
	{ 0x0da4, "Polar Electro Oy" },
	{ 0x0da7, "IOGear, Inc." },
	{ 0x0da8, "softDSP Co., Ltd" },
	{ 0x0dab, "Cubig Group" },
	{ 0x0dad, "Westover Scientific" },
	{ 0x0db0, "Micro Star International" },
	{ 0x0db1, "Wen Te Electronics Co., Ltd" },
	{ 0x0db2, "Shian Hwi Plug Parts, Plastic Factory" },
	{ 0x0db3, "Tekram Technology Co., Ltd" },
	{ 0x0db4, "Chung Fu Chen Yeh Enterprise Corp." },
	{ 0x0db5, "Access IS" },
	{ 0x0db7, "ELCON Systemtechnik" },
	{ 0x0dba, "Digidesign" },
	{ 0x0dbc, "A&D Medical" },
	{ 0x0dbe, "Jiuh Shiuh Precision Industry Co., Ltd" },
	{ 0x0dbf, "Jess-Link International" },
	{ 0x0dc0, "G7 Solutions (formerly Great Notions)" },
	{ 0x0dc1, "Tamagawa Seiki Co., Ltd" },
	{ 0x0dc3, "Athena Smartcard Solutions, Inc." },
	{ 0x0dc4, "inXtron, Inc." },
	{ 0x0dc5, "SDK Co., Ltd" },
	{ 0x0dc6, "Precision Squared Technology Corp." },
	{ 0x0dc7, "First Cable Line, Inc." },
	{ 0x0dcd, "NetworkFab Corp." },
	{ 0x0dd0, "Access Solutions" },
	{ 0x0dd1, "Contek Electronics Co., Ltd" },
	{ 0x0dd2, "Power Quotient International Co., Ltd" },
	{ 0x0dd3, "MediaQ" },
	{ 0x0dd4, "Custom Engineering SPA" },
	{ 0x0dd5, "California Micro Devices" },
	{ 0x0dd7, "Kocom Co., Ltd" },
	{ 0x0dd8, "Netac Technology Co., Ltd" },
	{ 0x0dd9, "HighSpeed Surfing" },
	{ 0x0dda, "Integrated Circuit Solution, Inc." },
	{ 0x0ddb, "Tamarack, Inc." },
	{ 0x0ddd, "Datelink Technology Co., Ltd" },
	{ 0x0dde, "Ubicom, Inc." },
	{ 0x0de0, "BD Consumer Healthcare" },
	{ 0x0de7, "USBmicro" },
	{ 0x0dea, "UTECH Electronic (D.G.) Co., Ltd." },
	{ 0x0ded, "Novasonics" },
	{ 0x0dee, "Lifetime Memory Products" },
	{ 0x0def, "Full Rise Electronic Co., Ltd" },
	{ 0x0df4, "NET&SYS" },
	{ 0x0df6, "Sitecom Europe B.V." },
	{ 0x0df7, "Mobile Action Technology, Inc." },
	{ 0x0dfa, "Toyo Communication Equipment Co., Ltd" },
	{ 0x0dfc, "GeneralTouch Technology Co., Ltd" },
	{ 0x0e03, "Nippon Systemware Co., Ltd" },
	{ 0x0e08, "Winbest Technology Co., Ltd" },
	{ 0x0e0b, "Amigo Technology Inc." },
	{ 0x0e0c, "Gesytec" },
	{ 0x0e0d, "PicoQuant GmbH" },
	{ 0x0e0f, "VMware, Inc." },
	{ 0x0e16, "JMTek, LLC" },
	{ 0x0e17, "Walex Electronic, Ltd" },
	{ 0x0e1a, "Unisys" },
	{ 0x0e1b, "Crewave" },
	{ 0x0e1e, "Green Hills Software" },
	{ 0x0e20, "Pegasus Technologies Ltd." },
	{ 0x0e21, "Cowon Systems, Inc." },
	{ 0x0e22, "Symbian Ltd." },
	{ 0x0e23, "Liou Yuane Enterprise Co., Ltd" },
	{ 0x0e25, "VinChip Systems, Inc." },
	{ 0x0e26, "J-Phone East Co., Ltd" },
	{ 0x0e30, "HeartMath LLC" },
	{ 0x0e34, "Micro Computer Control Corp." },
	{ 0x0e35, "3Pea Technologies, Inc." },
	{ 0x0e36, "TiePie engineering" },
	{ 0x0e38, "Stratitec, Inc." },
	{ 0x0e39, "Smart Modular Technologies, Inc." },
	{ 0x0e3a, "Neostar Technology Co., Ltd" },
	{ 0x0e3b, "Mansella, Ltd" },
	{ 0x0e41, "Line6, Inc." },
	{ 0x0e44, "Sun-Riseful Technology Co., Ltd." },
	{ 0x0e48, "Julia Corp., Ltd" },
	{ 0x0e4a, "Shenzhen Bao Hing Electric Wire & Cable Mfr. Co." },
	{ 0x0e4c, "Radica Games, Ltd" },
	{ 0x0e50, "TechnoData Interware" },
	{ 0x0e55, "Speed Dragon Multimedia, Ltd" },
	{ 0x0e56, "Kingston Technology Company, Inc." },
	{ 0x0e5a, "Active Co., Ltd" },
	{ 0x0e5b, "Union Power Information Industrial Co., Ltd" },
	{ 0x0e5c, "Bitland Information Technology Co., Ltd" },
	{ 0x0e5d, "Neltron Industrial Co., Ltd" },
	{ 0x0e5e, "Conwise Technology Co., Ltd." },
	{ 0x0e66, "Hawking Technologies" },
	{ 0x0e67, "Fossil, Inc." },
	{ 0x0e6a, "Megawin Technology Co., Ltd" },
	{ 0x0e6f, "Logic3" },
	{ 0x0e70, "Tokyo Electronic Industry Co., Ltd" },
	{ 0x0e72, "Hsi-Chin Electronics Co., Ltd" },
	{ 0x0e75, "TVS Electronics, Ltd" },
	{ 0x0e79, "Archos, Inc." },
	{ 0x0e7b, "On-Tech Industry Co., Ltd" },
	{ 0x0e7e, "Gmate, Inc." },
	{ 0x0e82, "Ching Tai Electric Wire & Cable Co., Ltd" },
	{ 0x0e83, "Shin An Wire & Cable Co." },
	{ 0x0e8c, "Well Force Electronic Co., Ltd" },
	{ 0x0e8d, "MediaTek Inc." },
	{ 0x0e8f, "GreenAsia Inc." },
	{ 0x0e90, "WiebeTech, LLC" },
	{ 0x0e91, "VTech Engineering Canada, Ltd" },
	{ 0x0e92, "C's Glory Enterprise Co., Ltd" },
	{ 0x0e93, "eM Technics Co., Ltd" },
	{ 0x0e95, "Future Technology Co., Ltd" },
	{ 0x0e96, "Aplux Communications, Ltd" },
	{ 0x0e97, "Fingerworks, Inc." },
	{ 0x0e98, "Advanced Analogic Technologies, Inc." },
	{ 0x0e99, "Parallel Dice Co., Ltd" },
	{ 0x0e9a, "TA HSING Industries, Ltd" },
	{ 0x0e9b, "ADTEC Corp." },
	{ 0x0e9c, "Streamzap, Inc." },
	{ 0x0e9f, "Tamura Corp." },
	{ 0x0ea0, "Ours Technology, Inc." },
	{ 0x0ea6, "Nihon Computer Co., Ltd" },
	{ 0x0ea7, "MSL Enterprises Corp." },
	{ 0x0ea8, "CenDyne, Inc." },
	{ 0x0ead, "Humax Co., Ltd" },
	{ 0x0eb0, "NovaTech" },
	{ 0x0eb1, "WIS Technologies, Inc." },
	{ 0x0eb2, "Y-S Electronic Co., Ltd" },
	{ 0x0eb3, "Saint Technology Corp." },
	{ 0x0eb7, "Endor AG" },
	{ 0x0eb8, "Mettler Toledo" },
	{ 0x0ebb, "Thermo Fisher Scientific" },
	{ 0x0ebe, "VWeb Corp." },
	{ 0x0ebf, "Omega Technology of Taiwan, Inc." },
	{ 0x0ec0, "LHI Technology (China) Co., Ltd" },
	{ 0x0ec1, "Abit Computer Corp." },
	{ 0x0ec2, "Sweetray Industrial, Ltd" },
	{ 0x0ec3, "Axell Co., Ltd" },
	{ 0x0ec4, "Ballracing Developments, Ltd" },
	{ 0x0ec5, "GT Information System Co., Ltd" },
	{ 0x0ec6, "InnoVISION Multimedia, Ltd" },
	{ 0x0ec7, "Theta Link Corp." },
	{ 0x0ecd, "Lite-On IT Corp." },
	{ 0x0ece, "TaiSol Electronics Co., Ltd" },
	{ 0x0ecf, "Phogenix Imaging, LLC" },
	{ 0x0ed1, "WinMaxGroup" },
	{ 0x0ed2, "Kyoto Micro Computer Co., Ltd" },
	{ 0x0ed3, "Wing-Tech Enterprise Co., Ltd" },
	{ 0x0ed5, "Fiberbyte" },
	{ 0x0eda, "Noriake Itron Corp." },
	{ 0x0edf, "e-MDT Co., Ltd" },
	{ 0x0ee0, "Shima Seiki Mfg., Ltd" },
	{ 0x0ee1, "Sarotech Co., Ltd" },
	{ 0x0ee2, "AMI Semiconductor, Inc." },
	{ 0x0ee3, "ComTrue Technology Corp." },
	{ 0x0ee4, "Sunrich Technology, Ltd" },
	{ 0x0eee, "Digital Stream Technology, Inc." },
	{ 0x0eef, "D-WAV Scientific Co., Ltd" },
	{ 0x0ef0, "Hitachi Cable, Ltd" },
	{ 0x0ef1, "Aichi Micro Intelligent Corp." },
	{ 0x0ef2, "I/O Magic Corp." },
	{ 0x0ef3, "Lynn Products, Inc." },
	{ 0x0ef4, "DSI Datotech" },
	{ 0x0ef5, "PointChips" },
	{ 0x0ef6, "Yield Microelectronics Corp." },
	{ 0x0ef7, "SM Tech Co., Ltd (Tulip)" },
	{ 0x0efd, "Oasis Semiconductor" },
	{ 0x0efe, "Wem Technology, Inc." },
	{ 0x0f03, "Unitek UPS Systems" },
	{ 0x0f06, "Visual Frontier Enterprise Co., Ltd" },
	{ 0x0f08, "CSL Wire & Plug (Shen Zhen) Co." },
	{ 0x0f0c, "CAS Corp." },
	{ 0x0f0d, "Hori Co., Ltd" },
	{ 0x0f0e, "Energy Full Corp." },
	{ 0x0f0f, "Silego Technology Inc" },
	{ 0x0f11, "LD Didactic GmbH" },
	{ 0x0f12, "Mars Engineering Corp." },
	{ 0x0f13, "Acetek Technology Co., Ltd" },
	{ 0x0f14, "Ingenico" },
	{ 0x0f18, "Finger Lakes Instrumentation" },
	{ 0x0f19, "Oracom Co., Ltd" },
	{ 0x0f1b, "Onset Computer Corp." },
	{ 0x0f1c, "Funai Electric Co., Ltd" },
	{ 0x0f1d, "Iwill Corp." },
	{ 0x0f21, "IOI Technology Corp." },
	{ 0x0f22, "Senior Industries, Inc." },
	{ 0x0f23, "Leader Tech Manufacturer Co., Ltd" },
	{ 0x0f24, "Flex-P Industries, Snd., Bhd." },
	{ 0x0f2d, "ViPower, Inc." },
	{ 0x0f2e, "Geniality Maple Technology Co., Ltd" },
	{ 0x0f2f, "Priva Design Services" },
	{ 0x0f30, "Jess Technology Co., Ltd" },
	{ 0x0f31, "Chrysalis Development" },
	{ 0x0f32, "YFC-BonEagle Electric Co., Ltd" },
	{ 0x0f37, "Kokuyo Co., Ltd" },
	{ 0x0f38, "Nien-Yi Industrial Corp." },
	{ 0x0f39, "TG3 Electronics" },
	{ 0x0f3d, "Airprime, Incorporated" },
	{ 0x0f41, "RDC Semiconductor Co., Ltd" },
	{ 0x0f42, "Nital Consulting Services, Inc." },
	{ 0x0f44, "Polhemus" },
	{ 0x0f49, "Evolis SA" },
	{ 0x0f4b, "St. John Technology Co., Ltd" },
	{ 0x0f4c, "WorldWide Cable Opto Corp." },
	{ 0x0f4d, "Microtune, Inc." },
	{ 0x0f4e, "Freedom Scientific" },
	{ 0x0f52, "Wing Key Electrical Co., Ltd" },
	{ 0x0f53, "Dongguan White Horse Cable Factory, Ltd" },
	{ 0x0f54, "Kawai Musical Instruments Mfg. Co., Ltd" },
	{ 0x0f55, "AmbiCom, Inc." },
	{ 0x0f5c, "Prairiecomm, Inc." },
	{ 0x0f5d, "NewAge International, LLC" },
	{ 0x0f5f, "Key Technology Corp." },
	{ 0x0f60, "NTK, Ltd" },
	{ 0x0f61, "Varian, Inc." },
	{ 0x0f62, "Acrox Technologies Co., Ltd" },
	{ 0x0f63, "LeapFrog Enterprises" },
	{ 0x0f68, "Kobe Steel, Ltd" },
	{ 0x0f69, "Dionex Corp." },
	{ 0x0f6a, "Vibren Technologies, Inc." },
	{ 0x0f6e, "INTELLIGENT SYSTEMS" },
	{ 0x0f73, "DFI" },
	{ 0x0f78, "Guntermann & Drunck GmbH" },
	{ 0x0f7c, "DQ Technology, Inc." },
	{ 0x0f7d, "NetBotz, Inc." },
	{ 0x0f7e, "Fluke Corp." },
	{ 0x0f88, "VTech Holdings, Ltd" },
	{ 0x0f8b, "Yazaki Corp." },
	{ 0x0f8c, "Young Generation International Corp." },
	{ 0x0f8d, "Uniwill Computer Corp." },
	{ 0x0f8e, "Kingnet Technology Co., Ltd" },
	{ 0x0f8f, "Soma Networks" },
	{ 0x0f97, "CviLux Corp." },
	{ 0x0f98, "CyberBank Corp." },
	{ 0x0f9c, "Hyun Won, Inc." },
	{ 0x0f9e, "Lucent Technologies" },
	{ 0x0fa3, "Starconn Electronic Co., Ltd" },
	{ 0x0fa4, "ATL Technology" },
	{ 0x0fa5, "Sotec Co., Ltd" },
	{ 0x0fa7, "Epox Computer Co., Ltd" },
	{ 0x0fa8, "Logic Controls, Inc." },
	{ 0x0faf, "Winpoint Electronic Corp." },
	{ 0x0fb0, "Haurtian Wire & Cable Co., Ltd" },
	{ 0x0fb1, "Inclose Design, Inc." },
	{ 0x0fb2, "Juan-Chern Industrial Co., Ltd" },
	{ 0x0fb6, "Heber Ltd" },
	{ 0x0fb8, "Wistron Corp." },
	{ 0x0fb9, "AACom Corp." },
	{ 0x0fba, "San Shing Electronics Co., Ltd" },
	{ 0x0fbb, "Bitwise Systems, Inc." },
	{ 0x0fc1, "Mitac Internatinal Corp." },
	{ 0x0fc2, "Plug and Jack Industrial, Inc." },
	{ 0x0fc5, "Delcom Engineering" },
	{ 0x0fc6, "Dataplus Supplies, Inc." },
	{ 0x0fca, "Research In Motion, Ltd." },
	{ 0x0fce, "Sony Ericsson Mobile Communications AB" },
	{ 0x0fcf, "Dynastream Innovations, Inc." },
	{ 0x0fd0, "Tulip Computers B.V." },
	{ 0x0fd1, "Giant Electronics Ltd." },
	{ 0x0fd2, "Seac Banche" },
	{ 0x0fd4, "Tenovis GmbH & Co., KG" },
	{ 0x0fd5, "Direct Access Technology, Inc." },
	{ 0x0fd9, "Elgato Systems GmbH" },
	{ 0x0fda, "Quantec Networks GmbH" },
	{ 0x0fdc, "Micro Plus" },
	{ 0x0fde, "Oregon Scientific" },
	{ 0x0fe0, "Osterhout Design Group" },
	{ 0x0fe2, "Air Techniques" },
	{ 0x0fe4, "IN-Tech Electronics, Ltd" },
	{ 0x0fe5, "Greenconn (U.S.A.), Inc." },
	{ 0x0fe6, "ICS Advent" },
	{ 0x0fe9, "DVICO" },
	{ 0x0fea, "United Computer Accessories" },
	{ 0x0feb, "CRS Electronic Co., Ltd" },
	{ 0x0fec, "UMC Electronics Co., Ltd" },
	{ 0x0fed, "Access Co., Ltd" },
	{ 0x0fee, "Xsido Corp." },
	{ 0x0fef, "MJ Research, Inc." },
	{ 0x0ff6, "Core Valley Co., Ltd" },
	{ 0x0ff7, "CHI SHING Computer Accessories Co., Ltd" },
	{ 0x0ffc, "Clavia DMI AB" },
	{ 0x0ffd, "EarlySense" },
	{ 0x0fff, "Aopen, Inc." },
	{ 0x1000, "Speed Tech Corp." },
	{ 0x1001, "Ritronics Components (S) Pte., Ltd" },
	{ 0x1003, "Sigma Corp." },
	{ 0x1004, "LG Electronics, Inc." },
	{ 0x1005, "Apacer Technology, Inc." },
	{ 0x1006, "iRiver, Ltd." },
	{ 0x1009, "Emuzed, Inc." },
	{ 0x100a, "AV Chaseway, Ltd" },
	{ 0x100b, "Chou Chin Industrial Co., Ltd" },
	{ 0x100d, "Netopia, Inc." },
	{ 0x1010, "Fukuda Denshi Co., Ltd" },
	{ 0x1011, "Mobile Media Tech." },
	{ 0x1012, "SDKM Fibres, Wires & Cables Berhad" },
	{ 0x1013, "TST-Touchless Sensor Technology AG" },
	{ 0x1014, "Densitron Technologies PLC" },
	{ 0x1015, "Softronics Pty., Ltd" },
	{ 0x1016, "Xiamen Hung's Enterprise Co., Ltd" },
	{ 0x1017, "Speedy Industrial Supplies, Pte., Ltd" },
	{ 0x1019, "Elitegroup Computer Systems (ECS)" },
	{ 0x1020, "Labtec" },
	{ 0x1022, "Shinko Shoji Co., Ltd" },
	{ 0x1025, "Hyper-Paltek" },
	{ 0x1026, "Newly Corp." },
	{ 0x1027, "Time Domain" },
	{ 0x1028, "Inovys Corp." },
	{ 0x1029, "Atlantic Coast Telesys" },
	{ 0x102a, "Ramos Technology Co., Ltd" },
	{ 0x102b, "Infotronic America, Inc." },
	{ 0x102c, "Etoms Electronics Corp." },
	{ 0x102d, "Winic Corp." },
	{ 0x1031, "Comax Technology, Inc." },
	{ 0x1032, "C-One Technology Corp." },
	{ 0x1033, "Nucam Corp." },
	{ 0x1038, "SteelSeries ApS" },
	{ 0x1039, "devolo AG" },
	{ 0x103a, "PSA" },
	{ 0x103d, "Stanton" },
	{ 0x1043, "iCreate Technologies Corp." },
	{ 0x1044, "Chu Yuen Enterprise Co., Ltd" },
	{ 0x1046, "Winbond Electronics Corp. [hex]" },
	{ 0x1048, "Targus Group International" },
	{ 0x104b, "Mylex / Buslogic" },
	{ 0x104c, "AMCO TEC International, Inc." },
	{ 0x104d, "Newport Corporation" },
	{ 0x104f, "WB Electronics" },
	{ 0x1050, "Yubico.com" },
	{ 0x1053, "Immanuel Electronics Co., Ltd" },
	{ 0x1054, "BMS International Beheer N.V." },
	{ 0x1055, "Complex Micro Interconnection Co., Ltd" },
	{ 0x1056, "Hsin Chen Ent Co., Ltd" },
	{ 0x1057, "ON Semiconductor" },
	{ 0x1058, "Western Digital Technologies, Inc." },
	{ 0x1059, "Giesecke & Devrient GmbH" },
	{ 0x105b, "Foxconn International, Inc." },
	{ 0x105c, "Hong Ji Electric Wire & Cable (Dongguan) Co., Ltd" },
	{ 0x105d, "Delkin Devices, Inc." },
	{ 0x105e, "Valence Semiconductor Design, Ltd" },
	{ 0x105f, "Chin Shong Enterprise Co., Ltd" },
	{ 0x1060, "Easthome Industrial Co., Ltd" },
	{ 0x1063, "Motorola Electronics Taiwan, Ltd [hex]" },
	{ 0x1065, "CCYU Technology" },
	{ 0x1068, "Micropi Elettronica" },
	{ 0x106a, "Loyal Legend, Ltd" },
	{ 0x106c, "Curitel Communications, Inc." },
	{ 0x106d, "San Chieh Manufacturing, Ltd" },
	{ 0x106e, "ConectL" },
	{ 0x106f, "Money Controls" },
	{ 0x1076, "GCT Semiconductor, Inc." },
	{ 0x107b, "Gateway, Inc." },
	{ 0x107d, "Arlec Australia, Ltd" },
	{ 0x107e, "Midoriya Electric Co., Ltd" },
	{ 0x107f, "KidzMouse, Inc." },
	{ 0x1082, "Shin-Etsukaken Co., Ltd" },
	{ 0x1083, "Canon Electronics, Inc." },
	{ 0x1084, "Pantech Co., Ltd" },
	{ 0x108a, "Chloride Power Protection" },
	{ 0x108b, "Grand-tek Technology Co., Ltd" },
	{ 0x108c, "Robert Bosch GmbH" },
	{ 0x108e, "Lotes Co., Ltd." },
	{ 0x1091, "Numerik Jena" },
	{ 0x1099, "Surface Optics Corp." },
	{ 0x109a, "DATASOFT Systems GmbH" },
	{ 0x109b, "Hisense" },
	{ 0x109f, "eSOL Co., Ltd" },
	{ 0x10a0, "Hirotech, Inc." },
	{ 0x10a3, "Mitsubishi Materials Corp." },
	{ 0x10a9, "SK Teletech Co., Ltd" },
	{ 0x10aa, "Cables To Go" },
	{ 0x10ab, "USI Co., Ltd" },
	{ 0x10ac, "Honeywell, Inc." },
	{ 0x10ae, "Princeton Technology Corp." },
	{ 0x10af, "Liebert Corp." },
	{ 0x10b5, "Comodo (PLX?)" },
	{ 0x10b8, "DiBcom" },
	{ 0x10bb, "TM Technology, Inc." },
	{ 0x10bc, "Dinging Technology Co., Ltd" },
	{ 0x10bd, "TMT Technology, Inc." },
	{ 0x10bf, "SmartHome" },
	{ 0x10c3, "Universal Laser Systems, Inc." },
	{ 0x10c4, "Silicon Labs" },
	{ 0x10c5, "Sanei Electric, Inc." },
	{ 0x10c6, "Intec, Inc." },
	{ 0x10cb, "Eratech" },
	{ 0x10cc, "GBM Connector Co., Ltd" },
	{ 0x10cd, "Kycon, Inc." },
	{ 0x10ce, "Silicon Labs" },
	{ 0x10cf, "Velleman Components, Inc." },
	{ 0x10d1, "Hottinger Baldwin Measurement" },
	{ 0x10d2, "RayComposer - R. Adams" },
	{ 0x10d4, "Man Boon Manufactory, Ltd" },
	{ 0x10d5, "Uni Class Technology Co., Ltd" },
	{ 0x10d6, "Actions Semiconductor Co., Ltd" },
	{ 0x10de, "Authenex, Inc." },
	{ 0x10df, "In-Win Development, Inc." },
	{ 0x10e0, "Post-Op Video, Inc." },
	{ 0x10e1, "CablePlus, Ltd" },
	{ 0x10e2, "Nada Electronics, Ltd" },
	{ 0x10ec, "Vast Technologies, Inc." },
	{ 0x10f0, "Nexio Co., Ltd" },
	{ 0x10f1, "Importek" },
	{ 0x10f5, "Turtle Beach" },
	{ 0x10f8, "Cesys GmbH" },
	{ 0x10fb, "Pictos Technologies, Inc." },
	{ 0x10fd, "Anubis Electronics, Ltd" },
	{ 0x10fe, "Thrane & Thrane" },
	{ 0x1100, "VirTouch, Ltd" },
	{ 0x1101, "EasyPass Industrial Co., Ltd" },
	{ 0x1108, "Brightcom Technologies, Ltd" },
	{ 0x110a, "Moxa Technologies Co., Ltd." },
	{ 0x1110, "Analog Devices Canada, Ltd (Allied Telesyn)" },
	{ 0x1111, "Pandora International Ltd." },
	{ 0x1112, "YM ELECTRIC CO., Ltd" },
	{ 0x1113, "Medion AG" },
	{ 0x111e, "VSO Electric Co., Ltd" },
	{ 0x112a, "RedRat" },
	{ 0x112e, "Master Hill Electric Wire and Cable Co., Ltd" },
	{ 0x112f, "Cellon International, Inc." },
	{ 0x1130, "Tenx Technology, Inc." },
	{ 0x1131, "Integrated System Solution Corp." },
	{ 0x1132, "Toshiba Corp., Digital Media Equipment [hex]" },
	{ 0x1136, "CTS Electronincs" },
	{ 0x113c, "Arin Tech Co., Ltd" },
	{ 0x113d, "Mapower Electronics Co., Ltd" },
	{ 0x113f, "Integrated Biometrics, LLC" },
	{ 0x1141, "V One Multimedia, Pte., Ltd" },
	{ 0x1142, "CyberScan Technologies, Inc." },
	{ 0x1145, "Japan Radio Company" },
	{ 0x1146, "Shimane SANYO Electric Co., Ltd." },
	{ 0x1147, "Ever Great Electric Wire and Cable Co., Ltd" },
	{ 0x114b, "Sphairon Access Systems GmbH" },
	{ 0x114c, "Tinius Olsen Testing Machine Co., Inc." },
	{ 0x114d, "Alpha Imaging Technology Corp." },
	{ 0x114f, "Wavecom" },
	{ 0x115b, "Salix Technology Co., Ltd." },
	{ 0x1162, "Secugen Corp." },
	{ 0x1163, "DeLorme Publishing, Inc." },
	{ 0x1164, "YUAN High-Tech Development Co., Ltd" },
	{ 0x1165, "Telson Electronics Co., Ltd" },
	{ 0x1166, "Bantam Interactive Technologies" },
	{ 0x1167, "Salient Systems Corp." },
	{ 0x1168, "BizConn International Corp." },
	{ 0x116e, "Gigastorage Corp." },
	{ 0x116f, "Silicon 10 Technology Corp." },
	{ 0x1175, "Shengyih Steel Mold Co., Ltd" },
	{ 0x117d, "Santa Electronic, Inc." },
	{ 0x117e, "JNC, Inc." },
	{ 0x1182, "Venture Corp., Ltd" },
	{ 0x1183, "Compaq Computer Corp. [hex] (Digital Dream ?)" },
	{ 0x1184, "Kyocera Elco Corp." },
	{ 0x1188, "Bloomberg L.P." },
	{ 0x1189, "Acer Communications & Multimedia" },
	{ 0x118f, "You Yang Technology Co., Ltd" },
	{ 0x1190, "Tripace" },
	{ 0x1191, "Loyalty Founder Enterprise Co., Ltd" },
	{ 0x1196, "Yankee Robotics, LLC" },
	{ 0x1197, "Technoimagia Co., Ltd" },
	{ 0x1198, "StarShine Technology Corp." },
	{ 0x1199, "Sierra Wireless, Inc." },
	{ 0x119a, "ZHAN QI Technology Co., Ltd" },
	{ 0x119b, "ruwido austria GmbH" },
	{ 0x11a0, "Chipcon AS" },
	{ 0x11a3, "Technovas Co., Ltd" },
	{ 0x11aa, "GlobalMedia Group, LLC" },
	{ 0x11ab, "Exito Electronics Co., Ltd" },
	{ 0x11ac, "Nike" },
	{ 0x11b0, "ATECH FLASH TECHNOLOGY" },
	{ 0x11be, "R&D International NV" },
	{ 0x11c0, "Betop" },
	{ 0x11c5, "Inmax" },
	{ 0x11c9, "Nacon" },
	{ 0x11ca, "VeriFone Inc" },
	{ 0x11db, "Topfield Co., Ltd." },
	{ 0x11e6, "K.I. Technology Co. Ltd." },
	{ 0x11f5, "Siemens AG" },
	{ 0x11f6, "Prolific" },
	{ 0x11f7, "Alcatel (?)" },
	{ 0x1203, "TSC Auto ID Technology Co., Ltd" },
	{ 0x1209, "Generic" },
	{ 0x120e, "Hudson Soft Co., Ltd" },
	{ 0x120f, "Magellan" },
	{ 0x1210, "DigiTech" },
	{ 0x121e, "Jungsoft Co., Ltd" },
	{ 0x121f, "Panini S.p.A." },
	{ 0x1220, "TC Electronic" },
	{ 0x1221, "Unknown manufacturer" },
	{ 0x1222, "TiPro" },
	{ 0x1223, "SKYCABLE ENTERPRISE. CO., LTD." },
	{ 0x1228, "Datapaq Limited" },
	{ 0x1230, "Chipidea-Microelectronica, S.A." },
	{ 0x1233, "Denver Electronics" },
	{ 0x1234, "Brain Actuated Technologies" },
	{ 0x1235, "Focusrite-Novation" },
	{ 0x1241, "Belkin" },
	{ 0x1243, "Holtek Semiconductor, Inc." },
	{ 0x124a, "AirVast" },
	{ 0x124b, "Nyko (Honey Bee)" },
	{ 0x124c, "MXI - Memory Experts International, Inc." },
	{ 0x125c, "Apogee Inc." },
	{ 0x125d, "JMicron" },
	{ 0x125f, "A-DATA Technology Co., Ltd." },
	{ 0x1260, "Standard Microsystems Corp." },
	{ 0x1264, "Covidien Energy-based Devices" },
	{ 0x1266, "Pirelli Broadband Solutions" },
	{ 0x1267, "Logic3 / SpectraVideo plc" },
	{ 0x126c, "Aristocrat Technologies" },
	{ 0x126d, "Bel Stewart" },
	{ 0x126e, "Strobe Data, Inc." },
	{ 0x126f, "TwinMOS" },
	{ 0x1274, "Ensoniq" },
	{ 0x1275, "Xaxero Marine Software Engineering, Ltd." },
	{ 0x1278, "Starlight Xpress" },
	{ 0x1283, "zebris Medical GmbH" },
	{ 0x1286, "Marvell Semiconductor, Inc." },
	{ 0x1291, "Qualcomm Flarion Technologies, Inc. / Leadtek Research, Inc." },
	{ 0x1292, "Innomedia" },
	{ 0x1293, "Belkin Components [hex]" },
	{ 0x1294, "RISO KAGAKU CORP." },
	{ 0x1297, "DekTec" },
	{ 0x129b, "CyberTAN Technology" },
	{ 0x12a7, "Trendchip Technologies Corp." },
	{ 0x12ab, "Honey Bee Electronic International Ltd." },
	{ 0x12b8, "Zhejiang Xinya Electronic Technology Co., Ltd." },
	{ 0x12b9, "E28" },
	{ 0x12ba, "Licensed by Sony Computer Entertainment America" },
	{ 0x12bd, "Gembird" },
	{ 0x12c4, "Autocue Group Ltd" },
	{ 0x12cf, "DEXIN" },
	{ 0x12d1, "Huawei Technologies Co., Ltd." },
	{ 0x12d2, "LINE TECH INDUSTRIAL CO., LTD." },
	{ 0x12d3, "LINAK" },
	{ 0x12d6, "EMS Dr. Thomas Wuensche" },
	{ 0x12d7, "BETTER WIRE FACTORY CO., LTD." },
	{ 0x12d8, "Araneus Information Systems Oy" },
	{ 0x12e6, "Waldorf Music GmbH" },
	{ 0x12ef, "Tapwave, Inc." },
	{ 0x12f2, "ViewPlus Technologies, Inc." },
	{ 0x12f5, "Dynamic System Electronics Corp." },
	{ 0x12f7, "Memorex Products, Inc." },
	{ 0x12fd, "AIN Comm. Technology Co., Ltd" },
	{ 0x12ff, "Fascinating Electronics, Inc." },
	{ 0x1306, "FM20 Barcode Scanner" },
	{ 0x1307, "Transcend Information, Inc." },
	{ 0x1308, "Shuttle, Inc." },
	{ 0x1310, "Roper" },
	{ 0x1312, "ICS Electronics" },
	{ 0x1313, "ThorLabs" },
	{ 0x131d, "Natural Point" },
	{ 0x1325, "ams AG" },
	{ 0x132a, "Envara Inc." },
	{ 0x132b, "Konica Minolta" },
	{ 0x133e, "Kemper Digital GmbH" },
	{ 0x1342, "Mobility" },
	{ 0x1343, "Citizen Systems" },
	{ 0x1345, "Sino Lite Technology Corp." },
	{ 0x1347, "Moravian Instruments" },
	{ 0x1348, "Katsuragawa Electric Co., Ltd." },
	{ 0x134c, "PanJit International Inc." },
	{ 0x134e, "Digby's Bitpile, Inc. DBA D Bit" },
	{ 0x1357, "P&E Microcomputer Systems" },
	{ 0x135e, "Insta GmbH" },
	{ 0x135f, "Control Development Inc." },
	{ 0x1366, "SEGGER" },
	{ 0x136b, "STEC" },
	{ 0x136e, "Andor Technology Ltd." },
	{ 0x1370, "Swissbit" },
	{ 0x1371, "CNet Technology Inc." },
	{ 0x1376, "Vimtron Electronics Co., Ltd." },
	{ 0x1377, "Sennheiser electronic GmbH & Co. KG" },
	{ 0x137b, "SCAPS GmbH" },
	{ 0x137c, "YASKAWA ELECTRIC CORP." },
	{ 0x1385, "Netgear, Inc" },
	{ 0x138a, "Validity Sensors, Inc." },
	{ 0x138e, "Jungo LTD" },
	{ 0x1390, "TOMTOM B.V." },
	{ 0x1391, "IdealTEK, Inc." },
	{ 0x1395, "Sennheiser Communications" },
	{ 0x1397, "BEHRINGER International GmbH" },
	{ 0x1398, "Q-tec" },
	{ 0x13ad, "Baltech" },
	{ 0x13b0, "PerkinElmer Optoelectronics" },
	{ 0x13b1, "Linksys" },
	{ 0x13b2, "Alesis" },
	{ 0x13b3, "Nippon Dics Co., Ltd." },
	{ 0x13ba, "PCPlay" },
	{ 0x13be, "Ricoh Printing Systems, Ltd." },
	{ 0x13ca, "JyeTai Precision Industrial Co., Ltd." },
	{ 0x13cf, "Wisair Ltd." },
	{ 0x13d0, "Techsan Electronics Co., Ltd." },
	{ 0x13d1, "A-Max Technology Macao Commercial Offshore Co. Ltd." },
	{ 0x13d2, "Shark Multimedia" },
	{ 0x13d3, "IMC Networks" },
	{ 0x13d7, "Guidance Software, Inc." },
	{ 0x13dc, "ALEREON, INC." },
	{ 0x13dd, "i.Tech Dynamic Limited" },
	{ 0x13e1, "Kaibo Wire & Cable (Shenzhen) Co., Ltd." },
	{ 0x13e5, "Rane" },
	{ 0x13e6, "TechnoScope Co., Ltd." },
	{ 0x13ea, "Hengstler" },
	{ 0x13ec, "Zydacron" },
	{ 0x13ee, "MosArt" },
	{ 0x13fd, "Initio Corporation" },
	{ 0x13fe, "Kingston Technology Company Inc." },
	{ 0x1400, "Axxion Group Corp." },
	{ 0x1402, "Bowe Bell & Howell" },
	{ 0x1403, "Sitronix" },
	{ 0x1404, "Fundamental Software, Inc." },
	{ 0x1409, "IDS Imaging Development Systems GmbH" },
	{ 0x140e, "Telechips, Inc." },
	{ 0x1410, "Novatel Wireless" },
	{ 0x1415, "Nam Tai E&E Products Ltd. or OmniVision Technologies, Inc." },
	{ 0x1419, "ABILITY ENTERPRISE CO., LTD." },
	{ 0x1421, "Sensor Technology" },
	{ 0x1424, "Posnet Polska S.A." },
	{ 0x1429, "Vega Technologies Industrial (Austria) Co." },
	{ 0x142a, "Thales E-Transactions" },
	{ 0x142b, "Arbiter Systems, Inc." },
	{ 0x1430, "RedOctane" },
	{ 0x1431, "Pertech Resources, Inc." },
	{ 0x1435, "Wistron NeWeb" },
	{ 0x1436, "Denali Software, Inc." },
	{ 0x143c, "Altek Corporation" },
	{ 0x1443, "Digilent" },
	{ 0x1446, "X.J.GROUP" },
	{ 0x1451, "Force Dimension" },
	{ 0x1452, "Dai Nippon Printing, Inc" },
	{ 0x1453, "Radio Shack" },
	{ 0x1456, "Extending Wire & Cable Co., Ltd." },
	{ 0x1457, "First International Computer, Inc." },
	{ 0x145f, "Trust" },
	{ 0x1460, "Tatung Co." },
	{ 0x1461, "Staccato Communications" },
	{ 0x1462, "Micro Star International" },
	{ 0x146b, "BigBen Interactive" },
	{ 0x1472, "Huawei-3Com" },
	{ 0x147a, "Formosa Industrial Computing, Inc." },
	{ 0x147e, "Upek" },
	{ 0x147f, "Hama GmbH & Co., KG" },
	{ 0x1482, "Vaillant" },
	{ 0x1484, "Elsa AG [hex]" },
	{ 0x1485, "Silicom" },
	{ 0x1487, "DSP Group, Ltd." },
	{ 0x148e, "EVATRONIX SA" },
	{ 0x148f, "Ralink Technology, Corp." },
	{ 0x1491, "Futronic Technology Co. Ltd." },
	{ 0x1493, "Suunto" },
	{ 0x1497, "Panstrong Company Ltd." },
	{ 0x1498, "Microtek International Inc." },
	{ 0x149a, "Imagination Technologies" },
	{ 0x14aa, "WideView Technology Inc." },
	{ 0x14ad, "CTK Corporation" },
	{ 0x14ae, "Printronix Inc." },
	{ 0x14af, "ATP Electronics Inc." },
	{ 0x14b0, "StarTech.com Ltd." },
	{ 0x14b2, "Ralink Technology, Corp." },
	{ 0x14c0, "Rockwell Automation, Inc." },
	{ 0x14c2, "Gemlight Computer, Ltd" },
	{ 0x14c8, "Zytronic" },
	{ 0x14cd, "Super Top" },
	{ 0x14d8, "JAMER INDUSTRIES CO., LTD." },
	{ 0x14dd, "Raritan Computer, Inc." },
	{ 0x14e0, "WiNRADiO Communications" },
	{ 0x14e1, "Dialogue Technology Corp." },
	{ 0x14e5, "SAIN Information & Communications Co., Ltd." },
	{ 0x14ea, "Planex Communications" },
	{ 0x14ed, "Shure Inc." },
	{ 0x14f7, "TechniSat Digital GmbH" },
	{ 0x1500, "Ellisys" },
	{ 0x1501, "Pine-Tum Enterprise Co., Ltd." },
	{ 0x1504, "Bixolon CO LTD" },
	{ 0x1508, "Fibocom" },
	{ 0x1509, "First International Computer, Inc." },
	{ 0x1513, "medMobile" },
	{ 0x1514, "Actel" },
	{ 0x1516, "CompUSA" },
	{ 0x1518, "Cheshire Engineering Corp." },
	{ 0x1519, "Comneon" },
	{ 0x151f, "Opal Kelly Incorporated" },
	{ 0x1520, "Bitwire Corp." },
	{ 0x1524, "ENE Technology Inc" },
	{ 0x1527, "Silicon Portals" },
	{ 0x1529, "UBIQUAM Co., Ltd." },
	{ 0x152a, "Thesycon Systemsoftware & Consulting GmbH" },
	{ 0x152b, "MIR Srl" },
	{ 0x152d, "JMicron Technology Corp. / JMicron USA Technology Corp." },
	{ 0x152e, "LG (HLDS)" },
	{ 0x1532, "Razer USA, Ltd" },
	{ 0x153b, "TerraTec Electronic GmbH" },
	{ 0x1546, "U-Blox AG" },
	{ 0x1547, "SG Intec Ltd & Co KG" },
	{ 0x154a, "Celectronic GmbH" },
	{ 0x154b, "PNY" },
	{ 0x154d, "ConnectCounty Holdings Berhad" },
	{ 0x154e, "D&M Holdings, Inc. (Denon/Marantz)" },
	{ 0x154f, "SNBC CO., Ltd" },
	{ 0x1554, "Prolink Microsystems Corp." },
	{ 0x1557, "OQO" },
	{ 0x1568, "Sunf Pu Technology Co., Ltd" },
	{ 0x156f, "Quantum Corporation" },
	{ 0x1570, "ALLTOP TECHNOLOGY CO., LTD." },
	{ 0x157b, "Ketron SRL" },
	{ 0x157e, "TRENDnet" },
	{ 0x1582, "Fiberline" },
	{ 0x1587, "SMA Technologie AG" },
	{ 0x158d, "Oakley Inc." },
	{ 0x158e, "JDS Uniphase Corporation (JDSU)" },
	{ 0x1598, "Kunshan Guoji Electronics Co., Ltd." },
	{ 0x15a2, "Freescale Semiconductor, Inc." },
	{ 0x15a4, "Afatech Technologies, Inc." },
	{ 0x15a8, "Teams Power Limited" },
	{ 0x15a9, "Gemtek" },
	{ 0x15aa, "Gearway Electronics (Dong Guan) Co., Ltd." },
	{ 0x15ad, "VMware Inc." },
	{ 0x15ba, "Olimex Ltd." },
	{ 0x15c0, "XL Imaging" },
	{ 0x15c2, "SoundGraph Inc." },
	{ 0x15c5, "Pressure Profile Systems, Inc." },
	{ 0x15c6, "Laboratoires MXM" },
	{ 0x15c8, "KTF Technologies" },
	{ 0x15c9, "D-Box Technologies" },
	{ 0x15ca, "Textech International Ltd." },
	{ 0x15d5, "Coulomb Electronics Ltd." },
	{ 0x15d9, "Trust International B.V." },
	{ 0x15dc, "Hynix Semiconductor Inc." },
	{ 0x15e0, "Seong Ji Industrial Co., Ltd." },
	{ 0x15e1, "RSA" },
	{ 0x15e4, "Numark" },
	{ 0x15e8, "SohoWare" },
	{ 0x15e9, "Pacific Digital Corp." },
	{ 0x15ec, "Belcarra Technologies Corp." },
	{ 0x15f4, "HanfTek" },
	{ 0x1604, "Tascam" },
	{ 0x1605, "ACCES I/O Products, Inc." },
	{ 0x1606, "Umax" },
	{ 0x1608, "Inside Out Networks [hex]" },
	{ 0x160a, "VIA Technologies, Inc." },
	{ 0x160e, "INRO" },
	{ 0x1614, "Amoi Electronics" },
	{ 0x1617, "Sony Corp." },
	{ 0x1619, "L & K Precision Technology Co., Ltd." },
	{ 0x161c, "Digitech Systems" },
	{ 0x1621, "Wionics Research" },
	{ 0x1628, "Stonestreet One, Inc." },
	{ 0x162a, "Airgo Networks Inc." },
	{ 0x162f, "WiQuest Communications, Inc." },
	{ 0x1630, "2Wire, Inc." },
	{ 0x1631, "Good Way Technology" },
	{ 0x1633, "AIM GmbH" },
	{ 0x1645, "Entrega [hex]" },
	{ 0x1649, "SofTec Microsystems" },
	{ 0x164a, "ChipX" },
	{ 0x164c, "Matrix Vision GmbH" },
	{ 0x1657, "Struck Innovative Systeme GmbH" },
	{ 0x165b, "Frontier Design Group" },
	{ 0x165c, "Kondo Kagaku" },
	{ 0x1660, "Creatix Polymedia GmbH" },
	{ 0x1667, "GIGA-TMS INC." },
	{ 0x1668, "Actiontec Electronics, Inc. [hex]" },
	{ 0x1669, "PiKRON Ltd. [hex]" },
	{ 0x166a, "Clipsal" },
	{ 0x1677, "China Huada Integrated Circuit Design (Group) Co., Ltd. (CIDC Group)" },
	{ 0x1679, "Total Phase" },
	{ 0x167b, "Pure Digital Technologies, Inc." },
	{ 0x1680, "Golden Bridge Electech Inc." },
	{ 0x1681, "Prevo Technologies, Inc." },
	{ 0x1682, "Maxwise Production Enterprise Ltd." },
	{ 0x1684, "Godspeed Computer Corp." },
	{ 0x1685, "Delock" },
	{ 0x1686, "ZOOM Corporation" },
	{ 0x1687, "Kingmax Digital Inc." },
	{ 0x1688, "Saab AB" },
	{ 0x1689, "Razer USA, Ltd" },
	{ 0x168c, "Atheros Communications" },
	{ 0x1690, "Askey Computer Corp. [hex]" },
	{ 0x1696, "Hitachi Video and Information System, Inc." },
	{ 0x1697, "VTec Test, Inc." },
	{ 0x16a5, "Shenzhen Zhengerya Cable Co., Ltd." },
	{ 0x16a6, "Unigraf" },
	{ 0x16ab, "Global Sun Technology" },
	{ 0x16ac, "Dongguan ChingLung Wire & Cable Co., Ltd." },
	{ 0x16b4, "iStation" },
	{ 0x16b5, "Persentec, Inc." },
	{ 0x16c0, "Van Ooijen Technische Informatica" },
	{ 0x16ca, "Wireless Cables, Inc." },
	{ 0x16cc, "silex technology, Inc." },
	{ 0x16d0, "MCS" },
	{ 0x16d1, "Suprema Inc." },
	{ 0x16d3, "Frontline Test Equipment, Inc." },
	{ 0x16d5, "AnyDATA Corporation" },
	{ 0x16d6, "JABLOCOM s.r.o." },
	{ 0x16d8, "CMOTECH Co., Ltd." },
	{ 0x16dc, "Wiener, Plein & Baus" },
	{ 0x16de, "Telemecanique" },
	{ 0x16df, "King Billion Electronics Co., Ltd." },
	{ 0x16f0, "GN Hearing A/S" },
	{ 0x16f5, "Futurelogic Inc." },
	{ 0x1702, "FDI-MATELEC" },
	{ 0x1706, "BlueView Technologies, Inc." },
	{ 0x1707, "ARTIMI" },
	{ 0x170b, "Swissonic" },
	{ 0x170d, "Avnera" },
	{ 0x1711, "Leica Microsystems" },
	{ 0x1724, "Meyer Instruments (MIS)" },
	{ 0x1725, "Vitesse Semiconductor" },
	{ 0x1726, "Axesstel, Inc." },
	{ 0x172f, "Waltop International Corp." },
	{ 0x1733, "Cellink Technology Co., Ltd" },
	{ 0x1736, "CANON IMAGING SYSTEM TECHNOLOGIES INC." },
	{ 0x1737, "802.11g Adapter [Linksys WUSB54GC v3]" },
	{ 0x173a, "Roche" },
	{ 0x173d, "QSENN" },
	{ 0x1740, "Senao" },
	{ 0x1743, "General Atomics" },
	{ 0x1748, "MQP Electronics" },
	{ 0x174c, "ASMedia Technology Inc." },
	{ 0x174f, "Syntek" },
	{ 0x1753, "GERTEC Telecomunicacoes Ltda." },
	{ 0x1756, "ENENSYS Technologies" },
	{ 0x1759, "LucidPort Technology, Inc." },
	{ 0x1761, "ASUSTek Computer, Inc. (wrong ID)" },
	{ 0x1770, "MSI" },
	{ 0x1772, "System Level Solutions, Inc." },
	{ 0x1776, "Arowana" },
	{ 0x1777, "Microscan Systems, Inc." },
	{ 0x177f, "Sweex" },
	{ 0x1781, "Multiple Vendors" },
	{ 0x1782, "Spreadtrum Communications Inc." },
	{ 0x1784, "TopSeed Technology Corp." },
	{ 0x1787, "ATI AIB" },
	{ 0x1788, "ShenZhen Litkconn Technology Co., Ltd." },
	{ 0x178e, "ASUSTek Computer, Inc. (wrong ID)" },
	{ 0x1796, "Printrex, Inc." },
	{ 0x1797, "JALCO CO., LTD." },
	{ 0x1799, "Thales Norway A/S" },
	{ 0x179d, "Ricavision International, Inc." },
	{ 0x17a0, "Samson Technologies Corp." },
	{ 0x17a4, "Concept2" },
	{ 0x17a5, "Advanced Connection Technology Inc." },
	{ 0x17a7, "MICOMSOFT CO., LTD." },
	{ 0x17a8, "Kamstrup A/S" },
	{ 0x17b3, "Grey Innovation" },
	{ 0x17b5, "Lunatone" },
	{ 0x17ba, "SAURIS GmbH" },
	{ 0x17c3, "Singim International Corp." },
	{ 0x17cc, "Native Instruments" },
	{ 0x17cf, "Hip Hing Cable & Plug Mfy. Ltd." },
	{ 0x17d0, "Sanford L.P." },
	{ 0x17d3, "Korea Techtron Co., Ltd." },
	{ 0x17e9, "DisplayLink" },
	{ 0x17eb, "Cornice, Inc." },
	{ 0x17ef, "Lenovo" },
	{ 0x17f4, "WaveSense" },
	{ 0x17f5, "K.K. Rocky" },
	{ 0x17f6, "Unicomp, Inc." },
	{ 0x1809, "Advantech" },
	{ 0x1822, "Twinhan" },
	{ 0x1831, "Gwo Jinn Industries Co., Ltd." },
	{ 0x1832, "Huizhou Shenghua Industrial Co., Ltd." },
	{ 0x183d, "VIVOphone" },
	{ 0x1843, "Vaisala" },
	{ 0x1849, "ASRock Incorporation" },
	{ 0x184f, "K2L GmbH" },
	{ 0x1852, "GYROCOM C&C Co., LTD" },
	{ 0x1854, "Memory Devices Ltd." },
	{ 0x185b, "Compro" },
	{ 0x1861, "Tech Technology Industrial Company" },
	{ 0x1862, "Teridian Semiconductor Corp." },
	{ 0x1870, "Nexio Co., Ltd" },
	{ 0x1871, "Aveo Technology Corp." },
	{ 0x1873, "Navilock" },
	{ 0x187c, "Alienware Corporation" },
	{ 0x187f, "Siano Mobile Silicon" },
	{ 0x1892, "Vast Technologies, Inc." },
	{ 0x1894, "Topseed" },
	{ 0x1897, "Evertop Wire Cable Co." },
	{ 0x189f, "3Shape A/S" },
	{ 0x18a4, "CSSN" },
	{ 0x18a5, "Verbatim, Ltd" },
	{ 0x18b1, "Petalynx" },
	{ 0x18b4, "e3C Technologies" },
	{ 0x18b6, "Mikkon Technology Limited" },
	{ 0x18b7, "Zotek Electronic Co., Ltd." },
	{ 0x18c5, "AMIT Technology, Inc." },
	{ 0x18cd, "Ecamm" },
	{ 0x18d1, "Google Inc." },
	{ 0x18d5, "Starline International Group Limited" },
	{ 0x18d9, "Kaba" },
	{ 0x18dc, "LKC Technologies, Inc." },
	{ 0x18dd, "Planon System Solutions Inc." },
	{ 0x18e3, "Fitipower Integrated Technology Inc" },
	{ 0x18e8, "Qcom" },
	{ 0x18ea, "Matrox Graphics, Inc." },
	{ 0x18ec, "Arkmicro Technologies Inc." },
	{ 0x18ef, "ELV Elektronik AG" },
	{ 0x18f8, "[Maxxter]" },
	{ 0x18fb, "Scriptel Corporation" },
	{ 0x18fd, "FineArch Inc." },
	{ 0x1901, "GE Healthcare" },
	{ 0x1908, "GEMBIRD" },
	{ 0x190d, "Motorola GSG" },
	{ 0x1914, "Alco Digital Devices Limited" },
	{ 0x1915, "Nordic Semiconductor ASA" },
	{ 0x191c, "Innovative Technology LTD" },
	{ 0x1923, "FitLinxx" },
	{ 0x1926, "NextWindow" },
	{ 0x1928, "Proceq SA" },
	{ 0x192f, "Avago Technologies, Pte." },
	{ 0x1930, "Shenzhen Xianhe Technology Co., Ltd." },
	{ 0x1931, "Ningbo Broad Telecommunication Co., Ltd." },
	{ 0x1934, "Feature Integration Technology Inc. (Fintek)" },
	{ 0x1935, "Elektron Music Machines" },
	{ 0x1938, "Meinberg Funkuhren GmbH & Co. KG" },
	{ 0x1941, "Dream Link" },
	{ 0x1943, "Sensoray Co., Inc." },
	{ 0x1949, "Lab126, Inc." },
	{ 0x194f, "PreSonus Audio Electronics, Inc." },
	{ 0x1951, "Hyperstone AG" },
	{ 0x1953, "Ironkey Inc." },
	{ 0x1954, "Radiient Technologies" },
	{ 0x195d, "Itron Technology iONE" },
	{ 0x1963, "IK Multimedia" },
	{ 0x1965, "Uniden Corporation" },
	{ 0x1967, "CASIO HITACHI Mobile Communications Co., Ltd." },
	{ 0x196b, "Wispro Technology Inc." },
	{ 0x1970, "Dane-Elec Corp. USA" },
	{ 0x1973, "Spectralink Corporation" },
	{ 0x1975, "Dongguan Guneetal Wire & Cable Co., Ltd." },
	{ 0x1976, "Chipsbrand Microelectronics (HK) Co., Ltd." },
	{ 0x1977, "T-Logic" },
	{ 0x197d, "Leuze electronic" },
	{ 0x1980, "Storage Appliance Corporation" },
	{ 0x1989, "Nuconn Technology Corp." },
	{ 0x198f, "Beceem Communications Inc." },
	{ 0x1990, "Acron Precision Industrial Co., Ltd." },
	{ 0x1995, "Trillium Technology Pty. Ltd." },
	{ 0x1996, "PixeLINK" },
	{ 0x1997, "Shenzhen Riitek Technology Co., Ltd" },
	{ 0x199b, "MicroStrain, Inc." },
	{ 0x199e, "The Imaging Source Europe GmbH" },
	{ 0x199f, "Benica Corporation" },
	{ 0x19a5, "HARRIS Corp." },
	{ 0x19a8, "Biforst Technology Inc." },
	{ 0x19ab, "Bodelin" },
	{ 0x19af, "S Life" },
	{ 0x19b2, "Batronix" },
	{ 0x19b4, "Celestron" },
	{ 0x19b5, "B & W Group" },
	{ 0x19b6, "Infotech Logistic, LLC" },
	{ 0x19b9, "Data Robotics" },
	{ 0x19c2, "Futuba" },
	{ 0x19ca, "Mindtribe" },
	{ 0x19cf, "Parrot SA" },
	{ 0x19d1, "BYD" },
	{ 0x19d2, "ZTE WCDMA Technologies MSM" },
	{ 0x19db, "KFI Printers" },
	{ 0x19e1, "WeiDuan Electronic Accessory (S.Z.) Co., Ltd." },
	{ 0x19e8, "Industrial Technology Research Institute" },
	{ 0x19ef, "Pak Heng Technology (Shenzhen) Co., Ltd." },
	{ 0x19f7, "RODE Microphones" },
	{ 0x19fa, "Gampaq Co.Ltd" },
	{ 0x19fd, "MTI Instruments Inc." },
	{ 0x19ff, "Dynex" },
	{ 0x1a08, "Bellwood International, Inc." },
	{ 0x1a0a, "USB-IF non-workshop" },
	{ 0x1a12, "KES Co., Ltd." },
	{ 0x1a1d, "Veho" },
	{ 0x1a25, "Amphenol East Asia Ltd." },
	{ 0x1a2a, "Seagate Branded Solutions" },
	{ 0x1a2c, "China Resource Semico Co., Ltd" },
	{ 0x1a32, "Quanta Microsystems, Inc." },
	{ 0x1a34, "ACRUX" },
	{ 0x1a36, "Biwin Technology Ltd." },
	{ 0x1a40, "Terminus Technology Inc." },
	{ 0x1a41, "Action Electronics Co., Ltd." },
	{ 0x1a44, "VASCO Data Security International" },
	{ 0x1a4a, "Silicon Image" },
	{ 0x1a4b, "SafeBoot International B.V." },
	{ 0x1a5a, "Tandberg Data" },
	{ 0x1a61, "Abbott Diabetes Care" },
	{ 0x1a64, "Mastervolt" },
	{ 0x1a6a, "Spansion Inc." },
	{ 0x1a6d, "SamYoung Electronics Co., Ltd" },
	{ 0x1a6e, "Global Unichip Corp." },
	{ 0x1a6f, "Sagem Orga GmbH" },
	{ 0x1a72, "Physik Instrumente" },
	{ 0x1a79, "Bayer Health Care LLC" },
	{ 0x1a7b, "Lumberg Connect  GmbH & Co. KG" },
	{ 0x1a7c, "Evoluent" },
	{ 0x1a7e, "Meltec Systementwicklung" },
	{ 0x1a81, "Holtek Semiconductor, Inc." },
	{ 0x1a86, "QinHeng Electronics" },
	{ 0x1a89, "Dynalith Systems Co., Ltd." },
	{ 0x1a8b, "SGS Taiwan Ltd." },
	{ 0x1a8d, "BandRich, Inc." },
	{ 0x1a98, "Leica Camera AG" },
	{ 0x1aa4, "Data Drive Thru, Inc." },
	{ 0x1aa5, "UBeacon Technologies, Inc." },
	{ 0x1aa6, "eFortune Technology Corp." },
	{ 0x1aab, "Silvercreations Software AG" },
	{ 0x1aad, "KeeTouch" },
	{ 0x1ab1, "Rigol Technologies" },
	{ 0x1ab2, "Allied Vision" },
	{ 0x1acb, "Salcomp Plc" },
	{ 0x1acc, "Midiplus Co, Ltd." },
	{ 0x1ad1, "Desay Wire Co., Ltd." },
	{ 0x1ad4, "APS" },
	{ 0x1adb, "Schweitzer Engineering Laboratories, Inc" },
	{ 0x1ae4, "ic-design Reinhard Gottinger GmbH" },
	{ 0x1ae7, "X-TENSIONS" },
	{ 0x1aed, "High Top Precision Electronic Co., Ltd." },
	{ 0x1aef, "Conntech Electronic (Suzhou) Corporation" },
	{ 0x1af1, "Connect One Ltd." },
	{ 0x1af3, "Kingsis Technology Corporation" },
	{ 0x1afe, "A. Eberle GmbH & Co. KG" },
	{ 0x1b04, "Meilhaus Electronic GmbH" },
	{ 0x1b0e, "BLUTRONICS S.r.l." },
	{ 0x1b12, "Eventide" },
	{ 0x1b1c, "Corsair" },
	{ 0x1b1e, "General Imaging / General Electric" },
	{ 0x1b1f, "eQ-3 Entwicklung GmbH" },
	{ 0x1b20, "MStar Semiconductor, Inc." },
	{ 0x1b22, "WiLinx Corp." },
	{ 0x1b24, "Telegent Systems, Inc." },
	{ 0x1b26, "Cellex Power Products, Inc." },
	{ 0x1b27, "Current Electronics Inc." },
	{ 0x1b28, "NAVIsis Inc." },
	{ 0x1b32, "Ugobe Life Forms, Inc." },
	{ 0x1b36, "ViXS Systems, Inc." },
	{ 0x1b3b, "iPassion Technology Inc." },
	{ 0x1b3f, "Generalplus Technology Inc." },
	{ 0x1b47, "Energizer Holdings, Inc." },
	{ 0x1b48, "Plastron Precision Co., Ltd." },
	{ 0x1b52, "ARH Inc." },
	{ 0x1b59, "K.S. Terminals Inc." },
	{ 0x1b5a, "Chao Zhou Kai Yuan Electric Co., Ltd." },
	{ 0x1b65, "The Hong Kong Standards and Testing Centre Ltd." },
	{ 0x1b71, "Fushicai" },
	{ 0x1b72, "ATERGI TECHNOLOGY CO., LTD." },
	{ 0x1b73, "Fresco Logic" },
	{ 0x1b75, "Ovislink Corp." },
	{ 0x1b76, "Legend Silicon Corp." },
	{ 0x1b80, "Afatech" },
	{ 0x1b86, "Dongguan Guanshang Electronics Co., Ltd." },
	{ 0x1b88, "ShenMing Electron (Dong Guan) Co., Ltd." },
	{ 0x1b8c, "Altium Limited" },
	{ 0x1b8d, "e-MOVE Technology Co., Ltd." },
	{ 0x1b8e, "Amlogic, Inc." },
	{ 0x1b8f, "MA LABS, Inc." },
	{ 0x1b96, "N-Trig" },
	{ 0x1b98, "YMax Communications Corp." },
	{ 0x1b99, "Shenzhen Yuanchuan Electronic" },
	{ 0x1ba1, "JINQ CHERN ENTERPRISE CO., LTD." },
	{ 0x1ba2, "Lite Metals & Plastic (Shenzhen) Co., Ltd." },
	{ 0x1ba4, "Ember Corporation" },
	{ 0x1ba6, "Abilis Systems" },
	{ 0x1ba8, "China Telecommunication Technology Labs" },
	{ 0x1bad, "Harmonix Music" },
	{ 0x1bae, "Vuzix Corporation" },
	{ 0x1bbb, "T & A Mobile Phones" },
	{ 0x1bbd, "Videology Imaging Solutions, Inc." },
	{ 0x1bc0, "Beijing Senseshield Technology Co.,Ltd." },
	{ 0x1bc4, "Ford Motor Co." },
	{ 0x1bc5, "AVIXE Technology (China) Ltd." },
	{ 0x1bc7, "Telit Wireless Solutions" },
	{ 0x1bce, "Contac Cable Industrial Limited" },
	{ 0x1bcf, "Sunplus Innovation Technology Inc." },
	{ 0x1bd0, "Hangzhou Riyue Electronic Co., Ltd." },
	{ 0x1bd5, "BG Systems, Inc." },
	{ 0x1bda, "University Of Southampton" },
	{ 0x1bde, "P-TWO INDUSTRIES, INC." },
	{ 0x1bef, "Shenzhen Tongyuan Network-Communication Cables Co., Ltd" },
	{ 0x1bf0, "RealVision Inc." },
	{ 0x1bf5, "Extranet Systems Inc." },
	{ 0x1bf6, "Orient Semiconductor Electronics, Ltd." },
	{ 0x1bfd, "TouchPack" },
	{ 0x1c02, "Kreton Corporation" },
	{ 0x1c04, "QNAP System Inc." },
	{ 0x1c05, "Shenxhen Stager Electric" },
	{ 0x1c0c, "Ionics EMS, Inc." },
	{ 0x1c0d, "Relm Wireless" },
	{ 0x1c10, "Lanterra Industrial Co., Ltd." },
	{ 0x1c11, "Input Club Inc." },
	{ 0x1c13, "ALECTRONIC LIMITED" },
	{ 0x1c1a, "Datel Electronics Ltd." },
	{ 0x1c1b, "Volkswagen of America, Inc." },
	{ 0x1c1f, "Goldvish S.A." },
	{ 0x1c20, "Fuji Electric Device Technology Co., Ltd." },
	{ 0x1c21, "ADDMM LLC" },
	{ 0x1c22, "ZHONGSHAN CHIANG YU ELECTRIC CO., LTD." },
	{ 0x1c26, "Shanghai Haiying Electronics Co., Ltd." },
	{ 0x1c27, "HuiYang D & S Cable Co., Ltd." },
	{ 0x1c28, "PMD Technologies" },
	{ 0x1c29, "Elster GmbH" },
	{ 0x1c31, "LS Cable Ltd." },
	{ 0x1c34, "SpringCard" },
	{ 0x1c37, "Authorizer Technologies, Inc." },
	{ 0x1c3d, "NONIN MEDICAL INC." },
	{ 0x1c3e, "Wep Peripherals" },
	{ 0x1c40, "EZPrototypes" },
	{ 0x1c49, "Cherng Weei Technology Corp." },
	{ 0x1c4b, "Geratherm Medical AG" },
	{ 0x1c4f, "SiGma Micro" },
	{ 0x1c57, "Zalman Tech Co., Ltd." },
	{ 0x1c6b, "Philips & Lite-ON Digital Solutions Corporation" },
	{ 0x1c6c, "Skydigital Inc." },
	{ 0x1c71, "Humanware Inc" },
	{ 0x1c73, "AMT" },
	{ 0x1c75, "Arturia" },
	{ 0x1c77, "Kaetat Industrial Co., Ltd." },
	{ 0x1c78, "Datascope Corp." },
	{ 0x1c79, "Unigen Corporation" },
	{ 0x1c7a, "LighTuning Technology Inc." },
	{ 0x1c7b, "LUXSHARE PRECISION INDUSTRY (SHENZHEN) CO., LTD." },
	{ 0x1c82, "Atracsys" },
	{ 0x1c83, "Schomaecker GmbH" },
	{ 0x1c87, "2N TELEKOMUNIKACE a.s." },
	{ 0x1c88, "Somagic, Inc." },
	{ 0x1c89, "HONGKONG WEIDIDA ELECTRON LIMITED" },
	{ 0x1c8e, "ASTRON INTERNATIONAL CORP." },
	{ 0x1c98, "ALPINE ELECTRONICS, INC." },
	{ 0x1c9e, "OMEGA TECHNOLOGY" },
	{ 0x1ca0, "ACCARIO Inc." },
	{ 0x1ca1, "Symwave" },
	{ 0x1cac, "Kinstone" },
	{ 0x1cb3, "Aces Electronic Co., Ltd." },
	{ 0x1cb4, "OPEX CORPORATION" },
	{ 0x1cb6, "IdeaCom Technology Inc." },
	{ 0x1cbe, "Luminary Micro Inc." },
	{ 0x1cbf, "FORTAT SKYMARK INDUSTRIAL COMPANY" },
	{ 0x1cc0, "PlantSense" },
	{ 0x1cca, "NextWave Broadband Inc." },
	{ 0x1ccd, "Bodatong Technology (Shenzhen) Co., Ltd." },
	{ 0x1cd4, "adp corporation" },
	{ 0x1cd5, "Firecomms Ltd." },
	{ 0x1cd6, "Antonio Precise Products Manufactory Ltd." },
	{ 0x1cde, "Telecommunications Technology Association (TTA)" },
	{ 0x1cdf, "WonTen Technology Co., Ltd." },
	{ 0x1ce0, "EDIMAX TECHNOLOGY CO., LTD." },
	{ 0x1ce1, "Amphenol KAE" },
	{ 0x1cf1, "Dresden Elektronik" },
	{ 0x1cfc, "ANDES TECHNOLOGY CORPORATION" },
	{ 0x1cfd, "Flextronics Digital Design Japan, LTD." },
	{ 0x1d03, "iCON" },
	{ 0x1d07, "Solid-Motion" },
	{ 0x1d08, "NINGBO HENTEK DRAGON ELECTRONICS CO., LTD." },
	{ 0x1d09, "TechFaith Wireless Technology Limited" },
	{ 0x1d0a, "Johnson Controls, Inc. The Automotive Business Unit" },
	{ 0x1d0b, "HAN HUA CABLE & WIRE TECHNOLOGY (J.X.) CO., LTD." },
	{ 0x1d0d, "TDKMedia" },
	{ 0x1d0f, "Sonix Technology Co., Ltd." },
	{ 0x1d14, "ALPHA-SAT TECHNOLOGY LIMITED" },
	{ 0x1d17, "C-Thru Music Ltd." },
	{ 0x1d19, "Dexatek Technology Ltd." },
	{ 0x1d1f, "Diostech Co., Ltd." },
	{ 0x1d20, "SAMTACK INC." },
	{ 0x1d27, "ASUS" },
	{ 0x1d34, "Dream Cheeky" },
	{ 0x1d45, "Touch" },
	{ 0x1d4d, "PEGATRON CORPORATION" },
	{ 0x1d50, "OpenMoko, Inc." },
	{ 0x1d57, "Xenta" },
	{ 0x1d5b, "Smartronix, Inc." },
	{ 0x1d5c, "Fresco Logic" },
	{ 0x1d6b, "Linux Foundation" },
	{ 0x1d88, "Mahr GmbH" },
	{ 0x1d90, "Citizen" },
	{ 0x1d9d, "Sigma Sport" },
	{ 0x1dd2, "Leo Bodnar Electronics Ltd" },
	{ 0x1dd3, "Dajc Inc." },
	{ 0x1de1, "Actions Microelectronics Co." },
	{ 0x1de6, "MICRORISC s.r.o." },
	{ 0x1df7, "SDRplay" },
	{ 0x1e0e, "Qualcomm / Option" },
	{ 0x1e10, "Point Grey Research, Inc." },
	{ 0x1e17, "Mirion Technologies Dosimetry Services Division" },
	{ 0x1e1d, "Kanguru Solutions" },
	{ 0x1e1f, "INVIA" },
	{ 0x1e29, "Festo AG & Co. KG" },
	{ 0x1e2d, "Gemalto M2M GmbH" },
	{ 0x1e3d, "Chipsbank Microelectronics Co., Ltd" },
	{ 0x1e41, "Cleverscope" },
	{ 0x1e44, "SHIMANO INC." },
	{ 0x1e4e, "Cubeternet" },
	{ 0x1e54, "TypeMatrix" },
	{ 0x1e68, "TrekStor GmbH & Co. KG" },
	{ 0x1e71, "NZXT" },
	{ 0x1e74, "Coby Electronics Corporation" },
	{ 0x1e7b, "Zurich Instruments" },
	{ 0x1e7d, "ROCCAT" },
	{ 0x1e8e, "Airbus Defence and Space" },
	{ 0x1e91, "Other World Computing" },
	{ 0x1ea7, "SHARKOON Technologies GmbH" },
	{ 0x1eab, "Fujian Newland Computer Co., Ltd" },
	{ 0x1eaf, "Leaflabs" },
	{ 0x1eb8, "Modacom Co., Ltd." },
	{ 0x1ebb, "NuCORE Technology, Inc." },
	{ 0x1ecb, "AMTelecom" },
	{ 0x1ed8, "FENDER MUSICAL INSTRUMENTS CORPORATION" },
	{ 0x1eda, "AirTies Wireless Networks" },
	{ 0x1edb, "Blackmagic design" },
	{ 0x1ee8, "ONDA COMMUNICATION S.p.a." },
	{ 0x1ef6, "EADS Deutschland GmbH" },
	{ 0x1f0c, "CMX Systems" },
	{ 0x1f28, "Cal-Comp" },
	{ 0x1f3a, "Allwinner Technology" },
	{ 0x1f44, "The Neat Company" },
	{ 0x1f48, "H-TRONIC GmbH" },
	{ 0x1f4d, "G-Tek Electronics Group" },
	{ 0x1f52, "Systems & Electronic Development FZCO (SEDCO)" },
	{ 0x1f6f, "Aliph" },
	{ 0x1f75, "Innostor Technology Corporation" },
	{ 0x1f82, "TANDBERG" },
	{ 0x1f84, "Alere, Inc." },
	{ 0x1f87, "Stantum" },
	{ 0x1f9b, "Ubiquiti Networks, Inc." },
	{ 0x1fab, "Samsung Opto-Electroncs Co., Ltd." },
	{ 0x1fac, "Franklin Wireless" },
	{ 0x1fae, "Lumidigm" },
	{ 0x1fb2, "Withings" },
	{ 0x1fba, "DERMALOG Identification Systems GmbH" },
	{ 0x1fbd, "Delphin Technology AG" },
	{ 0x1fc9, "NXP Semiconductors" },
	{ 0x1fde, "ILX Lightwave Corporation" },
	{ 0x1fe7, "Vertex Wireless Co., Ltd." },
	{ 0x1ff7, "CVT Electronics.Co.,Ltd" },
	{ 0x1ffb, "Pololu Corporation" },
	{ 0x1fff, "Ideofy Inc." },
	{ 0x2000, "CMX Systems" },
	{ 0x2001, "D-Link Corp." },
	{ 0x2002, "DAP Technologies" },
	{ 0x2003, "detectomat" },
	{ 0x2006, "LenovoMobile" },
	{ 0x2009, "iStorage" },
	{ 0x200c, "Reloop" },
	{ 0x2013, "PCTV Systems" },
	{ 0x2018, "Deutsche Telekom AG" },
	{ 0x2019, "PLANEX" },
	{ 0x201e, "Haier" },
	{ 0x203a, "PARALLELS" },
	{ 0x203d, "Encore Electronics Inc." },
	{ 0x2040, "Hauppauge" },
	{ 0x2047, "Texas Instruments" },
	{ 0x2058, "Nano River Technology" },
	{ 0x2077, "Taicang T&W Electronics Co. Ltd" },
	{ 0x2080, "Barnes & Noble" },
	{ 0x2086, "SIMPASS" },
	{ 0x2087, "Cando" },
	{ 0x20a0, "Clay Logic" },
	{ 0x20b1, "XMOS Ltd" },
	{ 0x20b3, "Hanvon" },
	{ 0x20b7, "Qi Hardware" },
	{ 0x20bc, "ShenZhen ShanWan Technology Co., Ltd." },
	{ 0x20ce, "Minicircuits" },
	{ 0x20df, "Simtec Electronics" },
	{ 0x20f0, "L3Harris Technologies" },
	{ 0x20f1, "NET New Electronic Technology GmbH" },
	{ 0x20f4, "TRENDnet" },
	{ 0x20f7, "XIMEA" },
	{ 0x2100, "RT Systems" },
	{ 0x2101, "ActionStar" },
	{ 0x2104, "Tobii Technology AB" },
	{ 0x2107, "RDING TECH CO.,LTD" },
	{ 0x2109, "VIA Labs, Inc." },
	{ 0x2113, "Softkinetic" },
	{ 0x2116, "KT Tech" },
	{ 0x211f, "CELOT Corporation" },
	{ 0x2123, "Cheeky Dream" },
	{ 0x2125, "Fiberpro Inc." },
	{ 0x2133, "signotec GmbH" },
	{ 0x2149, "Advanced Silicon S.A." },
	{ 0x214b, "Huasheng Electronics" },
	{ 0x214e, "Swiftpoint" },
	{ 0x2162, "Broadxent (Creative Labs)" },
	{ 0x2166, "JVC Kenwood" },
	{ 0x2184, "GW Instek" },
	{ 0x2188, "No brand" },
	{ 0x219c, "Seal One AG" },
	{ 0x21a1, "Emotiv Systems Pty. Ltd." },
	{ 0x21a4, "Electronic Arts Inc." },
	{ 0x21a9, "Saleae, Inc." },
	{ 0x21ab, "Planeta Informatica" },
	{ 0x21b4, "AudioQuest" },
	{ 0x21d6, "Agecodagis SARL" },
	{ 0x2207, "Fuzhou Rockchip Electronics Company" },
	{ 0x221a, "ZTEX GmbH" },
	{ 0x2222, "MacAlly" },
	{ 0x2226, "Copper Mountain technologies" },
	{ 0x2227, "SAMWOO Enterprise" },
	{ 0x222a, "ILI Technology Corp." },
	{ 0x2230, "Plugable" },
	{ 0x2232, "Silicon Motion" },
	{ 0x2233, "RadioShack Corporation" },
	{ 0x2237, "Kobo Inc." },
	{ 0x2245, "Aspeed Technology, Inc." },
	{ 0x224f, "APDM" },
	{ 0x2256, "Faderfox" },
	{ 0x225d, "Morpho" },
	{ 0x226e, "DISPLAX" },
	{ 0x228d, "8D Technologies inc." },
	{ 0x22a4, "VERZO Technology" },
	{ 0x22a6, "Pie Digital, Inc." },
	{ 0x22a7, "Fortinet Technologies" },
	{ 0x22b1, "Secret Labs LLC" },
	{ 0x22b8, "Motorola PCS" },
	{ 0x22b9, "eTurboTouch Technology, Inc." },
	{ 0x22ba, "Technology Innovation Holdings, Ltd" },
	{ 0x22c9, "StepOver GmbH" },
	{ 0x22cd, "Kinova Robotics Inc." },
	{ 0x22d4, "Laview Technology" },
	{ 0x22d9, "OPPO Electronics Corp." },
	{ 0x22db, "Phase One" },
	{ 0x22dc, "Mellanox Technologies" },
	{ 0x22de, "WeTelecom Incorporated" },
	{ 0x22df, "Medicom MTD, Ltd" },
	{ 0x22e0, "secunet Security Networks AG" },
	{ 0x22e8, "Cambridge Audio" },
	{ 0x2304, "Pinnacle Systems, Inc." },
	{ 0x230d, "Teracom" },
	{ 0x2314, "INQ Mobile" },
	{ 0x2318, "Shining Technologies, Inc. [hex]" },
	{ 0x2319, "Tronsmart" },
	{ 0x232b, "Pantum Ltd." },
	{ 0x232e, "EA Elektro-Automatik GmbH & Co. KG" },
	{ 0x2340, "Teleepoch" },
	{ 0x2341, "Arduino SA" },
	{ 0x2349, "P2 Engineering Group, LLC" },
	{ 0x234b, "Free Software Initiative of Japan" },
	{ 0x2357, "TP-Link" },
	{ 0x2366, "Bitmanufaktur GmbH" },
	{ 0x2367, "Teenage Engineering" },
	{ 0x2368, "Peterson Electro-Musical Products Inc." },
	{ 0x236a, "SiBEAM" },
	{ 0x2373, "Pumatronix Ltda" },
	{ 0x2375, "Digit@lway, Inc." },
	{ 0x2378, "OnLive" },
	{ 0x237d, "Cradlepoint" },
	{ 0x2386, "Raydium Corporation" },
	{ 0x238b, "Hytera Communications" },
	{ 0x239a, "Adafruit" },
	{ 0x23a0, "BIFIT" },
	{ 0x23a6, "Tronical Components GmbH" },
	{ 0x23b4, "Dental Wings Inc." },
	{ 0x23c7, "Gemini" },
	{ 0x23fc, "SesKion GmbH" },
	{ 0x2405, "Custom Computer Services, Inc" },
	{ 0x2406, "SANHO Digital Electronics Co., Ltd." },
	{ 0x2420, "IRiver" },
	{ 0x242e, "Vossloh-Schwabe Deutschland GmbH" },
	{ 0x2433, "ASETEK" },
	{ 0x2443, "Aessent Technology Ltd" },
	{ 0x2457, "Ocean Optics Inc." },
	{ 0x2458, "Bluegiga Technologies" },
	{ 0x245f, "Chord Electronics Limited" },
	{ 0x2464, "Nest" },
	{ 0x2466, "Fractal Audio Systems" },
	{ 0x2476, "YEI Technology" },
	{ 0x2478, "Tripp-Lite" },
	{ 0x248a, "Maxxter" },
	{ 0x249c, "M2Tech s.r.l." },
	{ 0x24a4, "Primare AB" },
	{ 0x24ae, "Shenzhen Rapoo Technology Co., Ltd." },
	{ 0x24c0, "Chaney Instrument" },
	{ 0x24c6, "ThrustMaster, Inc." },
	{ 0x24cf, "Lytro, Inc." },
	{ 0x24dc, "Aladdin R.D." },
	{ 0x24e0, "Yoctopuce Sarl" },
	{ 0x24e1, "Paratronic" },
	{ 0x24e3, "K-Touch" },
	{ 0x24ea, "Meva" },
	{ 0x24ed, "Zen Group" },
	{ 0x24f0, "Metadot" },
	{ 0x24ff, "Acroname Inc." },
	{ 0x2500, "Ettus Research LLC" },
	{ 0x2516, "Cooler Master Co., Ltd." },
	{ 0x2520, "ANA-U GmbH" },
	{ 0x2527, "Software Bisque" },
	{ 0x2537, "Norelsys" },
	{ 0x2544, "Energy Micro AS" },
	{ 0x2546, "Ravensburger" },
	{ 0x2548, "Pulse-Eight" },
	{ 0x254e, "SHF Communication Technologies AG" },
	{ 0x2554, "ASSA ABLOY AB" },
	{ 0x2555, "Basis Science Inc." },
	{ 0x255e, "Beijing Bonxeon Technology Co., Ltd." },
	{ 0x2560, "e-con Systems" },
	{ 0x2563, "ShenZhen ShanWan Technology Co., Ltd." },
	{ 0x256b, "Perreaux Industries Ltd" },
	{ 0x256f, "3Dconnexion" },
	{ 0x2573, "ESI Audiotechnik GmbH" },
	{ 0x2574, "AVer Information, Inc." },
	{ 0x2575, "Weida Hi-Tech Co., Ltd." },
	{ 0x2576, "AFO Co., Ltd." },
	{ 0x2578, "Pluscom" },
	{ 0x2581, "Plug-up" },
	{ 0x258d, "Sequans Communications" },
	{ 0x259a, "TriQuint Semiconductor" },
	{ 0x25a7, "Areson Technology Corp" },
	{ 0x25b5, "FlatFrog" },
	{ 0x25bb, "Brunner Elektronik AG" },
	{ 0x25bf, "Elegant Invention" },
	{ 0x25c4, "ARCAM" },
	{ 0x25c6, "Vitus Audio (AVA Group A/S)" },
	{ 0x25c8, "Visual Planet Ltd" },
	{ 0x25da, "Netatmo" },
	{ 0x25dd, "Bit4id Srl" },
	{ 0x25e3, "Lumigon" },
	{ 0x25f0, "ShanWan" },
	{ 0x25fb, "Pentax Ricoh Imaging Co., Ltd" },
	{ 0x2604, "Tenda" },
	{ 0x2625, "MilDef AB" },
	{ 0x2626, "Aruba Networks" },
	{ 0x262a, "SAVITECH Corp." },
	{ 0x2632, "TwinMOS" },
	{ 0x2639, "Xsens" },
	{ 0x264a, "Thermaltake" },
	{ 0x2650, "Electronics For Imaging, Inc. [hex]" },
	{ 0x2659, "Sundtek" },
	{ 0x2662, "Moog Music Inc." },
	{ 0x266e, "Silicon Integrated Systems" },
	{ 0x2672, "GoPro" },
	{ 0x2676, "Basler AG" },
	{ 0x2685, "Cardo Peripheral Systems LTD" },
	{ 0x2687, "Fitbit Inc." },
	{ 0x2689, "StepOver International GmbH" },
	{ 0x268b, "Dimension Engineering" },
	{ 0x26a9, "Research Industrial Systems Engineering" },
	{ 0x26aa, "Yaesu Musen" },
	{ 0x26b5, "Electrocompaniet" },
	{ 0x26bd, "Integral Memory" },
	{ 0x26e2, "Ingenieurbuero Dietzsch und Thiele, PartG" },
	{ 0x26f2, "Micromega" },
	{ 0x2707, "Bardac Corporation" },
	{ 0x270d, "Rosand Technologies" },
	{ 0x2717, "Xiaomi Inc." },
	{ 0x272a, "StarLeaf Ltd." },
	{ 0x272c, "Signum Systems" },
	{ 0x2730, "Citizen" },
	{ 0x2735, "DigitalWay" },
	{ 0x273f, "Hughski Limited" },
	{ 0x2756, "Victor Hasselblad AB" },
	{ 0x2759, "Philip Morris Products S.A." },
	{ 0x2765, "Firstbeat Technologies, Ltd." },
	{ 0x2766, "LifeScan" },
	{ 0x2770, "NHJ, Ltd" },
	{ 0x27a8, "Square, Inc." },
	{ 0x27b8, "ThingM" },
	{ 0x27bd, "Codethink Ltd." },
	{ 0x27c0, "Cadwell Laboratories, Inc." },
	{ 0x27c6, "Shenzhen Goodix Technology Co.,Ltd." },
	{ 0x27d4, "Blackstar Amplification Limited" },
	{ 0x27dd, "Mindeo" },
	{ 0x27f2, "Softnautics LLP" },
	{ 0x2803, "StarLine LLC." },
	{ 0x2806, "SIMPASS" },
	{ 0x2817, "Signal Hound, Inc." },
	{ 0x2818, "Codex Digital Limited" },
	{ 0x2821, "ASUSTek Computer Inc." },
	{ 0x2822, "REFLEXdigital" },
	{ 0x2833, "Oculus VR, Inc." },
	{ 0x2836, "OUYA" },
	{ 0x286b, "STANEO SAS" },
	{ 0x2886, "Seeed Technology Co., Ltd." },
	{ 0x2890, "Teknic, Inc" },
	{ 0x2899, "Toptronic Industrial Co., Ltd" },
	{ 0x289b, "Dracal/Raphnet technologies" },
	{ 0x289d, "Seek Thermal, Inc." },
	{ 0x28bd, "XP-Pen" },
	{ 0x28c7, "Ultimaker B.V." },
	{ 0x28d4, "Devialet" },
	{ 0x28de, "Valve Software" },
	{ 0x28e0, "PT. Prasimax Inovasi Teknologi" },
	{ 0x28e9, "GDMicroelectronics" },
	{ 0x28f3, "Clover Network, Inc." },
	{ 0x28f9, "Profitap HQ BV" },
	{ 0x290c, "R. Hamilton & Co. Ltd." },
	{ 0x2912, "Audioengine" },
	{ 0x2916, "Yota Devices" },
	{ 0x2931, "Jolla Oy" },
	{ 0x2939, "Zaber Technologies Inc." },
	{ 0x2957, "Obsidian Research Corporation" },
	{ 0x2961, "Miselu" },
	{ 0x296b, "Xacti Corporation" },
	{ 0x2972, "FiiO Electronics Technology" },
	{ 0x298d, "Next Biometrics" },
	{ 0x29bd, "Silicon Works" },
	{ 0x29c1, "Taztag" },
	{ 0x29c2, "Lewitt GmbH" },
	{ 0x29c3, "Noviga" },
	{ 0x29e2, "Huatune Technology (Shanghai) Co., Ltd." },
	{ 0x29e7, "Brunel University" },
	{ 0x29e8, "4Links Limited" },
	{ 0x29ea, "Kinesis Corporation" },
	{ 0x29f1, "Canaan Creative Co., Ltd" },
	{ 0x2a03, "dog hunter AG" },
	{ 0x2a0e, "Shenzhen DreamSource Technology Co., Ltd." },
	{ 0x2a13, "Grabba International" },
	{ 0x2a19, "Numato Systems Pvt. Ltd" },
	{ 0x2a1d, "Oxford Nanopore Technologies, Ltd" },
	{ 0x2a37, "RTD Embedded Technologies, Inc." },
	{ 0x2a39, "RME" },
	{ 0x2a3c, "Trinamic Motion Control GmbH & Co KG" },
	{ 0x2a45, "Meizu Corp." },
	{ 0x2a47, "Mundo Reader, S.L." },
	{ 0x2a4b, "EMULEX Corporation" },
	{ 0x2a62, "Flymaster Avionics" },
	{ 0x2a6e, "Bare Conductive" },
	{ 0x2a70, "OnePlus Technology (Shenzhen) Co., Ltd." },
	{ 0x2a88, "DFU Technology Ltd" },
	{ 0x2a8d, "Keysight Technologies, Inc." },
	{ 0x2ab6, "T+A elektroakustik GmbH & Co KG, Germany" },
	{ 0x2ac7, "Ultrahaptics Ltd." },
	{ 0x2ad1, "Picotronic GmbH" },
	{ 0x2ae5, "Fairphone B.V." },
	{ 0x2aec, "Ambiq Micro, Inc." },
	{ 0x2af4, "ROLI Ltd." },
	{ 0x2b03, "STEREOLABS" },
	{ 0x2b0e, "LeEco" },
	{ 0x2b23, "Red Hat, Inc." },
	{ 0x2b24, "KeepKey LLC" },
	{ 0x2b3e, "NewAE Technology Inc." },
	{ 0x2b4c, "ZUK" },
	{ 0x2bc5, "Orbbec 3D Technology International, Inc" },
	{ 0x2bcc, "InoTec GmbH Organisationssysteme" },
	{ 0x2bd6, "Coroware, Inc." },
	{ 0x2bd8, "ROPEX Industrie-Elektronik GmbH" },
	{ 0x2c02, "Planex Communications" },
	{ 0x2c1a, "Dolphin Peripherals" },
	{ 0x2c23, "Supermicro Computer Incorporated" },
	{ 0x2c4e, "Mercucys INC" },
	{ 0x2c4f, "Canon Electronic Business Machines Co., Ltd." },
	{ 0x2c55, "Magic Leap, Inc." },
	{ 0x2c7c, "Quectel Wireless Solutions Co., Ltd." },
	{ 0x2c97, "Ledger" },
	{ 0x2c99, "Prusa" },
	{ 0x2c9c, "Vayyar Imaging Ltd." },
	{ 0x2c9d, "Nod Inc" },
	{ 0x2ca3, "DJI Technology Co., Ltd." },
	{ 0x2cb7, "Fibocom" },
	{ 0x2cc0, "Hangzhou Zero Zero Infinity Technology Co., Ltd." },
	{ 0x2cc2, "Lautsprecher Teufel GmbH" },
	{ 0x2ccf, "Hypersecu" },
	{ 0x2cd9, "Cambrionix Ltd" },
	{ 0x2cdc, "Sea & Sun Technology GmbH" },
	{ 0x2ce5, "InX8 Inc [AKiTiO]" },
	{ 0x2cf0, "Nuand LLC" },
	{ 0x2d1f, "Wacom Taiwan Information Co. Ltd." },
	{ 0x2d25, "Kronegger GmbH." },
	{ 0x2d2d, "proxmark.org" },
	{ 0x2d37, "Zhuhai Poskey Technology Co.,Ltd" },
	{ 0x2d6b, "NetUP Inc." },
	{ 0x2d81, "Evollve Inc." },
	{ 0x2d84, "Zhuhai Poskey Technology Co.,Ltd" },
	{ 0x2dc8, "8BitDo" },
	{ 0x2dcf, "Dialog Semiconductor" },
	{ 0x2def, "Kirale Technologies" },
	{ 0x2df2, "LIPS Corporation" },
	{ 0x2e04, "HMD Global" },
	{ 0x2e0e, "Hatteland Display AS" },
	{ 0x2e24, "Hyperkin" },
	{ 0x2e3b, "uSens Inc." },
	{ 0x2e57, "MEGWARE Computer Vertrieb und Service GmbH" },
	{ 0x2e69, "Swift Navigation" },
	{ 0x2e95, "SCUF Gaming" },
	{ 0x2f76, "KeyXentic Inc." },
	{ 0x2fad, "Definium Technologies" },
	{ 0x2fb0, "Infocrypt" },
	{ 0x2fb2, "Fujitsu, Ltd" },
	{ 0x2fc0, "Sensidyne, LP" },
	{ 0x2fc6, "Comtrue Inc." },
	{ 0x2fe0, "Xaptum, Inc." },
	{ 0x2fe3, "NordicSemiconductor" },
	{ 0x2fe7, "ELGIN S.A." },
	{ 0x2feb, "Beijing Veikk E-Commerce Co., Ltd." },
	{ 0x2ff4, "Quixant Plc" },
	{ 0x3016, "Boundary Devices, LLC" },
	{ 0x3036, "Control iD" },
	{ 0x3037, "Beijing Chushifengmang Technology Development Co.,Ltd." },
	{ 0x3057, "Kingsis Corporation" },
	{ 0x308f, "Input Club" },
	{ 0x30a4, "Blues Wireless" },
	{ 0x30c2, "UNPARALLEL Innovation, Lda" },
	{ 0x30c9, "Luxvisions Innotech Limited" },
	{ 0x30ee, "Fujitsu Connected Technologies Limited" },
	{ 0x30f2, "Varex Imaging" },
	{ 0x3111, "Hiperscan GmbH" },
	{ 0x3112, "Meteca SA" },
	{ 0x3125, "Eagletron" },
	{ 0x3136, "Navini Networks" },
	{ 0x3145, "SafeLogic Inc." },
	{ 0x3147, "Tanvas, Inc." },
	{ 0x316c, "SigmaSense, LLC" },
	{ 0x316d, "Purism, SPC" },
	{ 0x316e, "SPECINFOSYSTEMS" },
	{ 0x3171, "8086 Consultancy" },
	{ 0x3176, "Whanam Electronics Co., Ltd" },
	{ 0x3195, "Link Instruments" },
	{ 0x31c9, "BeiJing LanXum Computer Technology Co., Ltd." },
	{ 0x3200, "Alcatel-Lucent Enterprise" },
	{ 0x3219, "Smak Tecnologia e Automacao LTDA" },
	{ 0x321c, "Premio, Inc." },
	{ 0x324c, "CUPRIS Ltd." },
	{ 0x326d, "Agile Display Solutions Co., Ltd" },
	{ 0x3275, "VidzMedia Pte Ltd" },
	{ 0x3293, "Unhuman Inc." },
	{ 0x32b3, "TEXA" },
	{ 0x3310, "MUDITA Sp. z o.o." },
	{ 0x3333, "InLine" },
	{ 0x3334, "AEI" },
	{ 0x3340, "Yakumo" },
	{ 0x3344, "Leaguer Microelectronics (LME)" },
	{ 0x3384, "System76" },
	{ 0x348f, "ISY" },
	{ 0x3504, "Micro Star" },
	{ 0x3538, "Power Quotient International Co., Ltd" },
	{ 0x3579, "DIVA" },
	{ 0x357d, "Sharkoon" },
	{ 0x3636, "InVibro" },
	{ 0x3767, "Fanatec" },
	{ 0x3838, "WEM" },
	{ 0x3923, "National Instruments Corp." },
	{ 0x40bb, "I-O Data" },
	{ 0x4101, "i-rocks" },
	{ 0x4102, "iRiver, Ltd." },
	{ 0x413c, "Dell Computer Corp." },
	{ 0x4146, "USBest Technology" },
	{ 0x4168, "Targus" },
	{ 0x4242, "USB Design by Example" },
	{ 0x4255, "GoPro" },
	{ 0x4317, "Broadcom Corp." },
	{ 0x4348, "WinChipHead" },
	{ 0x4572, "Shuttle, Inc." },
	{ 0x4586, "Panram" },
	{ 0x4670, "EMS Production" },
	{ 0x46f4, "QEMU" },
	{ 0x4752, "Miditech" },
	{ 0x4757, "GW Instek" },
	{ 0x4766, "Aceeca" },
	{ 0x4855, "Memorex" },
	{ 0x4971, "SimpleTech" },
	{ 0x4d46, "Musical Fidelity" },
	{ 0x5032, "Grandtec" },
	{ 0x50c2, "Averatec (?)" },
	{ 0x5131, "MSR" },
	{ 0x5173, "Sweex" },
	{ 0x5219, "I-Tetra" },
	{ 0x5332, "Clearly Superior Technologies, Inc." },
	{ 0x5345, "Owon" },
	{ 0x534c, "SatoshiLabs" },
	{ 0x534d, "MacroSilicon" },
	{ 0x5354, "Meyer Instruments (MIS)" },
	{ 0x544d, "Transmeta Corp." },
	{ 0x5543, "UC-Logic Technology Corp." },
	{ 0x5555, "Epiphan Systems Inc." },
	{ 0x55aa, "OnSpec Electronic, Inc." },
	{ 0x5654, "Gotview" },
	{ 0x5656, "Uni-Trend Group Limited" },
	{ 0x595a, "IRTOUCHSYSTEMS Co. Ltd." },
	{ 0x5986, "Acer, Inc" },
	{ 0x59e3, "Nonolith Labs" },
	{ 0x5a57, "Zinwell" },
	{ 0x6000, "Beholder International Ltd." },
	{ 0x601a, "Ingenic Semiconductor Ltd." },
	{ 0x6022, "Xektek" },
	{ 0x6189, "Sitecom" },
	{ 0x6244, "LightingSoft AG" },
	{ 0x6253, "TwinHan Technology Co., Ltd" },
	{ 0x636c, "CoreLogic, Inc." },
	{ 0x6472, "Sony Corp." },
	{ 0x6547, "Arkmicro Technologies Inc." },
	{ 0x6557, "Emtec" },
	{ 0x6615, "IRTOUCHSYSTEMS Co. Ltd." },
	{ 0x6666, "Prototype product Vendor ID" },
	{ 0x6677, "WiseGroup, Ltd." },
	{ 0x675d, "Humanscale" },
	{ 0x6891, "3Com" },
	{ 0x695c, "Opera1" },
	{ 0x6993, "Yealink Network Technology Co., Ltd." },
	{ 0x6a75, "Shanghai Jujo Electronics Co., Ltd" },
	{ 0x7104, "CME (Central Music Co.)" },
	{ 0x726c, "StackFoundry LLC" },
	{ 0x7302, "Solinftec" },
	{ 0x734c, "TBS Technologies China" },
	{ 0x7373, "Beijing STONE Technology Co. Ltd." },
	{ 0x7392, "Edimax Technology Co., Ltd" },
	{ 0x73d8, "Progeny Dental Equipment Specialists" },
	{ 0x7669, "Venable Instruments" },
	{ 0x7825, "Other World Computing" },
	{ 0x8070, "ACCES I/O Products, Inc." },
	{ 0x8086, "Intel Corp." },
	{ 0x8087, "Intel Corp." },
	{ 0x80ee, "VirtualBox" },
	{ 0x8282, "Keio" },
	{ 0x8301, "Hapurs" },
	{ 0x8341, "EGO Systems, Inc." },
	{ 0x8564, "Transcend Information, Inc." },
	{ 0x8644, "Intenso GmbG" },
	{ 0x8e06, "CH Products, Inc." },
	{ 0x8ea3, "Doosl" },
	{ 0x9016, "Sitecom" },
	{ 0x9022, "TeVii Technology Ltd." },
	{ 0x9148, "GeoLab, Ltd" },
	{ 0x9516, "Studiologic" },
	{ 0x9710, "MosChip Semiconductor" },
	{ 0x9849, "Bestmedia CD Recordable GmbH & Co. KG" },
	{ 0x9886, "Astro Gaming" },
	{ 0x9999, "Odeon" },
	{ 0x99fa, "Grandtec" },
	{ 0x9ac4, "J. Westhues" },
	{ 0x9e88, "Marvell Semiconductor, Inc." },
	{ 0xa014, "Insignia (Best Buy)" },
	{ 0xa108, "Ingenic Semiconductor Co.,Ltd" },
	{ 0xa128, "AnMo Electronics Corp. / Dino-Lite (?)" },
	{ 0xa168, "AnMo Electronics Corporation" },
	{ 0xa466, "Haikou Xingong Electronics Co.,Ltd" },
	{ 0xa600, "ASIX s.r.o." },
	{ 0xa727, "3Com" },
	{ 0xa88a, "Clas Ohlsson" },
	{ 0xaaaa, "MXT" },
	{ 0xab12, "aplic" },
	{ 0xabcd, "LogiLink" },
	{ 0xb58e, "Blue Microphones" },
	{ 0xba77, "Clockmaker" },
	{ 0xc216, "Card Device Expert Co., LTD" },
	{ 0xc251, "Keil Software, Inc." },
	{ 0xc502, "AGPTek" },
	{ 0xcace, "CACE Technologies Inc." },
	{ 0xcd12, "SMART TECHNOLOGY INDUSTRIAL LTD." },
	{ 0xd208, "Ultimarc" },
	{ 0xd209, "Ultimarc" },
	{ 0xd904, "LogiLink" },
	{ 0xe2b7, "Jie Li" },
	{ 0xe4e4, "Xorcom Ltd." },
	{ 0xeb03, "MakingThings" },
	{ 0xeb1a, "eMPIA Technology, Inc." },
	{ 0xeb2a, "KWorld" },
	{ 0xef18, "SMART TECHNOLOGY INDUSTRIAL LTD." },
	{ 0xf003, "Hewlett Packard" },
	{ 0xf007, "Teslong" },
	{ 0xf182, "Leap Motion" },
	{ 0xf3f0, "CCT, Inc" },
	{ 0xf4ec, "Atten Electronics / Siglent Technologies" },
	{ 0xf4ed, "Shenzhen Siglent Co., Ltd." },
	{ 0xf766, "Hama" },
	{ 0xfa11, "DyingLight" },
	{ 0xfc08, "Conrad Electronic SE" },
	{ 0xff00, "Power Delivery" },
	{ 0xffee, "FNK Tech" },
};

const char* LIBWDI_API wdi_get_vendor_name(unsigned short vid)
{
	int i;

	for(i=0; i<sizeof(usb_vendor)/sizeof(usb_vendor[0]); i++) {
		if (usb_vendor[i].vid == vid) {
			return usb_vendor[i].name;
		}
	}
	return NULL;
}
