/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Set;

import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;

/**
 * @author <a href="mailto:mposolda@redhat.com">Marek Posolda</a>
 */
@ProtoTypeId(Marshalling.RESOURCE_UPDATED_EVENT)
public class ResourceUpdatedEvent extends BaseResourceEvent {

    @ProtoFactory
    static ResourceUpdatedEvent protoFactory(String id, String name, String owner, String serverId, String type, Set<String> uris, Set<String> scopes) {
        return new ResourceUpdatedEvent(id, name, owner, serverId, type, uris, scopes);
    }

    private ResourceUpdatedEvent(String id, String name, String owner, String serverId, String type, Set<String> uris, Set<String> scopes) {
        super(id, name, owner, serverId, type, uris, scopes);
    }

    public static ResourceUpdatedEvent create(String id, String name, String type, Set<String> uris, String owner, Set<String> scopes, String serverId) {
        return new ResourceUpdatedEvent(id, name, owner, serverId, type, uris, scopes);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceUpdated(getId(), name, type, uris, scopes, serverId, owner, invalidations);
    }

}
