# Contributing guide

Thank for you taking the time to contribute to `gltf`. Your contributions are valued, no matter how small.

## Branch conventions and pull requests

 * Please submit all pull requests to the `master` branch.

## Contribution opportunities

 * Create or discuss issues for bugs and new features.
 * Improve the crate documentation.
 * Submit pull requests that implement new features, fix bugs, or improve ergonomics.
 * Participate in code reviews.
 * Improve formatting of code.

## Guidelines for API design and code style

 * We aim to follow the [Rust API guidelines](https://github.com/rust-lang-nursery/api-guidelines).
 * We aim to leave no blank spaces in generated documentation.
 * We use 4 space indentation with the [new Rust style guide](https://github.com/rust-lang-nursery/fmt-rfcs/blob/master/guide/guide.md).

## Code of conduct

Contributors are expected to abide by the [Rust code of conduct](https://www.rust-lang.org/en-US/conduct.html) and are encouraged to contact the author at alteous@outlook.com should confidential moderation be required.

## License agreement

Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
