// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ethermint/evm/v1/evm.proto

package types

import (
	cosmossdk_io_math "cosmossdk.io/math"
	fmt "fmt"
	_ "github.com/cosmos/cosmos-sdk/types/tx/amino"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AccessType defines the types of permissions for the operations
type AccessType int32

const (
	// ACCESS_TYPE_PERMISSIONLESS does not restrict the operation to anyone
	AccessTypePermissionless AccessType = 0
	// ACCESS_TYPE_RESTRICTED restrict the operation to anyone
	AccessTypeRestricted AccessType = 1
	// ACCESS_TYPE_PERMISSIONED only allows the operation for specific addresses
	AccessTypePermissioned AccessType = 2
)

var AccessType_name = map[int32]string{
	0: "ACCESS_TYPE_PERMISSIONLESS",
	1: "ACCESS_TYPE_RESTRICTED",
	2: "ACCESS_TYPE_PERMISSIONED",
}

var AccessType_value = map[string]int32{
	"ACCESS_TYPE_PERMISSIONLESS": 0,
	"ACCESS_TYPE_RESTRICTED":     1,
	"ACCESS_TYPE_PERMISSIONED":   2,
}

func (x AccessType) String() string {
	return proto.EnumName(AccessType_name, int32(x))
}

func (AccessType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{0}
}

// Params defines the EVM module parameters
type Params struct {
	// evm_denom represents the token denomination used to run the EVM state
	// transitions.
	EvmDenom string `protobuf:"bytes,1,opt,name=evm_denom,json=evmDenom,proto3" json:"evm_denom,omitempty" yaml:"evm_denom"`
	// extra_eips defines the additional EIPs for the vm.Config
	ExtraEIPs []string `protobuf:"bytes,4,rep,name=extra_eips,json=extraEips,proto3" json:"extra_eips,omitempty" yaml:"extra_eips"`
	// chain_config defines the EVM chain configuration parameters
	ChainConfig ChainConfig `protobuf:"bytes,5,opt,name=chain_config,json=chainConfig,proto3" json:"chain_config" yaml:"chain_config"`
	// allow_unprotected_txs defines if replay-protected (i.e non EIP155
	// signed) transactions can be executed on the state machine.
	AllowUnprotectedTxs bool `protobuf:"varint,6,opt,name=allow_unprotected_txs,json=allowUnprotectedTxs,proto3" json:"allow_unprotected_txs,omitempty"`
	// evm_channels is the list of channel identifiers from EVM compatible chains
	EVMChannels []string `protobuf:"bytes,8,rep,name=evm_channels,json=evmChannels,proto3" json:"evm_channels,omitempty"`
	// access_control defines the permission policy of the EVM
	AccessControl AccessControl `protobuf:"bytes,9,opt,name=access_control,json=accessControl,proto3" json:"access_control"`
	// active_static_precompiles defines the slice of hex addresses of the precompiled
	// contracts that are active
	ActiveStaticPrecompiles []string `protobuf:"bytes,10,rep,name=active_static_precompiles,json=activeStaticPrecompiles,proto3" json:"active_static_precompiles,omitempty"`
}

func (m *Params) Reset()         { *m = Params{} }
func (m *Params) String() string { return proto.CompactTextString(m) }
func (*Params) ProtoMessage()    {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

func (m *Params) GetEvmDenom() string {
	if m != nil {
		return m.EvmDenom
	}
	return ""
}

func (m *Params) GetExtraEIPs() []string {
	if m != nil {
		return m.ExtraEIPs
	}
	return nil
}

func (m *Params) GetChainConfig() ChainConfig {
	if m != nil {
		return m.ChainConfig
	}
	return ChainConfig{}
}

func (m *Params) GetAllowUnprotectedTxs() bool {
	if m != nil {
		return m.AllowUnprotectedTxs
	}
	return false
}

func (m *Params) GetEVMChannels() []string {
	if m != nil {
		return m.EVMChannels
	}
	return nil
}

func (m *Params) GetAccessControl() AccessControl {
	if m != nil {
		return m.AccessControl
	}
	return AccessControl{}
}

func (m *Params) GetActiveStaticPrecompiles() []string {
	if m != nil {
		return m.ActiveStaticPrecompiles
	}
	return nil
}

// AccessControl defines the permission policy of the EVM
// for creating and calling contracts
type AccessControl struct {
	// create defines the permission policy for creating contracts
	Create AccessControlType `protobuf:"bytes,1,opt,name=create,proto3" json:"create"`
	// call defines the permission policy for calling contracts
	Call AccessControlType `protobuf:"bytes,2,opt,name=call,proto3" json:"call"`
}

func (m *AccessControl) Reset()         { *m = AccessControl{} }
func (m *AccessControl) String() string { return proto.CompactTextString(m) }
func (*AccessControl) ProtoMessage()    {}
func (*AccessControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{1}
}
func (m *AccessControl) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessControl.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AccessControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessControl.Merge(m, src)
}
func (m *AccessControl) XXX_Size() int {
	return m.Size()
}
func (m *AccessControl) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessControl.DiscardUnknown(m)
}

var xxx_messageInfo_AccessControl proto.InternalMessageInfo

func (m *AccessControl) GetCreate() AccessControlType {
	if m != nil {
		return m.Create
	}
	return AccessControlType{}
}

func (m *AccessControl) GetCall() AccessControlType {
	if m != nil {
		return m.Call
	}
	return AccessControlType{}
}

// AccessControlType defines the permission type for policies
type AccessControlType struct {
	// access_type defines which type of permission is required for the operation
	AccessType AccessType `protobuf:"varint,1,opt,name=access_type,json=accessType,proto3,enum=ethermint.evm.v1.AccessType" json:"access_type,omitempty" yaml:"access_type"`
	// access_control_list defines defines different things depending on the AccessType:
	// - ACCESS_TYPE_PERMISSIONLESS: list of addresses that are blocked from performing the operation
	// - ACCESS_TYPE_RESTRICTED: ignored
	// - ACCESS_TYPE_PERMISSIONED: list of addresses that are allowed to perform the operation
	AccessControlList []string `protobuf:"bytes,2,rep,name=access_control_list,json=accessControlList,proto3" json:"access_control_list,omitempty" yaml:"access_control_list"`
}

func (m *AccessControlType) Reset()         { *m = AccessControlType{} }
func (m *AccessControlType) String() string { return proto.CompactTextString(m) }
func (*AccessControlType) ProtoMessage()    {}
func (*AccessControlType) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{2}
}
func (m *AccessControlType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessControlType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessControlType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AccessControlType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessControlType.Merge(m, src)
}
func (m *AccessControlType) XXX_Size() int {
	return m.Size()
}
func (m *AccessControlType) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessControlType.DiscardUnknown(m)
}

var xxx_messageInfo_AccessControlType proto.InternalMessageInfo

func (m *AccessControlType) GetAccessType() AccessType {
	if m != nil {
		return m.AccessType
	}
	return AccessTypePermissionless
}

func (m *AccessControlType) GetAccessControlList() []string {
	if m != nil {
		return m.AccessControlList
	}
	return nil
}

// ChainConfig defines the Ethereum ChainConfig parameters using *sdk.Int values
// instead of *big.Int.
type ChainConfig struct {
	// homestead_block switch (nil no fork, 0 = already homestead)
	HomesteadBlock *cosmossdk_io_math.Int `protobuf:"bytes,1,opt,name=homestead_block,json=homesteadBlock,proto3,customtype=cosmossdk.io/math.Int" json:"homestead_block,omitempty" yaml:"homestead_block"`
	// dao_fork_block corresponds to TheDAO hard-fork switch block (nil no fork)
	DAOForkBlock *cosmossdk_io_math.Int `protobuf:"bytes,2,opt,name=dao_fork_block,json=daoForkBlock,proto3,customtype=cosmossdk.io/math.Int" json:"dao_fork_block,omitempty" yaml:"dao_fork_block"`
	// dao_fork_support defines whether the nodes supports or opposes the DAO hard-fork
	DAOForkSupport bool `protobuf:"varint,3,opt,name=dao_fork_support,json=daoForkSupport,proto3" json:"dao_fork_support,omitempty" yaml:"dao_fork_support"`
	// eip150_block: EIP150 implements the Gas price changes
	// (https://github.com/ethereum/EIPs/issues/150) EIP150 HF block (nil no fork)
	EIP150Block *cosmossdk_io_math.Int `protobuf:"bytes,4,opt,name=eip150_block,json=eip150Block,proto3,customtype=cosmossdk.io/math.Int" json:"eip150_block,omitempty" yaml:"eip150_block"`
	// eip150_hash: EIP150 HF hash (needed for header only clients as only gas pricing changed)
	EIP150Hash string `protobuf:"bytes,5,opt,name=eip150_hash,json=eip150Hash,proto3" json:"eip150_hash,omitempty" yaml:"byzantium_block"`
	// eip155_block: EIP155Block HF block
	EIP155Block *cosmossdk_io_math.Int `protobuf:"bytes,6,opt,name=eip155_block,json=eip155Block,proto3,customtype=cosmossdk.io/math.Int" json:"eip155_block,omitempty" yaml:"eip155_block"`
	// eip158_block: EIP158 HF block
	EIP158Block *cosmossdk_io_math.Int `protobuf:"bytes,7,opt,name=eip158_block,json=eip158Block,proto3,customtype=cosmossdk.io/math.Int" json:"eip158_block,omitempty" yaml:"eip158_block"`
	// byzantium_block: Byzantium switch block (nil no fork, 0 = already on byzantium)
	ByzantiumBlock *cosmossdk_io_math.Int `protobuf:"bytes,8,opt,name=byzantium_block,json=byzantiumBlock,proto3,customtype=cosmossdk.io/math.Int" json:"byzantium_block,omitempty" yaml:"byzantium_block"`
	// constantinople_block: Constantinople switch block (nil no fork, 0 = already activated)
	ConstantinopleBlock *cosmossdk_io_math.Int `protobuf:"bytes,9,opt,name=constantinople_block,json=constantinopleBlock,proto3,customtype=cosmossdk.io/math.Int" json:"constantinople_block,omitempty" yaml:"constantinople_block"`
	// petersburg_block: Petersburg switch block (nil same as Constantinople)
	PetersburgBlock *cosmossdk_io_math.Int `protobuf:"bytes,10,opt,name=petersburg_block,json=petersburgBlock,proto3,customtype=cosmossdk.io/math.Int" json:"petersburg_block,omitempty" yaml:"petersburg_block"`
	// istanbul_block: Istanbul switch block (nil no fork, 0 = already on istanbul)
	IstanbulBlock *cosmossdk_io_math.Int `protobuf:"bytes,11,opt,name=istanbul_block,json=istanbulBlock,proto3,customtype=cosmossdk.io/math.Int" json:"istanbul_block,omitempty" yaml:"istanbul_block"`
	// muir_glacier_block: Eip-2384 (bomb delay) switch block (nil no fork, 0 = already activated)
	MuirGlacierBlock *cosmossdk_io_math.Int `protobuf:"bytes,12,opt,name=muir_glacier_block,json=muirGlacierBlock,proto3,customtype=cosmossdk.io/math.Int" json:"muir_glacier_block,omitempty" yaml:"muir_glacier_block"`
	// berlin_block: Berlin switch block (nil = no fork, 0 = already on berlin)
	BerlinBlock *cosmossdk_io_math.Int `protobuf:"bytes,13,opt,name=berlin_block,json=berlinBlock,proto3,customtype=cosmossdk.io/math.Int" json:"berlin_block,omitempty" yaml:"berlin_block"`
	// london_block: London switch block (nil = no fork, 0 = already on london)
	LondonBlock *cosmossdk_io_math.Int `protobuf:"bytes,17,opt,name=london_block,json=londonBlock,proto3,customtype=cosmossdk.io/math.Int" json:"london_block,omitempty" yaml:"london_block"`
	// arrow_glacier_block: Eip-4345 (bomb delay) switch block (nil = no fork, 0 = already activated)
	ArrowGlacierBlock *cosmossdk_io_math.Int `protobuf:"bytes,18,opt,name=arrow_glacier_block,json=arrowGlacierBlock,proto3,customtype=cosmossdk.io/math.Int" json:"arrow_glacier_block,omitempty" yaml:"arrow_glacier_block"`
	// gray_glacier_block: EIP-5133 (bomb delay) switch block (nil = no fork, 0 = already activated)
	GrayGlacierBlock *cosmossdk_io_math.Int `protobuf:"bytes,20,opt,name=gray_glacier_block,json=grayGlacierBlock,proto3,customtype=cosmossdk.io/math.Int" json:"gray_glacier_block,omitempty" yaml:"gray_glacier_block"`
	// merge_netsplit_block: Virtual fork after The Merge to use as a network splitter
	MergeNetsplitBlock *cosmossdk_io_math.Int `protobuf:"bytes,21,opt,name=merge_netsplit_block,json=mergeNetsplitBlock,proto3,customtype=cosmossdk.io/math.Int" json:"merge_netsplit_block,omitempty" yaml:"merge_netsplit_block"`
	// shanghai_block switch block (nil = no fork, 0 = already on shanghai)
	ShanghaiBlock *cosmossdk_io_math.Int `protobuf:"bytes,22,opt,name=shanghai_block,json=shanghaiBlock,proto3,customtype=cosmossdk.io/math.Int" json:"shanghai_block,omitempty" yaml:"shanghai_block"`
	// cancun_block switch block (nil = no fork, 0 = already on cancun)
	CancunBlock *cosmossdk_io_math.Int `protobuf:"bytes,23,opt,name=cancun_block,json=cancunBlock,proto3,customtype=cosmossdk.io/math.Int" json:"cancun_block,omitempty" yaml:"cancun_block"`
}

func (m *ChainConfig) Reset()         { *m = ChainConfig{} }
func (m *ChainConfig) String() string { return proto.CompactTextString(m) }
func (*ChainConfig) ProtoMessage()    {}
func (*ChainConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{3}
}
func (m *ChainConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChainConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ChainConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ChainConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChainConfig.Merge(m, src)
}
func (m *ChainConfig) XXX_Size() int {
	return m.Size()
}
func (m *ChainConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ChainConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ChainConfig proto.InternalMessageInfo

func (m *ChainConfig) GetDAOForkSupport() bool {
	if m != nil {
		return m.DAOForkSupport
	}
	return false
}

func (m *ChainConfig) GetEIP150Hash() string {
	if m != nil {
		return m.EIP150Hash
	}
	return ""
}

// State represents a single Storage key value pair item.
type State struct {
	// key is the stored key
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// value is the stored value for the given key
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *State) Reset()         { *m = State{} }
func (m *State) String() string { return proto.CompactTextString(m) }
func (*State) ProtoMessage()    {}
func (*State) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{4}
}
func (m *State) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *State) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_State.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *State) XXX_Merge(src proto.Message) {
	xxx_messageInfo_State.Merge(m, src)
}
func (m *State) XXX_Size() int {
	return m.Size()
}
func (m *State) XXX_DiscardUnknown() {
	xxx_messageInfo_State.DiscardUnknown(m)
}

var xxx_messageInfo_State proto.InternalMessageInfo

func (m *State) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *State) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// TransactionLogs define the logs generated from a transaction execution
// with a given hash. It it used for import/export data as transactions are not
// persisted on blockchain state after an upgrade.
type TransactionLogs struct {
	// hash of the transaction
	Hash string `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// logs is an array of Logs for the given transaction hash
	Logs []*Log `protobuf:"bytes,2,rep,name=logs,proto3" json:"logs,omitempty"`
}

func (m *TransactionLogs) Reset()         { *m = TransactionLogs{} }
func (m *TransactionLogs) String() string { return proto.CompactTextString(m) }
func (*TransactionLogs) ProtoMessage()    {}
func (*TransactionLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{5}
}
func (m *TransactionLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TransactionLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TransactionLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionLogs.Merge(m, src)
}
func (m *TransactionLogs) XXX_Size() int {
	return m.Size()
}
func (m *TransactionLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionLogs.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionLogs proto.InternalMessageInfo

func (m *TransactionLogs) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *TransactionLogs) GetLogs() []*Log {
	if m != nil {
		return m.Logs
	}
	return nil
}

// Log represents an protobuf compatible Ethereum Log that defines a contract
// log event. These events are generated by the LOG opcode and stored/indexed by
// the node.
//
// NOTE: address, topics and data are consensus fields. The rest of the fields
// are derived, i.e. filled in by the nodes, but not secured by consensus.
type Log struct {
	// address of the contract that generated the event
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// topics is a list of topics provided by the contract.
	Topics []string `protobuf:"bytes,2,rep,name=topics,proto3" json:"topics,omitempty"`
	// data which is supplied by the contract, usually ABI-encoded
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// block_number of the block in which the transaction was included
	BlockNumber uint64 `protobuf:"varint,4,opt,name=block_number,json=blockNumber,proto3" json:"blockNumber"`
	// tx_hash is the transaction hash
	TxHash string `protobuf:"bytes,5,opt,name=tx_hash,json=txHash,proto3" json:"transactionHash"`
	// tx_index of the transaction in the block
	TxIndex uint64 `protobuf:"varint,6,opt,name=tx_index,json=txIndex,proto3" json:"transactionIndex"`
	// block_hash of the block in which the transaction was included
	BlockHash string `protobuf:"bytes,7,opt,name=block_hash,json=blockHash,proto3" json:"blockHash"`
	// index of the log in the block
	Index uint64 `protobuf:"varint,8,opt,name=index,proto3" json:"logIndex"`
	// removed is true if this log was reverted due to a chain
	// reorganisation. You must pay attention to this field if you receive logs
	// through a filter query.
	Removed bool `protobuf:"varint,9,opt,name=removed,proto3" json:"removed,omitempty"`
}

func (m *Log) Reset()         { *m = Log{} }
func (m *Log) String() string { return proto.CompactTextString(m) }
func (*Log) ProtoMessage()    {}
func (*Log) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{6}
}
func (m *Log) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Log) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Log.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Log) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Log.Merge(m, src)
}
func (m *Log) XXX_Size() int {
	return m.Size()
}
func (m *Log) XXX_DiscardUnknown() {
	xxx_messageInfo_Log.DiscardUnknown(m)
}

var xxx_messageInfo_Log proto.InternalMessageInfo

func (m *Log) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Log) GetTopics() []string {
	if m != nil {
		return m.Topics
	}
	return nil
}

func (m *Log) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Log) GetBlockNumber() uint64 {
	if m != nil {
		return m.BlockNumber
	}
	return 0
}

func (m *Log) GetTxHash() string {
	if m != nil {
		return m.TxHash
	}
	return ""
}

func (m *Log) GetTxIndex() uint64 {
	if m != nil {
		return m.TxIndex
	}
	return 0
}

func (m *Log) GetBlockHash() string {
	if m != nil {
		return m.BlockHash
	}
	return ""
}

func (m *Log) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *Log) GetRemoved() bool {
	if m != nil {
		return m.Removed
	}
	return false
}

// TxResult stores results of Tx execution.
type TxResult struct {
	// contract_address contains the ethereum address of the created contract (if
	// any). If the state transition is an evm.Call, the contract address will be
	// empty.
	ContractAddress string `protobuf:"bytes,1,opt,name=contract_address,json=contractAddress,proto3" json:"contract_address,omitempty" yaml:"contract_address"`
	// bloom represents the bloom filter bytes
	Bloom []byte `protobuf:"bytes,2,opt,name=bloom,proto3" json:"bloom,omitempty"`
	// tx_logs contains the transaction hash and the proto-compatible ethereum
	// logs.
	TxLogs TransactionLogs `protobuf:"bytes,3,opt,name=tx_logs,json=txLogs,proto3" json:"tx_logs" yaml:"tx_logs"`
	// ret defines the bytes from the execution.
	Ret []byte `protobuf:"bytes,4,opt,name=ret,proto3" json:"ret,omitempty"`
	// reverted flag is set to true when the call has been reverted
	Reverted bool `protobuf:"varint,5,opt,name=reverted,proto3" json:"reverted,omitempty"`
	// gas_used notes the amount of gas consumed while execution
	GasUsed uint64 `protobuf:"varint,6,opt,name=gas_used,json=gasUsed,proto3" json:"gas_used,omitempty"`
}

func (m *TxResult) Reset()         { *m = TxResult{} }
func (m *TxResult) String() string { return proto.CompactTextString(m) }
func (*TxResult) ProtoMessage()    {}
func (*TxResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{7}
}
func (m *TxResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxResult.Merge(m, src)
}
func (m *TxResult) XXX_Size() int {
	return m.Size()
}
func (m *TxResult) XXX_DiscardUnknown() {
	xxx_messageInfo_TxResult.DiscardUnknown(m)
}

var xxx_messageInfo_TxResult proto.InternalMessageInfo

// AccessTuple is the element type of an access list.
type AccessTuple struct {
	// address is a hex formatted ethereum address
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// storage_keys are hex formatted hashes of the storage keys
	StorageKeys []string `protobuf:"bytes,2,rep,name=storage_keys,json=storageKeys,proto3" json:"storageKeys"`
}

func (m *AccessTuple) Reset()         { *m = AccessTuple{} }
func (m *AccessTuple) String() string { return proto.CompactTextString(m) }
func (*AccessTuple) ProtoMessage()    {}
func (*AccessTuple) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{8}
}
func (m *AccessTuple) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessTuple) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessTuple.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AccessTuple) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessTuple.Merge(m, src)
}
func (m *AccessTuple) XXX_Size() int {
	return m.Size()
}
func (m *AccessTuple) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessTuple.DiscardUnknown(m)
}

var xxx_messageInfo_AccessTuple proto.InternalMessageInfo

// TraceConfig holds extra parameters to trace functions.
type TraceConfig struct {
	// tracer is a custom javascript tracer
	Tracer string `protobuf:"bytes,1,opt,name=tracer,proto3" json:"tracer,omitempty"`
	// timeout overrides the default timeout of 5 seconds for JavaScript-based tracing
	// calls
	Timeout string `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// reexec defines the number of blocks the tracer is willing to go back
	Reexec uint64 `protobuf:"varint,3,opt,name=reexec,proto3" json:"reexec,omitempty"`
	// disable_stack switches stack capture
	DisableStack bool `protobuf:"varint,5,opt,name=disable_stack,json=disableStack,proto3" json:"disableStack"`
	// disable_storage switches storage capture
	DisableStorage bool `protobuf:"varint,6,opt,name=disable_storage,json=disableStorage,proto3" json:"disableStorage"`
	// debug can be used to print output during capture end
	Debug bool `protobuf:"varint,8,opt,name=debug,proto3" json:"debug,omitempty"`
	// limit defines the maximum length of output, but zero means unlimited
	Limit int32 `protobuf:"varint,9,opt,name=limit,proto3" json:"limit,omitempty"`
	// overrides can be used to execute a trace using future fork rules
	Overrides *ChainConfig `protobuf:"bytes,10,opt,name=overrides,proto3" json:"overrides,omitempty"`
	// enable_memory switches memory capture
	EnableMemory bool `protobuf:"varint,11,opt,name=enable_memory,json=enableMemory,proto3" json:"enableMemory"`
	// enable_return_data switches the capture of return data
	EnableReturnData bool `protobuf:"varint,12,opt,name=enable_return_data,json=enableReturnData,proto3" json:"enableReturnData"`
	// tracer_json_config configures the tracer using a JSON string
	TracerJsonConfig string `protobuf:"bytes,13,opt,name=tracer_json_config,json=tracerJsonConfig,proto3" json:"tracerConfig"`
}

func (m *TraceConfig) Reset()         { *m = TraceConfig{} }
func (m *TraceConfig) String() string { return proto.CompactTextString(m) }
func (*TraceConfig) ProtoMessage()    {}
func (*TraceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_d21ecc92c8c8583e, []int{9}
}
func (m *TraceConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TraceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TraceConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TraceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TraceConfig.Merge(m, src)
}
func (m *TraceConfig) XXX_Size() int {
	return m.Size()
}
func (m *TraceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TraceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TraceConfig proto.InternalMessageInfo

func (m *TraceConfig) GetTracer() string {
	if m != nil {
		return m.Tracer
	}
	return ""
}

func (m *TraceConfig) GetTimeout() string {
	if m != nil {
		return m.Timeout
	}
	return ""
}

func (m *TraceConfig) GetReexec() uint64 {
	if m != nil {
		return m.Reexec
	}
	return 0
}

func (m *TraceConfig) GetDisableStack() bool {
	if m != nil {
		return m.DisableStack
	}
	return false
}

func (m *TraceConfig) GetDisableStorage() bool {
	if m != nil {
		return m.DisableStorage
	}
	return false
}

func (m *TraceConfig) GetDebug() bool {
	if m != nil {
		return m.Debug
	}
	return false
}

func (m *TraceConfig) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *TraceConfig) GetOverrides() *ChainConfig {
	if m != nil {
		return m.Overrides
	}
	return nil
}

func (m *TraceConfig) GetEnableMemory() bool {
	if m != nil {
		return m.EnableMemory
	}
	return false
}

func (m *TraceConfig) GetEnableReturnData() bool {
	if m != nil {
		return m.EnableReturnData
	}
	return false
}

func (m *TraceConfig) GetTracerJsonConfig() string {
	if m != nil {
		return m.TracerJsonConfig
	}
	return ""
}

func init() {
	proto.RegisterEnum("ethermint.evm.v1.AccessType", AccessType_name, AccessType_value)
	proto.RegisterType((*Params)(nil), "ethermint.evm.v1.Params")
	proto.RegisterType((*AccessControl)(nil), "ethermint.evm.v1.AccessControl")
	proto.RegisterType((*AccessControlType)(nil), "ethermint.evm.v1.AccessControlType")
	proto.RegisterType((*ChainConfig)(nil), "ethermint.evm.v1.ChainConfig")
	proto.RegisterType((*State)(nil), "ethermint.evm.v1.State")
	proto.RegisterType((*TransactionLogs)(nil), "ethermint.evm.v1.TransactionLogs")
	proto.RegisterType((*Log)(nil), "ethermint.evm.v1.Log")
	proto.RegisterType((*TxResult)(nil), "ethermint.evm.v1.TxResult")
	proto.RegisterType((*AccessTuple)(nil), "ethermint.evm.v1.AccessTuple")
	proto.RegisterType((*TraceConfig)(nil), "ethermint.evm.v1.TraceConfig")
}

func init() { proto.RegisterFile("ethermint/evm/v1/evm.proto", fileDescriptor_d21ecc92c8c8583e) }

var fileDescriptor_d21ecc92c8c8583e = []byte{
	// 1927 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x4b, 0x6f, 0x23, 0xc7,
	0x11, 0x16, 0xa5, 0x91, 0x34, 0x6c, 0x52, 0xe4, 0xa8, 0x45, 0xed, 0x72, 0xb9, 0x8e, 0x46, 0x99,
	0x04, 0xc1, 0x66, 0xe1, 0x48, 0x2b, 0xad, 0x95, 0x08, 0xeb, 0xbc, 0x44, 0x89, 0x4e, 0xa4, 0x68,
	0xd7, 0x42, 0x53, 0x8e, 0xe1, 0x20, 0xc1, 0xa0, 0x39, 0xd3, 0x26, 0xc7, 0x9a, 0x99, 0x26, 0xa6,
	0x9b, 0x5c, 0x32, 0xbf, 0xc0, 0xd8, 0xd3, 0xe6, 0x07, 0x2c, 0x60, 0x20, 0x97, 0x1c, 0xfd, 0x13,
	0x72, 0x34, 0x72, 0xf2, 0x31, 0x08, 0x90, 0x41, 0xc0, 0x3d, 0x18, 0xd0, 0x51, 0xf7, 0x00, 0x41,
	0x3f, 0xf8, 0x94, 0x2c, 0x2b, 0x17, 0xaa, 0xab, 0xba, 0xea, 0xfb, 0xaa, 0xaa, 0x6b, 0xfa, 0x21,
	0x50, 0x21, 0xbc, 0x45, 0x92, 0x28, 0x88, 0xf9, 0x36, 0xe9, 0x46, 0xdb, 0xdd, 0x1d, 0xf1, 0x67,
	0xab, 0x9d, 0x50, 0x4e, 0xa1, 0x35, 0x9a, 0xdb, 0x12, 0xca, 0xee, 0x4e, 0x65, 0x15, 0x47, 0x41,
	0x4c, 0xb7, 0xe5, 0xaf, 0x32, 0xaa, 0x94, 0x9a, 0xb4, 0x49, 0xe5, 0x70, 0x5b, 0x8c, 0x94, 0xd6,
	0x79, 0x6d, 0x80, 0xa5, 0x33, 0x9c, 0xe0, 0x88, 0xc1, 0x1d, 0x90, 0x25, 0xdd, 0xc8, 0xf5, 0x49,
	0x4c, 0xa3, 0x72, 0x66, 0x33, 0xf3, 0x28, 0x5b, 0x2d, 0x5d, 0xa5, 0xb6, 0xd5, 0xc7, 0x51, 0xf8,
	0xcc, 0x19, 0x4d, 0x39, 0xc8, 0x24, 0xdd, 0xe8, 0x48, 0x0c, 0xe1, 0x01, 0x00, 0xa4, 0xc7, 0x13,
	0xec, 0x92, 0xa0, 0xcd, 0xca, 0xc6, 0xe6, 0xc2, 0xa3, 0x6c, 0xd5, 0x19, 0xa4, 0x76, 0xb6, 0x26,
	0xb4, 0xb5, 0xe3, 0x33, 0x76, 0x95, 0xda, 0xab, 0x1a, 0x60, 0x64, 0xe8, 0xa0, 0xac, 0x14, 0x6a,
	0x41, 0x9b, 0xc1, 0x06, 0xc8, 0x7b, 0x2d, 0x1c, 0xc4, 0xae, 0x47, 0xe3, 0x4f, 0x83, 0x66, 0x79,
	0x71, 0x33, 0xf3, 0x28, 0xb7, 0xfb, 0xbd, 0xad, 0xd9, 0x94, 0xb6, 0x0e, 0x85, 0xd5, 0xa1, 0x34,
	0xaa, 0x6e, 0x7e, 0x95, 0xda, 0x73, 0x57, 0xa9, 0xbd, 0xa6, 0xa0, 0x27, 0x01, 0x9c, 0xbf, 0x7d,
	0xf3, 0xe5, 0xe3, 0x0c, 0xca, 0x79, 0x63, 0x73, 0xb8, 0x0b, 0xd6, 0x71, 0x18, 0xd2, 0x97, 0x6e,
	0x27, 0x16, 0x59, 0x13, 0x8f, 0x13, 0xdf, 0xe5, 0x3d, 0x56, 0x5e, 0xda, 0xcc, 0x3c, 0x32, 0xd1,
	0x9a, 0x9c, 0xfc, 0x68, 0x3c, 0x77, 0xde, 0x63, 0x70, 0x17, 0xe4, 0x45, 0xca, 0x5e, 0x0b, 0xc7,
	0x31, 0x09, 0x59, 0xd9, 0x94, 0xc9, 0x15, 0x07, 0xa9, 0x9d, 0xab, 0xfd, 0xfe, 0xf9, 0xa1, 0x56,
	0xa3, 0x1c, 0xe9, 0x46, 0x43, 0x01, 0xfe, 0x09, 0x14, 0xb0, 0xe7, 0x11, 0xc6, 0x44, 0x2c, 0x3c,
	0xa1, 0x61, 0x39, 0x2b, 0xb3, 0xb1, 0xaf, 0x67, 0x73, 0x20, 0xed, 0x0e, 0x95, 0x59, 0x75, 0x5d,
	0xe4, 0x33, 0x48, 0xed, 0x95, 0x29, 0x35, 0x5a, 0xc1, 0x93, 0x22, 0x7c, 0x06, 0x1e, 0x60, 0x8f,
	0x07, 0x5d, 0xe2, 0x32, 0x8e, 0x79, 0xe0, 0xb9, 0xed, 0x84, 0x78, 0x34, 0x6a, 0x07, 0x21, 0x61,
	0x65, 0x20, 0xe2, 0x43, 0xf7, 0x95, 0x41, 0x5d, 0xce, 0x9f, 0x8d, 0xa7, 0x9f, 0xdd, 0x7f, 0xf5,
	0xcd, 0x97, 0x8f, 0x21, 0xe9, 0x46, 0x94, 0x6d, 0xf7, 0x64, 0x07, 0xa9, 0x55, 0x3f, 0x31, 0xcc,
	0x79, 0x6b, 0xe1, 0xc4, 0x30, 0x17, 0x2c, 0xe3, 0xc4, 0x30, 0x97, 0x2d, 0xd3, 0xf9, 0x4b, 0x06,
	0x4c, 0xc7, 0x01, 0x0f, 0xc0, 0x92, 0x97, 0x10, 0xcc, 0x89, 0x6c, 0x8b, 0xdc, 0xee, 0x0f, 0xbe,
	0x23, 0x9f, 0xf3, 0x7e, 0x9b, 0x54, 0x0d, 0x91, 0x13, 0xd2, 0x8e, 0xf0, 0x17, 0xc0, 0xf0, 0x70,
	0x18, 0x96, 0xe7, 0xff, 0x5f, 0x00, 0xe9, 0xe6, 0xfc, 0x3b, 0x03, 0x56, 0xaf, 0x59, 0x40, 0x0f,
	0xe4, 0x74, 0xbd, 0x79, 0xbf, 0xad, 0x82, 0x2b, 0xec, 0xbe, 0xf3, 0x6d, 0xd8, 0x12, 0xf4, 0x87,
	0x83, 0xd4, 0x06, 0x63, 0xf9, 0x2a, 0xb5, 0xa1, 0xea, 0xa1, 0x09, 0x20, 0x07, 0x01, 0x3c, 0xb2,
	0x80, 0x1e, 0x58, 0x9b, 0x5e, 0x54, 0x37, 0x0c, 0x18, 0x2f, 0xcf, 0xcb, 0x7e, 0x78, 0x3a, 0x48,
	0xed, 0xe9, 0xc0, 0x4e, 0x03, 0xc6, 0xaf, 0x52, 0xbb, 0x32, 0x85, 0x3a, 0xe9, 0xe9, 0xa0, 0x55,
	0x3c, 0xeb, 0xe0, 0xfc, 0xb7, 0x00, 0x72, 0x13, 0x0d, 0x0e, 0xff, 0x08, 0x8a, 0x2d, 0x1a, 0x11,
	0xc6, 0x09, 0xf6, 0xdd, 0x46, 0x48, 0xbd, 0x0b, 0xfd, 0x45, 0x3e, 0xfd, 0x57, 0x6a, 0xaf, 0x7b,
	0x94, 0x45, 0x94, 0x31, 0xff, 0x62, 0x2b, 0xa0, 0xdb, 0x11, 0xe6, 0xad, 0xad, 0xe3, 0x58, 0x90,
	0xde, 0x53, 0xa4, 0x33, 0x9e, 0x0e, 0x2a, 0x8c, 0x34, 0x55, 0xa1, 0x80, 0x2d, 0x50, 0xf0, 0x31,
	0x75, 0x3f, 0xa5, 0xc9, 0x85, 0x06, 0x9f, 0x97, 0xe0, 0xd5, 0x6f, 0x05, 0x1f, 0xa4, 0x76, 0xfe,
	0xe8, 0xe0, 0xc3, 0x0f, 0x68, 0x72, 0x21, 0x21, 0xae, 0x52, 0x7b, 0x5d, 0x91, 0x4d, 0x03, 0x39,
	0x28, 0xef, 0x63, 0x3a, 0x32, 0x83, 0x1f, 0x03, 0x6b, 0x64, 0xc0, 0x3a, 0xed, 0x36, 0x4d, 0x78,
	0x79, 0x41, 0x7c, 0x74, 0xd5, 0x9f, 0x0c, 0x52, 0xbb, 0xa0, 0x21, 0xeb, 0x6a, 0xe6, 0x2a, 0xb5,
	0xef, 0xcf, 0x80, 0x6a, 0x1f, 0x07, 0x15, 0x34, 0xac, 0x36, 0x15, 0xdb, 0x06, 0x09, 0xda, 0x3b,
	0x7b, 0x4f, 0x74, 0x02, 0x86, 0x4c, 0xe0, 0x57, 0xb7, 0x25, 0x90, 0xab, 0x1d, 0x9f, 0xed, 0xec,
	0x3d, 0x19, 0xc6, 0xaf, 0xf7, 0x8e, 0x49, 0x14, 0x07, 0xe5, 0x94, 0xa8, 0x82, 0x3f, 0x06, 0x5a,
	0x74, 0x5b, 0x98, 0xb5, 0xe4, 0xce, 0x94, 0xad, 0x3e, 0x12, 0x0d, 0xa4, 0x90, 0x7e, 0x8b, 0x59,
	0x6b, 0x5c, 0xf5, 0x46, 0xff, 0xcf, 0x38, 0xe6, 0x41, 0x27, 0x1a, 0x62, 0x01, 0xe5, 0x2c, 0xac,
	0x46, 0xe1, 0xee, 0xe9, 0x70, 0x97, 0xee, 0x1a, 0xee, 0xde, 0x4d, 0xe1, 0xee, 0x4d, 0x87, 0xab,
	0x6c, 0x46, 0x1c, 0xfb, 0x9a, 0x63, 0xf9, 0xae, 0x1c, 0xfb, 0x37, 0x71, 0xec, 0x4f, 0x73, 0x28,
	0x1b, 0xd1, 0x97, 0x33, 0x79, 0x96, 0xcd, 0x3b, 0xf7, 0xe5, 0xb5, 0x0a, 0x15, 0x46, 0x1a, 0x85,
	0x7e, 0x01, 0x4a, 0x1e, 0x8d, 0x19, 0x17, 0xba, 0x98, 0xb6, 0x43, 0xa2, 0x29, 0xb2, 0x92, 0x62,
	0xff, 0x36, 0x8a, 0x87, 0xfa, 0x24, 0xb8, 0xc1, 0xdd, 0x41, 0x6b, 0xd3, 0x6a, 0x45, 0xe6, 0x02,
	0xab, 0x4d, 0x38, 0x49, 0x58, 0xa3, 0x93, 0x34, 0x35, 0x11, 0x90, 0x44, 0xef, 0xdd, 0x46, 0xa4,
	0x3b, 0x74, 0xd6, 0xd5, 0x41, 0xc5, 0xb1, 0x4a, 0x11, 0x7c, 0x02, 0x0a, 0x81, 0x60, 0x6d, 0x74,
	0x42, 0x0d, 0x9f, 0x93, 0xf0, 0xbb, 0xb7, 0xc1, 0xeb, 0xaf, 0x6a, 0xda, 0xd1, 0x41, 0x2b, 0x43,
	0x85, 0x82, 0xf6, 0x01, 0x8c, 0x3a, 0x41, 0xe2, 0x36, 0x43, 0xec, 0x05, 0x24, 0xd1, 0xf0, 0x79,
	0x09, 0xff, 0xd3, 0xdb, 0xe0, 0x1f, 0x28, 0xf8, 0xeb, 0xce, 0x0e, 0xb2, 0x84, 0xf2, 0x37, 0x4a,
	0xa7, 0x58, 0xea, 0x20, 0xdf, 0x20, 0x49, 0x18, 0xc4, 0x1a, 0x7f, 0x45, 0xe2, 0x3f, 0xb9, 0x0d,
	0x5f, 0x77, 0xd0, 0xa4, 0x9b, 0x83, 0x72, 0x4a, 0x1c, 0x81, 0x86, 0x34, 0xf6, 0xe9, 0x10, 0x74,
	0xf5, 0xce, 0xa0, 0x93, 0x6e, 0x0e, 0xca, 0x29, 0x51, 0x81, 0x36, 0xc1, 0x1a, 0x4e, 0x12, 0xfa,
	0x72, 0xa6, 0x20, 0x50, 0x62, 0xff, 0xec, 0x36, 0xec, 0xe1, 0x3e, 0x7d, 0xdd, 0x5b, 0xec, 0xd3,
	0x42, 0x3b, 0x55, 0x12, 0x1f, 0xc0, 0x66, 0x82, 0xfb, 0x33, 0x3c, 0xa5, 0x3b, 0x17, 0xfe, 0xba,
	0xb3, 0x83, 0x2c, 0xa1, 0x9c, 0x62, 0xf9, 0x0c, 0x94, 0x22, 0x92, 0x34, 0x89, 0x1b, 0x13, 0xce,
	0xda, 0x61, 0xc0, 0x35, 0xcf, 0xfa, 0x9d, 0xbf, 0x83, 0x9b, 0xdc, 0x1d, 0x04, 0xa5, 0xfa, 0x85,
	0xd6, 0x8e, 0xba, 0x94, 0xb5, 0x70, 0xdc, 0x6c, 0xe1, 0x40, 0xb3, 0xdc, 0xbb, 0x73, 0x97, 0x4e,
	0x3b, 0x3a, 0x68, 0x65, 0xa8, 0x18, 0x2d, 0xb5, 0x87, 0x63, 0xaf, 0x33, 0x5c, 0xea, 0xfb, 0x77,
	0x5e, 0xea, 0x49, 0x37, 0x07, 0xe5, 0x94, 0x28, 0x41, 0x4f, 0x0c, 0xb3, 0x60, 0x15, 0x4f, 0x0c,
	0xb3, 0x68, 0x59, 0x27, 0x86, 0x69, 0x59, 0xab, 0x27, 0x86, 0xb9, 0x66, 0x95, 0xd0, 0x4a, 0x9f,
	0x86, 0xd4, 0xed, 0x3e, 0x55, 0x4e, 0x28, 0x47, 0x5e, 0x62, 0xa6, 0x37, 0x1a, 0x54, 0xf0, 0x30,
	0xc7, 0x61, 0x9f, 0xe9, 0x42, 0x20, 0x4b, 0x95, 0x67, 0xe2, 0xd8, 0xda, 0x06, 0x8b, 0xe2, 0xce,
	0x44, 0xa0, 0x05, 0x16, 0x2e, 0x48, 0x5f, 0x1d, 0xb6, 0x48, 0x0c, 0x61, 0x09, 0x2c, 0x76, 0x71,
	0xd8, 0x21, 0xea, 0x8c, 0x44, 0x4a, 0x70, 0xce, 0x40, 0xf1, 0x3c, 0xc1, 0x31, 0x13, 0xf7, 0x2d,
	0x1a, 0x9f, 0xd2, 0x26, 0x83, 0x10, 0x18, 0xf2, 0x9c, 0x50, 0xbe, 0x72, 0x0c, 0x7f, 0x0c, 0x8c,
	0x90, 0x36, 0x99, 0xbc, 0x2d, 0xe4, 0x76, 0xd7, 0xaf, 0x5f, 0x4d, 0x4e, 0x69, 0x13, 0x49, 0x13,
	0xe7, 0x1f, 0xf3, 0x60, 0xe1, 0x94, 0x36, 0x61, 0x19, 0x2c, 0x63, 0xdf, 0x4f, 0x08, 0x63, 0x1a,
	0x69, 0x28, 0xc2, 0x7b, 0x60, 0x89, 0xd3, 0x76, 0xe0, 0x29, 0xb8, 0x2c, 0xd2, 0x92, 0x20, 0xf6,
	0x31, 0xc7, 0xf2, 0x60, 0xcd, 0x23, 0x39, 0x16, 0xd7, 0x57, 0x99, 0x99, 0x1b, 0x77, 0xa2, 0x06,
	0x49, 0xe4, 0xf9, 0x68, 0x54, 0x8b, 0x97, 0xa9, 0x9d, 0x93, 0xfa, 0x17, 0x52, 0x8d, 0x26, 0x05,
	0xf8, 0x2e, 0x58, 0xe6, 0xbd, 0xc9, 0xb3, 0x6e, 0xed, 0x32, 0xb5, 0x8b, 0x7c, 0x9c, 0xa6, 0x38,
	0xca, 0xd0, 0x12, 0xef, 0xc9, 0x23, 0x6d, 0x1b, 0x98, 0xbc, 0xe7, 0x06, 0xb1, 0x4f, 0x7a, 0xf2,
	0x38, 0x33, 0xaa, 0xa5, 0xcb, 0xd4, 0xb6, 0x26, 0xcc, 0x8f, 0xc5, 0x1c, 0x5a, 0xe6, 0x3d, 0x39,
	0x80, 0xef, 0x02, 0xa0, 0x42, 0x92, 0x0c, 0xea, 0x74, 0x5a, 0xb9, 0x4c, 0xed, 0xac, 0xd4, 0x4a,
	0xec, 0xf1, 0x10, 0x3a, 0x60, 0x51, 0x61, 0x9b, 0x12, 0x3b, 0x7f, 0x99, 0xda, 0x66, 0x48, 0x9b,
	0x0a, 0x53, 0x4d, 0x89, 0x52, 0x25, 0x24, 0xa2, 0x5d, 0xe2, 0xcb, 0x23, 0xc2, 0x44, 0x43, 0xd1,
	0x79, 0x3d, 0x0f, 0xcc, 0xf3, 0x1e, 0x22, 0xac, 0x13, 0x72, 0xf8, 0x01, 0xb0, 0xe4, 0x05, 0x0c,
	0x7b, 0xdc, 0x9d, 0x2a, 0x6d, 0xf5, 0xe1, 0x78, 0x43, 0x9f, 0xb5, 0x70, 0x50, 0x71, 0xa8, 0x3a,
	0xd0, 0xf5, 0x2f, 0x81, 0xc5, 0x46, 0x48, 0x69, 0x24, 0x3b, 0x21, 0x8f, 0x94, 0x00, 0x3f, 0x96,
	0x55, 0x93, 0xab, 0xbc, 0x20, 0x2f, 0xb7, 0xdf, 0xbf, 0xbe, 0xca, 0x33, 0xad, 0x52, 0x7d, 0xa8,
	0xdf, 0x2f, 0x05, 0xc5, 0xad, 0xfd, 0xf5, 0xd3, 0x65, 0x89, 0xf7, 0x64, 0x3f, 0x59, 0x60, 0x21,
	0x21, 0x5c, 0xae, 0x5c, 0x1e, 0x89, 0x21, 0xac, 0x00, 0x33, 0x21, 0x5d, 0x92, 0x70, 0xe2, 0xcb,
	0x15, 0x32, 0xd1, 0x48, 0x86, 0x0f, 0x80, 0xd9, 0xc4, 0xcc, 0xed, 0x30, 0xe2, 0xab, 0xe5, 0x40,
	0xcb, 0x4d, 0xcc, 0x3e, 0x62, 0xc4, 0x7f, 0x66, 0x7c, 0xfe, 0x85, 0x3d, 0xe7, 0x60, 0x90, 0xd3,
	0xf7, 0xde, 0x4e, 0x3b, 0x24, 0xb7, 0xb4, 0xd9, 0x2e, 0xc8, 0x33, 0x4e, 0x13, 0xdc, 0x24, 0xee,
	0x05, 0xe9, 0xeb, 0x66, 0x53, 0xad, 0xa3, 0xf5, 0xbf, 0x23, 0x7d, 0x86, 0x26, 0x05, 0x4d, 0xf1,
	0x85, 0x01, 0x72, 0xe7, 0x09, 0xf6, 0x88, 0xbe, 0xc5, 0x8a, 0x86, 0x15, 0x62, 0xa2, 0x29, 0xb4,
	0x24, 0xb8, 0x79, 0x10, 0x11, 0xda, 0xe1, 0xfa, 0xa3, 0x1a, 0x8a, 0xc2, 0x23, 0x21, 0xa4, 0x47,
	0x3c, 0x59, 0x4b, 0x03, 0x69, 0x09, 0xee, 0x81, 0x15, 0x3f, 0x60, 0xb8, 0x11, 0xca, 0xb7, 0x8f,
	0x77, 0xa1, 0xd2, 0xaf, 0x5a, 0x97, 0xa9, 0x9d, 0xd7, 0x13, 0x75, 0xa1, 0x47, 0x53, 0x12, 0x7c,
	0x1f, 0x14, 0xc7, 0x6e, 0x32, 0x5a, 0xf5, 0xe4, 0xab, 0xc2, 0xcb, 0xd4, 0x2e, 0x8c, 0x4c, 0xe5,
	0x0c, 0x9a, 0x91, 0xc5, 0x72, 0xfb, 0xa4, 0xd1, 0x69, 0xca, 0x0e, 0x34, 0x91, 0x12, 0x84, 0x36,
	0x0c, 0xa2, 0x80, 0xcb, 0x8e, 0x5b, 0x44, 0x4a, 0x80, 0xef, 0x83, 0x2c, 0xed, 0x92, 0x24, 0x09,
	0x7c, 0xf9, 0x14, 0xfb, 0xee, 0x27, 0x2c, 0x1a, 0xdb, 0x8b, 0xe4, 0x48, 0x2c, 0x83, 0x8c, 0x48,
	0x44, 0x93, 0xbe, 0xbc, 0x27, 0xe8, 0xe4, 0xd4, 0xc4, 0x73, 0xa9, 0x47, 0x53, 0x12, 0xac, 0x02,
	0xa8, 0xdd, 0x12, 0xc2, 0x3b, 0x49, 0xec, 0xca, 0x4d, 0x20, 0x2f, 0x7d, 0xe5, 0xa7, 0xa8, 0x66,
	0x91, 0x9c, 0x3c, 0xc2, 0x1c, 0xa3, 0x6b, 0x1a, 0xf8, 0x4b, 0x00, 0xd5, 0x9a, 0xb8, 0x9f, 0x31,
	0x3a, 0x7a, 0x83, 0xab, 0x83, 0x5e, 0xf2, 0xab, 0x59, 0x1d, 0xb3, 0xa5, 0xa4, 0x13, 0x46, 0x75,
	0x16, 0x27, 0x86, 0x69, 0x58, 0x8b, 0xea, 0xdd, 0x38, 0xaa, 0x9f, 0xce, 0x02, 0xad, 0x0d, 0xe5,
	0x89, 0xf0, 0x1e, 0xff, 0x3d, 0x03, 0x26, 0x9e, 0x5f, 0xf0, 0xe7, 0xa0, 0x72, 0x70, 0x78, 0x58,
	0xab, 0xd7, 0xdd, 0xf3, 0x4f, 0xce, 0x6a, 0xee, 0x59, 0x0d, 0x3d, 0x3f, 0xae, 0xd7, 0x8f, 0x3f,
	0x7c, 0x71, 0x5a, 0xab, 0xd7, 0xad, 0xb9, 0xca, 0x3b, 0xaf, 0xde, 0x6c, 0x96, 0xc7, 0xf6, 0x67,
	0xa2, 0x9e, 0x8c, 0x05, 0x34, 0x0e, 0x45, 0xa7, 0xbe, 0x07, 0xee, 0x4d, 0x7a, 0xa3, 0x5a, 0xfd,
	0x1c, 0x1d, 0x1f, 0x9e, 0xd7, 0x8e, 0xac, 0x4c, 0xa5, 0xfc, 0xea, 0xcd, 0x66, 0x69, 0xec, 0x89,
	0x08, 0xe3, 0x49, 0x20, 0x1e, 0xf7, 0x70, 0x1f, 0x94, 0x6f, 0xe6, 0xac, 0x1d, 0x59, 0xf3, 0x95,
	0xca, 0xab, 0x37, 0x9b, 0xf7, 0x6e, 0x62, 0x24, 0x7e, 0xc5, 0xf8, 0xfc, 0xaf, 0x1b, 0x73, 0xd5,
	0x5f, 0x7f, 0x35, 0xd8, 0xc8, 0x7c, 0x3d, 0xd8, 0xc8, 0xfc, 0x67, 0xb0, 0x91, 0x79, 0xfd, 0x76,
	0x63, 0xee, 0xeb, 0xb7, 0x1b, 0x73, 0xff, 0x7c, 0xbb, 0x31, 0xf7, 0x87, 0x1f, 0x35, 0x03, 0xde,
	0xea, 0x34, 0xb6, 0x3c, 0x1a, 0x6d, 0xab, 0xa7, 0xb6, 0xfa, 0xed, 0xee, 0x3e, 0xd1, 0x8f, 0x6e,
	0xf1, 0xbc, 0x64, 0x8d, 0x25, 0xf9, 0xbf, 0x97, 0xa7, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x80,
	0xcf, 0xeb, 0x91, 0xd4, 0x11, 0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Params) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ActiveStaticPrecompiles) > 0 {
		for iNdEx := len(m.ActiveStaticPrecompiles) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ActiveStaticPrecompiles[iNdEx])
			copy(dAtA[i:], m.ActiveStaticPrecompiles[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.ActiveStaticPrecompiles[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	{
		size, err := m.AccessControl.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvm(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x4a
	if len(m.EVMChannels) > 0 {
		for iNdEx := len(m.EVMChannels) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EVMChannels[iNdEx])
			copy(dAtA[i:], m.EVMChannels[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.EVMChannels[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.AllowUnprotectedTxs {
		i--
		if m.AllowUnprotectedTxs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	{
		size, err := m.ChainConfig.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvm(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if len(m.ExtraEIPs) > 0 {
		for iNdEx := len(m.ExtraEIPs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExtraEIPs[iNdEx])
			copy(dAtA[i:], m.ExtraEIPs[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.ExtraEIPs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.EvmDenom) > 0 {
		i -= len(m.EvmDenom)
		copy(dAtA[i:], m.EvmDenom)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.EvmDenom)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccessControl) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessControl) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccessControl) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Call.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvm(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Create.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvm(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *AccessControlType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessControlType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccessControlType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AccessControlList) > 0 {
		for iNdEx := len(m.AccessControlList) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AccessControlList[iNdEx])
			copy(dAtA[i:], m.AccessControlList[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.AccessControlList[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.AccessType != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.AccessType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ChainConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChainConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ChainConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CancunBlock != nil {
		{
			size := m.CancunBlock.Size()
			i -= size
			if _, err := m.CancunBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if m.ShanghaiBlock != nil {
		{
			size := m.ShanghaiBlock.Size()
			i -= size
			if _, err := m.ShanghaiBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.MergeNetsplitBlock != nil {
		{
			size := m.MergeNetsplitBlock.Size()
			i -= size
			if _, err := m.MergeNetsplitBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.GrayGlacierBlock != nil {
		{
			size := m.GrayGlacierBlock.Size()
			i -= size
			if _, err := m.GrayGlacierBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.ArrowGlacierBlock != nil {
		{
			size := m.ArrowGlacierBlock.Size()
			i -= size
			if _, err := m.ArrowGlacierBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.LondonBlock != nil {
		{
			size := m.LondonBlock.Size()
			i -= size
			if _, err := m.LondonBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.BerlinBlock != nil {
		{
			size := m.BerlinBlock.Size()
			i -= size
			if _, err := m.BerlinBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.MuirGlacierBlock != nil {
		{
			size := m.MuirGlacierBlock.Size()
			i -= size
			if _, err := m.MuirGlacierBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.IstanbulBlock != nil {
		{
			size := m.IstanbulBlock.Size()
			i -= size
			if _, err := m.IstanbulBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.PetersburgBlock != nil {
		{
			size := m.PetersburgBlock.Size()
			i -= size
			if _, err := m.PetersburgBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.ConstantinopleBlock != nil {
		{
			size := m.ConstantinopleBlock.Size()
			i -= size
			if _, err := m.ConstantinopleBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.ByzantiumBlock != nil {
		{
			size := m.ByzantiumBlock.Size()
			i -= size
			if _, err := m.ByzantiumBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.EIP158Block != nil {
		{
			size := m.EIP158Block.Size()
			i -= size
			if _, err := m.EIP158Block.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.EIP155Block != nil {
		{
			size := m.EIP155Block.Size()
			i -= size
			if _, err := m.EIP155Block.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.EIP150Hash) > 0 {
		i -= len(m.EIP150Hash)
		copy(dAtA[i:], m.EIP150Hash)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.EIP150Hash)))
		i--
		dAtA[i] = 0x2a
	}
	if m.EIP150Block != nil {
		{
			size := m.EIP150Block.Size()
			i -= size
			if _, err := m.EIP150Block.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.DAOForkSupport {
		i--
		if m.DAOForkSupport {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.DAOForkBlock != nil {
		{
			size := m.DAOForkBlock.Size()
			i -= size
			if _, err := m.DAOForkBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.HomesteadBlock != nil {
		{
			size := m.HomesteadBlock.Size()
			i -= size
			if _, err := m.HomesteadBlock.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *State) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *State) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *State) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TransactionLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TransactionLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Logs) > 0 {
		for iNdEx := len(m.Logs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Logs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvm(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Log) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Log) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Log) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Removed {
		i--
		if m.Removed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Index != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x40
	}
	if len(m.BlockHash) > 0 {
		i -= len(m.BlockHash)
		copy(dAtA[i:], m.BlockHash)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.BlockHash)))
		i--
		dAtA[i] = 0x3a
	}
	if m.TxIndex != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.TxIndex))
		i--
		dAtA[i] = 0x30
	}
	if len(m.TxHash) > 0 {
		i -= len(m.TxHash)
		copy(dAtA[i:], m.TxHash)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.TxHash)))
		i--
		dAtA[i] = 0x2a
	}
	if m.BlockNumber != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.BlockNumber))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Topics) > 0 {
		for iNdEx := len(m.Topics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Topics[iNdEx])
			copy(dAtA[i:], m.Topics[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.Topics[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TxResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.GasUsed != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x30
	}
	if m.Reverted {
		i--
		if m.Reverted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Ret) > 0 {
		i -= len(m.Ret)
		copy(dAtA[i:], m.Ret)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Ret)))
		i--
		dAtA[i] = 0x22
	}
	{
		size, err := m.TxLogs.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvm(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if len(m.Bloom) > 0 {
		i -= len(m.Bloom)
		copy(dAtA[i:], m.Bloom)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Bloom)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContractAddress) > 0 {
		i -= len(m.ContractAddress)
		copy(dAtA[i:], m.ContractAddress)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.ContractAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AccessTuple) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessTuple) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AccessTuple) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.StorageKeys) > 0 {
		for iNdEx := len(m.StorageKeys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.StorageKeys[iNdEx])
			copy(dAtA[i:], m.StorageKeys[iNdEx])
			i = encodeVarintEvm(dAtA, i, uint64(len(m.StorageKeys[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TraceConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TraceConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TraceConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TracerJsonConfig) > 0 {
		i -= len(m.TracerJsonConfig)
		copy(dAtA[i:], m.TracerJsonConfig)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.TracerJsonConfig)))
		i--
		dAtA[i] = 0x6a
	}
	if m.EnableReturnData {
		i--
		if m.EnableReturnData {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.EnableMemory {
		i--
		if m.EnableMemory {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.Overrides != nil {
		{
			size, err := m.Overrides.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvm(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Limit != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x48
	}
	if m.Debug {
		i--
		if m.Debug {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.DisableStorage {
		i--
		if m.DisableStorage {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.DisableStack {
		i--
		if m.DisableStack {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Reexec != 0 {
		i = encodeVarintEvm(dAtA, i, uint64(m.Reexec))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Timeout) > 0 {
		i -= len(m.Timeout)
		copy(dAtA[i:], m.Timeout)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Timeout)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tracer) > 0 {
		i -= len(m.Tracer)
		copy(dAtA[i:], m.Tracer)
		i = encodeVarintEvm(dAtA, i, uint64(len(m.Tracer)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintEvm(dAtA []byte, offset int, v uint64) int {
	offset -= sovEvm(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EvmDenom)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if len(m.ExtraEIPs) > 0 {
		for _, s := range m.ExtraEIPs {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	l = m.ChainConfig.Size()
	n += 1 + l + sovEvm(uint64(l))
	if m.AllowUnprotectedTxs {
		n += 2
	}
	if len(m.EVMChannels) > 0 {
		for _, s := range m.EVMChannels {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	l = m.AccessControl.Size()
	n += 1 + l + sovEvm(uint64(l))
	if len(m.ActiveStaticPrecompiles) > 0 {
		for _, s := range m.ActiveStaticPrecompiles {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	return n
}

func (m *AccessControl) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Create.Size()
	n += 1 + l + sovEvm(uint64(l))
	l = m.Call.Size()
	n += 1 + l + sovEvm(uint64(l))
	return n
}

func (m *AccessControlType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AccessType != 0 {
		n += 1 + sovEvm(uint64(m.AccessType))
	}
	if len(m.AccessControlList) > 0 {
		for _, s := range m.AccessControlList {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	return n
}

func (m *ChainConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HomesteadBlock != nil {
		l = m.HomesteadBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.DAOForkBlock != nil {
		l = m.DAOForkBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.DAOForkSupport {
		n += 2
	}
	if m.EIP150Block != nil {
		l = m.EIP150Block.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	l = len(m.EIP150Hash)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.EIP155Block != nil {
		l = m.EIP155Block.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.EIP158Block != nil {
		l = m.EIP158Block.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.ByzantiumBlock != nil {
		l = m.ByzantiumBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.ConstantinopleBlock != nil {
		l = m.ConstantinopleBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.PetersburgBlock != nil {
		l = m.PetersburgBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.IstanbulBlock != nil {
		l = m.IstanbulBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.MuirGlacierBlock != nil {
		l = m.MuirGlacierBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.BerlinBlock != nil {
		l = m.BerlinBlock.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.LondonBlock != nil {
		l = m.LondonBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	if m.ArrowGlacierBlock != nil {
		l = m.ArrowGlacierBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	if m.GrayGlacierBlock != nil {
		l = m.GrayGlacierBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	if m.MergeNetsplitBlock != nil {
		l = m.MergeNetsplitBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	if m.ShanghaiBlock != nil {
		l = m.ShanghaiBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	if m.CancunBlock != nil {
		l = m.CancunBlock.Size()
		n += 2 + l + sovEvm(uint64(l))
	}
	return n
}

func (m *State) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	return n
}

func (m *TransactionLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	return n
}

func (m *Log) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if len(m.Topics) > 0 {
		for _, s := range m.Topics {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.BlockNumber != 0 {
		n += 1 + sovEvm(uint64(m.BlockNumber))
	}
	l = len(m.TxHash)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.TxIndex != 0 {
		n += 1 + sovEvm(uint64(m.TxIndex))
	}
	l = len(m.BlockHash)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.Index != 0 {
		n += 1 + sovEvm(uint64(m.Index))
	}
	if m.Removed {
		n += 2
	}
	return n
}

func (m *TxResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContractAddress)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	l = len(m.Bloom)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	l = m.TxLogs.Size()
	n += 1 + l + sovEvm(uint64(l))
	l = len(m.Ret)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.Reverted {
		n += 2
	}
	if m.GasUsed != 0 {
		n += 1 + sovEvm(uint64(m.GasUsed))
	}
	return n
}

func (m *AccessTuple) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if len(m.StorageKeys) > 0 {
		for _, s := range m.StorageKeys {
			l = len(s)
			n += 1 + l + sovEvm(uint64(l))
		}
	}
	return n
}

func (m *TraceConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Tracer)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	l = len(m.Timeout)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.Reexec != 0 {
		n += 1 + sovEvm(uint64(m.Reexec))
	}
	if m.DisableStack {
		n += 2
	}
	if m.DisableStorage {
		n += 2
	}
	if m.Debug {
		n += 2
	}
	if m.Limit != 0 {
		n += 1 + sovEvm(uint64(m.Limit))
	}
	if m.Overrides != nil {
		l = m.Overrides.Size()
		n += 1 + l + sovEvm(uint64(l))
	}
	if m.EnableMemory {
		n += 2
	}
	if m.EnableReturnData {
		n += 2
	}
	l = len(m.TracerJsonConfig)
	if l > 0 {
		n += 1 + l + sovEvm(uint64(l))
	}
	return n
}

func sovEvm(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEvm(x uint64) (n int) {
	return sovEvm(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvmDenom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EvmDenom = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraEIPs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtraEIPs = append(m.ExtraEIPs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChainConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChainConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowUnprotectedTxs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowUnprotectedTxs = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EVMChannels", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EVMChannels = append(m.EVMChannels, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessControl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AccessControl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveStaticPrecompiles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveStaticPrecompiles = append(m.ActiveStaticPrecompiles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessControl) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessControl: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessControl: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Create", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Create.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Call", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Call.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessControlType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessControlType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessControlType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessType", wireType)
			}
			m.AccessType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AccessType |= AccessType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessControlList", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessControlList = append(m.AccessControlList, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChainConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChainConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChainConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HomesteadBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.HomesteadBlock = &v
			if err := m.HomesteadBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DAOForkBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.DAOForkBlock = &v
			if err := m.DAOForkBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DAOForkSupport", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DAOForkSupport = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EIP150Block", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.EIP150Block = &v
			if err := m.EIP150Block.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EIP150Hash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EIP150Hash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EIP155Block", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.EIP155Block = &v
			if err := m.EIP155Block.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EIP158Block", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.EIP158Block = &v
			if err := m.EIP158Block.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ByzantiumBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.ByzantiumBlock = &v
			if err := m.ByzantiumBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConstantinopleBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.ConstantinopleBlock = &v
			if err := m.ConstantinopleBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PetersburgBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.PetersburgBlock = &v
			if err := m.PetersburgBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IstanbulBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.IstanbulBlock = &v
			if err := m.IstanbulBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MuirGlacierBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.MuirGlacierBlock = &v
			if err := m.MuirGlacierBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BerlinBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.BerlinBlock = &v
			if err := m.BerlinBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LondonBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.LondonBlock = &v
			if err := m.LondonBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArrowGlacierBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.ArrowGlacierBlock = &v
			if err := m.ArrowGlacierBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrayGlacierBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.GrayGlacierBlock = &v
			if err := m.GrayGlacierBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeNetsplitBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.MergeNetsplitBlock = &v
			if err := m.MergeNetsplitBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShanghaiBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.ShanghaiBlock = &v
			if err := m.ShanghaiBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancunBlock", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v cosmossdk_io_math.Int
			m.CancunBlock = &v
			if err := m.CancunBlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *State) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: State: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: State: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, &Log{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Log) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Log: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Log: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topics = append(m.Topics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockNumber", wireType)
			}
			m.BlockNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockNumber |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxHash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxIndex", wireType)
			}
			m.TxIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BlockHash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Removed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Removed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContractAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContractAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bloom", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bloom = append(m.Bloom[:0], dAtA[iNdEx:postIndex]...)
			if m.Bloom == nil {
				m.Bloom = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxLogs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ret", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ret = append(m.Ret[:0], dAtA[iNdEx:postIndex]...)
			if m.Ret == nil {
				m.Ret = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverted = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessTuple) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessTuple: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessTuple: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageKeys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageKeys = append(m.StorageKeys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TraceConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TraceConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TraceConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tracer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timeout = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reexec", wireType)
			}
			m.Reexec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reexec |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableStack", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableStack = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableStorage", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisableStorage = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Debug", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Debug = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Overrides", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Overrides == nil {
				m.Overrides = &ChainConfig{}
			}
			if err := m.Overrides.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableMemory", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableMemory = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableReturnData", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableReturnData = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TracerJsonConfig", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvm
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvm
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TracerJsonConfig = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvm(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvm
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEvm(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEvm
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvm
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEvm
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEvm
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEvm
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEvm        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEvm          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEvm = fmt.Errorf("proto: unexpected end of group")
)
