package upgrade_test

import (
	"testing"

	"github.com/evmos/evmos/v20/tests/e2e/upgrade"
	"github.com/stretchr/testify/require"
)

const (
	blockOutputPreV50  = "{\"block_id\":{\"hash\":\"ECECD69FAF6D6B0722042615CA6B63C3520CE207A03B70A35BC549ECB4101798\",\"parts\":{\"total\":1,\"hash\":\"C433720E863ADA05E015DF78590F13C467FCE3D13B6F8FAD0B4BE94F98093457\"}},\"block\":{\"header\":{\"version\":{\"block\":\"11\"},\"chain_id\":\"evmos_9000-1\",\"height\":\"40\",\"time\":\"2024-08-29T20:59:03.029214545Z\",\"last_block_id\":{\"hash\":\"F5E28BDAAFB6E3769FE15E29256D2D2F265E150D73F6ADC84F76C64A5B668F5C\",\"parts\":{\"total\":1,\"hash\":\"EC6D871E67B5662FB96A696B9E74EA8436B74A5EE1B4F8FDE4007713101CAEB8\"}},\"last_commit_hash\":\"BBE9C89F763E696B189F11C2870893F966FEF5B46085C13D4551FE8F914246E1\",\"data_hash\":\"E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855\",\"validators_hash\":\"3E57E93AFF0EFFA13F92F3F363C4FBB8090D812072035D4D81DA91A1C289562A\",\"next_validators_hash\":\"3E57E93AFF0EFFA13F92F3F363C4FBB8090D812072035D4D81DA91A1C289562A\",\"consensus_hash\":\"7D0B88F8835DB6E92EC4E959CCD9324052C68794BC42567CFA45FB176ED6679A\",\"app_hash\":\"18ADDA9AD92E7C62915702E2A272891FA4EAE006BDD7B117CC2A4A05A262C9B6\",\"last_results_hash\":\"E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855\",\"evidence_hash\":\"E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855\",\"proposer_address\":\"2E33F057457BD6B1374B6776A5A2315CD177E8C8\"},\"data\":{\"txs\":null},\"evidence\":{\"evidence\":null},\"last_commit\":{\"height\":\"39\",\"round\":0,\"block_id\":{\"hash\":\"F5E28BDAAFB6E3769FE15E29256D2D2F265E150D73F6ADC84F76C64A5B668F5C\",\"parts\":{\"total\":1,\"hash\":\"EC6D871E67B5662FB96A696B9E74EA8436B74A5EE1B4F8FDE4007713101CAEB8\"}},\"signatures\":[{\"block_id_flag\":2,\"validator_address\":\"2E33F057457BD6B1374B6776A5A2315CD177E8C8\",\"timestamp\":\"2024-08-29T20:59:03.029214545Z\",\"signature\":\"vcK+Ew9OT/fTGKhxVH/ehKE/7dJ82BSHXNZb/B/saVB+0UhC1qFN/rBQ+FuihNN5J95IG2YdOe+2Fppg7RN1CA==\"}]}}}"
	blockOutputPostV50 = "{\"header\":{\"version\":{\"block\":\"11\",\"app\":\"0\"},\"chain_id\":\"evmos_9001-2\",\"height\":\"23136576\",\"time\":\"2024-08-29T21:07:47.173219060Z\",\"last_block_id\":{\"hash\":\"MFoG3Nc8BrfGLBWUtSm3XU/dJG45WZW8MxIo5IAlyho=\",\"part_set_header\":{\"total\":1,\"hash\":\"WlEMTfEcyTyNHzn9FTUZpTWEaOLGOIAYmN0H7gT7Hpk=\"}},\"last_commit_hash\":\"rs55UXNU/Ff/iIdnvf7Uu+OOh+N5nYmI1+jTpY92904=\",\"data_hash\":\"47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=\",\"validators_hash\":\"VFhmtCGzqKtwoK5lewntJwZdn6W7MR0u3tnWTVuWw9g=\",\"next_validators_hash\":\"VFhmtCGzqKtwoK5lewntJwZdn6W7MR0u3tnWTVuWw9g=\",\"consensus_hash\":\"ek5k0qm1ziK3XpVuICUnTcA7aEbM13JRUqa8DQcn4z4=\",\"app_hash\":\"KNmdEQk59wmj0JUCsmpRcXMhVN6Ru3PRpOWj2hykRjg=\",\"last_results_hash\":\"47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=\",\"evidence_hash\":\"47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=\",\"proposer_address\":\"INsp0gYoMX+pxKxyiKFV87qe3zo=\"},\"data\":{\"txs\":[]},\"evidence\":{\"evidence\":[]},\"last_commit\":{\"height\":\"23136575\",\"round\":0,\"block_id\":{\"hash\":\"MFoG3Nc8BrfGLBWUtSm3XU/dJG45WZW8MxIo5IAlyho=\",\"part_set_header\":{\"total\":1,\"hash\":\"WlEMTfEcyTyNHzn9FTUZpTWEaOLGOIAYmN0H7gT7Hpk=\"}},\"signatures\":[{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"INsp0gYoMX+pxKxyiKFV87qe3zo=\",\"timestamp\":\"2024-08-29T21:07:47.151689399Z\",\"signature\":\"zTYJQPONiX0fcJMTVJT42XOmxkJC1ycirXQtJ/sQRItJ6ARe5RxdErQiNfbDqh3JApKfshoRMu59RWkUUTI/AA==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"PNbD6+ovTnEkQQAxn4zzqbU0MyI=\",\"timestamp\":\"2024-08-29T21:07:47.190517293Z\",\"signature\":\"okzGvzYOTYRiCXc1YT4an6Oz7EetSwM4Pyj5vqYvJY1BpymD2MfeLp+u+vd0AeIsnimmngyMM35LWfmhOh3VCA==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"gVWhxuhAuZBkUGGIIaRtl972nr4=\",\"timestamp\":\"2024-08-29T21:10:55.258272572Z\",\"signature\":\"gJ5TuPbRt+XwBcBQblcKjmBjIV80XU/SGGhCIMO+0A79XRij9XgIJ+w069ttbkN4KelhWaVcuEIlvOP086mhCg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"q3gXyrWm5QD0ytQqUiye/bo1naE=\",\"timestamp\":\"2024-08-29T21:07:47.175072852Z\",\"signature\":\"g4tvzy/E6x0s3yIZ3yWktDLycLino3Oj6DDDTnXVyxtnV4iMBtowKbCX0vNc1eiUc684POURtbjtjxP9qWQ/Aw==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"ZyqajL8AeAA5TKmUIvhN+/bLpV4=\",\"timestamp\":\"2024-08-29T21:07:47.176287728Z\",\"signature\":\"EhGb0eIyNeBNWqa24ouhw2MpZTvBXYGk76ipZ+PHzMv8+4zoZ4J+jtTFEDM10Mj6g4/EZfSpdsG6P4bAQihHAw==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"8vf1/A5QX+0NszBqZp2oiOZplZw=\",\"timestamp\":\"2024-08-29T21:07:47.171566330Z\",\"signature\":\"Wm4zmzNVQsrnpTxonEiUpv/I4wnFA6CQSqd5u9T1Gb0jl+5hufmziMnDmxC4R00CTEysXFuTXKz4Pp6Qg90UBg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"tsPbkG+u8sh1jRiBOG5hXoQyqRw=\",\"timestamp\":\"2024-08-29T21:07:47.160570450Z\",\"signature\":\"LKhUrTphNk1ZWcqsaMvH/NgBy9kWnqql9zs/M8CR8rCcCHi4llZnnqw++0rkCIi0a2bRXtiYmiUEF3e49lgXBg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"fLQ4DAeE+5p51msU7OucyRAplb8=\",\"timestamp\":\"2024-08-29T21:07:47.189346366Z\",\"signature\":\"jeAFqiq4VUI79rMNkd9NzLrXSyH/Ssra5UK9OmMIyv+9/y4Jx5hWQoTwPutLfseDEdAHnwM9hKc+4rUMRe34CA==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"u5kxpaHBNO8ZZVxHyipibsqAwHE=\",\"timestamp\":\"2024-08-29T21:07:47.178648344Z\",\"signature\":\"68xYCrTjK/SYPn7Fh5QyvjgwvqbOYNvMzUpjCnXpOkPv94z80T4qUrjIh9JHUSXlv25qg6EBmXoi5tJhmGAPBw==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"2gFXnp7Wxh0MboY5hiLSveXcp8M=\",\"timestamp\":\"2024-08-29T21:07:47.152986647Z\",\"signature\":\"MNzh3Ji59ZuANClXJTNl2fRbIQrdctaJDO5ez0UIcsMsGPF5c8HWMKzE4xLM4W9FN7UbZno2e/XDpN2HZk9bAg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"dmkhFfk65ET6hXx7qWPxJdjC5sY=\",\"timestamp\":\"2024-08-29T21:07:47.165135535Z\",\"signature\":\"V6/DVfD7Ag5oMhsbPw9HfzpNdOv0ojVrVF64M31Blzpsj9yr3CN3AX6dHEV8VLS6oTSNqRe7m3lNlMzlw8vOBg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"sx94eM3xHLKEE8z5/yxT6GnztlI=\",\"timestamp\":\"2024-08-29T21:07:47.174593472Z\",\"signature\":\"/ELSkgB7Lrr564/e3X8Ijzc5TSCbq5GwRSY7so2003LBvz93Ah0xvcuwtIxIc1cM55brj3iyBmhAyyQGbJJqDQ==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"h+74vYVpLWjBYypK789kLmK010E=\",\"timestamp\":\"2024-08-29T21:07:47.160196561Z\",\"signature\":\"L/abFJLDQbLibh71fu2SLe9l5WJVsP7bsbWMAiyVeSR57hZ+yCUEYbABCgo2ZsiruPp+1ZVlKGf+q1uZjaRkDg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"fQ8XJW1rIsBOfscAODT1vIo68UQ=\",\"timestamp\":\"2024-08-29T21:07:47.171499902Z\",\"signature\":\"mogIBHuTm/ytCm//lOnXihm6R7eRFkZrijwWkgVfndRZIZreGQyiFqJei8jcV06nAczIPBe3meD3mtC5sXALBg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"v1/AbjKkFogXoW1paS82yPel2jc=\",\"timestamp\":\"2024-08-29T21:07:47.186492788Z\",\"signature\":\"KJRJuaC1r83O1aCd5pcwZMVSJgBgrt/1z571DkafSYl9E+5WiCcFFUx7F+TJVouXTeOd7leg6eRjdBLvLFlZAQ==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"ktHF8RsGVqD7MJxOx6OtaodeFSs=\",\"timestamp\":\"2024-08-29T21:07:47.164166723Z\",\"signature\":\"XE4IMVZV49CUHGTOI7hpq+DZ6cL6plKv/wq8epzeWnF31DX5mBARWdbWWNjB3ftlZqW244ZMBLK4P0xvv+zzCA==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"4qSeAH8p6atOaURmwC0U7u4S380=\",\"timestamp\":\"2024-08-29T21:07:47.161100379Z\",\"signature\":\"EvvZjNw3fwRAS3ECXuXlCS50hbJKSo9k65MvrbYFwC269ABemdygf0cE8SrF5HfRjAuncywzgqjyrA76QjLNDg==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"B30FDOAwzvoOmN1/DxCyWb6wj28=\",\"timestamp\":\"2024-08-29T21:07:47.154195098Z\",\"signature\":\"Gr0cbNlzG89mV05D+GzP51P2eWdmm4oeaTvyt/n5PzhxDME9KlbZWTPXiu6eQWMrCN7qbqh68/HOHBOvHNc2Aw==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"U7HWxxiQjw09k87HbDM45mZhjTg=\",\"timestamp\":\"2024-08-29T21:07:47.172476499Z\",\"signature\":\"5mwEzHtQyObVJ30zHUayW8a7OiU4lAcSZ/lb0reUP42ZBlIQxqf1OukrmcTUNrZhnzlCE66ujPfwkU+frxyCDQ==\"},{\"block_id_flag\":\"BLOCK_ID_FLAG_COMMIT\",\"validator_address\":\"Xx/1I0Iypa8OrdL2vGqIi90wWn0=\",\"timestamp\":\"2024-08-29T21:07:47.173219060Z\",\"signature\":\"2pPS9qOys5cchdWB4BfT9aFqedXPvMPPSZ1nXYbatMNBNLM3x2rgq78ZiRIm+98UMrGlw7O5C/j+d9sf0WUZAg==\"}]}}"
)

func TestUnwrapBlockHeight(t *testing.T) {
	blockHeight, err := upgrade.UnwrapBlockHeightPreV50(blockOutputPreV50)
	require.NoError(t, err, "error unwrapping block height")
	require.Equal(t, 40, blockHeight, "block height does not match")
}

func TestUnwrapBlockHeightPostV50(t *testing.T) {
	blockHeight, err := upgrade.UnwrapBlockHeightPostV50(blockOutputPostV50)
	require.NoError(t, err, "error unwrapping block height")
	require.Equal(t, 23136576, blockHeight, "block height does not match")
}
