// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: evmos/inflation/v1/query.proto

package types

import (
	context "context"
	cosmossdk_io_math "cosmossdk.io/math"
	fmt "fmt"
	types "github.com/cosmos/cosmos-sdk/types"
	_ "github.com/cosmos/cosmos-sdk/types/tx/amino"
	_ "github.com/cosmos/gogoproto/gogoproto"
	grpc1 "github.com/cosmos/gogoproto/grpc"
	proto "github.com/cosmos/gogoproto/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// QueryPeriodRequest is the request type for the Query/Period RPC method.
type QueryPeriodRequest struct {
}

func (m *QueryPeriodRequest) Reset()         { *m = QueryPeriodRequest{} }
func (m *QueryPeriodRequest) String() string { return proto.CompactTextString(m) }
func (*QueryPeriodRequest) ProtoMessage()    {}
func (*QueryPeriodRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{0}
}
func (m *QueryPeriodRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryPeriodRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryPeriodRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryPeriodRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryPeriodRequest.Merge(m, src)
}
func (m *QueryPeriodRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryPeriodRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryPeriodRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryPeriodRequest proto.InternalMessageInfo

// QueryPeriodResponse is the response type for the Query/Period RPC method.
type QueryPeriodResponse struct {
	// period is the current minting per epoch provision value.
	Period uint64 `protobuf:"varint,1,opt,name=period,proto3" json:"period,omitempty"`
}

func (m *QueryPeriodResponse) Reset()         { *m = QueryPeriodResponse{} }
func (m *QueryPeriodResponse) String() string { return proto.CompactTextString(m) }
func (*QueryPeriodResponse) ProtoMessage()    {}
func (*QueryPeriodResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{1}
}
func (m *QueryPeriodResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryPeriodResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryPeriodResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryPeriodResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryPeriodResponse.Merge(m, src)
}
func (m *QueryPeriodResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryPeriodResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryPeriodResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryPeriodResponse proto.InternalMessageInfo

func (m *QueryPeriodResponse) GetPeriod() uint64 {
	if m != nil {
		return m.Period
	}
	return 0
}

// QueryEpochMintProvisionRequest is the request type for the
// Query/EpochMintProvision RPC method.
type QueryEpochMintProvisionRequest struct {
}

func (m *QueryEpochMintProvisionRequest) Reset()         { *m = QueryEpochMintProvisionRequest{} }
func (m *QueryEpochMintProvisionRequest) String() string { return proto.CompactTextString(m) }
func (*QueryEpochMintProvisionRequest) ProtoMessage()    {}
func (*QueryEpochMintProvisionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{2}
}
func (m *QueryEpochMintProvisionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryEpochMintProvisionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryEpochMintProvisionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryEpochMintProvisionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryEpochMintProvisionRequest.Merge(m, src)
}
func (m *QueryEpochMintProvisionRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryEpochMintProvisionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryEpochMintProvisionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryEpochMintProvisionRequest proto.InternalMessageInfo

// QueryEpochMintProvisionResponse is the response type for the
// Query/EpochMintProvision RPC method.
type QueryEpochMintProvisionResponse struct {
	// epoch_mint_provision is the current minting per epoch provision value.
	EpochMintProvision types.DecCoin `protobuf:"bytes,1,opt,name=epoch_mint_provision,json=epochMintProvision,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.DecCoins" json:"epoch_mint_provision"`
}

func (m *QueryEpochMintProvisionResponse) Reset()         { *m = QueryEpochMintProvisionResponse{} }
func (m *QueryEpochMintProvisionResponse) String() string { return proto.CompactTextString(m) }
func (*QueryEpochMintProvisionResponse) ProtoMessage()    {}
func (*QueryEpochMintProvisionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{3}
}
func (m *QueryEpochMintProvisionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryEpochMintProvisionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryEpochMintProvisionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryEpochMintProvisionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryEpochMintProvisionResponse.Merge(m, src)
}
func (m *QueryEpochMintProvisionResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryEpochMintProvisionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryEpochMintProvisionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryEpochMintProvisionResponse proto.InternalMessageInfo

func (m *QueryEpochMintProvisionResponse) GetEpochMintProvision() types.DecCoin {
	if m != nil {
		return m.EpochMintProvision
	}
	return types.DecCoin{}
}

// QuerySkippedEpochsRequest is the request type for the Query/SkippedEpochs RPC
// method.
type QuerySkippedEpochsRequest struct {
}

func (m *QuerySkippedEpochsRequest) Reset()         { *m = QuerySkippedEpochsRequest{} }
func (m *QuerySkippedEpochsRequest) String() string { return proto.CompactTextString(m) }
func (*QuerySkippedEpochsRequest) ProtoMessage()    {}
func (*QuerySkippedEpochsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{4}
}
func (m *QuerySkippedEpochsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuerySkippedEpochsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuerySkippedEpochsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuerySkippedEpochsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuerySkippedEpochsRequest.Merge(m, src)
}
func (m *QuerySkippedEpochsRequest) XXX_Size() int {
	return m.Size()
}
func (m *QuerySkippedEpochsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QuerySkippedEpochsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QuerySkippedEpochsRequest proto.InternalMessageInfo

// QuerySkippedEpochsResponse is the response type for the Query/SkippedEpochs
// RPC method.
type QuerySkippedEpochsResponse struct {
	// skipped_epochs is the number of epochs that the inflation module has been disabled.
	SkippedEpochs uint64 `protobuf:"varint,1,opt,name=skipped_epochs,json=skippedEpochs,proto3" json:"skipped_epochs,omitempty"`
}

func (m *QuerySkippedEpochsResponse) Reset()         { *m = QuerySkippedEpochsResponse{} }
func (m *QuerySkippedEpochsResponse) String() string { return proto.CompactTextString(m) }
func (*QuerySkippedEpochsResponse) ProtoMessage()    {}
func (*QuerySkippedEpochsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{5}
}
func (m *QuerySkippedEpochsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuerySkippedEpochsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuerySkippedEpochsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuerySkippedEpochsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuerySkippedEpochsResponse.Merge(m, src)
}
func (m *QuerySkippedEpochsResponse) XXX_Size() int {
	return m.Size()
}
func (m *QuerySkippedEpochsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QuerySkippedEpochsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QuerySkippedEpochsResponse proto.InternalMessageInfo

func (m *QuerySkippedEpochsResponse) GetSkippedEpochs() uint64 {
	if m != nil {
		return m.SkippedEpochs
	}
	return 0
}

// QueryCirculatingSupplyRequest is the request type for the
// Query/CirculatingSupply RPC method.
type QueryCirculatingSupplyRequest struct {
}

func (m *QueryCirculatingSupplyRequest) Reset()         { *m = QueryCirculatingSupplyRequest{} }
func (m *QueryCirculatingSupplyRequest) String() string { return proto.CompactTextString(m) }
func (*QueryCirculatingSupplyRequest) ProtoMessage()    {}
func (*QueryCirculatingSupplyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{6}
}
func (m *QueryCirculatingSupplyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryCirculatingSupplyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryCirculatingSupplyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryCirculatingSupplyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryCirculatingSupplyRequest.Merge(m, src)
}
func (m *QueryCirculatingSupplyRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryCirculatingSupplyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryCirculatingSupplyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryCirculatingSupplyRequest proto.InternalMessageInfo

// QueryCirculatingSupplyResponse is the response type for the
// Query/CirculatingSupply RPC method.
type QueryCirculatingSupplyResponse struct {
	// circulating_supply is the total amount of coins in circulation
	CirculatingSupply types.DecCoin `protobuf:"bytes,1,opt,name=circulating_supply,json=circulatingSupply,proto3,castrepeated=github.com/cosmos/cosmos-sdk/types.DecCoins" json:"circulating_supply"`
}

func (m *QueryCirculatingSupplyResponse) Reset()         { *m = QueryCirculatingSupplyResponse{} }
func (m *QueryCirculatingSupplyResponse) String() string { return proto.CompactTextString(m) }
func (*QueryCirculatingSupplyResponse) ProtoMessage()    {}
func (*QueryCirculatingSupplyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{7}
}
func (m *QueryCirculatingSupplyResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryCirculatingSupplyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryCirculatingSupplyResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryCirculatingSupplyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryCirculatingSupplyResponse.Merge(m, src)
}
func (m *QueryCirculatingSupplyResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryCirculatingSupplyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryCirculatingSupplyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryCirculatingSupplyResponse proto.InternalMessageInfo

func (m *QueryCirculatingSupplyResponse) GetCirculatingSupply() types.DecCoin {
	if m != nil {
		return m.CirculatingSupply
	}
	return types.DecCoin{}
}

// QueryInflationRateRequest is the request type for the Query/InflationRate RPC
// method.
type QueryInflationRateRequest struct {
}

func (m *QueryInflationRateRequest) Reset()         { *m = QueryInflationRateRequest{} }
func (m *QueryInflationRateRequest) String() string { return proto.CompactTextString(m) }
func (*QueryInflationRateRequest) ProtoMessage()    {}
func (*QueryInflationRateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{8}
}
func (m *QueryInflationRateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryInflationRateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryInflationRateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryInflationRateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInflationRateRequest.Merge(m, src)
}
func (m *QueryInflationRateRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryInflationRateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInflationRateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInflationRateRequest proto.InternalMessageInfo

// QueryInflationRateResponse is the response type for the Query/InflationRate
// RPC method.
type QueryInflationRateResponse struct {
	// inflation_rate by which the total supply increases within one period
	InflationRate cosmossdk_io_math.LegacyDec `protobuf:"bytes,1,opt,name=inflation_rate,json=inflationRate,proto3,customtype=cosmossdk.io/math.LegacyDec" json:"inflation_rate"`
}

func (m *QueryInflationRateResponse) Reset()         { *m = QueryInflationRateResponse{} }
func (m *QueryInflationRateResponse) String() string { return proto.CompactTextString(m) }
func (*QueryInflationRateResponse) ProtoMessage()    {}
func (*QueryInflationRateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{9}
}
func (m *QueryInflationRateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryInflationRateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryInflationRateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryInflationRateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInflationRateResponse.Merge(m, src)
}
func (m *QueryInflationRateResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryInflationRateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInflationRateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInflationRateResponse proto.InternalMessageInfo

// QueryParamsRequest is the request type for the Query/Params RPC method.
type QueryParamsRequest struct {
}

func (m *QueryParamsRequest) Reset()         { *m = QueryParamsRequest{} }
func (m *QueryParamsRequest) String() string { return proto.CompactTextString(m) }
func (*QueryParamsRequest) ProtoMessage()    {}
func (*QueryParamsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{10}
}
func (m *QueryParamsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryParamsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryParamsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryParamsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParamsRequest.Merge(m, src)
}
func (m *QueryParamsRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryParamsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParamsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParamsRequest proto.InternalMessageInfo

// QueryParamsResponse is the response type for the Query/Params RPC method.
type QueryParamsResponse struct {
	// params defines the parameters of the module.
	Params Params `protobuf:"bytes,1,opt,name=params,proto3" json:"params"`
}

func (m *QueryParamsResponse) Reset()         { *m = QueryParamsResponse{} }
func (m *QueryParamsResponse) String() string { return proto.CompactTextString(m) }
func (*QueryParamsResponse) ProtoMessage()    {}
func (*QueryParamsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b9f1b5d47c7fd7, []int{11}
}
func (m *QueryParamsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryParamsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryParamsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryParamsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParamsResponse.Merge(m, src)
}
func (m *QueryParamsResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryParamsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParamsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParamsResponse proto.InternalMessageInfo

func (m *QueryParamsResponse) GetParams() Params {
	if m != nil {
		return m.Params
	}
	return Params{}
}

func init() {
	proto.RegisterType((*QueryPeriodRequest)(nil), "evmos.inflation.v1.QueryPeriodRequest")
	proto.RegisterType((*QueryPeriodResponse)(nil), "evmos.inflation.v1.QueryPeriodResponse")
	proto.RegisterType((*QueryEpochMintProvisionRequest)(nil), "evmos.inflation.v1.QueryEpochMintProvisionRequest")
	proto.RegisterType((*QueryEpochMintProvisionResponse)(nil), "evmos.inflation.v1.QueryEpochMintProvisionResponse")
	proto.RegisterType((*QuerySkippedEpochsRequest)(nil), "evmos.inflation.v1.QuerySkippedEpochsRequest")
	proto.RegisterType((*QuerySkippedEpochsResponse)(nil), "evmos.inflation.v1.QuerySkippedEpochsResponse")
	proto.RegisterType((*QueryCirculatingSupplyRequest)(nil), "evmos.inflation.v1.QueryCirculatingSupplyRequest")
	proto.RegisterType((*QueryCirculatingSupplyResponse)(nil), "evmos.inflation.v1.QueryCirculatingSupplyResponse")
	proto.RegisterType((*QueryInflationRateRequest)(nil), "evmos.inflation.v1.QueryInflationRateRequest")
	proto.RegisterType((*QueryInflationRateResponse)(nil), "evmos.inflation.v1.QueryInflationRateResponse")
	proto.RegisterType((*QueryParamsRequest)(nil), "evmos.inflation.v1.QueryParamsRequest")
	proto.RegisterType((*QueryParamsResponse)(nil), "evmos.inflation.v1.QueryParamsResponse")
}

func init() { proto.RegisterFile("evmos/inflation/v1/query.proto", fileDescriptor_91b9f1b5d47c7fd7) }

var fileDescriptor_91b9f1b5d47c7fd7 = []byte{
	// 715 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x95, 0x3d, 0x6f, 0xd3, 0x40,
	0x1c, 0xc6, 0x73, 0x08, 0x82, 0x7a, 0xa8, 0x95, 0x7a, 0x54, 0x08, 0xdc, 0xe2, 0x54, 0x16, 0x94,
	0xa8, 0xa8, 0x77, 0x24, 0x5d, 0x60, 0x60, 0x69, 0xcb, 0x50, 0x09, 0x44, 0x49, 0x99, 0x58, 0x22,
	0xc7, 0x39, 0xdc, 0x53, 0xeb, 0x3b, 0xd7, 0xe7, 0x44, 0x64, 0x60, 0x41, 0x42, 0x62, 0x44, 0x62,
	0x63, 0x60, 0xae, 0x2a, 0x24, 0xf8, 0x18, 0x1d, 0x2b, 0xb1, 0x20, 0x86, 0x82, 0x1a, 0x24, 0xbe,
	0x06, 0xf2, 0xdd, 0x39, 0x8d, 0x1b, 0x3b, 0xa5, 0x03, 0x8b, 0xe3, 0xdc, 0xff, 0xed, 0xb9, 0xc7,
	0xf7, 0xb3, 0xa1, 0x4d, 0xbb, 0x81, 0x90, 0x84, 0xf1, 0x97, 0x3b, 0x6e, 0xcc, 0x04, 0x27, 0xdd,
	0x1a, 0xd9, 0xed, 0xd0, 0xa8, 0x87, 0xc3, 0x48, 0xc4, 0x02, 0x21, 0x15, 0xc7, 0x83, 0x38, 0xee,
	0xd6, 0xac, 0x69, 0x37, 0x60, 0x5c, 0x10, 0x75, 0xd5, 0x69, 0x96, 0xed, 0x09, 0x99, 0xf4, 0x69,
	0xb9, 0x92, 0x92, 0x6e, 0xad, 0x45, 0x63, 0xb7, 0x46, 0x3c, 0xc1, 0xb8, 0x89, 0xcf, 0xe7, 0x8c,
	0xf1, 0x29, 0xa7, 0x92, 0x49, 0x93, 0x31, 0xe3, 0x0b, 0x5f, 0xa8, 0x5b, 0x92, 0xdc, 0x99, 0xd5,
	0x39, 0x5f, 0x08, 0x7f, 0x87, 0x12, 0x37, 0x64, 0xc4, 0xe5, 0x5c, 0xc4, 0xaa, 0xda, 0xd4, 0x38,
	0x33, 0x10, 0x3d, 0x4b, 0xb4, 0x6e, 0xd0, 0x88, 0x89, 0x76, 0x83, 0xee, 0x76, 0xa8, 0x8c, 0x9d,
	0x25, 0x78, 0x35, 0xb3, 0x2a, 0x43, 0xc1, 0x25, 0x45, 0xd7, 0x60, 0x39, 0x54, 0x2b, 0xd7, 0xc1,
	0x3c, 0xa8, 0x5e, 0x6c, 0x98, 0x7f, 0xce, 0x3c, 0xb4, 0x55, 0xfa, 0xa3, 0x50, 0x78, 0x5b, 0x4f,
	0x18, 0x8f, 0x37, 0x22, 0xd1, 0x65, 0x92, 0x09, 0x9e, 0x36, 0xfc, 0x0c, 0x60, 0xa5, 0x30, 0xc5,
	0x74, 0x7f, 0x07, 0xe0, 0x0c, 0x4d, 0xc2, 0xcd, 0x80, 0xf1, 0xb8, 0x19, 0xa6, 0x09, 0x6a, 0xd8,
	0x95, 0xfa, 0x1c, 0xd6, 0x06, 0xe1, 0xc4, 0x20, 0x6c, 0x0c, 0xc2, 0x6b, 0xd4, 0x5b, 0x15, 0x8c,
	0xaf, 0xdc, 0x3f, 0x38, 0xaa, 0x94, 0xf6, 0x7f, 0x56, 0xee, 0xfa, 0x2c, 0xde, 0xea, 0xb4, 0xb0,
	0x27, 0x02, 0x62, 0x0c, 0xd5, 0x3f, 0x4b, 0xb2, 0xbd, 0x4d, 0xe2, 0x5e, 0x48, 0x65, 0x5a, 0x23,
	0xf7, 0xfe, 0x7c, 0x5d, 0x04, 0x0d, 0x44, 0x47, 0x24, 0x39, 0xb3, 0xf0, 0x86, 0x52, 0xbb, 0xb9,
	0xcd, 0xc2, 0x90, 0xb6, 0x95, 0x68, 0x99, 0xee, 0x65, 0x15, 0x5a, 0x79, 0x41, 0xb3, 0x8b, 0xdb,
	0x70, 0x4a, 0xea, 0x40, 0x53, 0x35, 0x96, 0xc6, 0xab, 0x49, 0x39, 0x9c, 0xee, 0x54, 0xe0, 0x4d,
	0xd5, 0x64, 0x95, 0x45, 0x5e, 0x27, 0x79, 0xa0, 0xdc, 0xdf, 0xec, 0x84, 0xe1, 0x4e, 0x2f, 0x9d,
	0xb2, 0x07, 0x8c, 0xa9, 0x39, 0x19, 0x66, 0xd4, 0x5b, 0x00, 0x91, 0x77, 0x12, 0x6d, 0x4a, 0x15,
	0xfe, 0xcf, 0x76, 0x4d, 0x7b, 0xa7, 0xf5, 0x0c, 0xdc, 0x5a, 0x4f, 0x8f, 0x66, 0xc3, 0x8d, 0x69,
	0xba, 0x8f, 0xc0, 0xb8, 0x75, 0x2a, 0x68, 0xb6, 0xf0, 0x14, 0x4e, 0x0d, 0x0e, 0x74, 0x33, 0x72,
	0x63, 0xaa, 0xd4, 0x4f, 0xac, 0x54, 0x13, 0x7d, 0x3f, 0x8e, 0x2a, 0xb3, 0x5a, 0x8d, 0x6c, 0x6f,
	0x63, 0x26, 0x48, 0xe0, 0xc6, 0x5b, 0xf8, 0x31, 0xf5, 0x5d, 0xaf, 0xb7, 0x46, 0x3d, 0xad, 0x67,
	0x92, 0x0d, 0x37, 0x3e, 0x39, 0xcf, 0x6e, 0xe4, 0x06, 0x83, 0x47, 0xf6, 0x3c, 0x3d, 0xcf, 0x66,
	0xd5, 0x4c, 0x7f, 0x08, 0xcb, 0xa1, 0x5a, 0x31, 0x9e, 0x59, 0x78, 0x14, 0x55, 0xac, 0x6b, 0x56,
	0x26, 0x12, 0x45, 0x7a, 0xa4, 0x29, 0xaa, 0x7f, 0xba, 0x0c, 0x2f, 0xa9, 0xb6, 0xe8, 0x35, 0x2c,
	0x6b, 0x54, 0xd0, 0x42, 0x5e, 0x8b, 0x51, 0xc2, 0xac, 0x3b, 0x67, 0xe6, 0x69, 0x8d, 0x8e, 0xf3,
	0xe6, 0xdb, 0xef, 0x0f, 0x17, 0xe6, 0x90, 0x45, 0x72, 0xf8, 0xd7, 0xfc, 0xa1, 0x2f, 0x00, 0xa2,
	0x51, 0xb0, 0x50, 0xbd, 0x70, 0x46, 0x21, 0xa8, 0xd6, 0xf2, 0xb9, 0x6a, 0x8c, 0xc6, 0x7b, 0x4a,
	0xe3, 0x22, 0xaa, 0xe6, 0x69, 0xcc, 0x43, 0x1a, 0x7d, 0x04, 0x70, 0x32, 0xc3, 0x0f, 0x5a, 0x2a,
	0x1c, 0x9c, 0x07, 0xa1, 0x85, 0xff, 0x35, 0xdd, 0x48, 0x5c, 0x54, 0x12, 0x6f, 0x21, 0x27, 0x4f,
	0x62, 0x16, 0x58, 0xb4, 0x0f, 0xe0, 0xf4, 0x08, 0x75, 0xa8, 0x56, 0x38, 0xb1, 0x88, 0x61, 0xab,
	0x7e, 0x9e, 0x12, 0x23, 0x14, 0x2b, 0xa1, 0x55, 0xb4, 0x90, 0x27, 0x74, 0x94, 0x76, 0xe5, 0x64,
	0x86, 0xad, 0x31, 0x4e, 0xe6, 0x01, 0x3a, 0xc6, 0xc9, 0x5c, 0x64, 0xc7, 0x3b, 0x99, 0x85, 0x59,
	0x71, 0xa1, 0x58, 0x19, 0xc7, 0xc5, 0x30, 0xa9, 0xe3, 0xb8, 0xc8, 0xb0, 0x7b, 0x06, 0x17, 0x9a,
	0xd9, 0xf5, 0x83, 0x63, 0x1b, 0x1c, 0x1e, 0xdb, 0xe0, 0xd7, 0xb1, 0x0d, 0xde, 0xf7, 0xed, 0xd2,
	0x61, 0xdf, 0x2e, 0x7d, 0xef, 0xdb, 0xa5, 0x17, 0x64, 0xe8, 0xbd, 0xa7, 0xeb, 0xf5, 0xb5, 0x5b,
	0x7b, 0x40, 0x5e, 0x65, 0x7b, 0xa9, 0x97, 0x60, 0xab, 0xac, 0x3e, 0x97, 0xcb, 0x7f, 0x03, 0x00,
	0x00, 0xff, 0xff, 0x68, 0x21, 0x66, 0x46, 0xed, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// QueryClient is the client API for Query service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QueryClient interface {
	// Period retrieves current period.
	Period(ctx context.Context, in *QueryPeriodRequest, opts ...grpc.CallOption) (*QueryPeriodResponse, error)
	// EpochMintProvision retrieves current minting epoch provision value.
	EpochMintProvision(ctx context.Context, in *QueryEpochMintProvisionRequest, opts ...grpc.CallOption) (*QueryEpochMintProvisionResponse, error)
	// SkippedEpochs retrieves the total number of skipped epochs.
	SkippedEpochs(ctx context.Context, in *QuerySkippedEpochsRequest, opts ...grpc.CallOption) (*QuerySkippedEpochsResponse, error)
	// CirculatingSupply retrieves the total number of tokens that are in
	// circulation (i.e. excluding unvested tokens).
	CirculatingSupply(ctx context.Context, in *QueryCirculatingSupplyRequest, opts ...grpc.CallOption) (*QueryCirculatingSupplyResponse, error)
	// InflationRate retrieves the inflation rate of the current period.
	InflationRate(ctx context.Context, in *QueryInflationRateRequest, opts ...grpc.CallOption) (*QueryInflationRateResponse, error)
	// Params retrieves the total set of minting parameters.
	Params(ctx context.Context, in *QueryParamsRequest, opts ...grpc.CallOption) (*QueryParamsResponse, error)
}

type queryClient struct {
	cc grpc1.ClientConn
}

func NewQueryClient(cc grpc1.ClientConn) QueryClient {
	return &queryClient{cc}
}

func (c *queryClient) Period(ctx context.Context, in *QueryPeriodRequest, opts ...grpc.CallOption) (*QueryPeriodResponse, error) {
	out := new(QueryPeriodResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/Period", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) EpochMintProvision(ctx context.Context, in *QueryEpochMintProvisionRequest, opts ...grpc.CallOption) (*QueryEpochMintProvisionResponse, error) {
	out := new(QueryEpochMintProvisionResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/EpochMintProvision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) SkippedEpochs(ctx context.Context, in *QuerySkippedEpochsRequest, opts ...grpc.CallOption) (*QuerySkippedEpochsResponse, error) {
	out := new(QuerySkippedEpochsResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/SkippedEpochs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) CirculatingSupply(ctx context.Context, in *QueryCirculatingSupplyRequest, opts ...grpc.CallOption) (*QueryCirculatingSupplyResponse, error) {
	out := new(QueryCirculatingSupplyResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/CirculatingSupply", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) InflationRate(ctx context.Context, in *QueryInflationRateRequest, opts ...grpc.CallOption) (*QueryInflationRateResponse, error) {
	out := new(QueryInflationRateResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/InflationRate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) Params(ctx context.Context, in *QueryParamsRequest, opts ...grpc.CallOption) (*QueryParamsResponse, error) {
	out := new(QueryParamsResponse)
	err := c.cc.Invoke(ctx, "/evmos.inflation.v1.Query/Params", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QueryServer is the server API for Query service.
type QueryServer interface {
	// Period retrieves current period.
	Period(context.Context, *QueryPeriodRequest) (*QueryPeriodResponse, error)
	// EpochMintProvision retrieves current minting epoch provision value.
	EpochMintProvision(context.Context, *QueryEpochMintProvisionRequest) (*QueryEpochMintProvisionResponse, error)
	// SkippedEpochs retrieves the total number of skipped epochs.
	SkippedEpochs(context.Context, *QuerySkippedEpochsRequest) (*QuerySkippedEpochsResponse, error)
	// CirculatingSupply retrieves the total number of tokens that are in
	// circulation (i.e. excluding unvested tokens).
	CirculatingSupply(context.Context, *QueryCirculatingSupplyRequest) (*QueryCirculatingSupplyResponse, error)
	// InflationRate retrieves the inflation rate of the current period.
	InflationRate(context.Context, *QueryInflationRateRequest) (*QueryInflationRateResponse, error)
	// Params retrieves the total set of minting parameters.
	Params(context.Context, *QueryParamsRequest) (*QueryParamsResponse, error)
}

// UnimplementedQueryServer can be embedded to have forward compatible implementations.
type UnimplementedQueryServer struct {
}

func (*UnimplementedQueryServer) Period(ctx context.Context, req *QueryPeriodRequest) (*QueryPeriodResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Period not implemented")
}
func (*UnimplementedQueryServer) EpochMintProvision(ctx context.Context, req *QueryEpochMintProvisionRequest) (*QueryEpochMintProvisionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EpochMintProvision not implemented")
}
func (*UnimplementedQueryServer) SkippedEpochs(ctx context.Context, req *QuerySkippedEpochsRequest) (*QuerySkippedEpochsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SkippedEpochs not implemented")
}
func (*UnimplementedQueryServer) CirculatingSupply(ctx context.Context, req *QueryCirculatingSupplyRequest) (*QueryCirculatingSupplyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CirculatingSupply not implemented")
}
func (*UnimplementedQueryServer) InflationRate(ctx context.Context, req *QueryInflationRateRequest) (*QueryInflationRateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InflationRate not implemented")
}
func (*UnimplementedQueryServer) Params(ctx context.Context, req *QueryParamsRequest) (*QueryParamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Params not implemented")
}

func RegisterQueryServer(s grpc1.Server, srv QueryServer) {
	s.RegisterService(&_Query_serviceDesc, srv)
}

func _Query_Period_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryPeriodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).Period(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/Period",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).Period(ctx, req.(*QueryPeriodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_EpochMintProvision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryEpochMintProvisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).EpochMintProvision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/EpochMintProvision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).EpochMintProvision(ctx, req.(*QueryEpochMintProvisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_SkippedEpochs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QuerySkippedEpochsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).SkippedEpochs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/SkippedEpochs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).SkippedEpochs(ctx, req.(*QuerySkippedEpochsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_CirculatingSupply_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryCirculatingSupplyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).CirculatingSupply(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/CirculatingSupply",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).CirculatingSupply(ctx, req.(*QueryCirculatingSupplyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_InflationRate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryInflationRateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).InflationRate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/InflationRate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).InflationRate(ctx, req.(*QueryInflationRateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_Params_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryParamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).Params(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/evmos.inflation.v1.Query/Params",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).Params(ctx, req.(*QueryParamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Query_serviceDesc = grpc.ServiceDesc{
	ServiceName: "evmos.inflation.v1.Query",
	HandlerType: (*QueryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Period",
			Handler:    _Query_Period_Handler,
		},
		{
			MethodName: "EpochMintProvision",
			Handler:    _Query_EpochMintProvision_Handler,
		},
		{
			MethodName: "SkippedEpochs",
			Handler:    _Query_SkippedEpochs_Handler,
		},
		{
			MethodName: "CirculatingSupply",
			Handler:    _Query_CirculatingSupply_Handler,
		},
		{
			MethodName: "InflationRate",
			Handler:    _Query_InflationRate_Handler,
		},
		{
			MethodName: "Params",
			Handler:    _Query_Params_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "evmos/inflation/v1/query.proto",
}

func (m *QueryPeriodRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPeriodRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryPeriodRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryPeriodResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPeriodResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryPeriodResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Period != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.Period))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryEpochMintProvisionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryEpochMintProvisionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryEpochMintProvisionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryEpochMintProvisionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryEpochMintProvisionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryEpochMintProvisionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.EpochMintProvision.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintQuery(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *QuerySkippedEpochsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuerySkippedEpochsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuerySkippedEpochsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QuerySkippedEpochsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuerySkippedEpochsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuerySkippedEpochsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SkippedEpochs != 0 {
		i = encodeVarintQuery(dAtA, i, uint64(m.SkippedEpochs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryCirculatingSupplyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryCirculatingSupplyRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryCirculatingSupplyRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryCirculatingSupplyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryCirculatingSupplyResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryCirculatingSupplyResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.CirculatingSupply.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintQuery(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *QueryInflationRateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryInflationRateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryInflationRateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryInflationRateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryInflationRateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryInflationRateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size := m.InflationRate.Size()
		i -= size
		if _, err := m.InflationRate.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintQuery(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *QueryParamsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryParamsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryParamsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryParamsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryParamsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryParamsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Params.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintQuery(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintQuery(dAtA []byte, offset int, v uint64) int {
	offset -= sovQuery(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryPeriodRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryPeriodResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Period != 0 {
		n += 1 + sovQuery(uint64(m.Period))
	}
	return n
}

func (m *QueryEpochMintProvisionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryEpochMintProvisionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.EpochMintProvision.Size()
	n += 1 + l + sovQuery(uint64(l))
	return n
}

func (m *QuerySkippedEpochsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QuerySkippedEpochsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SkippedEpochs != 0 {
		n += 1 + sovQuery(uint64(m.SkippedEpochs))
	}
	return n
}

func (m *QueryCirculatingSupplyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryCirculatingSupplyResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.CirculatingSupply.Size()
	n += 1 + l + sovQuery(uint64(l))
	return n
}

func (m *QueryInflationRateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryInflationRateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.InflationRate.Size()
	n += 1 + l + sovQuery(uint64(l))
	return n
}

func (m *QueryParamsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryParamsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Params.Size()
	n += 1 + l + sovQuery(uint64(l))
	return n
}

func sovQuery(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQuery(x uint64) (n int) {
	return sovQuery(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *QueryPeriodRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPeriodRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPeriodRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPeriodResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPeriodResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPeriodResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Period |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryEpochMintProvisionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryEpochMintProvisionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryEpochMintProvisionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryEpochMintProvisionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryEpochMintProvisionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryEpochMintProvisionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EpochMintProvision", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EpochMintProvision.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuerySkippedEpochsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuerySkippedEpochsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuerySkippedEpochsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuerySkippedEpochsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuerySkippedEpochsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuerySkippedEpochsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkippedEpochs", wireType)
			}
			m.SkippedEpochs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SkippedEpochs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryCirculatingSupplyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryCirculatingSupplyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryCirculatingSupplyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryCirculatingSupplyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryCirculatingSupplyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryCirculatingSupplyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CirculatingSupply", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CirculatingSupply.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryInflationRateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryInflationRateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryInflationRateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryInflationRateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryInflationRateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryInflationRateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InflationRate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InflationRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryParamsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryParamsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryParamsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryParamsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryParamsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryParamsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQuery
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuery(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQuery
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupQuery
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthQuery
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthQuery        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuery          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupQuery = fmt.Errorf("proto: unexpected end of group")
)
