import { Service } from "../service.ts";
export class Teams extends Service {
    async list(search = '', limit = 25, offset = 0, orderType = 'ASC') {
        let path = '/teams';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'search': search,
            'limit': limit,
            'offset': offset,
            'orderType': orderType
        });
    }
    async create(name, roles = ["owner"]) {
        let path = '/teams';
        return await this.client.call('post', path, {
            'content-type': 'application/json',
        }, {
            'name': name,
            'roles': roles
        });
    }
    async get(teamId) {
        let path = '/teams/{teamId}'.replace(new RegExp('{teamId}', 'g'), teamId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async update(teamId, name) {
        let path = '/teams/{teamId}'.replace(new RegExp('{teamId}', 'g'), teamId);
        return await this.client.call('put', path, {
            'content-type': 'application/json',
        }, {
            'name': name
        });
    }
    async delete(teamId) {
        let path = '/teams/{teamId}'.replace(new RegExp('{teamId}', 'g'), teamId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getMemberships(teamId) {
        let path = '/teams/{teamId}/memberships'.replace(new RegExp('{teamId}', 'g'), teamId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async createMembership(teamId, email, roles, url, name = '') {
        let path = '/teams/{teamId}/memberships'.replace(new RegExp('{teamId}', 'g'), teamId);
        return await this.client.call('post', path, {
            'content-type': 'application/json',
        }, {
            'email': email,
            'name': name,
            'roles': roles,
            'url': url
        });
    }
    async deleteMembership(teamId, inviteId) {
        let path = '/teams/{teamId}/memberships/{inviteId}'.replace(new RegExp('{teamId}', 'g'), teamId).replace(new RegExp('{inviteId}', 'g'), inviteId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
}
//# sourceMappingURL=data:application/json;base64,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