package kha;

class Window {
	static var windows: Array<Window> = [];
	var num: Int;
	var windowTitle: String;

	public function new(num: Int) {
		this.num = num;
		windows.push(this);
	}

	public static function create(win: WindowOptions = null, frame: FramebufferOptions = null): Window {
		return null;
	}

	public static function destroy(window: Window): Void {}

	public static function get(index: Int): Window {
		return windows[index];
	}

	public static var all(get, never): Array<Window>;

	static function get_all(): Array<Window> {
		return windows;
	}

	public function resize(width: Int, height: Int): Void {
		Krom.resizeWindow(num, width, height);
	}

	public function move(x: Int, y: Int): Void {
		Krom.moveWindow(num, x, y);
	}

	public function changeWindowFeatures(features: Int): Void {}

	public function changeFramebuffer(frame: FramebufferOptions): Void {}

	public var x(get, set): Int;

	function get_x(): Int {
		return Krom.windowX(num);
	}

	function set_x(value: Int): Int {
		return 0;
	}

	public var y(get, set): Int;

	function get_y(): Int {
		return Krom.windowY(num);
	}

	function set_y(value: Int): Int {
		return 0;
	}

	public var width(get, set): Int;

	function get_width(): Int {
		return Krom.windowWidth(num);
	}

	function set_width(value: Int): Int {
		return 800;
	}

	public var height(get, set): Int;

	function get_height(): Int {
		return Krom.windowHeight(num);
	}

	function set_height(value: Int): Int {
		return 600;
	}

	public var mode(get, set): WindowMode;

	function get_mode(): WindowMode {
		return cast Krom.getWindowMode(num);
	}

	function set_mode(mode: WindowMode): WindowMode {
		Krom.setWindowMode(num, cast mode);
		return mode;
	}

	public var visible(get, set): Bool;

	function get_visible(): Bool {
		return true;
	}

	function set_visible(value: Bool): Bool {
		return true;
	}

	public var title(get, set): String;

	function get_title(): String {
		return windowTitle;
	}

	function set_title(value: String): String {
		Krom.setWindowTitle(num, value);
		windowTitle = value;
		return windowTitle;
	}

	public function notifyOnResize(callback: Int->Int->Void): Void {}

	public var vSynced(get, never): Bool;

	function get_vSynced(): Bool {
		return true;
	}
}
