package icons

import (
	"path/filepath"
	"strings"
)

// NOTE: Visit next links for inspiration:
// https://github.com/eza-community/eza/blob/main/src/output/icons.rs
// https://github.com/nvim-tree/nvim-web-devicons/blob/master/lua/nvim-web-devicons/icons-default.lua

var (
	DEFAULT_FILE_ICON      = IconProperties{Icon: "\uf15b", Color: "#878787"}     // 
	DEFAULT_SUBMODULE_ICON = IconProperties{Icon: "\U000f02a2", Color: "#FF4F00"} // 󰊢
	DEFAULT_DIRECTORY_ICON = IconProperties{Icon: "\uf07b", Color: "#878787"}     // 
)

var nameIconMap = map[string]IconProperties{
	".atom":                      {Icon: "\ue764", Color: "#EED9B7"},     // 
	".babelrc":                   {Icon: "\ue639", Color: "#FED836"},     // 
	".bash_profile":              {Icon: "\ue615", Color: "#89E051"},     // 
	".bashprofile":               {Icon: "\ue615", Color: "#89E051"},     // 
	".bashrc":                    {Icon: "\ue795", Color: "#89E051"},     // 
	".clang-format":              {Icon: "\ue615", Color: "#86806D"},     // 
	".clang-tidy":                {Icon: "\ue615", Color: "#86806D"},     // 
	".codespellrc":               {Icon: "\U000f04c6", Color: "#35DA60"}, // 󰓆
	".condarc":                   {Icon: "\ue715", Color: "#43B02A"},     // 
	".dockerignore":              {Icon: "\U000f0868", Color: "#458EE6"}, // 󰡨
	".ds_store":                  {Icon: "\uf302", Color: "#78919C"},     // 
	".editorconfig":              {Icon: "\ue652", Color: "#FFFFFF"},     // 
	".env":                       {Icon: "\U000f066a", Color: "#FBC02D"}, // 󰙪
	".eslintignore":              {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	".eslintrc":                  {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	".git":                       {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".git-blame-ignore-revs":     {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".gitattributes":             {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".gitconfig":                 {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".github":                    {Icon: "\uf408", Color: "#333333"},     // 
	".gitignore":                 {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".gitlab-ci.yml":             {Icon: "\uf296", Color: "#F54D27"},     // 
	".gitmodules":                {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	".gtkrc-2.0":                 {Icon: "\uf362", Color: "#FFFFFF"},     // 
	".gvimrc":                    {Icon: "\ue62b", Color: "#019833"},     // 
	".idea":                      {Icon: "\ue7b5", Color: "#626262"},     // 
	".justfile":                  {Icon: "\uf0ad", Color: "#6D8086"},     // 
	".luacheckrc":                {Icon: "\ue615", Color: "#868F9D"},     // 
	".luaurc":                    {Icon: "\ue615", Color: "#00A2FF"},     // 
	".mailmap":                   {Icon: "\U000f01ee", Color: "#42A5F5"}, // 󰇮
	".nanorc":                    {Icon: "\ue838", Color: "#440077"},     // 
	".npmignore":                 {Icon: "\ued0e", Color: "#CC3837"},     // 
	".npmrc":                     {Icon: "\ued0e", Color: "#CC3837"},     // 
	".nuxtrc":                    {Icon: "\U000f1106", Color: "#00C58E"}, // 󱄆
	".nvmrc":                     {Icon: "\ued0d", Color: "#4CAF51"},     // 
	".pre-commit-config.yaml":    {Icon: "\U000f06e2", Color: "#F8B424"}, // 󰛢
	".prettierignore":            {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc":                {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc.json":           {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc.json5":          {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc.toml":           {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc.yaml":           {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".prettierrc.yml":            {Icon: "\ue6b4", Color: "#4285F4"},     // 
	".pylintrc":                  {Icon: "\ue615", Color: "#968F6D"},     // 
	".rvm":                       {Icon: "\ue21e", Color: "#D70000"},     // 
	".settings.json":             {Icon: "\ue70c", Color: "#854CC7"},     // 
	".SRCINFO":                   {Icon: "\uf129", Color: "#0F94D2"},     // 
	".tmux.conf":                 {Icon: "\uebc8", Color: "#14BA19"},     // 
	".tmux.conf.local":           {Icon: "\uebc8", Color: "#14BA19"},     // 
	".Trash":                     {Icon: "\uf1f8", Color: "#ACBCEF"},     // 
	".vimrc":                     {Icon: "\ue62b", Color: "#019833"},     // 
	".vscode":                    {Icon: "\ue70c", Color: "#854CC7"},     // 
	".Xauthority":                {Icon: "\uf369", Color: "#E54D18"},     // 
	".Xresources":                {Icon: "\uf369", Color: "#E54D18"},     // 
	".xinitrc":                   {Icon: "\uf369", Color: "#E54D18"},     // 
	".xsession":                  {Icon: "\uf369", Color: "#E54D18"},     // 
	".zprofile":                  {Icon: "\ue615", Color: "#89E051"},     // 
	".zshenv":                    {Icon: "\ue615", Color: "#89E051"},     // 
	".zshrc":                     {Icon: "\ue795", Color: "#89E051"},     // 
	"_gvimrc":                    {Icon: "\ue62b", Color: "#019833"},     // 
	"_vimrc":                     {Icon: "\ue62b", Color: "#019833"},     // 
	"AUTHORS":                    {Icon: "\uedca", Color: "#A172FF"},     // 
	"AUTHORS.txt":                {Icon: "\uedca", Color: "#A172FF"},     // 
	"bin":                        {Icon: "\U000f12a7", Color: "#25A79A"}, // 󱊧
	"brewfile":                   {Icon: "\ue791", Color: "#701516"},     // 
	"bspwmrc":                    {Icon: "\uf355", Color: "#2F2F2F"},     // 
	"build":                      {Icon: "\ue63a", Color: "#89E051"},     // 
	"build.gradle":               {Icon: "\ue660", Color: "#005F87"},     // 
	"build.zig.zon":              {Icon: "\ue6a9", Color: "#F69A1B"},     // 
	"bun.lockb":                  {Icon: "\ue76f", Color: "#EADCD1"},     // 
	"cantorrc":                   {Icon: "\uf373", Color: "#1C99F3"},     // 
	"Cargo.lock":                 {Icon: "\ue7a8", Color: "#DEA584"},     // 
	"Cargo.toml":                 {Icon: "\ue7a8", Color: "#DEA584"},     // 
	"checkhealth":                {Icon: "\U000f04d9", Color: "#75B4FB"}, // 󰓙
	"cmakelists.txt":             {Icon: "\ue794", Color: "##DCE3EB"},    // 
	"CODE_OF_CONDUCT":            {Icon: "\uf4ae", Color: "#E41662"},     // 
	"CODE_OF_CONDUCT.md":         {Icon: "\uf4ae", Color: "#E41662"},     // 
	"CODE-OF-CONDUCT.md":         {Icon: "\uf4ae", Color: "#E41662"},     // 
	"commit_editmsg":             {Icon: "\ue702", Color: "#F54D27"},     // 
	"COMMIT_EDITMSG":             {Icon: "\ue702", Color: "#E54D18"},     // 
	"commitlint.config.js":       {Icon: "\U000f0718", Color: "#039688"}, // 
	"commitlint.config.ts":       {Icon: "\U000f0718", Color: "#039688"}, // 
	"compose.yaml":               {Icon: "\uf21f", Color: "#0088C9"},     // 
	"compose.yml":                {Icon: "\uf21f", Color: "#0088C9"},     // 
	"config":                     {Icon: "\uf013", Color: "#696969"},     // 
	"containerfile":              {Icon: "\uf21f", Color: "#0088C9"},     // 
	"copying":                    {Icon: "\U000f0124", Color: "#FF5821"}, // 󰄤
	"copying.lesser":             {Icon: "\ue60a", Color: "#CBCB41"},     // 
	"docker-compose.yaml":        {Icon: "\uf21f", Color: "#0088C9"},     // 
	"docker-compose.yml":         {Icon: "\uf21f", Color: "#0088C9"},     // 
	"dockerfile":                 {Icon: "\uf21f", Color: "#0088C9"},     // 
	"Dockerfile":                 {Icon: "\uf308", Color: "#458EE6"},     // 
	"ds_store":                   {Icon: "\uf179", Color: "#DDDDDD"},     // 
	"eslint.config.cjs":          {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	"eslint.config.js":           {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	"eslint.config.mjs":          {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	"eslint.config.ts":           {Icon: "\U000f0c7a", Color: "#3F52B5"}, // 󰱺
	"ext_typoscript_setup.txt":   {Icon: "\ue772", Color: "#FF8700"},     // 
	"favicon.ico":                {Icon: "\ue623", Color: "#CBCB41"},     // 
	"fp-info-cache":              {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	"fp-lib-table":               {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	"FreeCAD.conf":               {Icon: "\uf336", Color: "#CB333B"},     // 
	"gemfile$":                   {Icon: "\ue791", Color: "#701516"},     // 
	"gitignore_global":           {Icon: "\U000f02a2", Color: "#E64A19"}, // 󰊢
	"gnumakefile":                {Icon: "\ueba2", Color: "#EF5351"},     // 
	"GNUmakefile":                {Icon: "\ue779", Color: "#6D8086"},     // 
	"go.mod":                     {Icon: "\ue627", Color: "#02ACC1"},     // 
	"go.sum":                     {Icon: "\ue627", Color: "#02ACC1"},     // 
	"go.work":                    {Icon: "\ue627", Color: "#02ACC1"},     // 
	"gradle":                     {Icon: "\ue660", Color: "#005F87"},     // 
	"gradle-wrapper.properties":  {Icon: "\ue660", Color: "#005F87"},     // 
	"gradle.properties":          {Icon: "\ue660", Color: "#005F87"},     // 
	"gradlew":                    {Icon: "\ue660", Color: "#005F87"},     // 
	"gruntfile.babel.js":         {Icon: "\ue611", Color: "#E37933"},     // 
	"gruntfile.coffee":           {Icon: "\ue611", Color: "#E37933"},     // 
	"gruntfile.js":               {Icon: "\ue611", Color: "#E37933"},     // 
	"gruntfile.ls":               {Icon: "\ue611", Color: "#E37933"},     // 
	"gruntfile.ts":               {Icon: "\ue611", Color: "#E37933"},     // 
	"gtkrc":                      {Icon: "\uf362", Color: "#FFFFFF"},     // 
	"gulpfile.babel.js":          {Icon: "\ue610", Color: "#CC3E44"},     // 
	"gulpfile.coffee":            {Icon: "\ue610", Color: "#CC3E44"},     // 
	"gulpfile.js":                {Icon: "\ue610", Color: "#CC3E44"},     // 
	"gulpfile.ls":                {Icon: "\ue610", Color: "#CC3E44"},     // 
	"gulpfile.ts":                {Icon: "\ue610", Color: "#CC3E44"},     // 
	"hidden":                     {Icon: "\uf023", Color: "#555555"},     // 
	"hypridle.conf":              {Icon: "\uf359", Color: "#00AAAE"},     // 
	"hyprland.conf":              {Icon: "\uf359", Color: "#00AAAE"},     // 
	"hyprlock.conf":              {Icon: "\uf359", Color: "#00AAAE"},     // 
	"hyprpaper.conf":             {Icon: "\uf359", Color: "#00AAAE"},     // 
	"i3blocks.conf":              {Icon: "\uf35a", Color: "#E8EBEE"},     // 
	"i3status.conf":              {Icon: "\uf35a", Color: "#E8EBEE"},     // 
	"include":                    {Icon: "\ue5fc", Color: "#EEEEEE"},     // 
	"index.theme":                {Icon: "\uee72", Color: "#2DB96F"},     // 
	"ionic.config.json":          {Icon: "\ue66b", Color: "#508FF7"},     // 
	"justfile":                   {Icon: "\uf0ad", Color: "#6D8086"},     // 
	"kalgebrarc":                 {Icon: "\uf373", Color: "#1C99F3"},     // 
	"kdeglobals":                 {Icon: "\uf373", Color: "#1C99F3"},     // 
	"kdenlive-layoutsrc":         {Icon: "\uf33c", Color: "#83B8F2"},     // 
	"kdenliverc":                 {Icon: "\uf33c", Color: "#83B8F2"},     // 
	"kritadisplayrc":             {Icon: "\uf33d", Color: "#F245FB"},     // 
	"kritarc":                    {Icon: "\uf33d", Color: "#F245FB"},     // 
	"lib":                        {Icon: "\U000f1517", Color: "#8BC34A"}, // 󱔗
	"LICENSE":                    {Icon: "\uf02d", Color: "#EDEDED"},     // 
	"LICENSE.md":                 {Icon: "\uf02d", Color: "#EDEDED"},     // 
	"localized":                  {Icon: "\uf179", Color: "#DDDDDD"},     // 
	"lxde-rc.xml":                {Icon: "\uf363", Color: "#909090"},     // 
	"lxqt.conf":                  {Icon: "\uf364", Color: "#0192D3"},     // 
	"Makefile":                   {Icon: "\ue673", Color: "#FEFEFE"},     // 
	"mix.lock":                   {Icon: "\ue62d", Color: "#A074C4"},     // 
	"mpv.conf":                   {Icon: "\uf36e", Color: "#3B1342"},     // 
	"node_modules":               {Icon: "\ue718", Color: "#E8274B"},     // 
	"npmignore":                  {Icon: "\ue71e", Color: "#E8274B"},     // 
	"nuxt.config.cjs":            {Icon: "\U000f1106", Color: "#00C58E"}, // 󱄆
	"nuxt.config.js":             {Icon: "\U000f1106", Color: "#00C58E"}, // 󱄆
	"nuxt.config.mjs":            {Icon: "\U000f1106", Color: "#00C58E"}, // 󱄆
	"nuxt.config.ts":             {Icon: "\U000f1106", Color: "#00C58E"}, // 󱄆
	"package-lock.json":          {Icon: "\ued0d", Color: "#F54436"},     // 
	"package.json":               {Icon: "\ued0d", Color: "#4CAF51"},     // 
	"PKGBUILD":                   {Icon: "\uf303", Color: "#0F94D2"},     // 
	"platformio.ini":             {Icon: "\ue682", Color: "#F6822B"},     // 
	"pom.xml":                    {Icon: "\U000f06d3", Color: "#FF7043"}, // 󰛓
	"prettier.config.cjs":        {Icon: "\ue6b4", Color: "#4285F4"},     // 
	"prettier.config.js":         {Icon: "\ue6b4", Color: "#4285F4"},     // 
	"prettier.config.mjs":        {Icon: "\ue6b4", Color: "#4285F4"},     // 
	"prettier.config.ts":         {Icon: "\ue6b4", Color: "#4285F4"},     // 
	"PrusaSlicer.ini":            {Icon: "\uf351", Color: "#EC6B23"},     // 
	"PrusaSlicerGcodeViewer.ini": {Icon: "\uf351", Color: "#EC6B23"},     // 
	"py.typed":                   {Icon: "\ue606", Color: "#ffbc03"},     // 
	"QtProject.conf":             {Icon: "\uf375", Color: "#40CD52"},     // 
	"R":                          {Icon: "\U000f07d4", Color: "#2266BA"}, // 󰟔
	"README":                     {Icon: "\U000f00ba", Color: "#EDEDED"}, // 󰂺
	"README.md":                  {Icon: "\U000f00ba", Color: "#EDEDED"}, // 󰂺
	"robots.txt":                 {Icon: "\U000f06a9", Color: "#5D7096"}, // 󰚩
	"rubydoc":                    {Icon: "\ue73b", Color: "#F32C24"},     // 
	"SECURITY":                   {Icon: "\U000f0483", Color: "#BEC4C9"}, // 󰒃
	"SECURITY.md":                {Icon: "\U000f0483", Color: "#BEC4C9"}, // 󰒃
	"settings.gradle":            {Icon: "\ue660", Color: "#005F87"},     // 
	"svelte.config.js":           {Icon: "\ue697", Color: "#FF5821"},     // 
	"sxhkdrc":                    {Icon: "\uf355", Color: "#2F2F2F"},     // 
	"sym-lib-table":              {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	"tailwind.config.js":         {Icon: "\U000f13ff", Color: "#4DB6AC"}, // 󱏿
	"tailwind.config.mjs":        {Icon: "\U000f13ff", Color: "#4DB6AC"}, // 󱏿
	"tailwind.config.ts":         {Icon: "\U000f13ff", Color: "#4DB6AC"}, // 󱏿
	"tmux.conf":                  {Icon: "\uebc8", Color: "#14BA19"},     // 
	"tmux.conf.local":            {Icon: "\uebc8", Color: "#14BA19"},     // 
	"tsconfig.json":              {Icon: "\ue628", Color: "#0188D1"},     // 
	"unlicense":                  {Icon: "\ue60a", Color: "#D0BF41"},     // 
	"vagrantfile$":               {Icon: "\uf2b8", Color: "#1868F2"},     // 
	"vlcrc":                      {Icon: "\U000f057c", Color: "#E85E00"}, // 󰕼
	"webpack":                    {Icon: "\U000f072b", Color: "#519ABA"}, // 󰜫
	"weston.ini":                 {Icon: "\uf367", Color: "#FFBB01"},     // 
	"workspace":                  {Icon: "\ue63a", Color: "#89E051"},     // 
	"xmobarrc":                   {Icon: "\uf35e", Color: "#FD4D5D"},     // 
	"xmobarrc.hs":                {Icon: "\uf35e", Color: "#FD4D5D"},     // 
	"xmonad.hs":                  {Icon: "\uf35e", Color: "#FD4D5D"},     // 
	"xorg.conf":                  {Icon: "\uf369", Color: "#E54D18"},     // 
	"xsettingsd.conf":            {Icon: "\uf369", Color: "#E54D18"},     // 
	"yarn.lock":                  {Icon: "\ue6a7", Color: "#0188D1"},     // 
}

var extIconMap = map[string]IconProperties{
	".3gp":            {Icon: "\uf03d", Color: "#F6822B"},     // 
	".3mf":            {Icon: "\U000f01a7", Color: "#888888"}, // 󰆧
	".7z":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".DS_store":       {Icon: "\uf179", Color: "#A2AAAD"},     // 
	".a":              {Icon: "\U000f1517", Color: "#8BC34A"}, // 󱔗
	".aac":            {Icon: "\uf001", Color: "#20C2E3"},     // 
	".adb":            {Icon: "\ue6b5", Color: "#22FFFF"},     // 
	".ads":            {Icon: "\ue6b5", Color: "#22FFFF"},     // 
	".ai":             {Icon: "\ue7b4", Color: "#D0BF41"},     // 
	".aif":            {Icon: "\uf001", Color: "#00AFFF"},     // 
	".aiff":           {Icon: "\U000f0386", Color: "#EE534F"}, // 󰎆
	".android":        {Icon: "\ue70e", Color: "#66AF3D"},     // 
	".ape":            {Icon: "\uf001", Color: "#00AFFF"},     // 
	".apk":            {Icon: "\ue70e", Color: "#8BC34A"},     // 
	".app":            {Icon: "\ueae8", Color: "#9F0500"},     // 
	".apple":          {Icon: "\ue635", Color: "#A2AAAD"},     // 
	".applescript":    {Icon: "\uf302", Color: "#78919C"},     // 
	".asc":            {Icon: "\U000f0306", Color: "#25A79A"}, // 󰌆
	".asm":            {Icon: "\ue637", Color: "#0091BD"},     // 
	".ass":            {Icon: "\U000f0a16", Color: "#FFB713"}, // 󰨖
	".astro":          {Icon: "\ue6b3", Color: "#FF6D00"},     // 
	".avi":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".avif":           {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".avro":           {Icon: "\ue60b", Color: "#965824"},     // 
	".awk":            {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".azcli":          {Icon: "\uebd8", Color: "#2088E5"},     // 
	".bak":            {Icon: "\U000f006f", Color: "#6D8086"}, // 󰁯
	".bash":           {Icon: "\uebca", Color: "#FF7043"},     // 
	".bash_history":   {Icon: "\ue795", Color: "#8DC149"},     // 
	".bash_profile":   {Icon: "\ue795", Color: "#8DC149"},     // 
	".bashrc":         {Icon: "\ue795", Color: "#8DC149"},     // 
	".bat":            {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".bats":           {Icon: "\U000f0b5f", Color: "#D2D2D2"}, // 󰭟
	".bazel":          {Icon: "\ue63a", Color: "#44A047"},     // 
	".bib":            {Icon: "\U000f1517", Color: "#8BC34A"}, // 󱔗
	".bicep":          {Icon: "\U000f0fd7", Color: "#FBC02D"}, // 󰿗
	".bicepparam":     {Icon: "\ue63b", Color: "#797DAC"},     // 
	".blade.php":      {Icon: "\uf2f7", Color: "#FF5252"},     // 
	".blend":          {Icon: "\U000f00ab", Color: "#ED8F30"}, // 󰂫
	".blp":            {Icon: "\U000f0ebe", Color: "#458EE6"}, // 󰺾
	".bmp":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".brep":           {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".bz":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".bz2":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".bz3":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".bzl":            {Icon: "\ue63a", Color: "#44A047"},     // 
	".c":              {Icon: "\ue61e", Color: "#0188D1"},     // 
	".c++":            {Icon: "\ue61d", Color: "#0188D1"},     // 
	".cab":            {Icon: "\ue70f", Color: "#626262"},     // 
	".cache":          {Icon: "\uf49b", Color: "#FFFFFF"},     // 
	".cast":           {Icon: "\uf03d", Color: "#EA8220"},     // 
	".cbl":            {Icon: "\u2699", Color: "#005CA5"},     // ⚙
	".cc":             {Icon: "\ue61d", Color: "#0188D1"},     // 
	".ccm":            {Icon: "\ue61d", Color: "#F34B7D"},     // 
	".cfg":            {Icon: "\uf013", Color: "#42A5F5"},     // 
	".cjs":            {Icon: "\ue60c", Color: "#CBCB41"},     // 
	".class":          {Icon: "\uf0f4", Color: "#2088E5"},     // 
	".clj":            {Icon: "\ue642", Color: "#2AB6F6"},     // 
	".cljc":           {Icon: "\ue642", Color: "#2AB6F6"},     // 
	".cljd":           {Icon: "\ue76a", Color: "#519ABA"},     // 
	".cljs":           {Icon: "\ue642", Color: "#2AB6F6"},     // 
	".cls":            {Icon: "\ue69b", Color: "#4B5163"},     // 
	".cmake":          {Icon: "\ue794", Color: "##DCE3EB"},    // 
	".cmd":            {Icon: "\uebc4", Color: "#FF7043"},     // 
	".cob":            {Icon: "\u2699", Color: "#005CA5"},     // ⚙
	".cobol":          {Icon: "\u2699", Color: "#005CA5"},     // ⚙
	".coffee":         {Icon: "\ue61b", Color: "#6F4E38"},     // 
	".conda":          {Icon: "\ue715", Color: "#43B02A"},     // 
	".conf":           {Icon: "\uf013", Color: "#696969"},     // 
	".config.ru":      {Icon: "\ue791", Color: "#701516"},     // 
	".cp":             {Icon: "\ue646", Color: "#0188D1"},     // 
	".cpio":           {Icon: "\uf410", Color: "#ECA517"},     // 
	".cpp":            {Icon: "\ue61d", Color: "#0188D1"},     // 
	".cppm":           {Icon: "\ue61d", Color: "#519ABA"},     // 
	".cpy":            {Icon: "\u2699", Color: "#005CA5"},     // ⚙
	".cr":             {Icon: "\ue62f", Color: "#CFD8DD"},     // 
	".crdownload":     {Icon: "\uf019", Color: "#44CDA8"},     // 
	".cs":             {Icon: "\U000f031b", Color: "#0188D1"}, // 󰌛
	".csh":            {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".cshtml":         {Icon: "\uf486", Color: "#42A5F5"},     // 
	".cson":           {Icon: "\ue61b", Color: "#6F4E38"},     // 
	".csproj":         {Icon: "\U000f0610", Color: "#AB48BC"}, // 󰘐
	".css":            {Icon: "\ue749", Color: "#42A5F5"},     // 
	".csv":            {Icon: "\U000f021b", Color: "#8BC34A"}, // 󰈛
	".csx":            {Icon: "\U000f031b", Color: "#0188D1"}, // 󰌛
	".cts":            {Icon: "\ue628", Color: "#519ABA"},     // 
	".cu":             {Icon: "\ue64b", Color: "#89E051"},     // 
	".cue":            {Icon: "\U000f0cb9", Color: "#ED95AE"}, // 󰲹
	".cuh":            {Icon: "\ue64b", Color: "#A074C4"},     // 
	".cxx":            {Icon: "\ue646", Color: "#0188D1"},     // 
	".cxxm":           {Icon: "\ue61d", Color: "#519ABA"},     // 
	".d":              {Icon: "\ue7af", Color: "#B03931"},     // 
	".d.ts":           {Icon: "\ue628", Color: "#0188D1"},     // 
	".dart":           {Icon: "\ue64c", Color: "#59B6F0"},     // 
	".db":             {Icon: "\uf1c0", Color: "#FFCA29"},     // 
	".dconf":          {Icon: "\ue706", Color: "#DAD8D8"},     // 
	".deb":            {Icon: "\uebc5", Color: "#D80651"},     // 
	".desktop":        {Icon: "\uf108", Color: "#56347C"},     // 
	".diff":           {Icon: "\uf4d2", Color: "#4262A2"},     // 
	".djvu":           {Icon: "\uf02d", Color: "#624262"},     // 
	".dll":            {Icon: "\U000f107c", Color: "#42A5F5"}, // 󱁼
	".doc":            {Icon: "\U000f022c", Color: "#0188D1"}, // 󰈬
	".docx":           {Icon: "\U000f022c", Color: "#0188D1"}, // 󰈬
	".dot":            {Icon: "\U000f1049", Color: "#005F87"}, // 󱁉
	".download":       {Icon: "\uf019", Color: "#44CDA8"},     // 
	".drl":            {Icon: "\ue28c", Color: "#FFAFAF"},     // 
	".dropbox":        {Icon: "\ue707", Color: "#2E63FF"},     // 
	".ds_store":       {Icon: "\uf179", Color: "#A2AAAD"},     // 
	".dump":           {Icon: "\uf1c0", Color: "#DAD8D8"},     // 
	".dwg":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".dxf":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".ebook":          {Icon: "\ue28b", Color: "#EAB16D"},     // 
	".ebuild":         {Icon: "\uf30d", Color: "#4C416E"},     // 
	".editorconfig":   {Icon: "\ue615", Color: "#626262"},     // 
	".edn":            {Icon: "\ue76a", Color: "#519ABA"},     // 
	".eex":            {Icon: "\ue62d", Color: "#9575CE"},     // 
	".ejs":            {Icon: "\ue618", Color: "#CBCB41"},     // 
	".el":             {Icon: "\ue632", Color: "#805EB7"},     // 
	".elc":            {Icon: "\ue632", Color: "#805EB7"},     // 
	".elf":            {Icon: "\ueae8", Color: "#9F0500"},     // 
	".elm":            {Icon: "\ue62c", Color: "#60B6CC"},     // 
	".eln":            {Icon: "\ue632", Color: "#8172BE"},     // 
	".env":            {Icon: "\uf462", Color: "#FAF743"},     // 
	".eot":            {Icon: "\ue659", Color: "#F54436"},     // 
	".epp":            {Icon: "\ue631", Color: "#FFA61A"},     // 
	".epub":           {Icon: "\ue28b", Color: "#EAB16D"},     // 
	".erb":            {Icon: "\U000f0d2d", Color: "#F54436"}, // 󰴭
	".erl":            {Icon: "\uf23f", Color: "#F54436"},     // 
	".ex":             {Icon: "\ue62d", Color: "#9575CE"},     // 
	".exe":            {Icon: "\uf2d0", Color: "#E64A19"},     // 
	".exs":            {Icon: "\ue62d", Color: "#9575CE"},     // 
	".f#":             {Icon: "\ue7a7", Color: "#519ABA"},     // 
	".f3d":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".f90":            {Icon: "\U000f121a", Color: "#FF7043"}, // 󱈚
	".fbx":            {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".fcbak":          {Icon: "\uf336", Color: "#6D8086"},     // 
	".fcmacro":        {Icon: "\uf336", Color: "#CB333B"},     // 
	".fcmat":          {Icon: "\uf336", Color: "#CB333B"},     // 
	".fcparam":        {Icon: "\uf336", Color: "#CB333B"},     // 
	".fcscript":       {Icon: "\uf336", Color: "#CB333B"},     // 
	".fcstd":          {Icon: "\uf336", Color: "#CB333B"},     // 
	".fcstd1":         {Icon: "\uf336", Color: "#CB333B"},     // 
	".fctb":           {Icon: "\uf336", Color: "#CB333B"},     // 
	".fctl":           {Icon: "\uf336", Color: "#CB333B"},     // 
	".fdmdownload":    {Icon: "\uf019", Color: "#44CDA8"},     // 
	".fish":           {Icon: "\U000f023a", Color: "#FF7043"}, // 󰈺
	".flac":           {Icon: "\U000f0386", Color: "#EE534F"}, // 󰎆
	".flc":            {Icon: "\uf031", Color: "#ECECEC"},     // 
	".flf":            {Icon: "\uf031", Color: "#ECECEC"},     // 
	".flv":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".fnl":            {Icon: "\ue6af", Color: "#FFF3D7"},     // 
	".fodg":           {Icon: "\uf379", Color: "#FFFB57"},     // 
	".fodp":           {Icon: "\uf37a", Color: "#FE9C45"},     // 
	".fods":           {Icon: "\uf378", Color: "#78FC4E"},     // 
	".fodt":           {Icon: "\uf37c", Color: "#2DCBFD"},     // 
	".font":           {Icon: "\ue659", Color: "#F54436"},     // 
	".fs":             {Icon: "\ue7a7", Color: "#31B9DB"},     // 
	".fsi":            {Icon: "\ue7a7", Color: "#31B9DB"},     // 
	".fsscript":       {Icon: "\ue7a7", Color: "#519ABA"},     // 
	".fsx":            {Icon: "\ue7a7", Color: "#31B9DB"},     // 
	".gcode":          {Icon: "\U000f0af4", Color: "#505075"}, // 󰫴
	".gd":             {Icon: "\ue65f", Color: "#42A5F5"},     // 
	".gdoc":           {Icon: "\uf1c2", Color: "#01D000"},     // 
	".gem":            {Icon: "\ue21e", Color: "#C90F02"},     // 
	".gemfile":        {Icon: "\ueb48", Color: "#E63936"},     // 
	".gemspec":        {Icon: "\ue21e", Color: "#C90F02"},     // 
	".gform":          {Icon: "\uf298", Color: "#01D000"},     // 
	".gif":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".git":            {Icon: "\U000f02a2", Color: "#EC6B23"}, // 󰊢
	".glb":            {Icon: "\uf1b2", Color: "#FFA61A"},     // 
	".gnumakefile":    {Icon: "\ueba2", Color: "#EF5351"},     // 
	".go":             {Icon: "\ue627", Color: "#02ACC1"},     // 
	".godot":          {Icon: "\ue65f", Color: "#42A5F5"},     // 
	".gpr":            {Icon: "\ue6b5", Color: "#22FFFF"},     // 
	".gql":            {Icon: "\U000f0877", Color: "#EC417A"}, // 󰡷
	".gradle":         {Icon: "\ue660", Color: "#0397A7"},     // 
	".graphql":        {Icon: "\U000f0877", Color: "#EC417A"}, // 󰡷
	".gresource":      {Icon: "\uf362", Color: "#FFFFFF"},     // 
	".groovy":         {Icon: "\ue775", Color: "#005F87"},     // 
	".gsheet":         {Icon: "\uf1c3", Color: "#97BA6A"},     // 
	".gslides":        {Icon: "\uf1c4", Color: "#FFFF00"},     // 
	".guardfile":      {Icon: "\ue21e", Color: "#626262"},     // 
	".gv":             {Icon: "\U000f1049", Color: "#005F87"}, // 󱁉
	".gz":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".h":              {Icon: "\uf0fd", Color: "##A074C4"},    // 
	".haml":           {Icon: "\ue664", Color: "#F4521E"},     // 
	".hbs":            {Icon: "\U000f15de", Color: "#FF7043"}, // 󱗞
	".hc":             {Icon: "\U000f00a2", Color: "#FAF743"}, // 󰂢
	".heex":           {Icon: "\ue62d", Color: "#9575CE"},     // 
	".hex":            {Icon: "\U000f12a7", Color: "#25A79A"}, // 󱊧
	".hh":             {Icon: "\uf0fd", Color: "##A074C4"},    // 
	".hpp":            {Icon: "\uf0fd", Color: "##A074C4"},    // 
	".hrl":            {Icon: "\ue7b1", Color: "#B83998"},     // 
	".hs":             {Icon: "\ue61f", Color: "#FFA726"},     // 
	".htm":            {Icon: "\uf13b", Color: "#E44E27"},     // 
	".html":           {Icon: "\uf13b", Color: "#E44E27"},     // 
	".huff":           {Icon: "\U000f0858", Color: "#CFD8DD"}, // 󰡘
	".hurl":           {Icon: "\uf0ec", Color: "#FF0288"},     // 
	".hx":             {Icon: "\ue666", Color: "#F68713"},     // 
	".hxx":            {Icon: "\uf0fd", Color: "##A074C4"},    // 
	".ical":           {Icon: "\uf073", Color: "#2B9EF3"},     // 
	".icalendar":      {Icon: "\uf073", Color: "#2B9EF3"},     // 
	".ico":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".ics":            {Icon: "\U000f01ee", Color: "#42A5F5"}, // 󰇮
	".ifb":            {Icon: "\uf073", Color: "#2B9EF3"},     // 
	".ifc":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".ige":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".iges":           {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".igs":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".image":          {Icon: "\uf1c5", Color: "#CBCB41"},     // 
	".img":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".iml":            {Icon: "\U000f022e", Color: "#8BC34A"}, // 󰈮
	".import":         {Icon: "\uf0c6", Color: "#ECECEC"},     // 
	".info":           {Icon: "\uf129", Color: "#FFF3D7"},     // 
	".ini":            {Icon: "\uf013", Color: "#42A5F5"},     // 
	".ino":            {Icon: "\uf34b", Color: "#01979D"},     // 
	".ipynb":          {Icon: "\ue80f", Color: "#F57D01"},     // 
	".iso":            {Icon: "\uede9", Color: "#B1BEC5"},     // 
	".ixx":            {Icon: "\ue61d", Color: "#519ABA"},     // 
	".j2c":            {Icon: "\uf1c5", Color: "#4B5163"},     // 
	".j2k":            {Icon: "\uf1c5", Color: "#4B5163"},     // 
	".jad":            {Icon: "\ue256", Color: "#F19210"},     // 
	".jar":            {Icon: "\U000f06ca", Color: "#F19210"}, // 󰛊
	".java":           {Icon: "\uf0f4", Color: "#F19210"},     // 
	".jfi":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".jfif":           {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".jif":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".jl":             {Icon: "\ue624", Color: "#338A23"},     // 
	".jmd":            {Icon: "\uf48a", Color: "#519ABA"},     // 
	".jp2":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".jpe":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".jpeg":           {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".jpg":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".jpx":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".js":             {Icon: "\U000f031e", Color: "#FFCA29"}, // 󰌞
	".json":           {Icon: "\ue60b", Color: "#FAA825"},     // 
	".json5":          {Icon: "\ue60b", Color: "#FAA825"},     // 
	".jsonc":          {Icon: "\ue60b", Color: "#FAA825"},     // 
	".jsx":            {Icon: "\ued46", Color: "#FFCA29"},     // 
	".jwmrc":          {Icon: "\uf35b", Color: "#007AC2"},     // 
	".jxl":            {Icon: "\uf1c5", Color: "#727252"},     // 
	".kbx":            {Icon: "\U000f0bc4", Color: "#537662"}, // 󰯄
	".kdb":            {Icon: "\uf23e", Color: "#529B34"},     // 
	".kdbx":           {Icon: "\uf23e", Color: "#529B34"},     // 
	".kdenlive":       {Icon: "\uf33c", Color: "#83B8F2"},     // 
	".kdenlivetitle":  {Icon: "\uf33c", Color: "#83B8F2"},     // 
	".kicad_dru":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_mod":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_pcb":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_prl":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_pro":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_sch":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_sym":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".kicad_wks":      {Icon: "\uf34c", Color: "#FFFFFF"},     // 
	".ko":             {Icon: "\uf17c", Color: "#DDDDDD"},     // 
	".kpp":            {Icon: "\uf33d", Color: "#F245FB"},     // 
	".kra":            {Icon: "\uf33d", Color: "#F245FB"},     // 
	".krz":            {Icon: "\uf33d", Color: "#F245FB"},     // 
	".ksh":            {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".kt":             {Icon: "\ue634", Color: "#1A95D9"},     // 
	".kts":            {Icon: "\ue634", Color: "#1A95D9"},     // 
	".latex":          {Icon: "\ue69b", Color: "#626262"},     // 
	".lck":            {Icon: "\ue672", Color: "#BBBBBB"},     // 
	".leex":           {Icon: "\ue62d", Color: "#9575CE"},     // 
	".less":           {Icon: "\ued48", Color: "#0277BD"},     // 
	".lff":            {Icon: "\uf031", Color: "#ECECEC"},     // 
	".lhs":            {Icon: "\ue777", Color: "#A074C4"},     // 
	".license":        {Icon: "\U000f0124", Color: "#FFCA29"}, // 󰄤
	".liquid":         {Icon: "\uf043", Color: "#2AB6F6"},     // 
	".localized":      {Icon: "\uf179", Color: "#A2AAAD"},     // 
	".lock":           {Icon: "\uf023", Color: "#FFD550"},     // 
	".log":            {Icon: "\uf0f6", Color: "#ECA517"},     // 
	".lrc":            {Icon: "\U000f0a16", Color: "#FFA61A"}, // 󰨖
	".lua":            {Icon: "\ue620", Color: "#42A5F5"},     // 
	".luac":           {Icon: "\ue620", Color: "#519ABA"},     // 
	".luau":           {Icon: "\ue620", Color: "#519ABA"},     // 
	".lz":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".lz4":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".lzh":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".lzma":           {Icon: "\uf410", Color: "#ECA517"},     // 
	".lzo":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".m":              {Icon: "\ue61e", Color: "#599EFF"},     // 
	".m3u":            {Icon: "\U000f0cb9", Color: "#ED95AE"}, // 󰲹
	".m3u8":           {Icon: "\U000f0cb9", Color: "#ED95AE"}, // 󰲹
	".m4a":            {Icon: "\U000f0386", Color: "#EE534F"}, // 󰎆
	".m4v":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".magnet":         {Icon: "\uf076", Color: "#9F0500"},     // 
	".makefile":       {Icon: "\ue673", Color: "#FEFEFE"},     // 
	".markdown":       {Icon: "\ueb1d", Color: "#42A5F5"},     // 
	".material":       {Icon: "\U000f0509", Color: "#B83998"}, // 󰔉
	".md":             {Icon: "\ueb1d", Color: "#42A5F5"},     // 
	".md5":            {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".mdx":            {Icon: "\ueb1d", Color: "#FFCA29"},     // 
	".mint":           {Icon: "\ue7a4", Color: "#44A047"},     // 
	".mjs":            {Icon: "\U000f031e", Color: "#FFCA29"}, // 󰌞
	".mk":             {Icon: "\ue795", Color: "#626262"},     // 
	".mkd":            {Icon: "\uf48a", Color: "#519ABA"},     // 
	".mkv":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".ml":             {Icon: "\ue67a", Color: "#FF9800"},     // 
	".mli":            {Icon: "\ue67a", Color: "#FF9800"},     // 
	".mm":             {Icon: "\ue61d", Color: "#599EFF"},     // 
	".mo":             {Icon: "\U000f05ca", Color: "#7986CB"}, // 󰗊
	".mobi":           {Icon: "\ue28b", Color: "#EAB16D"},     // 
	".mojo":           {Icon: "\ue780", Color: "#FF7043"},     // 
	".mov":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".mp3":            {Icon: "\U000f0386", Color: "#EE534F"}, // 󰎆
	".mp4":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".mpp":            {Icon: "\ue61d", Color: "#519ABA"},     // 
	".msf":            {Icon: "\uf370", Color: "#137BE1"},     // 
	".msi":            {Icon: "\uf2d0", Color: "#E64A19"},     // 
	".mts":            {Icon: "\ue628", Color: "#519ABA"},     // 
	".mustache":       {Icon: "\U000f15de", Color: "#FF7043"}, // 󱗞
	".nfo":            {Icon: "\uf129", Color: "#FFF3D7"},     // 
	".nim":            {Icon: "\ue677", Color: "#FFCA29"},     // 
	".nix":            {Icon: "\uf313", Color: "#5175C2"},     // 
	".node":           {Icon: "\U000f0399", Color: "#E8274B"}, // 󰎙
	".npmignore":      {Icon: "\ue71e", Color: "#E8274B"},     // 
	".nswag":          {Icon: "\ue60b", Color: "#85EA2D"},     // 
	".nu":             {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".o":              {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".obj":            {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".odin":           {Icon: "\U000f07e2", Color: "#3882D2"}, // 󰟢
	".odf":            {Icon: "\uf37b", Color: "#FF5A96"},     // 
	".odg":            {Icon: "\uf379", Color: "#FFFB57"},     // 
	".odp":            {Icon: "\uf37a", Color: "#FE9C45"},     // 
	".ods":            {Icon: "\uf378", Color: "#78FC4E"},     // 
	".odt":            {Icon: "\uf37c", Color: "#2DCBFD"},     // 
	".ogg":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".ogv":            {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".opus":           {Icon: "\U000f0223", Color: "#EA8220"}, // 󰈣
	".org":            {Icon: "\ue633", Color: "#56B6C2"},     // 
	".otf":            {Icon: "\ue659", Color: "#F54436"},     // 
	".out":            {Icon: "\ueae8", Color: "#9F0500"},     // 
	".part":           {Icon: "\uf43a", Color: "#628262"},     // 
	".patch":          {Icon: "\uf440", Color: "#4262A2"},     // 
	".pck":            {Icon: "\uf487", Color: "#5D8096"},     // 
	".pdf":            {Icon: "\uf1c1", Color: "#EF5351"},     // 
	".php":            {Icon: "\U000f031f", Color: "#2088E5"}, // 󰌟
	".pl":             {Icon: "\U000f03d2", Color: "#EF5351"}, // 󰏒
	".pls":            {Icon: "\U000f0cb9", Color: "#ED95AE"}, // 󰲹
	".ply":            {Icon: "\U000f01a7", Color: "#888888"}, // 󰆧
	".pm":             {Icon: "\ue769", Color: "#9575CE"},     // 
	".png":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".po":             {Icon: "\U000f05ca", Color: "#7986CB"}, // 󰗊
	".pot":            {Icon: "\U000f05ca", Color: "#7986CB"}, // 󰗊
	".pp":             {Icon: "\ue631", Color: "#FFA61A"},     // 
	".ppt":            {Icon: "\U000f0227", Color: "#D14525"}, // 󰈧
	".pptx":           {Icon: "\U000f0227", Color: "#D14525"}, // 󰈧
	".prisma":         {Icon: "\ue684", Color: "#00BFA5"},     // 
	".pro":            {Icon: "\U000f03d2", Color: "#EF5351"}, // 󰏒
	".procfile":       {Icon: "\ue607", Color: "#6964BA"},     // 
	".properties":     {Icon: "\uf013", Color: "#42A5F5"},     // 
	".ps1":            {Icon: "\U000f0a0a", Color: "#04A9F4"}, // 󰨊
	".psb":            {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".psd":            {Icon: "\ue7b8", Color: "#25A6A0"},     // 
	".psd1":           {Icon: "\U000f0a0a", Color: "#04A9F4"}, // 󰨊
	".psm1":           {Icon: "\U000f0a0a", Color: "#04A9F4"}, // 󰨊
	".pub":            {Icon: "\U000f0306", Color: "#25A79A"}, // 󰌆
	".pxd":            {Icon: "\ue606", Color: "#00AFFF"},     // 
	".pxi":            {Icon: "\ue606", Color: "#00AFFF"},     // 
	".pxm":            {Icon: "\uf1c5", Color: "#626262"},     // 
	".py":             {Icon: "\ued1b", Color: "#FED836"},     // 
	".pyc":            {Icon: "\ue606", Color: "#FFA61A"},     // 
	".pyd":            {Icon: "\ue606", Color: "#E3C58E"},     // 
	".pyi":            {Icon: "\ue606", Color: "#FFA61A"},     // 
	".pyo":            {Icon: "\ue606", Color: "#E3C58E"},     // 
	".pyw":            {Icon: "\ue606", Color: "#00AFFF"},     // 
	".pyx":            {Icon: "\ue606", Color: "#00AFFF"},     // 
	".qm":             {Icon: "\U000f05ca", Color: "#2596BE"}, // 󰗊
	".qml":            {Icon: "\uf375", Color: "#42CD52"},     // 
	".qrc":            {Icon: "\uf375", Color: "#40CD52"},     // 
	".qss":            {Icon: "\uf375", Color: "#40CD52"},     // 
	".query":          {Icon: "\ue21c", Color: "#90A850"},     // 
	".r":              {Icon: "\ue68a", Color: "#1976D3"},     // 
	".rake":           {Icon: "\ue791", Color: "#701516"},     // 
	".rakefile":       {Icon: "\ue21e", Color: "#C90F02"},     // 
	".rar":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".razor":          {Icon: "\uf1fa", Color: "#207245"},     // 
	".rb":             {Icon: "\U000f0d2d", Color: "#F54436"}, // 󰴭
	".rdata":          {Icon: "\uf25d", Color: "#458EE6"},     // 
	".rdb":            {Icon: "\ue76d", Color: "#C90F02"},     // 
	".rdoc":           {Icon: "\uf48a", Color: "#519ABA"},     // 
	".rds":            {Icon: "\uf25d", Color: "#458EE6"},     // 
	".readme":         {Icon: "\uf05a", Color: "#42A5F5"},     // 
	".res":            {Icon: "\ue688", Color: "#EF5351"},     // 
	".resi":           {Icon: "\ue688", Color: "#FFB300"},     // 
	".rlib":           {Icon: "\ue7a8", Color: "#DEA584"},     // 
	".rmd":            {Icon: "\ue68a", Color: "#1976D3"},     // 
	".rpm":            {Icon: "\ue7bb", Color: "#EE0000"},     // 
	".rproj":          {Icon: "\U000f05c6", Color: "#358A5B"}, // 󰗆
	".rs":             {Icon: "\ue68b", Color: "#FF7043"},     // 
	".rspec":          {Icon: "\ue21e", Color: "#C90F02"},     // 
	".rspec_parallel": {Icon: "\ue21e", Color: "#C90F02"},     // 
	".rspec_status":   {Icon: "\ue21e", Color: "#C90F02"},     // 
	".rss":            {Icon: "\uf09e", Color: "#965824"},     // 
	".rtf":            {Icon: "\U000f022c", Color: "#0188D1"}, // 󰈬
	".ru":             {Icon: "\ue21e", Color: "#C90F02"},     // 
	".rubydoc":        {Icon: "\ue73b", Color: "#C90F02"},     // 
	".s":              {Icon: "\ue637", Color: "#0091BD"},     // 
	".sass":           {Icon: "\ue603", Color: "#EC417A"},     // 
	".sbt":            {Icon: "\ue68d", Color: "#0277BD"},     // 
	".sc":             {Icon: "\ue68e", Color: "#F54436"},     // 
	".scad":           {Icon: "\uf34e", Color: "#F9D72C"},     // 
	".scala":          {Icon: "\ue68e", Color: "#F54436"},     // 
	".scm":            {Icon: "\U000f0627", Color: "#F54436"}, // 󰘧
	".scss":           {Icon: "\ue603", Color: "#EC417A"},     // 
	".sh":             {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".sha1":           {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".sha224":         {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".sha256":         {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".sha384":         {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".sha512":         {Icon: "\U000f0565", Color: "#8C86AF"}, // 󰕥
	".shell":          {Icon: "\ue795", Color: "#89E051"},     // 
	".sig":            {Icon: "\u03bb", Color: "#DC682E"},     // Λ
	".signature":      {Icon: "\u03bb", Color: "#DC682E"},     // Λ
	".skp":            {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".sldasm":         {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".sldprt":         {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".slim":           {Icon: "\ue692", Color: "#F57F19"},     // 
	".sln":            {Icon: "\U000f0610", Color: "#AB48BC"}, // 󰘐
	".slvs":           {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".sml":            {Icon: "\u03bb", Color: "#DC682E"},     // Λ
	".so":             {Icon: "\U000f107c", Color: "#42A5F5"}, // 󱁼
	".sol":            {Icon: "\ue656", Color: "#0188D1"},     // 
	".spec.js":        {Icon: "\uf499", Color: "#FFCA29"},     // 
	".spec.jsx":       {Icon: "\uf499", Color: "#FFCA29"},     // 
	".spec.ts":        {Icon: "\uf499", Color: "#519ABA"},     // 
	".spec.tsx":       {Icon: "\uf499", Color: "#0188D1"},     // 
	".sql":            {Icon: "\uf1c0", Color: "#CFCA99"},     // 
	".sqlite":         {Icon: "\uf1c0", Color: "#CFCA99"},     // 
	".sqlite3":        {Icon: "\uf1c0", Color: "#CFCA99"},     // 
	".srt":            {Icon: "\U000f0a16", Color: "#FFA61A"}, // 󰨖
	".ssa":            {Icon: "\U000f0a16", Color: "#FFA61A"}, // 󰨖
	".ste":            {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".step":           {Icon: "\U000f0eeb", Color: "#839463"}, // 󰻫
	".stl":            {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".stp":            {Icon: "\uea8c", Color: "#2AB6F6"},     // 
	".strings":        {Icon: "\U000f05ca", Color: "#2596BE"}, // 󰗊
	".sty":            {Icon: "\ue69b", Color: "#42A5F5"},     // 
	".styl":           {Icon: "\ue759", Color: "#C0CA33"},     // 
	".stylus":         {Icon: "\ue600", Color: "#83C837"},     // 
	".sub":            {Icon: "\U000f0a16", Color: "#FFA61A"}, // 󰨖
	".sublime":        {Icon: "\ue7aa", Color: "#DC682E"},     // 
	".suo":            {Icon: "\U000f0610", Color: "#AB48BC"}, // 󰘐
	".sv":             {Icon: "\U000f035b", Color: "#FF7043"}, // 󰍛
	".svelte":         {Icon: "\ue697", Color: "#FF5821"},     // 
	".svg":            {Icon: "\U000f0721", Color: "#FFB300"}, // 󰜡
	".svh":            {Icon: "\U000f035b", Color: "#FF7043"}, // 󰍛
	".swift":          {Icon: "\U000f06e5", Color: "#FE5E2F"}, // 󰛥
	".t":              {Icon: "\ue769", Color: "#519ABA"},     // 
	".tar":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".taz":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".tbc":            {Icon: "\U000f06d3", Color: "#005CA5"}, // 󰛓
	".tbz":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".tbz2":           {Icon: "\uf410", Color: "#ECA517"},     // 
	".tcl":            {Icon: "\U000f06d3", Color: "#EF5351"}, // 󰛓
	".templ":          {Icon: "\U000f05c0", Color: "#FFD550"}, // 󰗀
	".terminal":       {Icon: "\uf489", Color: "#14BA19"},     // 
	".test.js":        {Icon: "\uf499", Color: "#FFCA29"},     // 
	".test.jsx":       {Icon: "\uf499", Color: "#FFCA29"},     // 
	".test.ts":        {Icon: "\uf499", Color: "#519ABA"},     // 
	".test.tsx":       {Icon: "\uf499", Color: "#0188D1"},     // 
	".tex":            {Icon: "\ue69b", Color: "#42A5F5"},     // 
	".tf":             {Icon: "\ue69a", Color: "#5D6BC0"},     // 
	".tfvars":         {Icon: "\ue69a", Color: "#5D6BC0"},     // 
	".tgz":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".tiff":           {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".tlz":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".tmux":           {Icon: "\uebc8", Color: "#14BA19"},     // 
	".toml":           {Icon: "\ue6b2", Color: "#9C4221"},     // 
	".torrent":        {Icon: "\ue275", Color: "##4C90E8"},    // 
	".tres":           {Icon: "\ue65f", Color: "#42A5F5"},     // 
	".ts":             {Icon: "\U000f06e6", Color: "#0188D1"}, // 󰛦
	".tscn":           {Icon: "\ue65f", Color: "#42A5F5"},     // 
	".tsconfig":       {Icon: "\ue772", Color: "#EA8220"},     // 
	".tsv":            {Icon: "\U000f021b", Color: "#8BC34A"}, // 󰈛
	".tsx":            {Icon: "\ued46", Color: "#04BCD4"},     // 
	".ttf":            {Icon: "\ue659", Color: "#F54436"},     // 
	".twig":           {Icon: "\ue61c", Color: "#9BB92F"},     // 
	".txt":            {Icon: "\U000f0219", Color: "#42A5F5"}, // 󰈙
	".txz":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".typ":            {Icon: "\uf37f", Color: "#0DBCC0"},     // 
	".typoscript":     {Icon: "\ue772", Color: "#EA8220"},     // 
	".tz":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".tzo":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".ui":             {Icon: "\uf2d0", Color: "#015BF0"},     // 
	".v":              {Icon: "\ue6ac", Color: "#009CE5"},     // 
	".vala":           {Icon: "\ue8d1", Color: "#7B3DB9"},     // 
	".vh":             {Icon: "\U000f035b", Color: "#009900"}, // 󰍛
	".vhd":            {Icon: "\U000f035b", Color: "#FF7043"}, // 󰍛
	".vhdl":           {Icon: "\U000f035b", Color: "#009900"}, // 󰍛
	".video":          {Icon: "\uf03d", Color: "#626262"},     // 
	".vi":             {Icon: "\ue81e", Color: "#FEC60A"},     // 
	".vim":            {Icon: "\ue62b", Color: "#44A047"},     // 
	".vsh":            {Icon: "\ue6ac", Color: "#5D87BF"},     // 
	".vsix":           {Icon: "\U000f0a1e", Color: "#2296F3"}, // 󰨞
	".vue":            {Icon: "\ue6a0", Color: "#40B883"},     // 
	".war":            {Icon: "\ue256", Color: "#F54436"},     // 
	".wasm":           {Icon: "\ue6a1", Color: "#7D4DFF"},     // 
	".wav":            {Icon: "\U000f0386", Color: "#76B900"}, // 󰎆
	".webm":           {Icon: "\U000f0381", Color: "#FF9800"}, // 󰎁
	".webmanifest":    {Icon: "\ue60b", Color: "#CBCB41"},     // 
	".webp":           {Icon: "\U000f021f", Color: "#25A6A0"}, // 󰈟
	".webpack":        {Icon: "\U000f072b", Color: "#519ABA"}, // 󰜫
	".windows":        {Icon: "\uf17a", Color: "#00A4EF"},     // 
	".wma":            {Icon: "\U000f0386", Color: "#EE534F"}, // 󰎆
	".woff":           {Icon: "\ue659", Color: "#F54436"},     // 
	".woff2":          {Icon: "\ue659", Color: "#F54436"},     // 
	".wrl":            {Icon: "\U000f01a7", Color: "#778899"}, // 󰆧
	".wrz":            {Icon: "\U000f01a7", Color: "#778899"}, // 󰆧
	".wv":             {Icon: "\uf001", Color: "#00AFFF"},     // 
	".wvc":            {Icon: "\uf001", Color: "#00AFFF"},     // 
	".x":              {Icon: "\ue691", Color: "#599EFF"},     // 
	".xaml":           {Icon: "\U000f0673", Color: "#42A5F5"}, // 󰙳
	".xcf":            {Icon: "\uf338", Color: "#635b46"},     // 
	".xcplayground":   {Icon: "\ue755", Color: "#DC682E"},     // 
	".xcstrings":      {Icon: "\U000f05ca", Color: "#2596BE"}, // 󰗊
	".xhtml":          {Icon: "\uf13b", Color: "#E44E27"},     // 
	".xls":            {Icon: "\U000f021b", Color: "#8BC34A"}, // 󰈛
	".xlsx":           {Icon: "\U000f021b", Color: "#8BC34A"}, // 󰈛
	".xm":             {Icon: "\ue691", Color: "#519ABA"},     // 
	".xml":            {Icon: "\U000f022e", Color: "#8BC34A"}, // 󰈮
	".xpi":            {Icon: "\ueae6", Color: "#375A8E"},     // 
	".xul":            {Icon: "\uf121", Color: "#DC682E"},     // 
	".xz":             {Icon: "\uf410", Color: "#ECA517"},     // 
	".yaml":           {Icon: "\ue6a8", Color: "#a074b3"},     // 
	".yml":            {Icon: "\ue6a8", Color: "#a074b3"},     // 
	".zig":            {Icon: "\ue6a9", Color: "#FAA825"},     // 
	".zip":            {Icon: "\uf410", Color: "#ECA517"},     // 
	".zsh":            {Icon: "\U000f018d", Color: "#FF7043"}, // 󰆍
	".zsh-theme":      {Icon: "\ue795", Color: "#89E051"},     // 
	".zshrc":          {Icon: "\ue795", Color: "#89E051"},     // 
	".zst":            {Icon: "\uf410", Color: "#ECA517"},     // 
}

func patchFileIconsForNerdFontsV2() {
	extIconMap[".cs"] = IconProperties{Icon: "\uf81a", Color: "#FEDECA"}      // 
	extIconMap[".csproj"] = IconProperties{Icon: "\uf81a", Color: "#AB48BC"}  // 
	extIconMap[".csx"] = IconProperties{Icon: "\uf81a", Color: "#0188D1"}     // 
	extIconMap[".license"] = IconProperties{Icon: "\uf718", Color: "#626262"} // 
	extIconMap[".node"] = IconProperties{Icon: "\uf898", Color: "#E8274B"}    // 
	extIconMap[".rtf"] = IconProperties{Icon: "\uf718", Color: "#626262"}     // 
	extIconMap[".vue"] = IconProperties{Icon: "\ufd42", Color: "#89e051"}     // ﵂
}

func IconForFile(name string, isSubmodule bool, isLinkedWorktree bool, isDirectory bool) IconProperties {
	base := filepath.Base(name)
	if icon, ok := nameIconMap[base]; ok {
		return icon
	}

	ext := strings.ToLower(filepath.Ext(name))
	if icon, ok := extIconMap[ext]; ok {
		return icon
	}

	if isSubmodule {
		return DEFAULT_SUBMODULE_ICON
	} else if isLinkedWorktree {
		return IconProperties{LINKED_WORKTREE_ICON, "#4E4E4E"}
	} else if isDirectory {
		return DEFAULT_DIRECTORY_ICON
	}
	return DEFAULT_FILE_ICON
}
