(require 'cider)

(ert-deftest test-cider-extract-error-info-14 ()
  (let ((message "CompilerException java.lang.RuntimeException: Unable to resolve symbol: dummy in this context, compiling:(/some/test/file/core.clj:31)"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (string= (nth 0 info) "/some/test/file/core.clj"))
      (should (= (nth 1 info) 31))
      (should (equal (nth 2 info) nil))
      (should (equal (nth 3 info) 'cider-error-highlight-face)))))

(ert-deftest test-cider-extract-error-info-14-no-file ()
  (let ((message "CompilerException java.lang.RuntimeException: Unable to resolve symbol: dummy in this context, compiling:(NO_SOURCE_PATH:31)"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (equal (nth 0 info) nil))
      (should (= (nth 1 info) 31))
      (should (equal (nth 2 info) nil))
      (should (equal (nth 3 info) 'cider-error-highlight-face)))))

(ert-deftest test-cider-extract-warning-info-14 ()
  (let ((message "Reflection warning, /some/othertest/file/core.clj:24 - reference to field getCanonicalPath can't be resolved.
"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (string= (nth 0 info) "/some/othertest/file/core.clj"))
      (should (= (nth 1 info) 24))
      (should (equal (nth 2 info) nil))
      (should (equal (nth 3 info) 'cider-warning-highlight-face)))))

(ert-deftest test-cider-extract-warning-info-14-no-file ()
  (let ((message "Reflection warning, NO_SOURCE_PATH:24 - reference to field getCanonicalPath can't be resolved.
"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (equal (nth 0 info) nil))
      (should (= (nth 1 info) 24))
      (should (equal (nth 2 info) nil))
      (should (equal (nth 3 info) 'cider-warning-highlight-face)))))

(ert-deftest test-cider-extract-error-info-15 ()
  (let ((message "CompilerException java.lang.RuntimeException: Unable to resolve symbol: dummy in this context, compiling:(/some/test/file/core.clj:31:3)"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (string= (nth 0 info) "/some/test/file/core.clj"))
      (should (= (nth 1 info) 31))
      (should (= (nth 2 info) 3))
      (should (equal (nth 3 info) 'cider-error-highlight-face)))))

(ert-deftest test-cider-extract-error-info-15-no-file ()
  (let ((message "CompilerException java.lang.RuntimeException: Unable to resolve symbol: dummy in this context, compiling:(NO_SOURCE_PATH:31:3)"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (equal (nth 0 info) nil))
      (should (= (nth 1 info) 31))
      (should (= (nth 2 info) 3))
      (should (equal (nth 3 info) 'cider-error-highlight-face)))))

(ert-deftest test-cider-extract-warning-info-15 ()
  (let ((message "Reflection warning, /some/othertest/file/core.clj:24:43 - reference to field getCanonicalPath can't be resolved.
"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (string= (nth 0 info) "/some/othertest/file/core.clj"))
      (should (= (nth 1 info) 24))
      (should (= (nth 2 info) 43))
      (should (equal (nth 3 info) 'cider-warning-highlight-face)))))

(ert-deftest test-cider-extract-warning-info-15-no-file ()
  (let ((message "Reflection warning, NO_SOURCE_PATH:24:43 - reference to field getCanonicalPath can't be resolved.
"))
    (let ((info (cider-extract-error-info cider-compilation-regexp message)))
      (should (equal (nth 0 info) nil))
      (should (= (nth 1 info) 24))
      (should (= (nth 2 info) 43))
      (should (equal (nth 3 info) 'cider-warning-highlight-face)))))
