# Migration `watch-20200414152651`

This migration has been generated by timsuchanek at 4/14/2020, 3:26:53 PM.
You can check out the [state of the schema](./schema.prisma) after the migration.

## Database Steps

```sql
CREATE TYPE "Sentiment" AS ENUM ('Happy', 'Unhappy');

CREATE TABLE "docs-feedback"."Feedback" (
    "createdAt" timestamp(3)  NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "id" SERIAL,
    "ip" text  NOT NULL ,
    "pageUrl" text  NOT NULL ,
    "sentiment" "Sentiment" NOT NULL ,
    "userAgent" text  NOT NULL ,
    PRIMARY KEY ("id")
) 
```

## Changes

```diff
diff --git schema.prisma schema.prisma
migration ..watch-20200414152651
--- datamodel.dml
+++ datamodel.dml
@@ -1,0 +1,18 @@
+datasource db {
+  provider = "postgresql"
+  url      = env("POSTGRES_URL")
+}
+
+model Feedback {
+  id        Int       @default(autoincrement()) @id
+  pageUrl   String
+  userAgent String
+  ip        String
+  sentiment Sentiment
+  createdAt DateTime  @default(now())
+}
+
+enum Sentiment {
+  Happy
+  Unhappy
+}
```


