---
title: args
---

## args

[GraphQL Docs on Arguments](https://graphql.org/learn/schema/#arguments)

`arg`, `intArg`, `stringArg`, `floatArg`, `idArg`, `booleanArg`

Defines an argument that can be used in any object or interface type. Args can be reused in multiple locations, and it can be convenient to create your own wrappers around arguments.

```ts
import { intArg, core } from '@nexus/schema'

function requiredInt(opts: core.ScalarArgConfig<number>) {
  return intArg({ ...opts, required: true })
}
```

&nbsp;

Common options available for `arg` include the following:

**Required**

Whether the argument is required or not.

Format: `required?: boolean;`

Note, when `required: true`, `nullable: false`

&nbsp;

**Nullable**

Whether the argument is nullable or not.

Format: `nullable?: boolean;`

Note, when `nullable: true`, `required: false`

&nbsp;

**List**

Whether the argument is a list or not.

Format: `list?: null | true | boolean[];`

null = not a list

true = list

array = nested list, where true/false decides whether the list member can be nullable

&nbsp;

**Description**

The description to annotate the GraphQL SDL

Format: `description?: string | null;`
