Welcome to _the_ Nexus tutorial! If you're new to Nexus and want a guided learning journey, this is the place! Through a handful of chapters we're going to be building just enough of a blog to give you an overview of Nexus; what it is and what it can do.

This tutorial is still under construction. Some chapters will continue to be refined and more added. If you're looking for our old tutorial content, it can still be found [here](/getting-started/tutorial).

## Assumed Tools

Throughout this journey, we'll be making a few minor assumptions about your toolchain to keep the content flowing:

- Using `npm` as the package manager.
- Using a \*nix OS
- Using VSCode

If you're using another set of tools, like Yarn on Windows with Sublime Text, that's totally fine and welcome! Just know that at you'll occasionally need to adapt minor instructions to your situation.

## Conventions

There's a few conventions used throughout this tutorial that you should know about.

- **Annotated Code Blocks**

  Most Code Blocks are explained with annotations. Take the following for example. Immediately following the codeblock are numbered points. Each corresponds to a line annotated with that number in the code block.

  <!-- prettier-ignore -->
  ```ts
  const a = 1 as const // 1

  interface A {}       // 2
  interface A {}       // 2

  const b: any = 1     // 3
  ```

  1. Use `as const` to make TS take the narrowest inference. Here `1` vs `number`.
  2. Same-named interfaces will merge into one.
  3. Use `any` to effectively disable type-checking

- **Auxiliary Content**

  Sometimes content that isn't core to the current flow but related to it will be mentioned. That looks like so:

  > Hello there, have a nice day!

## Copy-Pasting

As you progress you'll be writing code, of course. Often you'll have the chance to copy and paste our code, but we strongly suggest if you're just starting out to **write the code yourself**. This will expose you to _experience_ of writing a Nexus app. Things like autocompletion and letting static safety guide your implementations, e.g. inside a GraphQL resolver. Also if you're new to TypeScript getting used to encountering, understanding, and fixing static type errors is essential practice. That said at no time should you feel _frustrated_. If things just aren't working, copy-paste our work as needed. Then, once things _are_ working, taking a momemnt muck around, break things, fix them again, etc. is almost always time well spent.

## Wrapping Up

Thanks for checking out Nexus, we hope you're as excited<br>to learn about it as we are to show it to you! :rocket:

<div class="NextIs NextChapter"></div>

[➳](/tutorial/chapter-1-setup-and-first-query)
