# Chapter 1 <br> Setup & First Query {docsify-ignore}

In this first chapter we're just going to get the bare minimum of a Nexus project setup. You'll learn about:

- The `nexus` package
- The Nexus CLI
- Laying out and running a Nexus project
- GraphQL Playground

## CLI

Start by creating your project directory, initializing your `package.json`, and adding the `nexus` dependency.

```bash
mkdir nexus-tutorial && cd nexus-tutorial
npm init -y
npm add nexus
```

Nexus comes out of the box with a CLI. You'll use it often while working on your app. While you can access the CLI of your local nexus via `yarn` or npm scripts or `npx` but there's an even easier way. Install `nexus` globally. Then you can access the CLI from anywhere. Nexus is smart enough to delegate all invocations to the _local_ nexus. This is the idiomatic way to work with Nexus, but you aren't forced to do this.

```markdown
npm add --global nexus
```

There are just two CLI commands you need to know about right now:

- `nexus dev` : This command starts a development server in watch mode. Every time you change a file, your app will be restarted.
- `nexus build` : This command builds a "production-ready" server, ready to be deployed.

> Another is `nexus create app` which will scaffold a new Nexus project for you. That is how you should _normally_ start your Nexus projects. We're avoiding it in this tutorial so that you can learn the basics from the ground up.

Despite having the global Nexus CLI, using package scripts can be a handy way of self-documenting your project's workflows. So feel free to add the following scripts to your `package.json`. If you work with team members this can help streamline collaboration.

```json
"scripts": {
  "dev": "nexus dev",
  "build": "nexus build"
}
```

## Conventional Entrypoint

We'll now create our first module at `api/app.ts`:

```bash
mkdir api && touch api/app.ts
```

The directory name `api` is arbitrary but the module name `app` has special meaning. Nexus will find `app.ts` wherever you put it within your project and treat it as your entrypoint. Furthermore, every module that imports `nexus` will be automatically included into the final build by Nexus. This makes growing and refactoring your project easy as you are freed from managing import/export tedium. You might be wondering how import order is managed. The answer is that Nexus' APIs are declarative and so designed to be order independent.

## Contextual Feedback

Ok, with our entrypoint setup, let's boot up dev mode and see what happens.

```bash
nexus dev
```

Woops? You should be seeing a warning from Nexus:

```bash
▲ nexus:schema Your GraphQL schema is empty. [...]
```

All good, you indeed haven't added any types to your GraphQL schema yet so Nexus is right here. This is the first example of Nexus' rich development mode contextual feedback. One of the goals of Nexus is to never leave you in a confused disoriented state. If Nexus can give you in inline feedback it should. Add rich jsDoc and precise TypeScript types into the mix, and ideally you can largely avoid getting lost and _needing_ to consult the Nexus website, community, so on.

## Try It Out

Aside from the warning, you should also see a message indicating that your server is running, and where.

```bash
● nexus:server listening  --  url: 'http://localhost:4000/'
```

Open it up, what do you see? It should be an instance of [GraphQL Playground](https://github.com/prisma-labs/graphql-playground).

![image](https://user-images.githubusercontent.com/284476/83534302-ae1b7d00-a4be-11ea-9a13-2665bf152e2a.png)

This is a graphical user interface for interacting with GraphQL APIs. If you prefer you can run a [standalone](https://www.electronjs.org/apps/graphql-playground) version as an app on your machine, or another GraphQL GUI entirely. Nexus ships with one out of the box for your convenience.

Take a look at the right-hand side SCHEMA tab. There you'll see a default schema that Nexus has provided for you. This, along with the warning you say before, will go away once you begin your own schema.

## Wrapping Up

That's it! In the next chapter you'll begin working on your app's schema.

<div class="NextIs NextChapter"></div>

[➳](/tutorial/chapter-2-writing-your-first-schema)
