Defines a way to incrementally build types, by "extending" a type from multiple locations in a project. Useful in situations where you have types split across multiple domains, each of which should add fields to a single type (like the "Query" root).

```ts
export const AddUserById = extendType({
  type: 'Query',
  definition: (t) => {
    t.field('userById', {
      type: 'User',
      args: { id: intArg('id of the user') },
      resolve: (root, args, ctx) => ctx.user.getById(args.id),
    })
  },
})

// elsewhere...

export const AddPostById = extendType({
  type: 'Query',
  definition: (t) => {
    t.field('postById', {
      type: 'Post',
      args: { id: intArg('id of the post') },
      resolve: (root, args, ctx) => ctx.post.getById(args.id),
    })
  },
})
```

A similar `extendInputType` is available for extending input types.
