# `/testing`

## `createTestContext`

Setup a test context providing utilities to query against your GraphQL API.

This context can be augmented by plugins.

##### Signature

```ts
function createTestContext(opts?: CreateTestContextOptions): Promise<TestContext>
```

##### Example With Jest

```ts
import { TestContext, createTestContext } from 'nexus/testing'

let ctx: TestContext

beforeAll(async () => {
  Object.assign(ctx, await createTestContext())
  await ctx.app.start()
})

afterAll(async () => {
  await ctx.app.stop()
})

test('hello', async () => {
  const result = await ctx.client.send(`{ hello }`)

  expect(result).toMatchInlineSnapshot()
})
```

## `I` CreateTestContextOptions

```ts
export interface CreateTestContextOptions {
  /**
   * A path to the entrypoint of your app. Only necessary if the entrypoint falls outside of Nexus convention.
   * You should typically use this if you're using `nexus dev --entrypoint` or `nexus build --entrypoint`.
   */
  entrypointPath?: string
}
```

## `I` `TestContext`

```ts
export interface TestContext {
  client: {
    send: <T>(query: string, variables: Record<string, any>): Promise<T>
    headers: {
      set(headers: Record<string, string>): void
      set(name: string, value: string): void
      set(header: [string, string]): void
      add(headers: Record<string, string>): void
      add(name: string, value: string): void
      add(header: [string, string]): void
      del(name: string): void
      get(name: string): null | string
      has(name: string): boolean
      entries(): [string,string][]
    }
  }
  app: {
    server: {
      start: () => Promise<void>
      stop: () => Promise<void>
    }
  }
}
```
