# `import { server }`

[issues](https://nxs.li/issues/component/server) / [features](https://nxs.li/issues/components/server/features) | [bugs](https://nxs.li/issues/component/server/bugs)

Use the server to run the HTTP server that clients will connect to.

### `express`

Gives you access to the underlying `express` instance.

Use this to add middlewares or expose additional REST endpoints if needed.

##### Example of using middlewares

```ts
import cors from 'cors'
import { server } from 'nexus'

server.express.use(cors())
```

### `raw.http`

The underlying [Node HTTP Server](https://nodejs.org/api/http.html#http_class_http_server) instance.

Access to this is made available mostly as an escape hatch, and maybe a few valid advanced use-cases. If you haven't already/are not sure, consider [opening an issue](https://nxs.li/issues/create/feature) for your use-case. Maybe Nexus can and should provide better first-class support for what you are trying to do!
