# Welcome To Nexus {docsify-ignore}

<p class='NextIs Note'></p>

Nexus is a Node.js code-first GraphQL framework. It has a clean simple intuitive declarative API built from the ground to support autocompletion, type-safety, great jsDoc, and more out of the box. It leverages the TypeScript compiler API and its own sophisticated development mode to give you next-geneation levels of type safety and productivity. Add a powerful plugin system into the mix and what you get is a tool with a very low floor yet practically limitless ceiling.

Nexus is young, but its ready to grow with you. Dive in!

[Discussions](https://github.com/graphql-nexus/nexus/discussions) // [Issues](https://github.com/graphql-nexus/nexus/issues) // [Tweets](https://twitter.com/nexusgql) // [Changelog](https://github.com/graphql-nexus/nexus/releases) ([canary](https://github.com/graphql-nexus/nexus/releases/tag/next)) // [Repo](https://github.com/graphql-nexus/nexus)

## Goals

- It leverages TypeScript and its type system to unlock rich patterns that help you safely scale, maintain and test your GraphQL API.
- The development server that's running as you build your API ensures that you always get auto-completion and error checks for the schema changes you just introduced.
- Its API is designed with care to be as declarative as possible so that your schema stays readable despite being implemented with code.
- Its unconventional plugin system also enables the creation of "end-to-end plugins" which enhance not only Nexus at runtime, but also the CLI and many framework workflows such as dev mode and testing.
- On that matter, **Nexus has an official Prisma plugin** that will help you wire your GraphQL API to a database. Prisma is an [open source](https://github.com/prisma/prisma) database toolkit that currently consists of an auto-generated type-safe query builder, declarative data model language, and experimental migration system.

## Highlights

- **Type-safety by default** - Take advantage of TypeScript without the hassle of type annotations everywhere
- **GraphQL Server included** - We manage the GraphQL server for you while letting you control it
- **Bundled CLI for development workflows** - Develop, test and build your app using our CLI
- **Reusable modules** - Leverage your programming language to reuse parts of your GraphQL schema
- **Scalable** - Split your GraphQL schema by features to horizontally scale as your project grows
- **Testable** - Nexus includes tooling to run integration tests against your API
- **Zero config** - Thanks to conventions over configuration, get up and running quickly without the hassle of configuring anything
- **Batteries included (DB, rate limiting, relay connections, custom scalars, ...)** - We've got you covered beyond the to-do app
- **Readable** - Implement your schema with code, read it with the autogenerated GraphQL SDL file
- **Pluggable** - Make use of the Nexus plugin ecosystem or create yours to enhance the default experience
- **No lock-in** - Buying into a framework can be scary. We make sure you've got the right escape hatches

## Why

Nexus, the framework, is built on top of a great library called Nexus _Schema_, built by [Tim Griesser](https://github.com/tgriesser).

« Nexus Schema was born out of my experience building several production GraphQL APIs, in different languages and frameworks. The first with vanilla [graphql-js](https://github.com/graphql/graphql-js), another schema-first with [graph.ql](https://github.com/matthewmueller/graph.ql) and later [graphql-tools](https://github.com/apollographql/graphql-tools). Following that with [graphene-python](https://docs.graphene-python.org/en/latest/) and most recently with a bit of [graphql-ruby](http://graphql-ruby.org/).

After working with the toolkits in other scripting languages, it felt like there was a gap in the JavaScript approaches. Schema-first development starts out great, by simply expressing your schema in the GraphQL Schema Definition Language (SDL) and providing resolvers matching to the types as needed you are up and running fast! No need for tons of requires or "overhead" to get a GraphQL server running.

As your schema then grows to hundreds or thousands of types, manually curating these SDL fragments becomes tedious. Documentation changes can be tough. Modifying fields on interfaces can require manual changes to many implementing types, a process that can be quite error prone.

_If only there were a way to combine the simplicity of schema-first development, with the long-term maintainability of a definition-first approach._

Nexus Schema aims to fill that void, making the process as simple as possible while also making good use of the runtime to introduce powerful ways of composing types, introducing type or schema wide changes, and much more.

The core idea of Nexus Schema draws from basing the schema off the SDL - keeping things declarative and simple to understand. For example it allows you to reference the type names as string literals rather than always need to import to reference types (but, you can do that too if you prefer).

By combining automatic type generation with some of the more powerful features of TypeScript - type merging, conditional types, and type inference, we can know exactly which type names we are referring to and able to use throughout our code. We can know both the parameters and the return type of resolvers without providing any type annotation. It takes a little getting used to, but it ends up leading to a great feedback loop of the types annotating themselves. » — _Tim Griesser_

The complex mechanisms on which Nexus Schema relies turned out to produce a lot of friction to the daily workflows that people have to deal with when working with it.

Nexus, the framework, is a natural continuation of that vision built by Tim Griesser which aims to make Nexus Schema more accessible to everyone by hiding some of the underlying complexity of the system and by trying to push users into the pit of success.

## Pre-requisites

Having a decent understanding of GraphQL and a bit of familiarity with TypeScript may help you adopt Nexus. If you like to dive in and learn on the fly feel free to do so, but if you do want to build up some pre-requisite knowledge upfront then the following resources may be of interest.

_GraphQL_

- [How to GraphQL](https://www.howtographql.com)
- [Production Ready GraphQL](https://book.productionreadygraphql.com/)
- [Official GraphQL website](https://graphql.org) ([community resources](https://graphql.org/community/))

_TypeScript_

- [The New Handbook](https://microsoft.github.io/TypeScript-New-Handbook/everything/)
- [The Interactive Playground](http://www.typescriptlang.org/play)
- [Dozens of articles](https://mariusschulz.com/blog) by [Marius Schulz](https://github.com/mariusschulz)
- [Dozens of articles](https://2ality.com/index.html) by [Dr. Axel Rauschmayer](https://github.com/rauschma)

## Diving In

- Go through the [tutorial](/tutorial/introduction)
- Explore the [examples repo](https://github.com/graphql-nexus/examples)
- Explore your own first app by running `npx nexus`
