"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[2908],{9644:(e,t,c)=>{c.r(t),c.d(t,{assets:()=>o,contentTitle:()=>r,default:()=>u,frontMatter:()=>s,metadata:()=>i,toc:()=>h});var n=c(5893),a=c(1151);const s={title:"Query Cache",slug:"query-cache.html"},r="QueryCache",i={id:"query-cache",title:"Query Cache",description:"RxDB uses a QueryCache which optimizes the reuse of queries at runtime. This makes sense especially when RxDB is used in UI-applications where people move for- and backwards on different routes or pages and the same queries are used many times. Because of the event-reduce algorithm cached queries are even valuable for optimization, when changes to the database occur between now and the last execution.",source:"@site/docs/query-cache.md",sourceDirName:".",slug:"/query-cache.html",permalink:"/query-cache.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/query-cache.md",tags:[],version:"current",frontMatter:{title:"Query Cache",slug:"query-cache.html"},sidebar:"tutorialSidebar",previous:{title:"Middleware",permalink:"/middleware.html"},next:{title:"CRDT - Conflict-free replicated data type",permalink:"/crdt.html"}},o={},h=[{value:"Cache Replacement Policy",id:"cache-replacement-policy",level:2},{value:"The default policy",id:"the-default-policy",level:2},{value:"Other references to queries",id:"other-references-to-queries",level:2},{value:"Using a custom policy",id:"using-a-custom-policy",level:2}];function l(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",ul:"ul",...(0,a.a)(),...e.components};return(0,n.jsxs)(n.Fragment,{children:[(0,n.jsx)(t.h1,{id:"querycache",children:"QueryCache"}),"\n",(0,n.jsxs)(t.p,{children:["RxDB uses a ",(0,n.jsx)(t.code,{children:"QueryCache"})," which optimizes the reuse of queries at runtime. This makes sense especially when RxDB is used in UI-applications where people move for- and backwards on different routes or pages and the same queries are used many times. Because of the ",(0,n.jsx)(t.a,{href:"https://github.com/pubkey/event-reduce",children:"event-reduce algorithm"})," cached queries are even valuable for optimization, when changes to the database occur between now and the last execution."]}),"\n",(0,n.jsx)(t.h2,{id:"cache-replacement-policy",children:"Cache Replacement Policy"}),"\n",(0,n.jsxs)(t.p,{children:["To not let RxDB fill up all the memory, a ",(0,n.jsx)(t.code,{children:"cache replacement policy"})," is defined that clears up the cached queries. This is implemented as a function which runs regularly, depending on when queries are created and the database is idle. The default policy should be good enough for most use cases but defining custom ones can also make sense."]}),"\n",(0,n.jsx)(t.h2,{id:"the-default-policy",children:"The default policy"}),"\n",(0,n.jsx)(t.p,{children:"The default policy starts cleaning up queries depending on how much queries are in the cache and how much document data they contain."}),"\n",(0,n.jsxs)(t.ul,{children:["\n",(0,n.jsx)(t.li,{children:"It will never uncache queries that have subscribers to their results"}),"\n",(0,n.jsx)(t.li,{children:"It tries to always have less than 100 queries without subscriptions in the cache."}),"\n",(0,n.jsx)(t.li,{children:"It prefers to uncache queries that have never executed and are older then 30 seconds"}),"\n",(0,n.jsx)(t.li,{children:"It prefers to uncache queries that have not been used for longer time"}),"\n"]}),"\n",(0,n.jsx)(t.h2,{id:"other-references-to-queries",children:"Other references to queries"}),"\n",(0,n.jsxs)(t.p,{children:["With JavaScript, it is not possible to count references to variables. Therefore it might happen that an uncached ",(0,n.jsx)(t.code,{children:"RxQuery"})," is still referenced by the users code and used to get results. This should never be a problem, uncached queries must still work. Creating the same query again however, will result in having two ",(0,n.jsx)(t.code,{children:"RxQuery"})," instances instead of one."]}),"\n",(0,n.jsx)(t.h2,{id:"using-a-custom-policy",children:"Using a custom policy"}),"\n",(0,n.jsxs)(t.p,{children:["A cache replacement policy is a normal JavaScript function according to the type ",(0,n.jsx)(t.code,{children:"RxCacheReplacementPolicy"}),".\nIt gets the ",(0,n.jsx)(t.code,{children:"RxCollection"})," as first parameter and the ",(0,n.jsx)(t.code,{children:"QueryCache"})," as second. Then it iterates over the cached ",(0,n.jsx)(t.code,{children:"RxQuery"})," instances and uncaches the desired ones with ",(0,n.jsx)(t.code,{children:"uncacheRxQuery(rxQuery)"}),". When you create your custom policy, you should have a look at the ",(0,n.jsx)(t.a,{href:"https://github.com/pubkey/rxdb/blob/master/src/query-cache.ts",children:"default"}),"."]}),"\n",(0,n.jsxs)(t.p,{children:["To apply a custom policy to a ",(0,n.jsx)(t.code,{children:"RxCollection"}),", add the function as attribute ",(0,n.jsx)(t.code,{children:"cacheReplacementPolicy"}),"."]}),"\n",(0,n.jsx)(t.pre,{children:(0,n.jsx)(t.code,{className:"language-ts",children:"const collection = await myDatabase.addCollections({\n    humans: {\n        schema: mySchema,\n        cacheReplacementPolicy: function(){ /* ... */ }\n    }\n});\n"})})]})}function u(e={}){const{wrapper:t}={...(0,a.a)(),...e.components};return t?(0,n.jsx)(t,{...e,children:(0,n.jsx)(l,{...e})}):l(e)}},1151:(e,t,c)=>{c.d(t,{Z:()=>i,a:()=>r});var n=c(7294);const a={},s=n.createContext(a);function r(e){const t=n.useContext(s);return n.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function i(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:r(e.components),n.createElement(s.Provider,{value:t},e.children)}}}]);