"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[4431],{7798:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>c,contentTitle:()=>s,default:()=>h,frontMatter:()=>i,metadata:()=>r,toc:()=>l});var a=n(5893),o=n(1151);const i={title:"Migration Schema",slug:"migration-schema.html"},s="Migrate Database Data on schema changes",r={id:"migration-schema",title:"Migration Schema",description:"The RxDB Data Migration Plugin helps developers easily update stored data in their apps when they make changes to the data structure by changing the schema of a RxCollection. This is useful when developers release a new version of the app with a different schema.",source:"@site/docs/migration-schema.md",sourceDirName:".",slug:"/migration-schema.html",permalink:"/migration-schema.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/migration-schema.md",tags:[],version:"current",frontMatter:{title:"Migration Schema",slug:"migration-schema.html"},sidebar:"tutorialSidebar",previous:{title:"NATS Replication",permalink:"/replication-nats.html"},next:{title:"Migration Storage",permalink:"/migration-storage.html"}},c={},l=[{value:"Providing strategies",id:"providing-strategies",level:2},{value:"autoMigrate",id:"automigrate",level:2},{value:"migrationStates()",id:"migrationstates",level:2},{value:"Migrating attachments",id:"migrating-attachments",level:2},{value:"Migration on multi-tab in browsers",id:"migration-on-multi-tab-in-browsers",level:2},{value:"Migration and Replication",id:"migration-and-replication",level:2}];function d(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",p:"p",pre:"pre",strong:"strong",...(0,o.a)(),...e.components};return(0,a.jsxs)(a.Fragment,{children:[(0,a.jsx)(t.h1,{id:"migrate-database-data-on-schema-changes",children:"Migrate Database Data on schema changes"}),"\n",(0,a.jsxs)(t.p,{children:["The RxDB Data Migration Plugin helps developers easily update stored data in their apps when they make changes to the data structure by changing the schema of a ",(0,a.jsx)(t.a,{href:"/rx-collection.html",children:"RxCollection"}),". This is useful when developers release a new version of the app with a different schema."]}),"\n",(0,a.jsxs)(t.p,{children:["Imagine you have your awesome messenger-app distributed to many users. After a while, you decide that in your new version, you want to change the schema of the messages-collection. Instead of saving the message-date like ",(0,a.jsx)(t.code,{children:"2017-02-12T23:03:05+00:00"})," you want to have the unix-timestamp like ",(0,a.jsx)(t.code,{children:"1486940585"})," to make it easier to compare dates. To accomplish this, you change the schema and ",(0,a.jsx)(t.strong,{children:"increase the version-number"})," and you also change your code where you save the incoming messages. But one problem remains: what happens with the messages which are already stored in the database on the user's device in the old schema?"]}),"\n",(0,a.jsx)(t.p,{children:"With RxDB you can provide migrationStrategies for your collections that automatically (or on call) transform your existing data from older to newer schemas. This assures that the client's data always matches your newest code-version."}),"\n",(0,a.jsx)(t.h1,{id:"add-the-migration-plugin",children:"Add the migration plugin"}),"\n",(0,a.jsxs)(t.p,{children:["To enable the data migration, you have to add the ",(0,a.jsx)(t.code,{children:"migration-schema"})," plugin."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-ts",children:"import { addRxPlugin } from 'rxdb';\nimport { RxDBMigrationPlugin } from 'rxdb/plugins/migration-schema';\naddRxPlugin(RxDBMigrationPlugin);\n"})}),"\n",(0,a.jsx)(t.h2,{id:"providing-strategies",children:"Providing strategies"}),"\n",(0,a.jsxs)(t.p,{children:["Upon creation of a collection, you have to provide migrationStrategies when your schema's version-number is greater than ",(0,a.jsx)(t.code,{children:"0"}),". To do this, you have to add an object to the ",(0,a.jsx)(t.code,{children:"migrationStrategies"})," property where a function for every schema-version is assigned. A migrationStrategy is a function which gets the old document-data as a parameter and returns the new, transformed document-data. If the strategy returns ",(0,a.jsx)(t.code,{children:"null"}),", the document will be removed instead of migrated."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"myDatabase.addCollections({\n  messages: {\n    schema: messageSchemaV1,\n    migrationStrategies: {\n      // 1 means, this transforms data from version 0 to version 1\n      1: function(oldDoc){\n        oldDoc.time = new Date(oldDoc.time).getTime(); // string to unix\n        return oldDoc;\n      }\n    }\n  }\n});\n"})}),"\n",(0,a.jsx)(t.p,{children:"Asynchronous strategies can also be used:"}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"myDatabase.addCollections({\n  messages: {\n    schema: messageSchemaV1,\n    migrationStrategies: {\n      1: function(oldDoc){\n        oldDoc.time = new Date(oldDoc.time).getTime(); // string to unix\n        return oldDoc;\n      },\n      /**\n       * 2 means, this transforms data from version 1 to version 2\n       * this returns a promise which resolves with the new document-data\n       */\n      2: function(oldDoc){\n        // in the new schema (version: 2) we defined 'senderCountry' as required field (string)\n        // so we must get the country of the message-sender from the server\n        const coordinates = oldDoc.coordinates;\n        return fetch('http://myserver.com/api/countryByCoordinates/'+coordinates+'/')\n          .then(response => {\n            const response = response.json();\n            oldDoc.senderCountry = response;\n            return oldDoc;\n          });\n      }\n    }\n  }\n});\n"})}),"\n",(0,a.jsx)(t.p,{children:"you can also filter which documents should be migrated:"}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-js",children:"myDatabase.addCollections({\n  messages: {\n    schema: messageSchemaV1,\n    migrationStrategies: {\n      // 1 means, this transforms data from version 0 to version 1\n      1: function(oldDoc){\n        oldDoc.time = new Date(oldDoc.time).getTime(); // string to unix\n        return oldDoc;\n      },\n      /**\n       * this removes all documents older then 2017-02-12\n       * they will not appear in the new collection\n       */\n      2: function(oldDoc){\n        if(oldDoc.time < 1486940585) return null;\n        else return oldDoc;\n      }\n    }\n  }\n});\n"})}),"\n",(0,a.jsx)(t.h2,{id:"automigrate",children:"autoMigrate"}),"\n",(0,a.jsxs)(t.p,{children:["By default, the migration automatically happens when the collection is created. Calling ",(0,a.jsx)(t.code,{children:"RxDatabase.addRxCollections()"})," returns only when the migration has finished.\nIf you have lots of data or the migrationStrategies take a long time, it might be better to start the migration 'by hand' and show the migration-state to the user as a loading-bar."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const messageCol = await myDatabase.addCollections({\n  messages: {\n    schema: messageSchemaV1,\n    autoMigrate: false, // <- migration will not run at creation\n    migrationStrategies: {\n      1: async function(oldDoc){\n        ...\n        anything that takes very long\n        ...\n        return oldDoc;\n      }\n    }\n  }\n});\n\n// check if migration is needed\nconst needed = await messageCol.migrationNeeded();\nif(needed == false) return;\n\n// start the migration\nmessageCol.startMigration(10); // 10 is the batch-size, how many docs will run at parallel\n\nconst migrationState = messageCol.getMigrationState();\n\n// 'start' the observable\nmigrationState.$.subscribe(\n  state => console.dir(state),\n  error => console.error(error),\n  done => console.log('done')\n);\n\n// the emitted states look like this:\n{\n    status: 'RUNNING' // oneOf 'RUNNING' | 'DONE' | 'ERROR'\n    count: {\n      total: 50,   // amount of documents which must be migrated\n      handled: 0,  // amount of handled docs\n      percent: 0   // percentage [0-100]\n    }\n}\n\n"})}),"\n",(0,a.jsxs)(t.p,{children:["If you don't want to show the state to the user, you can also use ",(0,a.jsx)(t.code,{children:".migratePromise()"}),":"]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-js",children:"  const migrationPromise = messageCol.migratePromise(10);\n  await migratePromise;\n"})}),"\n",(0,a.jsx)(t.h2,{id:"migrationstates",children:"migrationStates()"}),"\n",(0,a.jsxs)(t.p,{children:[(0,a.jsx)(t.code,{children:"RxDatabase.migrationStates()"})," returns an ",(0,a.jsx)(t.code,{children:"Observable"})," that emits all migration states of any collection of the database.\nUse this when you add collections dynamically and want to show a loading-state of the migrations to the user."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-js",children:"const allStatesObservable = myDatabase.migrationStates();\nallStatesObservable.subscribe(allStates => {\n  allStates.forEach(migrationState => {\n    console.log(\n      'migration state of ' +\n      migrationState.collection.name\n    );\n  });\n});\n"})}),"\n",(0,a.jsx)(t.h2,{id:"migrating-attachments",children:"Migrating attachments"}),"\n",(0,a.jsxs)(t.p,{children:["When you store ",(0,a.jsx)(t.code,{children:"RxAttachment"}),"s together with your document, they can also be changed, added or removed while running the migration.\nYou can do this by mutating the ",(0,a.jsx)(t.code,{children:"oldDoc._attachments"})," property."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-js",children:"import { createBlob } from 'rxdb';\nconst migrationStrategies = {\n      1: async function(oldDoc){\n        // do nothing with _attachments to keep all attachments and have them in the new collection version.\n        return oldDoc;\n      },\n      2: async function(oldDoc){\n        // set _attachments to an empty object to delete all existing ones during the migration.\n        oldDoc._attachments = {};\n        return oldDoc;\n      }\n      3: async function(oldDoc){\n        // update the data field of a single attachment to change its data. \n        oldDoc._attachments.myFile.data = await createBlob(\n          'my new text',\n          oldDoc._attachments.myFile.content_type\n        );\n        return oldDoc;\n      }\n}\n"})}),"\n",(0,a.jsx)(t.h2,{id:"migration-on-multi-tab-in-browsers",children:"Migration on multi-tab in browsers"}),"\n",(0,a.jsxs)(t.p,{children:["If you use RxDB in a multiInstance environment, like a browser, it will ensure that exactly one tab is running a migration of a collection.\nAlso the ",(0,a.jsx)(t.code,{children:"migrationState.$"})," events are emitted between browser tabs."]}),"\n",(0,a.jsx)(t.h2,{id:"migration-and-replication",children:"Migration and Replication"}),"\n",(0,a.jsxs)(t.p,{children:["If you use any of the ",(0,a.jsx)(t.a,{href:"/replication.html",children:"RxReplication"})," plugins, the migration will also run on the internal replication-state storage. It will migrate all ",(0,a.jsx)(t.code,{children:"assumedMasterState"})," documents\nso that after the migration is done, you do not have to re-run the replication from scratch.\nRxDB assumes that you run the exact same migration on the servers and the clients. Notice that the replication ",(0,a.jsx)(t.code,{children:"pull-checkpoint"})," will not be migrated. Your backend must be compatible with pull-checkpoints of older versions."]})]})}function h(e={}){const{wrapper:t}={...(0,o.a)(),...e.components};return t?(0,a.jsx)(t,{...e,children:(0,a.jsx)(d,{...e})}):d(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>r,a:()=>s});var a=n(7294);const o={},i=a.createContext(o);function s(e){const t=a.useContext(i);return a.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:s(e.components),a.createElement(i.Provider,{value:t},e.children)}}}]);