"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[2081],{3898:(e,a,t)=>{t.r(a),t.d(a,{assets:()=>l,contentTitle:()=>n,default:()=>h,frontMatter:()=>r,metadata:()=>o,toc:()=>d});var i=t(5893),s=t(1151);const r={title:"Browser Storage - RxDB as a Database for Browsers",slug:"browser-storage.html",description:"Explore RxDB for browser storage its advantages, limitations, and why it outperforms SQL databases in web applications for enhanced efficiency"},n="Browser Storage - RxDB as a Database for Browsers",o={id:"articles/browser-storage",title:"Browser Storage - RxDB as a Database for Browsers",description:"Explore RxDB for browser storage its advantages, limitations, and why it outperforms SQL databases in web applications for enhanced efficiency",source:"@site/docs/articles/browser-storage.md",sourceDirName:"articles",slug:"/articles/browser-storage.html",permalink:"/articles/browser-storage.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/articles/browser-storage.md",tags:[],version:"current",frontMatter:{title:"Browser Storage - RxDB as a Database for Browsers",slug:"browser-storage.html",description:"Explore RxDB for browser storage its advantages, limitations, and why it outperforms SQL databases in web applications for enhanced efficiency"},sidebar:"tutorialSidebar",previous:{title:"The benefits of Browser Databases and RxDB",permalink:"/articles/browser-database.html"},next:{title:"RxDB as a data base - Empowering Web Applications with Reactive Data Handling",permalink:"/articles/data-base.html"}},l={},d=[{value:"Localstorage",id:"localstorage",level:3},{value:"IndexedDB",id:"indexeddb",level:3},{value:"Why Store Data in the Browser",id:"why-store-data-in-the-browser",level:2},{value:"Browser Storage Limitations",id:"browser-storage-limitations",level:2},{value:"Why SQL Databases Like SQLite Aren&#39;t a Good Fit for the Browser",id:"why-sql-databases-like-sqlite-arent-a-good-fit-for-the-browser",level:2},{value:"Push/Pull Based vs. Reactive",id:"pushpull-based-vs-reactive",level:3},{value:"Build Size of Server-Side Databases",id:"build-size-of-server-side-databases",level:3},{value:"Initialization Time and Performance",id:"initialization-time-and-performance",level:3},{value:"Why RxDB Is a Good Fit as Browser Storage",id:"why-rxdb-is-a-good-fit-as-browser-storage",level:2},{value:"Flexible Storage Layer for Various Platforms",id:"flexible-storage-layer-for-various-platforms",level:3},{value:"NoSQL JSON Documents Are a Better Fit for UIs",id:"nosql-json-documents-are-a-better-fit-for-uis",level:3},{value:"NoSQL Has Better TypeScript Support Compared to SQL",id:"nosql-has-better-typescript-support-compared-to-sql",level:3},{value:"Observable Document Fields",id:"observable-document-fields",level:3},{value:"Made in JavaScript, Optimized for JavaScript Applications",id:"made-in-javascript-optimized-for-javascript-applications",level:3},{value:"Observable Queries (rxjs) to Automatically Update the UI on Changes",id:"observable-queries-rxjs-to-automatically-update-the-ui-on-changes",level:3},{value:"Optimized Observed Queries with the EventReduce Algorithm",id:"optimized-observed-queries-with-the-eventreduce-algorithm",level:3},{value:"Handling of Schema Changes",id:"handling-of-schema-changes",level:3},{value:"Built-In Multi-Tab Support",id:"built-in-multi-tab-support",level:3},{value:"Storing Documents Compressed",id:"storing-documents-compressed",level:3},{value:"Replication Algorithm for Compatibility with Any Backend",id:"replication-algorithm-for-compatibility-with-any-backend",level:3},{value:"Summary",id:"summary",level:2},{value:"Follow Up",id:"follow-up",level:2}];function c(e){const a={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(a.h1,{id:"browser-storage---rxdb-as-a-database-for-browsers",children:"Browser Storage - RxDB as a Database for Browsers"}),"\n",(0,i.jsx)(a.p,{children:(0,i.jsx)(a.strong,{children:"Storing Data in the Browser"})}),"\n",(0,i.jsx)(a.p,{children:"When it comes to building web applications, one essential aspect is the storage of data. Two common methods of storing data directly within the user's web browser are Localstorage and IndexedDB. These browser-based storage options serve various purposes and cater to different needs in web development."}),"\n",(0,i.jsx)("center",{children:(0,i.jsx)("a",{href:"https://rxdb.info/",children:(0,i.jsx)("img",{src:"../files/logo/rxdb_javascript_database.svg",alt:"JavaScript Browser Storage",width:"220"})})}),"\n",(0,i.jsx)(a.h3,{id:"localstorage",children:"Localstorage"}),"\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.a,{href:"/articles/localstorage.html",children:"Localstorage"})," is a straightforward way to store small amounts of data in the user's web browser. It operates on a simple key-value basis and is relatively easy to use. While it has limitations, it is suitable for basic data storage requirements."]}),"\n",(0,i.jsx)(a.h3,{id:"indexeddb",children:"IndexedDB"}),"\n",(0,i.jsx)(a.p,{children:"IndexedDB, on the other hand, offers a more robust and structured approach to browser-based data storage. It can handle larger datasets and complex queries, making it a valuable choice for more advanced web applications."}),"\n",(0,i.jsx)(a.h2,{id:"why-store-data-in-the-browser",children:"Why Store Data in the Browser"}),"\n",(0,i.jsx)(a.p,{children:"Now that we've explored the methods of storing data in the browser, let's delve into why this is a beneficial strategy for web developers:"}),"\n",(0,i.jsxs)(a.ol,{children:["\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Caching"}),":\nStoring data in the browser allows you to cache frequently used information. This means that your web application can access essential data more quickly because it doesn't need to repeatedly fetch it from a server. This results in a smoother and more responsive user experience."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Offline Access"}),":\nOne significant advantage of browser storage is that data becomes portable and remains accessible even when the user is offline. This feature ensures that users can continue to use your application, view their saved information, and make changes, irrespective of their internet connection status."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Faster Real-time Applications"}),":\nFor real-time applications, having data stored locally in the browser significantly enhances performance. Local data allows your application to respond faster to user interactions, creating a more seamless and responsive user interface."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Low Latency Queries"}),":\nWhen you run queries locally within the browser, you minimize the latency associated with network requests. This results in near-instant access to data, which is particularly crucial for applications that require rapid data retrieval."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Faster Initial Application Start Time"}),":\nBy preloading essential data into browser storage, you can reduce the initial load time of your web application. Users can start using your application more swiftly, which is essential for making a positive first impression."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Store Local Data with Encryption"}),":\nFor applications that deal with sensitive data, browser storage allows you to implement ",(0,i.jsx)(a.a,{href:"/encryption.html",children:"encryption"})," to secure the stored information. This ensures that even if data is stored on the user's device, it remains confidential and protected."]}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(a.p,{children:"In summary, storing data in the browser offers several advantages, including improved performance, offline access, and enhanced user experiences. Localstorage and IndexedDB are two valuable tools that developers can utilize to leverage these benefits and create web applications that are more responsive and user-friendly."}),"\n",(0,i.jsx)(a.h2,{id:"browser-storage-limitations",children:"Browser Storage Limitations"}),"\n",(0,i.jsx)(a.p,{children:"While browser storage, such as Localstorage and IndexedDB, offers many advantages, it's important to be aware of its limitations:"}),"\n",(0,i.jsxs)(a.ul,{children:["\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Slower Performance Compared to Native Databases"}),": Browser-based storage solutions can't match the ",(0,i.jsx)(a.a,{href:"/rx-storage-performance.html",children:"performance"})," of native server-side databases. They may experience slower data retrieval and processing, especially for large datasets or complex operations."]}),"\n"]}),"\n",(0,i.jsxs)(a.li,{children:["\n",(0,i.jsxs)(a.p,{children:[(0,i.jsx)(a.strong,{children:"Storage Space Limitations"}),": Browsers impose restrictions on the amount of data that can be stored locally. This limitation can be problematic for applications with extensive data storage requirements, potentially necessitating creative solutions to manage data effectively."]}),"\n"]}),"\n"]}),"\n",(0,i.jsx)(a.h2,{id:"why-sql-databases-like-sqlite-arent-a-good-fit-for-the-browser",children:"Why SQL Databases Like SQLite Aren't a Good Fit for the Browser"}),"\n",(0,i.jsx)(a.p,{children:"SQL databases like SQLite, while powerful in server environments, may not be the best choice for browser-based applications due to various reasons:"}),"\n",(0,i.jsx)(a.h3,{id:"pushpull-based-vs-reactive",children:"Push/Pull Based vs. Reactive"}),"\n",(0,i.jsx)(a.p,{children:"SQL databases often use a push/pull model for data synchronization. This approach is less reactive and may not align well with the real-time nature of web applications, where immediate updates to the user interface are crucial."}),"\n",(0,i.jsx)(a.h3,{id:"build-size-of-server-side-databases",children:"Build Size of Server-Side Databases"}),"\n",(0,i.jsx)(a.p,{children:"Server-side databases like SQLite have a significant build size, which can increase the initial load time of web applications. This can result in a suboptimal user experience, particularly for users with slower internet connections."}),"\n",(0,i.jsx)(a.h3,{id:"initialization-time-and-performance",children:"Initialization Time and Performance"}),"\n",(0,i.jsx)(a.p,{children:"SQL databases are optimized for server environments, and their initialization processes and performance characteristics may not align with the needs of web applications. They might not offer the swift performance required for seamless user interactions."}),"\n",(0,i.jsx)(a.h2,{id:"why-rxdb-is-a-good-fit-as-browser-storage",children:"Why RxDB Is a Good Fit as Browser Storage"}),"\n",(0,i.jsx)(a.p,{children:"RxDB is an excellent choice for browser-based storage due to its numerous features and advantages:"}),"\n",(0,i.jsx)("center",{children:(0,i.jsx)("a",{href:"https://rxdb.info/",children:(0,i.jsx)("img",{src:"../files/logo/rxdb_javascript_database.svg",alt:"JavaScript Browser Storage",width:"220"})})}),"\n",(0,i.jsx)(a.h3,{id:"flexible-storage-layer-for-various-platforms",children:"Flexible Storage Layer for Various Platforms"}),"\n",(0,i.jsx)(a.p,{children:"RxDB offers a flexible storage layer that can seamlessly integrate with different platforms, making it versatile and adaptable to various application needs."}),"\n",(0,i.jsx)(a.h3,{id:"nosql-json-documents-are-a-better-fit-for-uis",children:"NoSQL JSON Documents Are a Better Fit for UIs"}),"\n",(0,i.jsxs)(a.p,{children:["NoSQL ",(0,i.jsx)(a.a,{href:"/articles/json-database.html",children:"JSON documents"}),", used by ",(0,i.jsx)(a.a,{href:"https://rxdb.info/",children:"RxDB"}),", are well-suited for user interfaces. They provide a natural and efficient way to structure and display data in web applications."]}),"\n",(0,i.jsx)(a.h3,{id:"nosql-has-better-typescript-support-compared-to-sql",children:"NoSQL Has Better TypeScript Support Compared to SQL"}),"\n",(0,i.jsx)(a.p,{children:"RxDB boasts robust TypeScript support, which is beneficial for developers who prefer type safety and code predictability in their projects."}),"\n",(0,i.jsx)(a.h3,{id:"observable-document-fields",children:"Observable Document Fields"}),"\n",(0,i.jsx)(a.p,{children:"RxDB enables developers to observe individual document fields, offering fine-grained control over data tracking and updates."}),"\n",(0,i.jsx)(a.h3,{id:"made-in-javascript-optimized-for-javascript-applications",children:"Made in JavaScript, Optimized for JavaScript Applications"}),"\n",(0,i.jsx)(a.p,{children:"Being built in JavaScript and optimized for JavaScript applications, RxDB seamlessly integrates into web development stacks, minimizing compatibility issues."}),"\n",(0,i.jsx)(a.h3,{id:"observable-queries-rxjs-to-automatically-update-the-ui-on-changes",children:"Observable Queries (rxjs) to Automatically Update the UI on Changes"}),"\n",(0,i.jsx)(a.p,{children:"RxDB's support for Observable Queries allows the user interface to update automatically in real-time when data changes. This reactivity enhances the user experience and simplifies UI development."}),"\n",(0,i.jsx)(a.pre,{children:(0,i.jsx)(a.code,{className:"language-typescript",children:"const query = myCollection.find({\n    selector: {\n        age: {\n            $gt: 21\n        }\n    }\n});\nconst querySub = query.$.subscribe(results => {\n    console.log('got results: ' + results.length);\n});\n"})}),"\n",(0,i.jsx)(a.h3,{id:"optimized-observed-queries-with-the-eventreduce-algorithm",children:"Optimized Observed Queries with the EventReduce Algorithm"}),"\n",(0,i.jsxs)(a.p,{children:["RxDB's ",(0,i.jsx)(a.a,{href:"https://github.com/pubkey/event-reduce",children:"EventReduce Algorithm"})," ensures efficient data handling and rendering, improving overall performance and responsiveness."]}),"\n",(0,i.jsx)(a.h3,{id:"handling-of-schema-changes",children:"Handling of Schema Changes"}),"\n",(0,i.jsxs)(a.p,{children:["RxDB provides built-in support for ",(0,i.jsx)(a.a,{href:"/migration-schema.html",children:"handling schema changes"}),", simplifying database management when updates are required."]}),"\n",(0,i.jsx)(a.h3,{id:"built-in-multi-tab-support",children:"Built-In Multi-Tab Support"}),"\n",(0,i.jsx)(a.p,{children:"For applications requiring multi-tab support, RxDB natively handles data consistency across different browser tabs, streamlining data synchronization."}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"../files/multiwindow.gif",alt:"multi tab support for browser storage",width:"450"})}),"\n",(0,i.jsx)(a.h3,{id:"storing-documents-compressed",children:"Storing Documents Compressed"}),"\n",(0,i.jsxs)(a.p,{children:["Efficient data storage is achieved through ",(0,i.jsx)(a.a,{href:"/key-compression.html",children:"document compression"}),", reducing storage space requirements and enhancing overall performance."]}),"\n",(0,i.jsx)(a.h3,{id:"replication-algorithm-for-compatibility-with-any-backend",children:"Replication Algorithm for Compatibility with Any Backend"}),"\n",(0,i.jsxs)(a.p,{children:["RxDB's  ",(0,i.jsx)(a.a,{href:"/replication.html",children:"Replication Algorithm"})," facilitates compatibility with various backend systems, ensuring seamless data synchronization between the browser and server."]}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"../files/database-replication.png",alt:"database replication",width:"200"})}),"\n",(0,i.jsx)(a.h2,{id:"summary",children:"Summary"}),"\n",(0,i.jsx)(a.p,{children:"In conclusion, RxDB is a powerful and feature-rich solution for browser-based storage. Its adaptability, real-time capabilities, TypeScript support, and optimization for JavaScript applications make it an ideal choice for modern web development projects, addressing the limitations of traditional SQL databases in the browser. Developers can harness RxDB to create efficient, responsive, and user-friendly web applications that leverage the full potential of browser storage."}),"\n",(0,i.jsx)(a.h2,{id:"follow-up",children:"Follow Up"}),"\n",(0,i.jsx)(a.p,{children:"To explore more about RxDB and leverage its capabilities for browser storage, check out the following resources:"}),"\n",(0,i.jsxs)(a.ul,{children:["\n",(0,i.jsxs)(a.li,{children:[(0,i.jsx)(a.a,{href:"https://github.com/pubkey/rxdb",children:"RxDB GitHub Repository"}),": Visit the official GitHub repository of RxDB to access the source code, documentation, and community support."]}),"\n",(0,i.jsxs)(a.li,{children:[(0,i.jsx)(a.a,{href:"/quickstart.html",children:"RxDB Quickstart"}),": Get started quickly with RxDB by following the provided quickstart guide, which provides step-by-step instructions for setting up and using RxDB in your projects."]}),"\n"]})]})}function h(e={}){const{wrapper:a}={...(0,s.a)(),...e.components};return a?(0,i.jsx)(a,{...e,children:(0,i.jsx)(c,{...e})}):c(e)}},1151:(e,a,t)=>{t.d(a,{Z:()=>o,a:()=>n});var i=t(7294);const s={},r=i.createContext(s);function n(e){const a=i.useContext(r);return i.useMemo((function(){return"function"==typeof e?e(a):{...a,...e}}),[a,e])}function o(e){let a;return a=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:n(e.components),i.createElement(r.Provider,{value:a},e.children)}}}]);