"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[6284],{5305:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>c,contentTitle:()=>s,default:()=>h,frontMatter:()=>a,metadata:()=>r,toc:()=>l});var i=n(5893),o=n(1151);const a={title:"CRDT - Conflict-free replicated data type",slug:"crdt.html",description:"Explore the beta RxDB CRDT Plugin - A guide to conflict-free data handling in distributed systems with RxDB's novel CRDT approach"},s="RxDB CRDT Plugin (beta)",r={id:"crdt",title:"CRDT - Conflict-free replicated data type",description:"Explore the beta RxDB CRDT Plugin - A guide to conflict-free data handling in distributed systems with RxDB's novel CRDT approach",source:"@site/docs/crdt.md",sourceDirName:".",slug:"/crdt.html",permalink:"/crdt.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/crdt.md",tags:[],version:"current",frontMatter:{title:"CRDT - Conflict-free replicated data type",slug:"crdt.html",description:"Explore the beta RxDB CRDT Plugin - A guide to conflict-free data handling in distributed systems with RxDB's novel CRDT approach"},sidebar:"tutorialSidebar",previous:{title:"Query Cache",permalink:"/query-cache.html"},next:{title:"Population",permalink:"/population.html"}},c={},l=[{value:"RxDB CRDT operations",id:"rxdb-crdt-operations",level:2},{value:"Operators",id:"operators",level:3},{value:"Installation",id:"installation",level:2},{value:"Conditional CRDT operations",id:"conditional-crdt-operations",level:2},{value:"Running multiples operations at once",id:"running-multiples-operations-at-once",level:2},{value:"CRDTs on inserts",id:"crdts-on-inserts",level:2},{value:"Deleting documents",id:"deleting-documents",level:2},{value:"CRDTs with replication",id:"crdts-with-replication",level:2},{value:"Why not automerge.js or yjs?",id:"why-not-automergejs-or-yjs",level:2},{value:"When to not use CRDTs",id:"when-to-not-use-crdts",level:2}];function d(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,o.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(t.h1,{id:"rxdb-crdt-plugin-beta",children:"RxDB CRDT Plugin (beta)"}),"\n",(0,i.jsx)(t.p,{children:"Whenever there are multiple instances in a distributed system, data writes can cause conflicts. Two different clients could do a write to the same document at the same time or while they are both offline. When the clients replicate the document state with the server, a conflict emerges that must be resolved by the system."}),"\n",(0,i.jsxs)(t.p,{children:["In ",(0,i.jsx)(t.a,{href:"./",children:"RxDB"}),", conflicts are normally resolved by setting a ",(0,i.jsx)(t.code,{children:"conflictHandler"})," when creating a collection. The conflict handler is a JavaScript function that gets the two conflicting states of the same document and it will return the resolved document state.\nThe ",(0,i.jsx)(t.a,{href:"/replication.html#conflict-handling",children:"default conflict handler"})," will always drop the fork state and use the master state to ensure that clients that have been offline for a long time, do not overwrite other clients changes when they go online again."]}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"./files/document-replication-conflict.svg",alt:"document replication conflict",width:"250"})}),"\n",(0,i.jsxs)(t.p,{children:["With CRDTs (short for ",(0,i.jsx)(t.a,{href:"https://en.wikipedia.org/wiki/Conflict-free_replicated_data_type",children:"Conflict-free replicated data type"}),'), all document\nwrites are represented as CRDT operations in plain JSON. The CRDT operations are stored together with the document and each time a conflict arises, the CRDT conflict handler will automatically merge the operations in a deterministic way. Using CRDTs is an easy way to "magically" handle all conflict problems in your application by storing the deltas of writes together with the document data.']}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"./files/crdt-conflict-free-replicated-data-type.svg",alt:"CRDT Conflict-free replicated data type",width:"300"})}),"\n",(0,i.jsx)(t.h2,{id:"rxdb-crdt-operations",children:"RxDB CRDT operations"}),"\n",(0,i.jsxs)(t.p,{children:["In RxDB, a CRDT operation is defined with NoSQL update operators, like you might know them from ",(0,i.jsx)(t.a,{href:"https://www.mongodb.com/docs/manual/reference/operator/update/",children:"MongoDB update operations"})," or the ",(0,i.jsx)(t.a,{href:"/rx-document.html#update",children:"RxDB update plugin"}),".\nTo run the operators, RxDB uses the ",(0,i.jsx)(t.a,{href:"https://github.com/kofrasa/mingo#updating-documents",children:"mingo library"}),"."]}),"\n",(0,i.jsx)(t.p,{children:"A CRDT operator example:"}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-js",children:"const myCRDTOperation = {\n    // increment the points field by +1\n    $inc: {\n        points: 1\n    },\n    // set the modified field to true\n    $set: {\n        modified: true\n    }\n};\n"})}),"\n",(0,i.jsx)(t.h3,{id:"operators",children:"Operators"}),"\n",(0,i.jsxs)(t.p,{children:["At the moment, not all possible operators are implemented in ",(0,i.jsx)(t.a,{href:"https://github.com/kofrasa/mingo#updating-documents",children:"mingo"}),", if you need additional ones, you should make a pull request there."]}),"\n",(0,i.jsx)(t.p,{children:"The following operators can be used at this point in time:"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$min"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$max"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$inc"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$set"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$unset"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$push"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$addToSet"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$pop"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$pullAll"})}),"\n",(0,i.jsx)(t.li,{children:(0,i.jsx)(t.code,{children:"$rename"})}),"\n"]}),"\n",(0,i.jsxs)(t.p,{children:["For the exact definition on how each operator behaves, check out the ",(0,i.jsx)(t.a,{href:"https://www.mongodb.com/docs/manual/reference/operator/update/",children:"MongoDB documentation on update operators"}),"."]}),"\n",(0,i.jsx)(t.h2,{id:"installation",children:"Installation"}),"\n",(0,i.jsx)(t.p,{children:"To use CRDTs with RxDB, you need the following:"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsxs)(t.li,{children:["Add the CRDT plugin via ",(0,i.jsx)(t.code,{children:"addRxPlugin"}),"."]}),"\n",(0,i.jsxs)(t.li,{children:["Add a field to your schema that defines where to store the CRDT operations via ",(0,i.jsx)(t.code,{children:"getCRDTSchemaPart()"})]}),"\n",(0,i.jsxs)(t.li,{children:["Set the ",(0,i.jsx)(t.code,{children:"crdt"})," options in your schema."]}),"\n",(0,i.jsxs)(t.li,{children:["Do ",(0,i.jsx)(t.strong,{children:"NOT"})," set a custom conflict handler, the plugin will use its own one."]}),"\n"]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"// import the relevant parts from the CRDT plugin\nimport {\n    getCRDTSchemaPart,\n    RxDBcrdtPlugin\n} from 'rxdb/plugins/crdt';\n\n// add the CRDT plugin to RxDB\nimport { addRxPlugin } from 'rxdb';\naddRxPlugin(RxDBcrdtPlugin);\n\n// create a database\nimport { createRxDatabase } from 'rxdb';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\nconst myDatabase = await createRxDatabase({\n  name: 'heroesdb',\n  storage: getRxStorageDexie()\n});\n\n// create a schema with the CRDT options\nconst mySchema = {\n    version: 0,\n    primaryKey: 'id',\n    type: 'object',\n    properties: {\n        id: {\n            type: 'string',\n            maxLength: 100\n        },\n        points: {\n            type: 'number',\n            maximum: 100,\n            minimum: 0\n        },\n        crdts: getCRDTSchemaPart() // use this field to store the CRDT operations\n    },\n    required: ['id', 'points'],\n    crdt: { // CRDT options\n        field: 'crdts'\n    }\n}\n\n// add a collection\nawait db.addCollections({\n    users: {\n        schema: mySchema\n    }\n});\n\n// insert a document\nconst myDocument = await db.users.insert({id: 'alice', points: 0});\n\n// run a CRDT operation that increments the 'points' by one\nawait myDocument.updateCRDT({\n    ifMatch: {\n        $inc: {\n            points: 1\n        }\n    }\n});\n"})}),"\n",(0,i.jsx)(t.h2,{id:"conditional-crdt-operations",children:"Conditional CRDT operations"}),"\n",(0,i.jsx)(t.p,{children:"By default, all CRDTs operations will be run to build the current document state. But in many cases, more granular operations are required to better reflect the desired business logic. For these cases, conditional CRDTs can be used."}),"\n",(0,i.jsxs)(t.p,{children:["For example if you have a field ",(0,i.jsx)(t.code,{children:"points"})," with a ",(0,i.jsx)(t.code,{children:"maximum"})," of ",(0,i.jsx)(t.code,{children:"100"}),", you might want to only run an ",(0,i.jsx)(t.code,{children:"$inc"})," operations, if the ",(0,i.jsx)(t.code,{children:"points"})," value is less then ",(0,i.jsx)(t.code,{children:"100"}),".\nIn an conditional CRDT, you can specify a ",(0,i.jsx)(t.code,{children:"selector"})," and the operation sets ",(0,i.jsx)(t.code,{children:"ifMatch"})," and ",(0,i.jsx)(t.code,{children:"ifNotMatch"}),". At each time the CRDT is applied to the document state, first the selector will run and evaluate which operations path must be used."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"await myDocument.updateCRDT({\n    // only if the selector matches, the ifMatch operation will run\n    selector: {\n        age: {\n            $lt: 100\n        }\n    },\n    // an operation that runs if the selector matches\n    ifMatch: {\n        $inc: {\n            points: 1\n        }\n    },\n    // if the selector does NOT match, you could run a different operation instead\n    ifNotMatch: {\n        // ...\n    }\n});\n"})}),"\n",(0,i.jsx)(t.h2,{id:"running-multiples-operations-at-once",children:"Running multiples operations at once"}),"\n",(0,i.jsx)(t.p,{children:"By default, one CRDT operation is applied to the document in a single database write.\nTo represent more complex logic chains, it might make sense to use multiple CRDTs and write them at once inside of a single atomic document write."}),"\n",(0,i.jsxs)(t.p,{children:["For these cases, the ",(0,i.jsx)(t.code,{children:"updateCRDT()"})," method allows to pass an array of operations."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"await myDocument.updateCRDT([\n    {\n        selector: { /** ... **/ },\n        ifMatch: { /** ... **/ }\n    },\n    {\n        selector: { /** ... **/ },\n        ifMatch: { /** ... **/ }\n    },\n    {\n        selector: { /** ... **/ },\n        ifMatch: { /** ... **/ }\n    },\n    {\n        selector: { /** ... **/ },\n        ifMatch: { /** ... **/ }\n    }\n]);\n"})}),"\n",(0,i.jsx)(t.h2,{id:"crdts-on-inserts",children:"CRDTs on inserts"}),"\n",(0,i.jsxs)(t.p,{children:["When CRDTs are enabled with the plugin, all insert operations are automatically mapped as CRDT operation with the ",(0,i.jsx)(t.code,{children:"$set"})," operator."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"// Calling RxCollection.insert()\nawait myRxCollection.insert({\n    id: 'foo'\n    points: 1\n});\n// is exactly equal to calling insertCRDT()\nawait myRxCollection.insertCRDT({\n    ifMatch: {\n        $set: {\n            id: 'foo'\n            points: 1\n        }\n    }\n});\n"})}),"\n",(0,i.jsxs)(t.p,{children:["When the same document is inserted in multiple client instances and then replicated, a conflict will emerge and the insert-CRDTs will overwrite each other in a deterministic order.\nYou can use ",(0,i.jsx)(t.code,{children:"insertCRDT()"})," to make conditional insert operations with any logic. To check for the previous existence of a document, use the ",(0,i.jsx)(t.code,{children:"$exists"})," query operation on the primary key of the document."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"await myRxCollection.insertCRDT({\n    selector: {\n        // only run if the document did not exist before.\n        id: { $exists: false }\n    }, \n    ifMatch: {\n        // if the document did not exist, insert it\n        $set: {\n            id: 'foo'\n            points: 1\n        }\n    },\n    ifNotMatch: {\n        // if document existed already, increment the points by +1\n        $inc: {\n            points: 1\n        }\n    }\n});\n"})}),"\n",(0,i.jsx)(t.h2,{id:"deleting-documents",children:"Deleting documents"}),"\n",(0,i.jsxs)(t.p,{children:["You can delete a document with a CRDT operation by setting ",(0,i.jsx)(t.code,{children:"_deleted"})," to true. Calling ",(0,i.jsx)(t.code,{children:"RxDocument.remove()"})," will do exactly the same when CRDTs are activated."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"await doc.updateCRDT({\n    ifMatch: {\n        $set: {\n            _deleted: true\n        }\n    }\n});\n\n// OR\nawait doc.remove();\n"})}),"\n",(0,i.jsx)(t.h2,{id:"crdts-with-replication",children:"CRDTs with replication"}),"\n",(0,i.jsxs)(t.p,{children:["CRDT operations are stored inside of a special field besides your 'normal' document fields.\nWhen replicating document data with the ",(0,i.jsx)(t.a,{href:"/replication.html",children:"RxDB replication"})," or the ",(0,i.jsx)(t.a,{href:"/replication-couchdb.html",children:"CouchDB replication"})," or even any custom replication, the CRDT operations must be replicated together with the document data as if they would be 'normal' a document property."]}),"\n",(0,i.jsxs)(t.p,{children:["When any instances makes a write to the document, it is required to update the CRDT operations accordingly. For example if your custom backend updates a document, it must also do that by adding a CRDT operation. In ",(0,i.jsx)(t.a,{href:"/dev-mode.html",children:"dev-mode"})," RxDB will refuse to store any document data where the document properties do not match the result of the CRDT operations."]}),"\n",(0,i.jsx)(t.h2,{id:"why-not-automergejs-or-yjs",children:"Why not automerge.js or yjs?"}),"\n",(0,i.jsxs)(t.p,{children:["There are already CRDT libraries out there that have been considered to be used with RxDB. The biggest ones are ",(0,i.jsx)(t.a,{href:"https://github.com/automerge/automerge",children:"automerge"})," and ",(0,i.jsx)(t.a,{href:"https://github.com/yjs/yjs",children:"yjs"}),". The decision was made to not use these but instead go for a more NoSQL way of designing the CRDT format because:"]}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsx)(t.li,{children:"Users do not have to learn a new syntax but instead can use the NoSQL query operations which they already know to manipulate the JSON data of a document."}),"\n",(0,i.jsxs)(t.li,{children:["RxDB is often used to ",(0,i.jsx)(t.a,{href:"/replication.html",children:"replicate"})," data with any custom backend on an already existing infrastructure. Using NoSQL operators instead of binary data in CRDTs, makes it easy to implement the exact same logic on these backends so that the backend can also do document writes and still be compliant to the RxDB CRDT plugin."]}),"\n"]}),"\n",(0,i.jsxs)(t.p,{children:["So instead of using YJS or Automerge with a database, you can use RxDB with the CRDT plugin to have a more database specific CRDT approach. This gives you additional features for free such as ",(0,i.jsx)(t.a,{href:"/schema-validation.html",children:"schema validation"})," or ",(0,i.jsx)(t.a,{href:"/migration-schema.html",children:"data migration"}),"."]}),"\n",(0,i.jsx)(t.h2,{id:"when-to-not-use-crdts",children:"When to not use CRDTs"}),"\n",(0,i.jsx)(t.p,{children:"CRDT can only be use when your business logic allows to represent document changes via static json operators.\nIf you can have cases where user interaction is required to correctly merge conflicting document states, you cannot use CRDTs for that."}),"\n",(0,i.jsx)(t.p,{children:"Also when CRDTs are used, it is no longer allowed to do non-CRDT writes to the document properties."})]})}function h(e={}){const{wrapper:t}={...(0,o.a)(),...e.components};return t?(0,i.jsx)(t,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>r,a:()=>s});var i=n(7294);const o={},a=i.createContext(o);function s(e){const t=i.useContext(a);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:s(e.components),i.createElement(a.Provider,{value:t},e.children)}}}]);