"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[9242],{5290:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>r,contentTitle:()=>l,default:()=>h,frontMatter:()=>i,metadata:()=>c,toc:()=>a});var o=t(5893),s=t(1151);const i={title:"RxCollection",slug:"rx-collection.html"},l="RxCollection",c={id:"rx-collection",title:"RxCollection",description:"A collection stores documents of the same type.",source:"@site/docs/rx-collection.md",sourceDirName:".",slug:"/rx-collection.html",permalink:"/rx-collection.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rx-collection.md",tags:[],version:"current",frontMatter:{title:"RxCollection",slug:"rx-collection.html"},sidebar:"tutorialSidebar",previous:{title:"RxSchema",permalink:"/rx-schema.html"},next:{title:"RxDocument",permalink:"/rx-document.html"}},r={},a=[{value:"Creating a Collection",id:"creating-a-collection",level:2},{value:"name",id:"name",level:3},{value:"schema",id:"schema",level:3},{value:"ORM-functions",id:"orm-functions",level:3},{value:"Migration",id:"migration",level:3},{value:"Get a collection from the database",id:"get-a-collection-from-the-database",level:2},{value:"Functions",id:"functions",level:2},{value:"Observe $",id:"observe-",level:3},{value:"insert()",id:"insert",level:3},{value:"bulkInsert()",id:"bulkinsert",level:3},{value:"bulkRemove()",id:"bulkremove",level:3},{value:"upsert()",id:"upsert",level:3},{value:"bulkUpsert()",id:"bulkupsert",level:3},{value:"incrementalUpsert()",id:"incrementalupsert",level:3},{value:"find()",id:"find",level:3},{value:"findOne()",id:"findone",level:3},{value:"findByIds()",id:"findbyids",level:3},{value:"exportJSON()",id:"exportjson",level:3},{value:"importJSON()",id:"importjson",level:3},{value:"remove()",id:"remove",level:3},{value:"destroy()",id:"destroy",level:3},{value:"isRxCollection",id:"isrxcollection",level:3}];function d(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",p:"p",pre:"pre",...(0,s.a)(),...e.components};return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(n.h1,{id:"rxcollection",children:"RxCollection"}),"\n",(0,o.jsx)(n.p,{children:"A collection stores documents of the same type."}),"\n",(0,o.jsx)(n.h2,{id:"creating-a-collection",children:"Creating a Collection"}),"\n",(0,o.jsxs)(n.p,{children:["To create one or more collections you need a RxDatabase object which has the ",(0,o.jsx)(n.code,{children:".addCollections()"}),"-method. Every collection needs a collection name and a valid ",(0,o.jsx)(n.code,{children:"RxJsonSchema"}),". Other attributes are optional."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const myCollections = await myDatabase.addCollections({\n  // key = collectionName\n  humans: {\n    schema: mySchema,\n    statics: {},                          // (optional) ORM-functions for this collection\n    methods: {},                          // (optional) ORM-functions for documents\n    attachments: {},                      // (optional) ORM-functions for attachments\n    options: {},                          // (optional) Custom parameters that might be used in plugins\n    migrationStrategies: {},              // (optional)\n    autoMigrate: true,                    // (optional) [default=true]\n    cacheReplacementPolicy: function(){}, // (optional) custom cache replacement policy\n    conflictHandler: function(){}         // (optional) a custom conflict handler can be used\n  },\n  // you can create multiple collections at once\n  animals: {\n    // ...\n  }\n});\n"})}),"\n",(0,o.jsx)(n.h3,{id:"name",children:"name"}),"\n",(0,o.jsxs)(n.p,{children:["The name uniquely identifies the collection and should be used to refine the collection in the database. Two different collections in the same database can never have the same name. Collection names must match the following regex: ",(0,o.jsx)(n.code,{children:"^[a-z][a-z0-9]*$"}),"."]}),"\n",(0,o.jsx)(n.h3,{id:"schema",children:"schema"}),"\n",(0,o.jsxs)(n.p,{children:["The schema defines how the documents of the collection are structured. RxDB uses a schema format, similar to ",(0,o.jsx)(n.a,{href:"https://json-schema.org/",children:"JSON schema"}),". Read more about the RxDB schema format ",(0,o.jsx)(n.a,{href:"/rx-schema.html",children:"here"}),"."]}),"\n",(0,o.jsx)(n.h3,{id:"orm-functions",children:"ORM-functions"}),"\n",(0,o.jsxs)(n.p,{children:["With the parameters ",(0,o.jsx)(n.code,{children:"statics"}),", ",(0,o.jsx)(n.code,{children:"methods"})," and ",(0,o.jsx)(n.code,{children:"attachments"}),", you can define ORM-functions that are applied to each of these objects that belong to this collection. See ",(0,o.jsx)(n.a,{href:"/orm.html",children:"ORM/DRM"}),"."]}),"\n",(0,o.jsx)(n.h3,{id:"migration",children:"Migration"}),"\n",(0,o.jsxs)(n.p,{children:["With the parameters ",(0,o.jsx)(n.code,{children:"migrationStrategies"})," and ",(0,o.jsx)(n.code,{children:"autoMigrate"})," you can specify how migration between different schema-versions should be done. ",(0,o.jsx)(n.a,{href:"/migration-schema.html",children:"See Migration"}),"."]}),"\n",(0,o.jsx)(n.h2,{id:"get-a-collection-from-the-database",children:"Get a collection from the database"}),"\n",(0,o.jsx)(n.p,{children:"To get an existing collection from the database, call the collection name directly on the database:"}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"// newly created collection\nconst collections = await db.addCollections({\n  heroes: {\n    schema: mySchema\n  }\n});\nconst collection2 = db.heroes;\nconsole.log(collections.heroes === collection2); //> true\n"})}),"\n",(0,o.jsx)(n.h2,{id:"functions",children:"Functions"}),"\n",(0,o.jsx)(n.h3,{id:"observe-",children:"Observe $"}),"\n",(0,o.jsxs)(n.p,{children:["Calling this will return an ",(0,o.jsx)(n.a,{href:"http://reactivex.io/rxjs/manual/overview.html#observable",children:"rxjs-Observable"})," which streams every change to data of this collection."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"myCollection.$.subscribe(changeEvent => console.dir(changeEvent));\n\n// you can also observe single event-types with insert$ update$ remove$\nmyCollection.insert$.subscribe(changeEvent => console.dir(changeEvent));\nmyCollection.update$.subscribe(changeEvent => console.dir(changeEvent));\nmyCollection.remove$.subscribe(changeEvent => console.dir(changeEvent));\n\n"})}),"\n",(0,o.jsx)(n.h3,{id:"insert",children:"insert()"}),"\n",(0,o.jsx)(n.p,{children:"Use this to insert new documents into the database. The collection will validate the schema and automatically encrypt any encrypted fields. Returns the new RxDocument."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const doc = await myCollection.insert({\n  name: 'foo',\n  lastname: 'bar'\n});\n"})}),"\n",(0,o.jsx)(n.h3,{id:"bulkinsert",children:"bulkInsert()"}),"\n",(0,o.jsxs)(n.p,{children:["When you have to insert many documents at once, use bulk insert. This is much faster than calling ",(0,o.jsx)(n.code,{children:".insert()"})," multiple times.\nReturns an object with a ",(0,o.jsx)(n.code,{children:"success"}),"- and ",(0,o.jsx)(n.code,{children:"error"}),"-array."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const result = await myCollection.bulkInsert([{\n  name: 'foo1',\n  lastname: 'bar1'\n},\n{\n  name: 'foo2',\n  lastname: 'bar2'\n}]);\n\n// > {\n//   success: [RxDocument, RxDocument],\n//   error: []\n// }\n"})}),"\n",(0,o.jsxs)(n.p,{children:["NOTICE: ",(0,o.jsx)(n.code,{children:"bulkInsert"})," will not fail on update conflicts and you cannot expect that on failure the other documents are not inserted. Also the call to ",(0,o.jsx)(n.code,{children:"bulkInsert()"})," it will not throw if a single document errors because of validation errors. Instead it will return the error in the ",(0,o.jsx)(n.code,{children:".error"})," property of the returned object."]}),"\n",(0,o.jsx)(n.h3,{id:"bulkremove",children:"bulkRemove()"}),"\n",(0,o.jsxs)(n.p,{children:["When you want to remove many documents at once, use bulk remove. Returns an object with a ",(0,o.jsx)(n.code,{children:"success"}),"- and ",(0,o.jsx)(n.code,{children:"error"}),"-array."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const result = await myCollection.bulkRemove([\n  'primary1',\n  'primary2'\n]);\n\n// > {\n//   success: [RxDocument, RxDocument],\n//   error: []\n// }\n"})}),"\n",(0,o.jsx)(n.h3,{id:"upsert",children:"upsert()"}),"\n",(0,o.jsx)(n.p,{children:"Inserts the document if it does not exist within the collection, otherwise it will overwrite it. Returns the new or overwritten RxDocument."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const doc = await myCollection.upsert({\n  name: 'foo',\n  lastname: 'bar2'\n});\n"})}),"\n",(0,o.jsx)(n.h3,{id:"bulkupsert",children:"bulkUpsert()"}),"\n",(0,o.jsxs)(n.p,{children:["Same as ",(0,o.jsx)(n.code,{children:"upsert()"})," but runs over multiple documents. Improves performance compared to running many ",(0,o.jsx)(n.code,{children:"upsert()"})," calls.\nReturns an ",(0,o.jsx)(n.code,{children:"error"})," and a ",(0,o.jsx)(n.code,{children:"success"})," array."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const docs = await myCollection.bulkUpsert([\n  {\n    name: 'foo',\n    lastname: 'bar2'\n  },\n  {\n    name: 'bar',\n    lastname: 'foo2'\n  }\n]);\n/**\n * {\n *   success: [RxDocument, RxDocument]\n *   error: [],\n * }\n */\n"})}),"\n",(0,o.jsx)(n.h3,{id:"incrementalupsert",children:"incrementalUpsert()"}),"\n",(0,o.jsxs)(n.p,{children:["When you run many upsert operations on the same RxDocument in a very short timespan, you might get a ",(0,o.jsx)(n.code,{children:"409 Conflict"})," error.\nThis means that you tried to run a ",(0,o.jsx)(n.code,{children:".upsert()"})," on the document, while the previous upsert operation was still running.\nTo prevent these types of errors, you can run incremental upsert operations.\nThe behavior is similar to ",(0,o.jsx)(n.a,{href:"/rx-document.html#incrementalModify",children:"RxDocument.incrementalModify"}),"."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const docData = {\n    name: 'Bob', // primary\n    lastName: 'Kelso'\n};\n\nmyCollection.upsert(docData);\nmyCollection.upsert(docData);\n// -> throws because of parallel update to the same document\n\nmyCollection.incrementalUpsert(docData);\nmyCollection.incrementalUpsert(docData);\nmyCollection.incrementalUpsert(docData);\n\n// wait until last upsert finished\nawait myCollection.incrementalUpsert(docData);\n// -> works\n"})}),"\n",(0,o.jsx)(n.h3,{id:"find",children:"find()"}),"\n",(0,o.jsxs)(n.p,{children:["To find documents in your collection, use this method. ",(0,o.jsx)(n.a,{href:"/rx-query.html#find",children:"See RxQuery.find()"}),"."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"// find all that are older than 18\nconst olderDocuments = await myCollection\n    .find()\n    .where('age')\n    .gt(18)\n    .exec(); // execute\n"})}),"\n",(0,o.jsx)(n.h3,{id:"findone",children:"findOne()"}),"\n",(0,o.jsx)(n.p,{children:"This does basically what find() does, but it returns only a single document. You can pass a primary value to find a single document more easily."}),"\n",(0,o.jsxs)(n.p,{children:["To find documents in your collection, use this method. ",(0,o.jsx)(n.a,{href:"/rx-query.html#findOne",children:"See RxQuery.find()"}),"."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"// get document with name:foobar\nmyCollection.findOne({\n  selector: {\n    name: 'foo'\n  }\n}).exec().then(doc => console.dir(doc));\n\n// get document by primary, functionally identical to above query\nmyCollection.findOne('foo')\n  .exec().then(doc => console.dir(doc));\n"})}),"\n",(0,o.jsx)(n.h3,{id:"findbyids",children:"findByIds()"}),"\n",(0,o.jsxs)(n.p,{children:["Find many documents by their id (primary value). This has a way better performance than running multiple ",(0,o.jsx)(n.code,{children:"findOne()"})," or a ",(0,o.jsx)(n.code,{children:"find()"})," with a big ",(0,o.jsx)(n.code,{children:"$or"})," selector."]}),"\n",(0,o.jsxs)(n.p,{children:["Returns a ",(0,o.jsx)(n.code,{children:"Map"})," where the primary key of the document is mapped to the document. Documents that do not exist or are deleted, will not be inside of the returned Map."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const ids = [\n  'alice',\n  'bob',\n  /* ... */\n];\nconst docsMap = await myCollection.findByIds(ids);\n\nconsole.dir(docsMap); // Map(2)\n"})}),"\n",(0,o.jsxs)(n.p,{children:["NOTICE: The ",(0,o.jsx)(n.code,{children:"Map"})," returned by ",(0,o.jsx)(n.code,{children:"findByIds"})," is not guaranteed to return elements in the same order as the list of ids passed to it."]}),"\n",(0,o.jsx)(n.h3,{id:"exportjson",children:"exportJSON()"}),"\n",(0,o.jsx)(n.p,{children:"Use this function to create a json export from every document in the collection."}),"\n",(0,o.jsxs)(n.p,{children:["Before ",(0,o.jsx)(n.code,{children:"exportJSON()"})," and ",(0,o.jsx)(n.code,{children:"importJSON()"})," can be used, you have to add the ",(0,o.jsx)(n.code,{children:"json-dump"})," plugin."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"import { addRxPlugin } from 'rxdb';\nimport { RxDBJsonDumpPlugin } from 'rxdb/plugins/json-dump';\naddRxPlugin(RxDBJsonDumpPlugin);\n"})}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"myCollection.exportJSON()\n  .then(json => console.dir(json));\n"})}),"\n",(0,o.jsx)(n.h3,{id:"importjson",children:"importJSON()"}),"\n",(0,o.jsx)(n.p,{children:"To import the json dump into your collection, use this function."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"// import the dump to the database\nmyCollection.importJSON(json)\n  .then(() => console.log('done'));\n"})}),"\n",(0,o.jsx)(n.p,{children:"Note that importing will fire events for each inserted document."}),"\n",(0,o.jsx)(n.h3,{id:"remove",children:"remove()"}),"\n",(0,o.jsx)(n.p,{children:"Removes all known data of the collection and its previous versions.\nThis removes the documents, the schemas, and older schemaVersions."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"await myCollection.remove();\n// collection is now removed and can be re-created\n"})}),"\n",(0,o.jsx)(n.h3,{id:"destroy",children:"destroy()"}),"\n",(0,o.jsx)(n.p,{children:"Destroys the collection's object instance. This is to free up memory and stop all observers and replications."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"await myCollection.destroy();\n"})}),"\n",(0,o.jsx)(n.h3,{id:"isrxcollection",children:"isRxCollection"}),"\n",(0,o.jsx)(n.p,{children:"Returns true if the given object is an instance of RxCollection. Returns false if not."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-js",children:"const is = isRxCollection(myObj);\n"})})]})}function h(e={}){const{wrapper:n}={...(0,s.a)(),...e.components};return n?(0,o.jsx)(n,{...e,children:(0,o.jsx)(d,{...e})}):d(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>c,a:()=>l});var o=t(7294);const s={},i=o.createContext(s);function l(e){const n=o.useContext(i);return o.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function c(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:l(e.components),o.createElement(i.Provider,{value:n},e.children)}}}]);