"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[1609],{2462:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>i,contentTitle:()=>h,default:()=>d,frontMatter:()=>c,metadata:()=>r,toc:()=>l});var a=n(5893),s=n(1151);const c={title:"Attachments",slug:"rx-attachment.html"},h="Attachments",r={id:"rx-attachment",title:"Attachments",description:"Attachments are binary data files that can be attachment to an RxDocument, like a file that is attached to an email.",source:"@site/docs/rx-attachment.md",sourceDirName:".",slug:"/rx-attachment.html",permalink:"/rx-attachment.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rx-attachment.md",tags:[],version:"current",frontMatter:{title:"Attachments",slug:"rx-attachment.html"},sidebar:"tutorialSidebar",previous:{title:"RxQuery",permalink:"/rx-query.html"},next:{title:"\u2699\ufe0f Rxstorage Layer",permalink:"/rx-storage.html"}},i={},l=[{value:"Add the attachments plugin",id:"add-the-attachments-plugin",level:2},{value:"Enable attachments in the schema",id:"enable-attachments-in-the-schema",level:2},{value:"putAttachment()",id:"putattachment",level:2},{value:"getAttachment()",id:"getattachment",level:2},{value:"allAttachments()",id:"allattachments",level:2},{value:"allAttachments$",id:"allattachments-1",level:2},{value:"RxAttachment",id:"rxattachment",level:2},{value:"doc",id:"doc",level:3},{value:"id",id:"id",level:3},{value:"type",id:"type",level:3},{value:"length",id:"length",level:3},{value:"digest",id:"digest",level:3},{value:"rev",id:"rev",level:3},{value:"remove()",id:"remove",level:3},{value:"getData()",id:"getdata",level:2},{value:"getStringData()",id:"getstringdata",level:2}];function o(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,a.jsxs)(a.Fragment,{children:[(0,a.jsx)(t.h1,{id:"attachments",children:"Attachments"}),"\n",(0,a.jsxs)(t.p,{children:["Attachments are binary data files that can be attachment to an ",(0,a.jsx)(t.code,{children:"RxDocument"}),", like a file that is attached to an email."]}),"\n",(0,a.jsxs)(t.p,{children:["Using attachments instead of adding the data to the normal document, ensures that you still have a good ",(0,a.jsx)(t.strong,{children:"performance"})," when querying and writing documents, even when a big amount of data, like an image file has to be stored."]}),"\n",(0,a.jsxs)(t.ul,{children:["\n",(0,a.jsx)(t.li,{children:"You can store string, binary files, images and whatever you want side by side with your documents."}),"\n",(0,a.jsx)(t.li,{children:"Deleted documents automatically loose all their attachments data."}),"\n",(0,a.jsx)(t.li,{children:"Not all replication plugins support the replication of attachments."}),"\n",(0,a.jsxs)(t.li,{children:["Attachments can be stored ",(0,a.jsx)(t.a,{href:"/encryption.html",children:"encrypted"}),"."]}),"\n"]}),"\n",(0,a.jsxs)(t.p,{children:["Internally, attachments in RxDB are stored and handled similar to how ",(0,a.jsx)(t.a,{href:"https://pouchdb.com/guides/attachments.html#how-attachments-are-stored",children:"CouchDB, PouchDB"})," does it."]}),"\n",(0,a.jsx)(t.h2,{id:"add-the-attachments-plugin",children:"Add the attachments plugin"}),"\n",(0,a.jsxs)(t.p,{children:["To enable the attachments, you have to add the ",(0,a.jsx)(t.code,{children:"attachments"})," plugin."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-ts",children:"import { addRxPlugin } from 'rxdb';\nimport { RxDBAttachmentsPlugin } from 'rxdb/plugins/attachments';\naddRxPlugin(RxDBAttachmentsPlugin);\n"})}),"\n",(0,a.jsx)(t.h2,{id:"enable-attachments-in-the-schema",children:"Enable attachments in the schema"}),"\n",(0,a.jsxs)(t.p,{children:["Before you can use attachments, you have to ensure that the attachments-object is set in the schema of your ",(0,a.jsx)(t.code,{children:"RxCollection"}),"."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"\nconst mySchema = {\n    version: 0,\n    type: 'object',\n    properties: {\n        // .\n        // .\n        // .\n    },\n    attachments: {\n        encrypted: true // if true, the attachment-data will be encrypted with the db-password\n    }\n};\n\nconst myCollection = await myDatabase.addCollections({\n    humans: {\n        schema: mySchema\n    }\n});\n"})}),"\n",(0,a.jsx)(t.h2,{id:"putattachment",children:"putAttachment()"}),"\n",(0,a.jsxs)(t.p,{children:["Adds an attachment to a ",(0,a.jsx)(t.code,{children:"RxDocument"}),". Returns a Promise with the new attachment."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"import { createBlob } from 'rxdb';\n\nconst attachment = await myDocument.putAttachment(\n    {\n        id: 'cat.txt',     // (string) name of the attachment\n        data: createBlob('meowmeow', 'text/plain'),   // (string|Blob) data of the attachment\n        type: 'text/plain'    // (string) type of the attachment-data like 'image/jpeg'\n    }\n);\n"})}),"\n",(0,a.jsx)(t.h2,{id:"getattachment",children:"getAttachment()"}),"\n",(0,a.jsxs)(t.p,{children:["Returns an ",(0,a.jsx)(t.code,{children:"RxAttachment"})," by its id. Returns ",(0,a.jsx)(t.code,{children:"null"})," when the attachment does not exist."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const attachment = myDocument.getAttachment('cat.jpg');\n"})}),"\n",(0,a.jsx)(t.h2,{id:"allattachments",children:"allAttachments()"}),"\n",(0,a.jsxs)(t.p,{children:["Returns an array of all attachments of the ",(0,a.jsx)(t.code,{children:"RxDocument"}),"."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const attachments = myDocument.allAttachments();\n"})}),"\n",(0,a.jsx)(t.h2,{id:"allattachments-1",children:"allAttachments$"}),"\n",(0,a.jsx)(t.p,{children:"Gets an Observable which emits a stream of all attachments from the document. Re-emits each time an attachment gets added or removed from the RxDocument."}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const all = [];\nmyDocument.allAttachments$.subscribe(\n    attachments => all = attachments\n);\n"})}),"\n",(0,a.jsx)(t.h2,{id:"rxattachment",children:"RxAttachment"}),"\n",(0,a.jsxs)(t.p,{children:["The attachments of RxDB are represented by the type ",(0,a.jsx)(t.code,{children:"RxAttachment"})," which has the following attributes/methods."]}),"\n",(0,a.jsx)(t.h3,{id:"doc",children:"doc"}),"\n",(0,a.jsxs)(t.p,{children:["The ",(0,a.jsx)(t.code,{children:"RxDocument"})," which the attachment is assigned to."]}),"\n",(0,a.jsx)(t.h3,{id:"id",children:"id"}),"\n",(0,a.jsxs)(t.p,{children:["The id as ",(0,a.jsx)(t.code,{children:"string"})," of the attachment."]}),"\n",(0,a.jsx)(t.h3,{id:"type",children:"type"}),"\n",(0,a.jsxs)(t.p,{children:["The type as ",(0,a.jsx)(t.code,{children:"string"})," of the attachment."]}),"\n",(0,a.jsx)(t.h3,{id:"length",children:"length"}),"\n",(0,a.jsxs)(t.p,{children:["The length of the data of the attachment as ",(0,a.jsx)(t.code,{children:"number"}),"."]}),"\n",(0,a.jsx)(t.h3,{id:"digest",children:"digest"}),"\n",(0,a.jsxs)(t.p,{children:["The hash of the attachments data as ",(0,a.jsx)(t.code,{children:"string"}),"."]}),"\n",(0,a.jsx)(t.p,{children:"NOTICE: The digest is NOT calculated by RxDB, instead it is calculated by the RxStorage. The only guarantee is that the digest will change when the attachments data changes."}),"\n",(0,a.jsx)(t.h3,{id:"rev",children:"rev"}),"\n",(0,a.jsxs)(t.p,{children:["The revision-number of the attachment as ",(0,a.jsx)(t.code,{children:"number"}),"."]}),"\n",(0,a.jsx)(t.h3,{id:"remove",children:"remove()"}),"\n",(0,a.jsx)(t.p,{children:"Removes the attachment. Returns a Promise that resolves when done."}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const attachment = myDocument.getAttachment('cat.jpg');\nawait attachment.remove();\n"})}),"\n",(0,a.jsx)(t.h2,{id:"getdata",children:"getData()"}),"\n",(0,a.jsxs)(t.p,{children:["Returns a Promise which resolves the attachment's data as ",(0,a.jsx)(t.code,{children:"Blob"}),". (async)"]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const attachment = myDocument.getAttachment('cat.jpg');\nconst blob = await attachment.getData();\n"})}),"\n",(0,a.jsx)(t.h2,{id:"getstringdata",children:"getStringData()"}),"\n",(0,a.jsxs)(t.p,{children:["Returns a Promise which resolves the attachment's data as ",(0,a.jsx)(t.code,{children:"string"}),"."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-javascript",children:"const attachment = await myDocument.getAttachment('cat.jpg');\nconst data = await attachment.getStringData();\n"})}),"\n",(0,a.jsx)(t.h1,{id:"attachment-compression",children:"Attachment compression"}),"\n",(0,a.jsxs)(t.p,{children:["Storing many attachments can be a problem when the disc space of the device is exceeded.\nTherefore it can make sense to compress the attachments before storing them in the ",(0,a.jsx)(t.a,{href:"/rx-storage.html",children:"RxStorage"}),".\nWith the ",(0,a.jsx)(t.code,{children:"attachments-compression"})," plugin you can compress the attachments data on write and decompress it on reads.\nThis happens internally and will now change on how you use the api. The compression is run with the ",(0,a.jsx)(t.a,{href:"https://developer.mozilla.org/en-US/docs/Web/API/Compression_Streams_API",children:"Compression Streams API"})," which is only supported on ",(0,a.jsx)(t.a,{href:"https://caniuse.com/?search=compressionstream",children:"newer browsers"}),"."]}),"\n",(0,a.jsx)(t.pre,{children:(0,a.jsx)(t.code,{className:"language-ts",children:"import {\n    wrappedAttachmentsCompressionStorage\n} from 'rxdb/plugins/attachments-compression';\n\nimport { getRxStorageIndexedDB } from 'rxdb-premium/plugins/storage-indexeddb';\n\n// create a wrapped storage with attachment-compression.\nconst storageWithAttachmentsCompression = wrappedAttachmentsCompressionStorage({\n    storage: getRxStorageIndexedDB()\n});\n\nconst db = await createRxDatabase<RxStylechaseCollections>({\n    name: 'mydatabase',\n    storage: storageWithAttachmentsCompression\n});\n\n\n// set the compression mode at the schema level\nconst mySchema = {\n    version: 0,\n    type: 'object',\n    properties: {\n        // .\n        // .\n        // .\n    },\n    attachments: {\n        compression: 'deflate'  // <- Specify the compression mode here. OneOf ['deflate', 'gzip']\n    }\n};\n\n/* ... create your collections as usual and store attachments in them. */\n\n"})})]})}function d(e={}){const{wrapper:t}={...(0,s.a)(),...e.components};return t?(0,a.jsx)(t,{...e,children:(0,a.jsx)(o,{...e})}):o(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>r,a:()=>h});var a=n(7294);const s={},c=a.createContext(s);function h(e){const t=a.useContext(c);return a.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:h(e.components),a.createElement(c.Provider,{value:t},e.children)}}}]);