"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[606],{4530:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>c,contentTitle:()=>o,default:()=>d,frontMatter:()=>i,metadata:()=>s,toc:()=>r});var a=t(5893),l=t(1151);const i={title:"Cleanup",slug:"cleanup.html"},o="\ud83e\uddf9 Cleanup",s={id:"cleanup",title:"Cleanup",description:"To make the replication work, and for other reasons, RxDB has to keep deleted documents in the storage.",source:"@site/docs/cleanup.md",sourceDirName:".",slug:"/cleanup.html",permalink:"/cleanup.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/cleanup.md",tags:[],version:"current",frontMatter:{title:"Cleanup",slug:"cleanup.html"},sidebar:"tutorialSidebar",previous:{title:"Leader Election",permalink:"/leader-election.html"},next:{title:"Backup",permalink:"/backup.html"}},c={},r=[{value:"Add the cleanup plugin",id:"add-the-cleanup-plugin",level:2},{value:"Create a database with cleanup options",id:"create-a-database-with-cleanup-options",level:2},{value:"Calling cleanup manually",id:"calling-cleanup-manually",level:2}];function u(e){const n={code:"code",h1:"h1",h2:"h2",p:"p",pre:"pre",...(0,l.a)(),...e.components};return(0,a.jsxs)(a.Fragment,{children:[(0,a.jsx)(n.h1,{id:"-cleanup",children:"\ud83e\uddf9 Cleanup"}),"\n",(0,a.jsx)(n.p,{children:"To make the replication work, and for other reasons, RxDB has to keep deleted documents in the storage.\nThis ensures that when a client is offline, the deletion state is still known and can be replicated with the backend when the client goes online again."}),"\n",(0,a.jsx)(n.p,{children:"Keeping too many deleted documents in the storage, can slow down queries or fill up too much disc space.\nWith the cleanup plugin, RxDB will run cleanup cycles that clean up deleted documents when it can be done safely."}),"\n",(0,a.jsx)(n.h2,{id:"add-the-cleanup-plugin",children:"Add the cleanup plugin"}),"\n",(0,a.jsx)(n.pre,{children:(0,a.jsx)(n.code,{className:"language-ts",children:"import { addRxPlugin } from 'rxdb';\nimport { RxDBCleanupPlugin } from 'rxdb/plugins/cleanup';\naddRxPlugin(RxDBCleanupPlugin);\n"})}),"\n",(0,a.jsx)(n.h2,{id:"create-a-database-with-cleanup-options",children:"Create a database with cleanup options"}),"\n",(0,a.jsxs)(n.p,{children:["You can set a specific cleanup policy when a ",(0,a.jsx)(n.code,{children:"RxDatabase"})," is created. For most use cases, the defaults should be ok."]}),"\n",(0,a.jsx)(n.pre,{children:(0,a.jsx)(n.code,{className:"language-ts",children:"import { createRxDatabase } from 'rxdb';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\nconst db = await createRxDatabase({\n  name: 'heroesdb',\n  storage: getRxStorageDexie(),\n  cleanupPolicy: {\n      /**\n       * The minimum time in milliseconds for how long\n       * a document has to be deleted before it is\n       * purged by the cleanup.\n       * [default=one month]\n       */\n      minimumDeletedTime: 1000 * 60 * 60 * 24 * 31, // one month,\n      /**\n       * The minimum amount of that that the RxCollection must have existed.\n       * This ensures that at the initial page load, more important\n       * tasks are not slowed down because a cleanup process is running.\n       * [default=60 seconds]\n       */\n      minimumCollectionAge: 1000 * 60, // 60 seconds\n      /**\n       * After the initial cleanup is done,\n       * a new cleanup is started after [runEach] milliseconds \n       * [default=5 minutes]\n       */      \n      runEach: 1000 * 60 * 5, // 5 minutes\n      /**\n       * If set to true,\n       * RxDB will await all running replications\n       * to not have a replication cycle running.\n       * This ensures we do not remove deleted documents\n       * when they might not have already been replicated.\n       * [default=true]\n       */\n      awaitReplicationsInSync: true,\n      /**\n       * If true, it will only start the cleanup\n       * when the current instance is also the leader.\n       * This ensures that when RxDB is used in multiInstance mode,\n       * only one instance will start the cleanup.\n       * [default=true]\n       */\n      waitForLeadership: true\n  }\n});\n"})}),"\n",(0,a.jsx)(n.h2,{id:"calling-cleanup-manually",children:"Calling cleanup manually"}),"\n",(0,a.jsxs)(n.p,{children:["You can manually run a cleanup per collection by calling ",(0,a.jsx)(n.code,{children:"RxCollection.cleanup()"}),"."]}),"\n",(0,a.jsx)(n.pre,{children:(0,a.jsx)(n.code,{className:"language-ts",children:"\n/**\n * Manually run the cleanup with the\n * minimumDeletedTime from the cleanupPolicy.\n */\nawait myRxCollection.cleanup();\n\n\n/**\n * Overwrite the minimumDeletedTime\n * be setting it explicitly (time in milliseconds)\n */\nawait myRxCollection.cleanup(1000);\n\n/**\n * Purge all deleted documents no\n * mather when they where deleted\n * by setting minimumDeletedTime to zero.\n */\nawait myRxCollection.cleanup(0);\n"})})]})}function d(e={}){const{wrapper:n}={...(0,l.a)(),...e.components};return n?(0,a.jsx)(n,{...e,children:(0,a.jsx)(u,{...e})}):u(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>s,a:()=>o});var a=t(7294);const l={},i=a.createContext(l);function o(e){const n=a.useContext(i);return a.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function s(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(l):e.components||l:o(e.components),a.createElement(i.Provider,{value:n},e.children)}}}]);