"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[8577],{566:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>d,contentTitle:()=>o,default:()=>c,frontMatter:()=>s,metadata:()=>a,toc:()=>u});var i=n(5893),r=n(1151);const s={title:"Query Optimizer \ud83d\udc51",slug:"query-optimizer.html"},o="Query Optimizer",a={id:"query-optimizer",title:"Query Optimizer \ud83d\udc51",description:"The query optimizer can be used to determine which index is the best to use for a given query.",source:"@site/docs/query-optimizer.md",sourceDirName:".",slug:"/query-optimizer.html",permalink:"/query-optimizer.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/query-optimizer.md",tags:[],version:"current",frontMatter:{title:"Query Optimizer \ud83d\udc51",slug:"query-optimizer.html"},sidebar:"tutorialSidebar",previous:{title:"ORM",permalink:"/orm.html"},next:{title:"Logger \ud83d\udc51",permalink:"/logger.html"}},d={},u=[{value:"Usage",id:"usage",level:2},{value:"Important details",id:"important-details",level:2}];function l(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,r.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(t.h1,{id:"query-optimizer",children:"Query Optimizer"}),"\n",(0,i.jsx)(t.p,{children:"The query optimizer can be used to determine which index is the best to use for a given query.\nBecause RxDB is used in client side applications, it cannot do any background checks or measurements to optimize the query plan because that would cause significant performance problems."}),"\n",(0,i.jsxs)(t.p,{children:[(0,i.jsx)(t.strong,{children:"NOTICE:"})," The query optimizer is part of the ",(0,i.jsx)(t.a,{href:"/premium",children:"\ud83d\udc51 RxDB Premium"})," plugin that must be purchased. It is not part of the default RxDB module."]}),"\n",(0,i.jsx)(t.h2,{id:"usage",children:"Usage"}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"import {\n    findBestIndex\n} from 'rxdb-premium/plugins/query-optimizer';\n\nimport { \n    getRxStorageIndexedDB\n} from 'rxdb-premium/plugins/indexeddb';\n\nconst bestIndexes = await findBestIndex({\n    schema: myRxJsonSchema,\n    /**\n     * In this example we use the IndexedDB RxStorage,\n     * but any other storage can be used for testing.\n     */\n    storage: getRxStorageIndexedDB(),\n    /**\n     * Multiple queries can be optimized at the same time\n     * which decreases the overall runtime.\n     */\n    queries: {\n        /**\n         * Queries can be mapped by a query id,\n         * here we use myFirstQuery as query id.\n         */\n        myFirstQuery: {\n            selector: {\n                age: {\n                    $gt: 10\n                }\n            },\n        },\n        mySecondQuery: {\n            selector: {\n                age: {\n                    $gt: 10\n                },\n                lastName: {\n                    $eq: 'Nakamoto'\n                }\n            },\n        }\n    },\n    testData: [/** data for the documents. **/]\n});\n\n"})}),"\n",(0,i.jsx)(t.h2,{id:"important-details",children:"Important details"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsxs)(t.li,{children:["\n",(0,i.jsxs)(t.p,{children:["This is a build time tool. You should use it to find the best indexes for your queries during ",(0,i.jsx)(t.strong,{children:"build time"}),". Then you store these results and you application can use the best indexes during ",(0,i.jsx)(t.strong,{children:"run time"}),"."]}),"\n"]}),"\n",(0,i.jsxs)(t.li,{children:["\n",(0,i.jsxs)(t.p,{children:["It makes no sense to run time optimization with a different ",(0,i.jsx)(t.code,{children:"RxStorage"})," (+settings) that what you use in production. The result of the query optimizer is heavily dependent on the RxStorage and JavaScript runtime. For example it makes no sense to run the optimization in Node.js and then use the optimized indexes in the browser."]}),"\n"]}),"\n",(0,i.jsxs)(t.li,{children:["\n",(0,i.jsxs)(t.p,{children:["It is very important the you use ",(0,i.jsx)(t.strong,{children:"production like"})," ",(0,i.jsx)(t.code,{children:"testData"}),". Finding the best index heavily depends on data distribution and amount of stored/queried documents. For example if you store and query users with an ",(0,i.jsx)(t.code,{children:"age"})," field, it makes no sense to just use a random number for the age because in production the ",(0,i.jsx)(t.code,{children:"age"})," of your users is not equally distributed."]}),"\n"]}),"\n",(0,i.jsxs)(t.li,{children:["\n",(0,i.jsxs)(t.p,{children:["The higher you set ",(0,i.jsx)(t.code,{children:"runs"}),", the more test cycles will be performed and the more ",(0,i.jsx)(t.strong,{children:"significant"})," will be the time measurements which leads to a better index selection."]}),"\n"]}),"\n"]})]})}function c(e={}){const{wrapper:t}={...(0,r.a)(),...e.components};return t?(0,i.jsx)(t,{...e,children:(0,i.jsx)(l,{...e})}):l(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>a,a:()=>o});var i=n(7294);const r={},s=i.createContext(r);function o(e){const t=i.useContext(s);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function a(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(r):e.components||r:o(e.components),i.createElement(s.Provider,{value:t},e.children)}}}]);