"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[6432],{698:(e,n,r)=>{r.r(n),r.d(n,{assets:()=>l,contentTitle:()=>i,default:()=>c,frontMatter:()=>o,metadata:()=>s,toc:()=>d});var t=r(5893),a=r(1151);const o={title:"Migration Storage",slug:"migration-storage.html"},i="Storage Migration",s={id:"migration-storage",title:"Migration Storage",description:"The storage migration plugin can be used to migrate all data from one existing RxStorage into another. This is useful when:",source:"@site/docs/migration-storage.md",sourceDirName:".",slug:"/migration-storage.html",permalink:"/migration-storage.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/migration-storage.md",tags:[],version:"current",frontMatter:{title:"Migration Storage",slug:"migration-storage.html"},sidebar:"tutorialSidebar",previous:{title:"Migration Schema",permalink:"/migration-schema.html"},next:{title:"Encryption",permalink:"/encryption.html"}},l={},d=[{value:"Usage",id:"usage",level:2},{value:"Migrate from a previous RxDB major version",id:"migrate-from-a-previous-rxdb-major-version",level:2},{value:"Disable Version Check on \ud83d\udc51 RxDB Premium",id:"disable-version-check-on--rxdb-premium",level:2}];function m(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,a.a)(),...e.components};return(0,t.jsxs)(t.Fragment,{children:[(0,t.jsx)(n.h1,{id:"storage-migration",children:"Storage Migration"}),"\n",(0,t.jsx)(n.p,{children:"The storage migration plugin can be used to migrate all data from one existing RxStorage into another. This is useful when:"}),"\n",(0,t.jsxs)(n.ul,{children:["\n",(0,t.jsxs)(n.li,{children:["You want to migration from one ",(0,t.jsx)(n.a,{href:"/rx-storage.html",children:"RxStorage"})," to another one."]}),"\n",(0,t.jsx)(n.li,{children:"You want to migrate to a new major RxDB version while keeping the previous saved data. This function only works from the previous major version upwards. Do not use it to migrate like rxdb v9 to v14."}),"\n"]}),"\n",(0,t.jsxs)(n.p,{children:["The storage migration ",(0,t.jsx)(n.strong,{children:"drops deleted documents"})," and filters them out during the migration."]}),"\n",(0,t.jsx)(n.h2,{id:"usage",children:"Usage"}),"\n",(0,t.jsxs)(n.p,{children:["Lets say you want to migrate from LokiJs to the ",(0,t.jsx)(n.a,{href:"/rx-storage-dexie.html",children:"Dexie.js"})," RxStorage."]}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-ts",children:"import { migrateStorage } from 'rxdb/plugins/migration-storage';\nimport {\n    getRxStorageLoki\n} from 'rxdb/plugins/storage-loki';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\n\n// create the new RxDatabase\nconst db = await createRxDatabase<RxStylechaseCollections>({\n    name: dbLocation,\n    storage: getRxStorageDexie(),\n    multiInstance: false\n});\n\nawait migrateStorage({\n    database: db as any,\n    /**\n     * Name of the old database,\n     * using the storage migration requires that the\n     * new database has a different name.\n     */\n    oldDatabaseName: 'myOldDatabaseName',\n    oldStorage: getRxStorageLoki(), // RxStorage of the old database\n    batchSize: 500, // batch size\n    parallel: false, // <- true if it should migrate all collections in parallel. False (default) if should migrate in serial\n    afterMigrateBatch: (input: AfterMigrateBatchHandlerInput) => {\n        console.log('storage migration: batch processed');\n    }\n});\n"})}),"\n",(0,t.jsx)(n.h2,{id:"migrate-from-a-previous-rxdb-major-version",children:"Migrate from a previous RxDB major version"}),"\n",(0,t.jsxs)(n.p,{children:["To migrate from a previous RxDB major version, you have to install the 'old' RxDB in the ",(0,t.jsx)(n.code,{children:"package.json"})]}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-json",children:'{\n    "dependencies": {\n        "rxdb-old": "npm:rxdb@14.17.1",\n    }\n}\n'})}),"\n",(0,t.jsx)(n.p,{children:"The you can run the migration by providing the old storage:"}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-ts",children:"/* ... */\nimport { migrateStorage } from 'rxdb/plugins/migration-storage';\nimport {\n    getRxStorageLoki\n} from 'rxdb-old/plugins/storage-loki'; // <- import from the old RxDB version\n\nawait migrateStorage({\n    database: db as any,\n    /**\n     * Name of the old database,\n     * using the storage migration requires that the\n     * new database has a different name.\n     */\n    oldDatabaseName: 'myOldDatabaseName',\n    oldStorage: getRxStorageLoki(), // RxStorage of the old database\n    batchSize: 500, // batch size\n    parallel: false,\n    afterMigrateBatch: (input: AfterMigrateBatchHandlerInput) => {\n        console.log('storage migration: batch processed');\n    }\n});\n/* ... */\n"})}),"\n",(0,t.jsxs)(n.h2,{id:"disable-version-check-on--rxdb-premium",children:["Disable Version Check on ",(0,t.jsx)(n.a,{href:"/premium",children:"\ud83d\udc51 RxDB Premium"})]}),"\n",(0,t.jsxs)(n.p,{children:["RxDb Premium has a check in place that ensures that you do not accidentally use the wrong RxDB core and \ud83d\udc51 Premium version together which could break your database state.\nThis can be a problem during migrations where you have multiple versions of RxDB in use and it will throw the error ",(0,t.jsx)(n.code,{children:"Version mismatch detected"}),".\nYou can disable that check by importing and running the ",(0,t.jsx)(n.code,{children:"disableVersionCheck()"})," function from RxDB Premium."]}),"\n",(0,t.jsx)(n.pre,{children:(0,t.jsx)(n.code,{className:"language-ts",children:"// RxDB Premium v15 or newer:\nimport {\n    disableVersionCheck\n} from 'rxdb-premium-old/plugins/shared';\ndisableVersionCheck();\n\n\n// RxDB Premium v14:\n\n// for esm\nimport {\n    disableVersionCheck\n} from 'rxdb-premium-old/dist/es/shared/version-check.js';\ndisableVersionCheck();\n\n// for cjs\nimport {\n    disableVersionCheck\n} from 'rxdb-premium-old/dist/lib/shared/version-check.js';\ndisableVersionCheck();\n\n\n\n\n"})})]})}function c(e={}){const{wrapper:n}={...(0,a.a)(),...e.components};return n?(0,t.jsx)(n,{...e,children:(0,t.jsx)(m,{...e})}):m(e)}},1151:(e,n,r)=>{r.d(n,{Z:()=>s,a:()=>i});var t=r(7294);const a={},o=t.createContext(a);function i(e){const n=t.useContext(o);return t.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function s(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:i(e.components),t.createElement(o.Provider,{value:n},e.children)}}}]);