"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[5657],{8852:(e,a,t)=>{t.r(a),t.d(a,{assets:()=>d,contentTitle:()=>o,default:()=>c,frontMatter:()=>s,metadata:()=>r,toc:()=>l});var n=t(5893),i=t(1151);const s={title:"Schema Validation",slug:"schema-validation.html"},o="Schema validation",r={id:"schema-validation",title:"Schema Validation",description:"RxDB has multiple validation implementations that can be used to ensure that your document data is always matching the provided JSON",source:"@site/docs/schema-validation.md",sourceDirName:".",slug:"/schema-validation.html",permalink:"/schema-validation.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/schema-validation.md",tags:[],version:"current",frontMatter:{title:"Schema Validation",slug:"schema-validation.html"}},d={},l=[{value:"validate-ajv",id:"validate-ajv",level:3},{value:"validate-z-schema",id:"validate-z-schema",level:3},{value:"validate-is-my-json-valid",id:"validate-is-my-json-valid",level:3}];function h(e){const a={a:"a",code:"code",h1:"h1",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,i.a)(),...e.components};return(0,n.jsxs)(n.Fragment,{children:[(0,n.jsx)(a.h1,{id:"schema-validation",children:"Schema validation"}),"\n",(0,n.jsxs)(a.p,{children:["RxDB has multiple validation implementations that can be used to ensure that your document data is always matching the provided JSON\nschema of your ",(0,n.jsx)(a.code,{children:"RxCollection"}),"."]}),"\n",(0,n.jsxs)(a.p,{children:["The schema validation is ",(0,n.jsx)(a.strong,{children:"not a plugin"})," but comes in as a wrapper around any other ",(0,n.jsx)(a.code,{children:"RxStorage"})," and it will then validate all data that is written into that storage. This is required for multiple reasons:"]}),"\n",(0,n.jsxs)(a.ul,{children:["\n",(0,n.jsxs)(a.li,{children:["It allows us to run the validation inside of a ",(0,n.jsx)(a.a,{href:"/rx-storage-worker.html",children:"Worker RxStorage"})," instead of running it in the main JavaScript process."]}),"\n",(0,n.jsxs)(a.li,{children:["It allows us to configure which ",(0,n.jsx)(a.code,{children:"RxDatabase"})," instance must use the validation and which does not. In production it often makes sense to validate user data, but you might not need the validation for data that is only replicated from the backend."]}),"\n"]}),"\n",(0,n.jsxs)(a.p,{children:[(0,n.jsx)(a.strong,{children:"NOTICE:"})," Schema validation can be ",(0,n.jsx)(a.strong,{children:"CPU expensive"})," and increases your build size. You should always use a schema validation in development mode. For most use cases, you ",(0,n.jsx)(a.strong,{children:"should not"})," use a validation in production for better performance."]}),"\n",(0,n.jsxs)(a.p,{children:["When no validation is used, any document data can be saved but there might be ",(0,n.jsx)(a.strong,{children:"undefined behavior"})," when saving data that does not comply to the schema of a ",(0,n.jsx)(a.code,{children:"RxCollection"}),"."]}),"\n",(0,n.jsxs)(a.p,{children:["RxDB has different implementations to validate data, each of them is based on a different ",(0,n.jsx)(a.a,{href:"https://json-schema.org/implementations.html",children:"JSON Schema library"}),". In this example we use the ",(0,n.jsx)(a.a,{href:"/rx-storage-dexie.html",children:"Dexie.js RxStorage"}),", but you can wrap the validation around ",(0,n.jsx)(a.strong,{children:"any other"})," ",(0,n.jsx)(a.a,{href:"/rx-storage.html",children:"RxStorage"}),"."]}),"\n",(0,n.jsx)(a.h3,{id:"validate-ajv",children:"validate-ajv"}),"\n",(0,n.jsxs)(a.p,{children:["A validation-module that does the schema-validation. This one is using ",(0,n.jsx)(a.a,{href:"https://github.com/epoberezkin/ajv",children:"ajv"})," as validator which is a bit faster. Better compliant to the jsonschema-standard but also has a bigger build-size."]}),"\n",(0,n.jsx)(a.pre,{children:(0,n.jsx)(a.code,{className:"language-javascript",children:"import { wrappedValidateAjvStorage } from 'rxdb/plugins/validate-ajv';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\n\n// wrap the validation around the main RxStorage\nconst storage = wrappedValidateAjvStorage({\n    storage: getRxStorageDexie()\n});\n\nconst db = await createRxDatabase({\n    name: randomCouchString(10),\n    storage\n});\n"})}),"\n",(0,n.jsx)(a.h3,{id:"validate-z-schema",children:"validate-z-schema"}),"\n",(0,n.jsxs)(a.p,{children:["Both ",(0,n.jsx)(a.code,{children:"is-my-json-valid"})," and ",(0,n.jsx)(a.code,{children:"validate-ajv"})," use ",(0,n.jsx)(a.code,{children:"eval()"})," to perform validation which might not be wanted when ",(0,n.jsx)(a.code,{children:"'unsafe-eval'"})," is not allowed in Content Security Policies. This one is using ",(0,n.jsx)(a.a,{href:"https://github.com/zaggino/z-schema",children:"z-schema"})," as validator which doesn't use ",(0,n.jsx)(a.code,{children:"eval"}),"."]}),"\n",(0,n.jsx)(a.pre,{children:(0,n.jsx)(a.code,{className:"language-javascript",children:"import { wrappedValidateZSchemaStorage } from 'rxdb/plugins/validate-z-schema';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\n\n// wrap the validation around the main RxStorage\nconst storage = wrappedValidateZSchemaStorage({\n    storage: getRxStorageDexie()\n});\n\nconst db = await createRxDatabase({\n    name: randomCouchString(10),\n    storage\n});\n"})}),"\n",(0,n.jsx)(a.h3,{id:"validate-is-my-json-valid",children:"validate-is-my-json-valid"}),"\n",(0,n.jsxs)(a.p,{children:[(0,n.jsx)(a.strong,{children:"WARNING"}),": The ",(0,n.jsx)(a.code,{children:"is-my-json-valid"})," validation is no longer supported until ",(0,n.jsx)(a.a,{href:"https://github.com/mafintosh/is-my-json-valid/pull/192",children:"this bug"})," is fixed."]}),"\n",(0,n.jsxs)(a.p,{children:["The ",(0,n.jsx)(a.code,{children:"validate-is-my-json-valid"})," plugin uses ",(0,n.jsx)(a.a,{href:"https://www.npmjs.com/package/is-my-json-valid",children:"is-my-json-valid"})," for schema validation."]}),"\n",(0,n.jsx)(a.pre,{children:(0,n.jsx)(a.code,{className:"language-javascript",children:"import { wrappedValidateIsMyJsonValidStorage } from 'rxdb/plugins/validate-is-my-json-valid';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\n\n// wrap the validation around the main RxStorage\nconst storage = wrappedValidateIsMyJsonValidStorage({\n    storage: getRxStorageDexie()\n});\n\nconst db = await createRxDatabase({\n    name: randomCouchString(10),\n    storage\n});\n"})})]})}function c(e={}){const{wrapper:a}={...(0,i.a)(),...e.components};return a?(0,n.jsx)(a,{...e,children:(0,n.jsx)(h,{...e})}):h(e)}},1151:(e,a,t)=>{t.d(a,{Z:()=>r,a:()=>o});var n=t(7294);const i={},s=n.createContext(i);function o(e){const a=n.useContext(s);return n.useMemo((function(){return"function"==typeof e?e(a):{...a,...e}}),[a,e])}function r(e){let a;return a=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:o(e.components),n.createElement(s.Provider,{value:a},e.children)}}}]);