"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[980],{5760:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>l,contentTitle:()=>s,default:()=>h,frontMatter:()=>c,metadata:()=>i,toc:()=>d});var o=t(5893),a=t(1151);const c={title:"ORM",slug:"orm.html"},s="Object-Data-Relational-Mapping",i={id:"orm",title:"ORM",description:"Like mongoose, RxDB has ORM-capabilities which can be used to add specific behavior to documents and collections.",source:"@site/docs/orm.md",sourceDirName:".",slug:"/orm.html",permalink:"/orm.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/orm.md",tags:[],version:"current",frontMatter:{title:"ORM",slug:"orm.html"},sidebar:"tutorialSidebar",previous:{title:"Population",permalink:"/population.html"},next:{title:"Query Optimizer \ud83d\udc51",permalink:"/query-optimizer.html"}},l={},d=[{value:"statics",id:"statics",level:2},{value:"Add statics to a collection",id:"add-statics-to-a-collection",level:3},{value:"instance-methods",id:"instance-methods",level:2},{value:"Add instance-methods to a collection",id:"add-instance-methods-to-a-collection",level:3},{value:"attachment-methods",id:"attachment-methods",level:2}];function r(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",p:"p",pre:"pre",...(0,a.a)(),...e.components};return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(n.h1,{id:"object-data-relational-mapping",children:"Object-Data-Relational-Mapping"}),"\n",(0,o.jsxs)(n.p,{children:["Like ",(0,o.jsx)(n.a,{href:"http://mongoosejs.com/docs/guide.html#methods",children:"mongoose"}),", RxDB has ORM-capabilities which can be used to add specific behavior to documents and collections."]}),"\n",(0,o.jsx)(n.h2,{id:"statics",children:"statics"}),"\n",(0,o.jsx)(n.p,{children:"Statics are defined collection-wide and can be called on the collection."}),"\n",(0,o.jsx)(n.h3,{id:"add-statics-to-a-collection",children:"Add statics to a collection"}),"\n",(0,o.jsxs)(n.p,{children:["To add static functions, pass a ",(0,o.jsx)(n.code,{children:"statics"}),"-object when you create your collection. The object contains functions, mapped to their function-names."]}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const heroes = await myDatabase.addCollections({\n  heroes: {\n    schema: mySchema,\n    statics: {\n      scream: function(){\n          return 'AAAH!!';\n      }\n    }\n  }\n});\n\nconsole.log(heroes.scream());\n// 'AAAH!!'\n"})}),"\n",(0,o.jsx)(n.p,{children:"You can also use the this-keyword which resolves to the collection:"}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const heroes = await myDatabase.addCollections({\n  heroes: {\n    schema: mySchema,\n    statics: {\n      whoAmI: function(){\n          return this.name;\n      }\n    }\n  }\n});\nconsole.log(heroes.whoAmI());\n// 'heroes'\n"})}),"\n",(0,o.jsx)(n.h2,{id:"instance-methods",children:"instance-methods"}),"\n",(0,o.jsx)(n.p,{children:"Instance-methods are defined collection-wide. They can be called on the RxDocuments of the collection."}),"\n",(0,o.jsx)(n.h3,{id:"add-instance-methods-to-a-collection",children:"Add instance-methods to a collection"}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const heroes = await myDatabase.addCollections({\n  heroes: {\n    schema: mySchema,\n    methods: {\n      scream: function(){\n        return 'AAAH!!';\n      }\n    }\n  }\n});\nconst doc = await heroes.findOne().exec();\nconsole.log(doc.scream());\n// 'AAAH!!'\n"})}),"\n",(0,o.jsx)(n.p,{children:"Here you can also use the this-keyword:"}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const heroes = await myDatabase.addCollections({\n  heroes: {\n    schema: mySchema,\n    methods: {\n      whoAmI: function(){\n          return 'I am ' + this.name + '!!';\n      }\n    }\n  }\n});\nawait heroes.insert({\n  name: 'Skeletor'\n});\nconst doc = await heroes.findOne().exec();\nconsole.log(doc.whoAmI());\n// 'I am Skeletor!!'\n"})}),"\n",(0,o.jsx)(n.h2,{id:"attachment-methods",children:"attachment-methods"}),"\n",(0,o.jsx)(n.p,{children:"Attachment-methods are defined collection-wide. They can be called on the RxAttachments of the RxDocuments of the collection."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const heroes = await myDatabase.addCollections({\n  heroes: {\n    schema: mySchema,\n    attachments: {\n      scream: function(){\n          return 'AAAH!!';\n      }\n    }\n  }\n});\nconst doc = await heroes.findOne().exec();\nconst attachment = await doc.putAttachment({\n    id: 'cat.txt',\n    data: 'meow I am a kitty',\n    type: 'text/plain'\n});\nconsole.log(attachment.scream());\n// 'AAAH!!'\n"})})]})}function h(e={}){const{wrapper:n}={...(0,a.a)(),...e.components};return n?(0,o.jsx)(n,{...e,children:(0,o.jsx)(r,{...e})}):r(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>i,a:()=>s});var o=t(7294);const a={},c=o.createContext(a);function s(e){const n=o.useContext(c);return o.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function i(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:s(e.components),o.createElement(c.Provider,{value:n},e.children)}}}]);