"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[4674],{544:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>l,contentTitle:()=>s,default:()=>h,frontMatter:()=>r,metadata:()=>o,toc:()=>c});var i=n(5893),a=n(1151);const r={title:"NATS Replication",slug:"replication-nats.html"},s="Replication with NATS",o={id:"replication-nats",title:"NATS Replication",description:"With this RxDB plugin you can run a two-way realtime replication with a NATS server.",source:"@site/docs/replication-nats.md",sourceDirName:".",slug:"/replication-nats.html",permalink:"/replication-nats.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/replication-nats.md",tags:[],version:"current",frontMatter:{title:"NATS Replication",slug:"replication-nats.html"},sidebar:"tutorialSidebar",previous:{title:"Firestore Replication",permalink:"/replication-firestore.html"},next:{title:"Migration Schema",permalink:"/migration-schema.html"}},l={},c=[{value:"Precondition",id:"precondition",level:2},{value:"Usage",id:"usage",level:2},{value:"Handling deletes",id:"handling-deletes",level:2}];function d(e){const t={a:"a",code:"code",em:"em",h1:"h1",h2:"h2",p:"p",pre:"pre",...(0,a.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(t.h1,{id:"replication-with-nats",children:"Replication with NATS"}),"\n",(0,i.jsxs)(t.p,{children:["With this RxDB plugin you can run a two-way realtime replication with a ",(0,i.jsx)(t.a,{href:"https://nats.io/",children:"NATS"})," server."]}),"\n",(0,i.jsxs)(t.p,{children:["The replication itself uses the ",(0,i.jsx)(t.a,{href:"/replication.html",children:"RxDB replication protocol"})," which handles conflicts, errors and retries.\nOn the client side the official ",(0,i.jsx)(t.a,{href:"https://www.npmjs.com/package/nats",children:"NATS npm package"})," is used to connect to the NATS server."]}),"\n",(0,i.jsx)(t.p,{children:"NATS is a messaging system that by itself does not have a validation or granulary access control build in.\nTherefore it is not recommended to directly replicate the NATS server with an untrusted RxDB client application. Instead you should replicated from NATS to your Node.js server side RxDB database."}),"\n",(0,i.jsx)(t.h2,{id:"precondition",children:"Precondition"}),"\n",(0,i.jsxs)(t.p,{children:["For the replication endpoint the NATS cluster must have enabled ",(0,i.jsx)(t.a,{href:"https://docs.nats.io/nats-concepts/jetstream",children:"JetStream"})," and store all message data as ",(0,i.jsx)(t.a,{href:"https://www.google.com/search?q=nats+jetstream+json&oq=nats+jetstream+json&aqs=chrome..69i57j69i60l2.2442j0j7&sourceid=chrome&ie=UTF-8",children:"structured JSON"}),"."]}),"\n",(0,i.jsx)(t.p,{children:"The easiest way to start a compatible NATS server is to use the official docker image:"}),"\n",(0,i.jsx)(t.p,{children:(0,i.jsx)(t.code,{children:"docker run --rm --name rxdb-nats -p 4222:4222 nats:2.9.17 -js"})}),"\n",(0,i.jsx)(t.h2,{id:"usage",children:"Usage"}),"\n",(0,i.jsxs)(t.p,{children:["To start the replication, import the ",(0,i.jsx)(t.code,{children:"replicateNats()"})," method from the RxDB plugin and call it with the collection\nthat must be replicated.\nThe replication runs ",(0,i.jsx)(t.em,{children:"per RxCollection"}),", you can replicate multiple RxCollections by starting a new replication for each of them."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-typescript",children:"import {\n    replicateNats\n} from 'rxdb/plugins/replication-nats';\n\nconst replicationState = replicateNats({\n    collection: myRxCollection,\n    replicationIdentifier: 'my-nats-replication-collection-A',\n    // in NATS, each stream need a name\n    streamName: 'stream-for-replication-A',\n    /**\n     * The subject prefix determines how the documents are stored in NATS.\n     * For example the document with id 'alice' will have the subject 'foobar.alice'\n     */\n    subjectPrefix: 'foobar',\n    connection: { servers: 'localhost:4222' },\n    live: true,\n    pull: {\n        batchSize: 30\n    },\n    push: {\n        batchSize: 30\n    }\n});\n"})}),"\n",(0,i.jsx)(t.h2,{id:"handling-deletes",children:"Handling deletes"}),"\n",(0,i.jsxs)(t.p,{children:["RxDB requires you to never ",(0,i.jsx)(t.a,{href:"/replication.html#data-layout-on-the-server",children:"fully delete documents"}),". This is needed to be able to replicate the deletion state of a document to other instances. The NATS replication will set a boolean ",(0,i.jsx)(t.code,{children:"_deleted"})," field to all documents to indicate the deletion state. You can change this by setting a different ",(0,i.jsx)(t.code,{children:"deletedField"})," in the sync options."]})]})}function h(e={}){const{wrapper:t}={...(0,a.a)(),...e.components};return t?(0,i.jsx)(t,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>o,a:()=>s});var i=n(7294);const a={},r=i.createContext(a);function s(e){const t=i.useContext(r);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function o(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:s(e.components),i.createElement(r.Provider,{value:t},e.children)}}}]);