"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[8862],{7292:(e,a,t)=>{t.r(a),t.d(a,{assets:()=>d,contentTitle:()=>r,default:()=>h,frontMatter:()=>i,metadata:()=>o,toc:()=>l});var s=t(5893),n=t(1151);const i={title:"RxDB - JSON Database for JavaScript",slug:"json-database.html"},r="RxDB - JSON Database for JavaScript",o={id:"articles/json-database",title:"RxDB - JSON Database for JavaScript",description:"Storing data as JSON documents in a NoSQL database is not just a trend; it's a practical choice. JSON data is highly compatible with various tools and is human-readable, making it an excellent fit for modern applications. JSON documents offer more flexibility compared to traditional SQL table rows, as they can contain nested data structures. This article introduces RxDB, an open-source, flexible, performant, and battle-tested NoSQL JSON database specifically designed for JavaScript applications.",source:"@site/docs/articles/json-database.md",sourceDirName:"articles",slug:"/articles/json-database.html",permalink:"/articles/json-database.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/articles/json-database.md",tags:[],version:"current",frontMatter:{title:"RxDB - JSON Database for JavaScript",slug:"json-database.html"},sidebar:"tutorialSidebar",previous:{title:"Ionic Storage - RxDB as database for hybrid apps",permalink:"/articles/ionic-database.html"},next:{title:"Using localStorage in Modern Applications - A Comprehensive Guide",permalink:"/articles/localstorage.html"}},d={},l=[{value:"Why Choose a JSON Database?",id:"why-choose-a-json-database",level:2},{value:"Storage and Access Options for JSON Documents",id:"storage-and-access-options-for-json-documents",level:2},{value:"Compression Storage for JSON Documents",id:"compression-storage-for-json-documents",level:2},{value:"Schema Validation and Data Migration on Schema Changes",id:"schema-validation-and-data-migration-on-schema-changes",level:2},{value:"Store JSON with RxDB in Browser Applications",id:"store-json-with-rxdb-in-browser-applications",level:2},{value:"RxDB Database Performance",id:"rxdb-database-performance",level:2},{value:"RxDB in Node.js",id:"rxdb-in-nodejs",level:2},{value:"RxDB to store JSON documents in React Native",id:"rxdb-to-store-json-documents-in-react-native",level:2},{value:"Using SQLite as a JSON Database",id:"using-sqlite-as-a-json-database",level:2},{value:"Follow Up",id:"follow-up",level:2}];function c(e){const a={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,n.a)(),...e.components};return(0,s.jsxs)(s.Fragment,{children:[(0,s.jsx)(a.h1,{id:"rxdb---json-database-for-javascript",children:"RxDB - JSON Database for JavaScript"}),"\n",(0,s.jsxs)(a.p,{children:["Storing data as ",(0,s.jsx)(a.strong,{children:"JSON documents"})," in a ",(0,s.jsx)(a.strong,{children:"NoSQL"})," database is not just a trend; it's a practical choice. JSON data is highly compatible with various tools and is human-readable, making it an excellent fit for modern applications. JSON documents offer more flexibility compared to traditional SQL table rows, as they can contain nested data structures. This article introduces ",(0,s.jsx)(a.a,{href:"https://rxdb.info/",children:"RxDB"}),", an open-source, flexible, performant, and battle-tested NoSQL JSON database specifically designed for ",(0,s.jsx)(a.strong,{children:"JavaScript"})," applications."]}),"\n",(0,s.jsx)("center",{children:(0,s.jsx)("a",{href:"https://rxdb.info/",children:(0,s.jsx)("img",{src:"../files/logo/rxdb_javascript_database.svg",alt:"JSON Database",width:"220"})})}),"\n",(0,s.jsx)(a.h2,{id:"why-choose-a-json-database",children:"Why Choose a JSON Database?"}),"\n",(0,s.jsxs)(a.ul,{children:["\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"JavaScript Friendliness"}),": JavaScript, a prevalent language for web development, naturally uses JSON for data representation. Using a JSON database aligns seamlessly with JavaScript's native data format."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Compatibility"}),": JSON is widely supported across different programming languages and platforms. Storing data in JSON format ensures compatibility with a broad range of tools and systems. All modern programming ecosystems have packages to parse, validate and process JSON data."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Flexibility"}),": JSON documents can accommodate complex and nested data structures, allowing developers to store data in a more intuitive and hierarchical manner compared to SQL table rows. Nested data can be just stored in-document instead of having related tables."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Human-Readable"}),": JSON is easy to read and understand, simplifying debugging and data inspection tasks."]}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(a.h2,{id:"storage-and-access-options-for-json-documents",children:"Storage and Access Options for JSON Documents"}),"\n",(0,s.jsx)(a.p,{children:"When incorporating JSON documents into your application, you have several storage and access options to consider:"}),"\n",(0,s.jsxs)(a.ul,{children:["\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Local In-App Database with In-Memory Storage"}),": Ideal for lightweight applications or temporary data storage, this option keeps data in memory, ensuring fast read and write operations. However, data is not persisted beyond the current application session, making it suitable for temporary data storage. With RxDB, the ",(0,s.jsx)(a.a,{href:"/rx-storage-memory.html",children:"memory RxStorage"})," can be utilized to create an in-memory database."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Local In-App Database with Persistent Storage"}),": Suitable for applications requiring data retention across sessions. Data is stored on the user's device or inside of the Node.js application, offering persistence between application sessions. It balances speed and data retention, making it versatile for various applications. With RxDB, a whole range of persistend storages is available. As example, for browser there is the ",(0,s.jsx)(a.a,{href:"/rx-storage-indexeddb.html",children:"IndexedDB storage"}),". For server side applications, the ",(0,s.jsx)(a.a,{href:"/rx-storage-filesystem-node.html",children:"Node.js Filesystem storage"})," can be used. There are ",(0,s.jsx)(a.a,{href:"/rx-storage.html",children:"many more storages"})," for React-Native, Flutter, Capacitors.js and others."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Server Database Connected to the Application"}),": For applications requiring data synchronization and accessibility from multiple processes, a server-based database is the preferred choice. Data is stored on a ",(0,s.jsx)(a.strong,{children:"remote server"}),", facilitating data sharing, synchronization, and accessibility across multiple processes. It's suitable for scenarios requiring centralized data management and enhanced security and backup capabilities on the server. RxDB supports the ",(0,s.jsx)(a.a,{href:"/rx-storage-foundationdb.html",children:"FoundationDB"})," and ",(0,s.jsx)(a.a,{href:"/rx-storage-mongodb.html",children:"MongoDB"})," as a remote database server."]}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(a.h2,{id:"compression-storage-for-json-documents",children:"Compression Storage for JSON Documents"}),"\n",(0,s.jsxs)(a.p,{children:["Compression storage for JSON documents is made effortless with RxDB's ",(0,s.jsx)(a.a,{href:"/key-compression.html",children:"key-compression plugin"}),". This feature enables the efficient storage of compressed document data, reducing storage requirements while maintaining data integrity. Queries on compressed documents remain seamless, ensuring that your application benefits from both space-saving advantages and optimal query performance, making RxDB a compelling choice for managing JSON data efficiently. The compression happens inside of the ",(0,s.jsx)(a.a,{href:"/rx-database.html",children:"RxDatabase"})," and does not affect the API usage. The only limitation is that encrypted fields themself cannot be used inside a query."]}),"\n",(0,s.jsx)(a.h2,{id:"schema-validation-and-data-migration-on-schema-changes",children:"Schema Validation and Data Migration on Schema Changes"}),"\n",(0,s.jsxs)(a.p,{children:["Storing JSON documents inside of an application, can cause a problem when the format of the data changes. Instead of having a single server where the data must be migrated, many client devices are out there that have to run a migration.\nWhen your application's schema evolves, RxDB provides ",(0,s.jsx)(a.a,{href:"/migration-schema.html",children:"migration strategies"})," to facilitate the transition, ensuring data consistency throughout schema updates."]}),"\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"JSONSchema Validation Plugins"}),": RxDB supports multiple ",(0,s.jsx)(a.a,{href:"/schema-validation.html",children:"JSONSchema validation plugins"}),", guaranteeing that only valid data is stored in the database. RxDB uses the JsonSchema standardization that you might know from other technologies like OpenAPI (aka Swagger)."]}),"\n",(0,s.jsx)(a.pre,{children:(0,s.jsx)(a.code,{className:"language-javascript",children:"// RxDB Schema example\nconst mySchema = {\n    version: 0,\n    primaryKey: 'id', // <- define the primary key for your documents\n    type: 'object',\n    properties: {\n        id: {\n            type: 'string',\n            maxLength: 100 // <- the primary key must have set maxLength\n        },\n        name: {\n            type: 'string',\n            maxLength: 100\n        },\n        done: {\n            type: 'boolean'\n        },\n        timestamp: {\n            type: 'string',\n            format: 'date-time'\n        }\n    },\n    required: ['id', 'name', 'done', 'timestamp']\n}\n"})}),"\n",(0,s.jsx)(a.h2,{id:"store-json-with-rxdb-in-browser-applications",children:"Store JSON with RxDB in Browser Applications"}),"\n",(0,s.jsx)(a.p,{children:"RxDB offers versatile storage solutions for browser-based applications:"}),"\n",(0,s.jsxs)(a.ul,{children:["\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Multiple Storage Plugins"}),": RxDB supports various storage backends, including ",(0,s.jsx)(a.a,{href:"/rx-storage-indexeddb.html",children:"IndexedDB"}),", ",(0,s.jsx)(a.a,{href:"/rx-storage-dexie.html",children:"Dexie.js"}),", ",(0,s.jsx)(a.a,{href:"/rx-storage-memory.html",children:"In-Memory"}),", and ",(0,s.jsx)(a.a,{href:"/rx-storage-lokijs.html",children:"Loki.js"}),", catering to a range of browser environments."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Observable Queries"}),": With RxDB, you can create observable ",(0,s.jsx)(a.a,{href:"/rx-query.html",children:"queries"})," that work seamlessly across multiple browser tabs, providing real-time updates and synchronization."]}),"\n"]}),"\n"]}),"\n",(0,s.jsx)("p",{align:"center",children:(0,s.jsx)("img",{src:"../files/multiwindow.gif",alt:"multi tab support",width:"450"})}),"\n",(0,s.jsx)(a.h2,{id:"rxdb-database-performance",children:"RxDB Database Performance"}),"\n",(0,s.jsx)(a.p,{children:"Certainly! Let's delve deeper into the performance aspects of RxDB when it comes to working with JSON data."}),"\n",(0,s.jsxs)(a.ol,{children:["\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Efficient Querying:"})," RxDB is engineered for rapid and efficient querying of JSON data. It employs a well-optimized indexing system that allows for lightning-fast retrieval of specific data points within your JSON documents. Whether you're fetching individual values or complex nested structures, RxDB's query performance is designed to keep your application responsive, even when dealing with large datasets."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Scalability:"})," As your application grows and your JSON dataset expands, RxDB scales gracefully. Its performance remains consistent, enabling you to handle increasingly larger volumes of data without compromising on speed or responsiveness. This scalability is essential for applications that need to accommodate growing user bases and evolving data needs."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"Reduced Latency:"})," RxDB's streamlined data access mechanisms significantly reduce latency when working with JSON data. Whether you're reading from the database, making updates, or synchronizing data between clients and servers, RxDB's optimized operations help minimize the delays often associated with data access. Observed queris are optimized with the ",(0,s.jsx)(a.a,{href:"https://github.com/pubkey/event-reduce",children:"EventReduce algorithm"})," to provide nearly-instand UI updates on data changes."]}),"\n"]}),"\n",(0,s.jsxs)(a.li,{children:["\n",(0,s.jsxs)(a.p,{children:[(0,s.jsx)(a.strong,{children:"RxStorage Layer"}),": Because RxDB allows you to swap out the storage layer. A storage with the most optimal performance can be chosen for each runtime while not touching other database code. Depending on the access patterns, you can pick exactly the storage that is best:"]}),"\n"]}),"\n"]}),"\n",(0,s.jsx)("p",{align:"center",children:(0,s.jsx)("img",{src:"../files/rx-storage-performance-browser.png",alt:"RxStorage performance - browser",width:"700"})}),"\n",(0,s.jsx)(a.h2,{id:"rxdb-in-nodejs",children:"RxDB in Node.js"}),"\n",(0,s.jsxs)(a.p,{children:["Node.js developers can also benefit from RxDB's capabilities. By integrating RxDB into your Node.js applications, you can harness the power of a NoSQL JSON database to efficiently manage your data on the server-side. RxDB's flexibility, performance, and essential features are equally valuable in server-side development. ",(0,s.jsx)(a.a,{href:"/nodejs-database.html",children:"Read more about RxDB+Node.js"}),"."]}),"\n",(0,s.jsx)(a.h2,{id:"rxdb-to-store-json-documents-in-react-native",children:"RxDB to store JSON documents in React Native"}),"\n",(0,s.jsxs)(a.p,{children:["For mobile app developers working with React Native, RxDB offers a convenient solution for handling JSON data. Whether you're building Android or iOS applications, RxDB's compatibility with JavaScript and its ability to work with JSON documents make it a natural choice for data management within your React Native apps. ",(0,s.jsx)(a.a,{href:"/react-native-database.html",children:"Read more about RxDB+React-Native"}),"."]}),"\n",(0,s.jsx)(a.h2,{id:"using-sqlite-as-a-json-database",children:"Using SQLite as a JSON Database"}),"\n",(0,s.jsxs)(a.p,{children:["In some cases, you might want to use SQLite as a backend storage solution for your JSON data. RxDB can be configured ",(0,s.jsx)(a.a,{href:"/rx-storage-sqlite.html",children:"to work with SQLite"}),", providing the benefits of both a relational database system and JSON document storage. This hybrid approach can be advantageous when dealing with complex data relationships while retaining the flexibility of JSON data representation."]}),"\n",(0,s.jsx)(a.h2,{id:"follow-up",children:"Follow Up"}),"\n",(0,s.jsx)(a.p,{children:"To further explore RxDB and get started with using it in your frontend applications, consider the following resources:"}),"\n",(0,s.jsxs)(a.ul,{children:["\n",(0,s.jsxs)(a.li,{children:[(0,s.jsx)(a.a,{href:"/quickstart.html",children:"RxDB Quickstart"}),": A step-by-step guide to quickly set up RxDB in your project and start leveraging its features."]}),"\n",(0,s.jsxs)(a.li,{children:[(0,s.jsx)(a.a,{href:"https://github.com/pubkey/rxdb",children:"RxDB GitHub Repository"}),": The official repository for RxDB, where you can find the code, examples, and community support."]}),"\n"]}),"\n",(0,s.jsxs)(a.p,{children:["By embracing ",(0,s.jsx)(a.a,{href:"https://rxdb.info/",children:"RxDB"})," as your ",(0,s.jsx)(a.strong,{children:"JSON database"})," solution, you can tap into the extensive capabilities of JSON data storage. This empowers your applications with offline accessibility, caching, enhanced performance, and effortless data synchronization. RxDB's focus on JavaScript and its robust feature set render it the perfect selection for frontend developers in pursuit of efficient and scalable data storage solutions."]})]})}function h(e={}){const{wrapper:a}={...(0,n.a)(),...e.components};return a?(0,s.jsx)(a,{...e,children:(0,s.jsx)(c,{...e})}):c(e)}},1151:(e,a,t)=>{t.d(a,{Z:()=>o,a:()=>r});var s=t(7294);const n={},i=s.createContext(n);function r(e){const a=s.useContext(i);return s.useMemo((function(){return"function"==typeof e?e(a):{...a,...e}}),[a,e])}function o(e){let a;return a=e.disableParentContext?"function"==typeof e.components?e.components(n):e.components||n:r(e.components),s.createElement(i.Provider,{value:a},e.children)}}}]);