"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[6493],{279:(e,o,n)=>{n.r(o),n.d(o,{assets:()=>i,contentTitle:()=>l,default:()=>u,frontMatter:()=>t,metadata:()=>s,toc:()=>r});var c=n(5893),a=n(1151);const t={title:"Local Documents",slug:"rx-local-document.html"},l="Local Documents",s={id:"rx-local-document",title:"Local Documents",description:"Local documents are a special class of documents which are used to store local metadata.",source:"@site/docs/rx-local-document.md",sourceDirName:".",slug:"/rx-local-document.html",permalink:"/rx-local-document.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rx-local-document.md",tags:[],version:"current",frontMatter:{title:"Local Documents",slug:"rx-local-document.html"},sidebar:"tutorialSidebar",previous:{title:"Key Compression",permalink:"/key-compression.html"},next:{title:"Leader Election",permalink:"/leader-election.html"}},i={},r=[{value:"Add the local documents plugin",id:"add-the-local-documents-plugin",level:2},{value:"Activate the plugin for a RxDatabase or RxCollection",id:"activate-the-plugin-for-a-rxdatabase-or-rxcollection",level:2},{value:"insertLocal()",id:"insertlocal",level:2},{value:"upsertLocal()",id:"upsertlocal",level:2},{value:"getLocal()",id:"getlocal",level:2},{value:"getLocal$()",id:"getlocal-1",level:2},{value:"RxLocalDocument",id:"rxlocaldocument",level:2},{value:"NOTICE: Because the local document does not have a schema, accessing the documents data-fields via pseudo-proxy will not work.",id:"notice-because-the-local-document-does-not-have-a-schema-accessing-the-documents-data-fields-via-pseudo-proxy-will-not-work",level:2}];function d(e){const o={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,a.a)(),...e.components};return(0,c.jsxs)(c.Fragment,{children:[(0,c.jsx)(o.h1,{id:"local-documents",children:"Local Documents"}),"\n",(0,c.jsx)(o.p,{children:"Local documents are a special class of documents which are used to store local metadata.\nThey come in handy when you want to store settings or additional data next to your documents."}),"\n",(0,c.jsxs)(o.ul,{children:["\n",(0,c.jsxs)(o.li,{children:["Local Documents can exist on ",(0,c.jsx)(o.code,{children:"RxDatabase"})," or ",(0,c.jsx)(o.code,{children:"RxCollection"}),"."]}),"\n",(0,c.jsx)(o.li,{children:"Local Document do not have to match the collections schema."}),"\n",(0,c.jsx)(o.li,{children:"Local Documents do not get replicated."}),"\n",(0,c.jsx)(o.li,{children:"Local Documents will not be found on queries."}),"\n",(0,c.jsx)(o.li,{children:"Local Documents can not have attachments."}),"\n",(0,c.jsxs)(o.li,{children:["Local Documents will not get handled by the ",(0,c.jsx)(o.a,{href:"/migration-schema.html",children:"migration-schema"}),"."]}),"\n",(0,c.jsxs)(o.li,{children:["The id of a local document has the ",(0,c.jsx)(o.code,{children:"maxLength"})," of ",(0,c.jsx)(o.code,{children:"128"})," characters."]}),"\n"]}),"\n",(0,c.jsx)(o.h2,{id:"add-the-local-documents-plugin",children:"Add the local documents plugin"}),"\n",(0,c.jsxs)(o.p,{children:["To enable the local documents, you have to add the ",(0,c.jsx)(o.code,{children:"local-documents"})," plugin."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-ts",children:"import { addRxPlugin } from 'rxdb';\nimport { RxDBLocalDocumentsPlugin } from 'rxdb/plugins/local-documents';\naddRxPlugin(RxDBLocalDocumentsPlugin);\n"})}),"\n",(0,c.jsx)(o.h2,{id:"activate-the-plugin-for-a-rxdatabase-or-rxcollection",children:"Activate the plugin for a RxDatabase or RxCollection"}),"\n",(0,c.jsxs)(o.p,{children:["For better performance, the local document plugin does not create a storage for every database or collection that is created.\nInstead you have to set ",(0,c.jsx)(o.code,{children:"localDocuments: true"})," when you want to store local documents in the instance."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-js",children:"// activate local documents on a RxDatabase\nconst myDatabase = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStorageDexie(),\n    localDocuments: true // <- activate this to store local documents in the database\n});\n\nmyDatabase.addCollections({\n  messages: {\n    schema: messageSchema,\n    localDocuments: true // <- activate this to store local documents in the collection\n  }\n});\n"})}),"\n",(0,c.jsxs)(o.p,{children:[(0,c.jsx)(o.strong,{children:"NOTICE:"})," If you want to store local documents in a ",(0,c.jsx)(o.code,{children:"RxCollection"})," but ",(0,c.jsx)(o.strong,{children:"NOT"})," in the ",(0,c.jsx)(o.code,{children:"RxDatabase"}),", you ",(0,c.jsx)(o.strong,{children:"MUST NOT"})," set ",(0,c.jsx)(o.code,{children:"localDocuments: true"})," in the ",(0,c.jsx)(o.code,{children:"RxDatabase"})," because it will only slow down the initial database creation."]}),"\n",(0,c.jsx)(o.h2,{id:"insertlocal",children:"insertLocal()"}),"\n",(0,c.jsxs)(o.p,{children:["Creates a local document for the database or collection. Throws if a local document with the same id already exists. Returns a Promise which resolves the new ",(0,c.jsx)(o.code,{children:"RxLocalDocument"}),"."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const localDoc = await myCollection.insertLocal(\n    'foobar',   // id\n    {           // data\n        foo: 'bar'\n    }\n);\n\n// you can also use local-documents on a database\nconst localDoc = await myDatabase.insertLocal(\n    'foobar',   // id\n    {           // data\n        foo: 'bar'\n    }\n);\n"})}),"\n",(0,c.jsx)(o.h2,{id:"upsertlocal",children:"upsertLocal()"}),"\n",(0,c.jsxs)(o.p,{children:["Creates a local document for the database or collection if not exists. Overwrites the if exists. Returns a Promise which resolves the ",(0,c.jsx)(o.code,{children:"RxLocalDocument"}),"."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const localDoc = await myCollection.upsertLocal(\n    'foobar',   // id\n    {           // data\n        foo: 'bar'\n    }\n);\n"})}),"\n",(0,c.jsx)(o.h2,{id:"getlocal",children:"getLocal()"}),"\n",(0,c.jsxs)(o.p,{children:["Find a ",(0,c.jsx)(o.code,{children:"RxLocalDocument"})," by its id. Returns a Promise which resolves the ",(0,c.jsx)(o.code,{children:"RxLocalDocument"})," or ",(0,c.jsx)(o.code,{children:"null"})," if not exists."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const localDoc = await myCollection.getLocal('foobar');\n"})}),"\n",(0,c.jsx)(o.h2,{id:"getlocal-1",children:"getLocal$()"}),"\n",(0,c.jsxs)(o.p,{children:["Like ",(0,c.jsx)(o.code,{children:"getLocal()"})," but returns an ",(0,c.jsx)(o.code,{children:"Observable"})," that emits the document or ",(0,c.jsx)(o.code,{children:"null"})," if not exists."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const subscription = myCollection.getLocal$('foobar').subscribe(documentOrNull => {\n    console.dir(documentOrNull); // > RxLocalDocument or null\n});\n"})}),"\n",(0,c.jsx)(o.h2,{id:"rxlocaldocument",children:"RxLocalDocument"}),"\n",(0,c.jsxs)(o.p,{children:["A ",(0,c.jsx)(o.code,{children:"RxLocalDocument"})," behaves like a normal ",(0,c.jsx)(o.code,{children:"RxDocument"}),"."]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const localDoc = await myCollection.getLocal('foobar');\n\n// access data\nconst foo = localDoc.get('foo');\n\n// change data\nlocalDoc.set('foo', 'bar2');\nawait localDoc.save();\n\n// observe data\nlocalDoc.get$('foo').subscribe(value => { /* .. */ });\n\n// remove it\nawait localDoc.remove();\n"})}),"\n",(0,c.jsx)(o.h2,{id:"notice-because-the-local-document-does-not-have-a-schema-accessing-the-documents-data-fields-via-pseudo-proxy-will-not-work",children:"NOTICE: Because the local document does not have a schema, accessing the documents data-fields via pseudo-proxy will not work."}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-javascript",children:"const foo = localDoc.foo; // undefined\nconst foo = localDoc.get('foo'); // works!\n\nlocalDoc.foo = 'bar'; // does not work!\nlocalDoc.set('foo', 'bar'); // works\n"})}),"\n",(0,c.jsxs)(o.p,{children:["For the usage with typescript, you can have access to the typed data of the document over ",(0,c.jsx)(o.code,{children:"toJSON()"})]}),"\n",(0,c.jsx)(o.pre,{children:(0,c.jsx)(o.code,{className:"language-ts",children:"declare type MyLocalDocumentType = {\n  foo: string\n}\nconst localDoc = await myCollection.upsertLocal<MyLocalDocumentType>(\n    'foobar',   // id\n    {           // data\n        foo: 'bar'\n    }\n);\n\n// typescript will know that foo is a string\nconst foo: string = localDoc.toJSON().foo;\n"})})]})}function u(e={}){const{wrapper:o}={...(0,a.a)(),...e.components};return o?(0,c.jsx)(o,{...e,children:(0,c.jsx)(d,{...e})}):d(e)}},1151:(e,o,n)=>{n.d(o,{Z:()=>s,a:()=>l});var c=n(7294);const a={},t=c.createContext(a);function l(e){const o=c.useContext(t);return c.useMemo((function(){return"function"==typeof e?e(o):{...o,...e}}),[o,e])}function s(e){let o;return o=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:l(e.components),c.createElement(t.Provider,{value:o},e.children)}}}]);