"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[5333],{1850:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>d,contentTitle:()=>s,default:()=>u,frontMatter:()=>i,metadata:()=>r,toc:()=>l});var a=t(5893),o=t(1151);const i={title:"FoundationDB RxStorage",slug:"rx-storage-foundationdb.html",description:"Explore the advanced features of RxDB with FoundationDB RxStorage - Efficient indexing, complex NoSQL queries, real-time updates, data compression, and attachment management for optimized database performance and scalability"},s="RxDB Database on top of FoundationDB",r={id:"rx-storage-foundationdb",title:"FoundationDB RxStorage",description:"Explore the advanced features of RxDB with FoundationDB RxStorage - Efficient indexing, complex NoSQL queries, real-time updates, data compression, and attachment management for optimized database performance and scalability",source:"@site/docs/rx-storage-foundationdb.md",sourceDirName:".",slug:"/rx-storage-foundationdb.html",permalink:"/rx-storage-foundationdb.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rx-storage-foundationdb.md",tags:[],version:"current",frontMatter:{title:"FoundationDB RxStorage",slug:"rx-storage-foundationdb.html",description:"Explore the advanced features of RxDB with FoundationDB RxStorage - Efficient indexing, complex NoSQL queries, real-time updates, data compression, and attachment management for optimized database performance and scalability"},sidebar:"tutorialSidebar",previous:{title:"DenoKV RxStorage",permalink:"/rx-storage-denokv.html"},next:{title:"Remote RxStorage",permalink:"/rx-storage-remote.html"}},d={},l=[{value:"Features of RxDB+FoundationDB",id:"features-of-rxdbfoundationdb",level:2},{value:"Installation",id:"installation",level:2},{value:"Usage",id:"usage",level:2},{value:"Multi Instance",id:"multi-instance",level:2}];function c(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,o.a)(),...e.components};return(0,a.jsxs)(a.Fragment,{children:[(0,a.jsx)(n.h1,{id:"rxdb-database-on-top-of-foundationdb",children:"RxDB Database on top of FoundationDB"}),"\n",(0,a.jsxs)(n.p,{children:[(0,a.jsx)(n.a,{href:"https://www.foundationdb.org/",children:"FoundationDB"})," is a distributed key-value store designed to handle large volumes of structured data across clusters of computers while maintaining high levels of performance, scalability, and fault tolerance. While FoundationDB itself only can store and query key-value pairs, it lacks more advanced features like complex queries, encryption and replication."]}),"\n",(0,a.jsxs)(n.p,{children:["With the FoundationDB based ",(0,a.jsx)(n.a,{href:"/rx-storage.html",children:"RxStorage"})," of ",(0,a.jsx)(n.a,{href:"https://rxdb.info/",children:"RxDB"})," you can combine the benefits of FoundationDB while having a fully featured, high performance NoSQL database."]}),"\n",(0,a.jsx)(n.h2,{id:"features-of-rxdbfoundationdb",children:"Features of RxDB+FoundationDB"}),"\n",(0,a.jsx)(n.p,{children:"Using RxDB on top of FoundationDB, gives you many benefits compare to using the plain FoundationDB API:"}),"\n",(0,a.jsxs)(n.ul,{children:["\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Indexes"}),": In RxDB with a FoundationDB storage layer, indexes are used to optimize query performance, allowing for fast and efficient data retrieval even in large datasets. You can define single and compound indexes with the ",(0,a.jsx)(n.a,{href:"/rx-schema.html",children:"RxDB schema"}),"."]}),"\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Schema Based Data Model"}),": Utilizing a ",(0,a.jsx)(n.a,{href:"/rx-schema.html",children:"jsonschema"})," based data model, the system offers a highly structured and versatile approach to organizing and ",(0,a.jsx)(n.a,{href:"/schema-validation.html",children:"validating data"}),", ensuring consistency and clarity in database interactions."]}),"\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Complex Queries"}),": The system supports complex ",(0,a.jsx)(n.a,{href:"/rx-query.html",children:"NoSQL queries"}),", allowing for advanced data manipulation and retrieval, tailored to specific needs and intricate data relationships. For example you can do ",(0,a.jsx)(n.code,{children:"$regex"})," or ",(0,a.jsx)(n.code,{children:"$or"})," queries which is hardy possible with the plain key-value access of FoundationDB."]}),"\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Observable Queries & Documents"}),": RxDB's observable queries and documents feature ensures real-time updates and synchronization, providing dynamic and responsive data interactions in applications."]}),"\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Compression"}),": RxDB employs data ",(0,a.jsx)(n.a,{href:"/key-compression.html",children:"compression techniques"})," to reduce storage requirements and enhance transmission efficiency, making it more cost-effective and faster, especially for large volumes of data. You can compress the ",(0,a.jsx)(n.a,{href:"/key-compression.html",children:"NoSQL document"})," data, but also the ",(0,a.jsx)(n.a,{href:"/rx-attachment.html#attachment-compression",children:"binary attachments"})," data."]}),"\n",(0,a.jsxs)(n.li,{children:[(0,a.jsx)(n.strong,{children:"Attachments"}),": RxDB supports the storage and management of ",(0,a.jsx)(n.a,{href:"/rx-attachment.html",children:"attachments"})," which allowing for the seamless inclusion of binary data like images or documents alongside structured data within the database."]}),"\n"]}),"\n",(0,a.jsx)(n.h2,{id:"installation",children:"Installation"}),"\n",(0,a.jsxs)(n.ul,{children:["\n",(0,a.jsxs)(n.li,{children:["Install the ",(0,a.jsx)(n.a,{href:"https://apple.github.io/foundationdb/getting-started-linux.html",children:"FoundationDB client cli"})," which is used to communicate with the FoundationDB cluster."]}),"\n",(0,a.jsxs)(n.li,{children:["Install the ",(0,a.jsx)(n.a,{href:"https://www.npmjs.com/package/foundationdb",children:"FoundationDB node bindings npm module"})," via ",(0,a.jsx)(n.code,{children:"npm install foundationdb --save"}),". If the latest version does not work for you, you should use the same version as stated in the ",(0,a.jsx)(n.code,{children:"storage-foundationdb"})," job of the RxDB CI ",(0,a.jsx)(n.code,{children:"main.yml"}),"."]}),"\n"]}),"\n",(0,a.jsx)(n.h2,{id:"usage",children:"Usage"}),"\n",(0,a.jsx)(n.pre,{children:(0,a.jsx)(n.code,{className:"language-typescript",children:"import {\n    createRxDatabase\n} from 'rxdb';\nimport {\n    getRxStorageFoundationDB\n} from 'rxdb/plugins/storage-foundationdb';\n\nconst db = await createRxDatabase({\n    name: 'exampledb',\n    storage: getRxStorageFoundationDB({\n        /**\n         * Version of the API of the FoundationDB cluster..\n         * FoundationDB is backwards compatible across a wide range of versions,\n         * so you have to specify the api version.\n         * If in doubt, set it to 620.\n         */\n        apiVersion: 620,\n        /**\n         * Path to the FoundationDB cluster file.\n         * (optional)\n         * If in doubt, leave this empty to use the default location.\n         */\n        clusterFile: '/path/to/fdb.cluster',\n        /**\n         * Amount of documents to be fetched in batch requests.\n         * You can change this to improve performance depending on\n         * your database access patterns.\n         * (optional)\n         * [default=50]\n         */\n        batchSize: 50\n    })\n});\n"})}),"\n",(0,a.jsx)(n.h2,{id:"multi-instance",children:"Multi Instance"}),"\n",(0,a.jsxs)(n.p,{children:["Because FoundationDB does not offer a ",(0,a.jsx)(n.a,{href:"https://forums.foundationdb.org/t/streaming-data-out-of-foundationdb/683/2",children:"changestream"}),", it is not possible to use the same cluster from more then one Node.js process at the same time. For example you cannot spin up multiple servers with RxDB databases that all use the same cluster. There might be workarounds to create something like a FoundationDB changestream and you can make a Pull Request if you need that feature."]})]})}function u(e={}){const{wrapper:n}={...(0,o.a)(),...e.components};return n?(0,a.jsx)(n,{...e,children:(0,a.jsx)(c,{...e})}):c(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>r,a:()=>s});var a=t(7294);const o={},i=a.createContext(o);function s(e){const n=a.useContext(i);return a.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function r(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:s(e.components),a.createElement(i.Provider,{value:n},e.children)}}}]);