"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[9971],{7562:(e,a,n)=>{n.r(a),n.d(a,{assets:()=>i,contentTitle:()=>r,default:()=>h,frontMatter:()=>d,metadata:()=>o,toc:()=>l});var t=n(5893),s=n(1151);const d={title:"PouchDB Adapters",slug:"adapters.html"},r="PouchDB Adapters",o={id:"adapters",title:"PouchDB Adapters",description:"When you use PouchDB RxStorage, there are many adapters that define where the data has to be stored.",source:"@site/docs/adapters.md",sourceDirName:".",slug:"/adapters.html",permalink:"/adapters.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/adapters.md",tags:[],version:"current",frontMatter:{title:"PouchDB Adapters",slug:"adapters.html"}},i={},l=[{value:"IMPORTANT:",id:"important",level:2},{value:"Memory",id:"memory",level:2},{value:"Memdown",id:"memdown",level:2},{value:"IndexedDB",id:"indexeddb",level:2},{value:"IndexedDB",id:"indexeddb-1",level:2},{value:"Websql",id:"websql",level:2},{value:"leveldown",id:"leveldown",level:2},{value:"Node-Websql",id:"node-websql",level:2},{value:"react-native-sqlite",id:"react-native-sqlite",level:2},{value:"asyncstorage",id:"asyncstorage",level:2},{value:"asyncstorage-down",id:"asyncstorage-down",level:2},{value:"cordova-sqlite",id:"cordova-sqlite",level:2}];function c(e){const a={a:"a",code:"code",h1:"h1",h2:"h2",hr:"hr",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,t.jsxs)(t.Fragment,{children:[(0,t.jsx)(a.h1,{id:"pouchdb-adapters",children:"PouchDB Adapters"}),"\n",(0,t.jsxs)(a.p,{children:["When you use PouchDB ",(0,t.jsx)(a.code,{children:"RxStorage"}),", there are many adapters that define where the data has to be stored.\nDepending on which environment you work in, you can choose between different adapters. For example, in the browser you want to store the data inside of IndexedDB but on NodeJS you want to store the data on the filesystem."]}),"\n",(0,t.jsx)(a.p,{children:"This page is an overview over the different adapters with recommendations on what to use where."}),"\n",(0,t.jsx)(a.hr,{}),"\n",(0,t.jsx)(a.h2,{id:"important",children:"IMPORTANT:"}),"\n",(0,t.jsxs)(a.p,{children:["The PouchDB RxStorage ",(0,t.jsx)(a.a,{href:"https://rxdb.info/questions-answers.html#why-is-the-pouchdb-rxstorage-deprecated",children:"is removed from RxDB"})," and can no longer be used in new projects. You should switch to a different ",(0,t.jsx)(a.a,{href:"/rx-storage.html",children:"RxStorage"}),"."]}),"\n",(0,t.jsx)(a.hr,{}),"\n",(0,t.jsxs)(a.p,{children:["Please always ensure that your pouchdb adapter-version is the same as ",(0,t.jsx)(a.code,{children:"pouchdb-core"})," in the ",(0,t.jsx)(a.a,{href:"https://github.com/pubkey/rxdb/blob/master/package.json",children:"rxdb package.json"}),". Otherwise, you might have strange problems."]}),"\n",(0,t.jsx)(a.h1,{id:"any-environment",children:"Any environment"}),"\n",(0,t.jsx)(a.h2,{id:"memory",children:"Memory"}),"\n",(0,t.jsx)(a.p,{children:"In any environment, you can use the memory-adapter. It stores the data in the javascript runtime memory. This means it is not persistent and the data is lost when the process terminates."}),"\n",(0,t.jsx)(a.p,{children:"Use this adapter when:"}),"\n",(0,t.jsxs)(a.ul,{children:["\n",(0,t.jsx)(a.li,{children:"You want to have really good performance"}),"\n",(0,t.jsx)(a.li,{children:"You do not want persistent state, for example in your test suite"}),"\n"]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"import {\n    createRxDatabase\n} from 'rxdb'\nimport {\n    getRxStoragePouch\n} from 'rxdb/plugins/pouchdb';\n// npm install pouchdb-adapter-memory --save\naddPouchPlugin(require('pouchdb-adapter-memory'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('memory')\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"memdown",children:"Memdown"}),"\n",(0,t.jsxs)(a.p,{children:["With RxDB you can also use adapters that implement ",(0,t.jsx)(a.a,{href:"https://github.com/Level/abstract-leveldown",children:"abstract-leveldown"})," like the memdown-adapter."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install memdown --save\n// npm install pouchdb-adapter-leveldb --save\naddPouchPlugin(require('pouchdb-adapter-leveldb')); // leveldown adapters need the leveldb plugin to work\n\nconst memdown = require('memdown');\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch(memdown) // the full leveldown-module\n});\n"})}),"\n",(0,t.jsx)(a.h1,{id:"browser",children:"Browser"}),"\n",(0,t.jsx)(a.h2,{id:"indexeddb",children:"IndexedDB"}),"\n",(0,t.jsxs)(a.p,{children:["The IndexedDB adapter stores the data inside of ",(0,t.jsx)(a.a,{href:"https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API",children:"IndexedDB"})," use this in browsers environments as default."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-idb --save\naddPouchPlugin(require('pouchdb-adapter-idb'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('idb')\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"indexeddb-1",children:"IndexedDB"}),"\n",(0,t.jsxs)(a.p,{children:["A reimplementation of the indexeddb adapter which uses native secondary indexes. Should have a much better performance but can behave ",(0,t.jsx)(a.a,{href:"https://github.com/pouchdb/pouchdb/tree/master/packages/node_modules/pouchdb-adapter-indexeddb#differences-between-couchdb-and-pouchdbs-find-implementations-under-indexeddb",children:"different on some edge cases"}),"."]}),"\n",(0,t.jsxs)(a.p,{children:[(0,t.jsx)(a.strong,{children:"Notice"}),": Multiple users have reported problems with this adapter. It is ",(0,t.jsx)(a.strong,{children:"not"})," recommended to use this adapter."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-indexeddb --save\naddPouchPlugin(require('pouchdb-adapter-indexeddb'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('indexeddb')\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"websql",children:"Websql"}),"\n",(0,t.jsxs)(a.p,{children:["This adapter stores the data inside of websql. It has a different performance behavior. ",(0,t.jsx)(a.a,{href:"https://softwareengineering.stackexchange.com/questions/220254/why-is-web-sql-database-deprecated",children:"Websql is deprecated"}),". You should not use the websql adapter unless you have a really good reason."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-websql --save\naddPouchPlugin(require('pouchdb-adapter-websql'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('websql')\n});\n"})}),"\n",(0,t.jsx)(a.h1,{id:"nodejs",children:"NodeJS"}),"\n",(0,t.jsx)(a.h2,{id:"leveldown",children:"leveldown"}),"\n",(0,t.jsxs)(a.p,{children:["This adapter uses a ",(0,t.jsx)(a.a,{href:"https://github.com/Level/leveldown",children:"LevelDB C++ binding"})," to store that data on the filesystem. It has the best performance compared to other filesystem adapters. This adapter can ",(0,t.jsx)(a.strong,{children:"not"})," be used when multiple nodejs-processes access the same filesystem folders for storage."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install leveldown --save\n// npm install pouchdb-adapter-leveldb --save\naddPouchPlugin(require('pouchdb-adapter-leveldb')); // leveldown adapters need the leveldb plugin to work\nconst leveldown = require('leveldown');\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch(leveldown) // the full leveldown-module\n});\n\n// or use a specific folder to store the data\nconst database = await createRxDatabase({\n    name: '/root/user/project/mydatabase',\n    storage: getRxStoragePouch(leveldown) // the full leveldown-module\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"node-websql",children:"Node-Websql"}),"\n",(0,t.jsxs)(a.p,{children:["This adapter uses the ",(0,t.jsx)(a.a,{href:"https://github.com/nolanlawson/node-websql",children:"node-websql"}),"-shim to store data on the filesystem. Its advantages are that it does not need a leveldb build and it can be used when multiple nodejs-processes use the same database-files."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-node-websql --save\naddPouchPlugin(require('pouchdb-adapter-node-websql'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('websql') // the name of your adapter\n});\n\n// or use a specific folder to store the data\nconst database = await createRxDatabase({\n    name: '/root/user/project/mydatabase',\n    storage: getRxStoragePouch('websql') // the name of your adapter\n});\n"})}),"\n",(0,t.jsx)(a.h1,{id:"react-native",children:"React-Native"}),"\n",(0,t.jsx)(a.h2,{id:"react-native-sqlite",children:"react-native-sqlite"}),"\n",(0,t.jsxs)(a.p,{children:["Uses ReactNative SQLite as storage. Claims to be much faster than the asyncstorage adapter.\nTo use it, you have to do some steps from ",(0,t.jsx)(a.a,{href:"https://dev.to/craftzdog/hacking-pouchdb-to-use-on-react-native-1gjh",children:"this tutorial"}),"."]}),"\n",(0,t.jsxs)(a.p,{children:["First install ",(0,t.jsx)(a.code,{children:"pouchdb-adapter-react-native-sqlite"})," and ",(0,t.jsx)(a.code,{children:"react-native-sqlite-2"}),"."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-bash",children:"npm install pouchdb-adapter-react-native-sqlite react-native-sqlite-2\n"})}),"\n",(0,t.jsxs)(a.p,{children:["Then you have to ",(0,t.jsx)(a.a,{href:"https://facebook.github.io/react-native/docs/linking-libraries-ios",children:"link"})," the library."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-bash",children:"react-native link react-native-sqlite-2\n"})}),"\n",(0,t.jsx)(a.p,{children:"You also have to add some polyfills which are need but not included in react-native."}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-bash",children:"npm install base-64 events\n"})}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"import { decode, encode } from 'base-64'\n\nif (!global.btoa) {\n    global.btoa = encode;\n}\n\nif (!global.atob) {\n    global.atob = decode;\n}\n\n// Avoid using node dependent modules\nprocess.browser = true;\n"})}),"\n",(0,t.jsx)(a.p,{children:"Then you can use it inside of your code."}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"import { createRxDatabase } from 'rxdb';\nimport { addPouchPlugin, getRxStoragePouch } from 'rxdb/plugins/pouchdb';\nimport SQLite from 'react-native-sqlite-2'\nimport SQLiteAdapterFactory from 'pouchdb-adapter-react-native-sqlite'\n\nconst SQLiteAdapter = SQLiteAdapterFactory(SQLite)\n\naddPouchPlugin(SQLiteAdapter);\naddPouchPlugin(require('pouchdb-adapter-http'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('react-native-sqlite') // the name of your adapter\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"asyncstorage",children:"asyncstorage"}),"\n",(0,t.jsxs)(a.p,{children:["Uses react-native's ",(0,t.jsx)(a.a,{href:"https://facebook.github.io/react-native/docs/asyncstorage",children:"asyncstorage"}),"."]}),"\n",(0,t.jsxs)(a.p,{children:[(0,t.jsx)(a.strong,{children:"Notice"}),": There are ",(0,t.jsx)(a.a,{href:"https://github.com/pubkey/rxdb/issues/2286",children:"known problems"})," with this adapter and it is ",(0,t.jsx)(a.strong,{children:"not"})," recommended to use it."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-asyncstorage --save\naddPouchPlugin(require('pouchdb-adapter-asyncstorage'));\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch('node-asyncstorage') // the name of your adapter\n});\n"})}),"\n",(0,t.jsx)(a.h2,{id:"asyncstorage-down",children:"asyncstorage-down"}),"\n",(0,t.jsx)(a.p,{children:"A leveldown adapter that stores on asyncstorage."}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-asyncstorage-down --save\naddPouchPlugin(require('pouchdb-adapter-leveldb')); // leveldown adapters need the leveldb plugin to work\n\nconst asyncstorageDown = require('asyncstorage-down');\n\nconst database = await createRxDatabase({\n    name: 'mydatabase',\n    storage: getRxStoragePouch(asyncstorageDown) // the full leveldown-module\n});\n"})}),"\n",(0,t.jsx)(a.h1,{id:"cordova--phonegap--capacitor",children:"Cordova / Phonegap / Capacitor"}),"\n",(0,t.jsx)(a.h2,{id:"cordova-sqlite",children:"cordova-sqlite"}),"\n",(0,t.jsxs)(a.p,{children:["Uses cordova's global ",(0,t.jsx)(a.code,{children:"cordova.sqlitePlugin"}),". It can be used with cordova and capacitor."]}),"\n",(0,t.jsx)(a.pre,{children:(0,t.jsx)(a.code,{className:"language-js",children:"// npm install pouchdb-adapter-cordova-sqlite --save\naddPouchPlugin(require('pouchdb-adapter-cordova-sqlite'));\n\n/**\n * In capacitor/cordova you have to wait until all plugins are loaded and 'window.sqlitePlugin'\n * can be accessed.\n * This function waits until document deviceready is called which ensures that everything is loaded.\n * @link https://cordova.apache.org/docs/de/latest/cordova/events/events.deviceready.html\n */\nexport function awaitCapacitorDeviceReady(): Promise<void> {\n    return new Promise(res => {\n        document.addEventListener('deviceready', () => {\n            res();\n        });\n    });\n}\n\nasync function getDatabase(){\n\n    // first wait until the deviceready event is fired\n    await awaitCapacitorDeviceReady();\n\n    const database = await createRxDatabase({\n        name: 'mydatabase',\n        storage: getRxStoragePouch(\n            'cordova-sqlite',\n            // pouch settings are passed as second parameter\n            {\n                // for ios devices, the cordova-sqlite adapter needs to know where to save the data.\n                iosDatabaseLocation: 'Library'\n            }\n        )\n    });\n}\n"})})]})}function h(e={}){const{wrapper:a}={...(0,s.a)(),...e.components};return a?(0,t.jsx)(a,{...e,children:(0,t.jsx)(c,{...e})}):c(e)}},1151:(e,a,n)=>{n.d(a,{Z:()=>o,a:()=>r});var t=n(7294);const s={},d=t.createContext(s);function r(e){const a=t.useContext(d);return t.useMemo((function(){return"function"==typeof e?e(a):{...a,...e}}),[a,e])}function o(e){let a;return a=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:r(e.components),t.createElement(d.Provider,{value:a},e.children)}}}]);