"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[9164],{253:(e,t,a)=>{a.r(t),a.d(t,{assets:()=>o,contentTitle:()=>r,default:()=>h,frontMatter:()=>n,metadata:()=>l,toc:()=>c});var i=a(5893),s=a(1151);const n={title:"What is a realtime database?",slug:"realtime-database.html"},r="What is a realtime database?",l={id:"articles/realtime-database",title:"What is a realtime database?",description:"I have been building RxDB, a NoSQL realtime JavaScript database for many years.",source:"@site/docs/articles/realtime-database.md",sourceDirName:"articles",slug:"/articles/realtime-database.html",permalink:"/articles/realtime-database.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/articles/realtime-database.md",tags:[],version:"current",frontMatter:{title:"What is a realtime database?",slug:"realtime-database.html"},sidebar:"tutorialSidebar",previous:{title:"RxDB as a Database for React Applications",permalink:"/articles/react-database.html"},next:{title:"Capacitor Database",permalink:"/capacitor-database.html"}},o={},c=[{value:"Realtime as in <strong>realtime computing</strong>",id:"realtime-as-in-realtime-computing",level:2},{value:"Realtime as in <strong>realtime replication</strong>",id:"realtime-as-in-realtime-replication",level:2},{value:"Realtime as in <strong>realtime applications</strong>",id:"realtime-as-in-realtime-applications",level:2},{value:"Follow Up",id:"follow-up",level:2}];function d(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(t.h1,{id:"what-is-a-realtime-database",children:"What is a realtime database?"}),"\n",(0,i.jsxs)(t.p,{children:["I have been building ",(0,i.jsx)(t.a,{href:"https://rxdb.info/",children:"RxDB"}),", a NoSQL ",(0,i.jsx)(t.strong,{children:"realtime"})," JavaScript database for many years.\nOften people get confused by the word ",(0,i.jsx)(t.strong,{children:"realtime database"}),", because the word ",(0,i.jsx)(t.strong,{children:"realtime"})," is so vaguely defined that it can mean everything and nothing at the same time."]}),"\n",(0,i.jsx)(t.p,{children:"In this article we will explore what a realtime database is, and more important, what it is not."}),"\n",(0,i.jsx)("center",{children:(0,i.jsx)("a",{href:"https://rxdb.info/",children:(0,i.jsx)("img",{src:"../files/logo/rxdb_javascript_database.svg",alt:"JavaScript Realtime Database",width:"150"})})}),"\n",(0,i.jsxs)(t.h2,{id:"realtime-as-in-realtime-computing",children:["Realtime as in ",(0,i.jsx)(t.strong,{children:"realtime computing"})]}),"\n",(0,i.jsxs)(t.p,{children:['When "normal" developers hear the word "realtime", they think of ',(0,i.jsx)(t.strong,{children:"Real-time computing (RTC)"}),". Real-time computing is a type of computer processing that ",(0,i.jsx)(t.strong,{children:"guarantees specific response times"})," for tasks or events, crucial in applications like industrial control, automotive systems, and aerospace. It relies on specialized operating systems (RTOS) to ensure predictability and low latency. Hard real-time systems must never miss deadlines, while soft real-time systems can tolerate occasional delays. Real-time responses are often understood to be in the order of milliseconds, and sometimes microseconds."]}),"\n",(0,i.jsxs)(t.p,{children:["Consider the role of real-time computing in car airbags: sensors detect collision force, swiftly process the data, and immediately decide to deploy the airbags within milliseconds. Such rapid action is imperative for safeguarding passengers. Hence, the controlling chip must ",(0,i.jsx)(t.strong,{children:"guarantee a certain response time"}),' \u2014 it must operate in "realtime".']}),"\n",(0,i.jsxs)(t.p,{children:["But when people talk about ",(0,i.jsx)(t.strong,{children:"realtime databases"}),", especially in the web-development world, they almost never mean realtime, as in ",(0,i.jsx)(t.strong,{children:"realtime computing"}),', they mean something else.\nIn fact, with any programming language that run on end users devices, it is not even possible to built a "real" realtime database. A program, like a JavaScript (',(0,i.jsx)(t.a,{href:"/articles/browser-database.html",children:"browser"})," or ",(0,i.jsx)(t.a,{href:"/nodejs-database.html",children:"Node.js"}),") process, can be halted by the operating systems task manager at any time and therefore it will never be able to guarantee specific response times. To build a realtime computing database, you would need a realtime capable operating system."]}),"\n",(0,i.jsxs)(t.h2,{id:"realtime-as-in-realtime-replication",children:["Realtime as in ",(0,i.jsx)(t.strong,{children:"realtime replication"})]}),"\n",(0,i.jsxs)(t.p,{children:["When talking about realtime databases, most people refer to realtime, as in realtime replication.\nOften they mean a very specific product which is the ",(0,i.jsx)(t.strong,{children:"Firebase Realtime Database"})," (not the ",(0,i.jsx)(t.a,{href:"/replication-firestore.html",children:"Firestore"}),")."]}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"../files/alternatives/firebase.svg",alt:"firebase realtime replication",width:"100"})}),"\n",(0,i.jsx)(t.p,{children:'In the context of the Firebase Realtime Database, "realtime" means that data changes are synchronized and delivered to all connected clients or devices as soon as they occur, typically within milliseconds. This means that when any client updates, adds, or removes data in the database, all other clients that are connected to the same database instance receive those updates instantly, without the need for manual polling or frequent HTTP requests.'}),"\n",(0,i.jsxs)(t.p,{children:["In short, when replicating data between databases, instead of polling, we use a ",(0,i.jsx)(t.a,{href:"https://developer.mozilla.org/en-US/docs/Web/API/WebSockets_API",children:"websocket connection"}),' to live-stream all changes between the server and the clients, this is labeled as "realtime database". A similar thing can be done with RxDB and the ',(0,i.jsx)(t.a,{href:"/replication.html",children:"RxDB Replication Plugins"}),"."]}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("a",{href:"https://rxdb.info/replication.html",children:(0,i.jsx)("img",{src:"../files/database-replication.png",alt:"database replication",width:"100"})})}),"\n",(0,i.jsxs)(t.h2,{id:"realtime-as-in-realtime-applications",children:["Realtime as in ",(0,i.jsx)(t.strong,{children:"realtime applications"})]}),"\n",(0,i.jsx)(t.p,{children:'In the context of realtime client-side applications, "realtime" refers to the immediate or near-instantaneous processing and response to events or data inputs. When data changes, the application must directly update to reflect the new data state, without any user interaction or delay. Notice that the change to the data could have come from any source, like a user action, an operation in another browser tab, or even an operation from another device that has been replicated to the client.'}),"\n",(0,i.jsx)("p",{align:"center",children:(0,i.jsx)("img",{src:"../files/multiwindow.gif",alt:"realtime applications",width:"400"})}),"\n",(0,i.jsxs)(t.p,{children:["In contrast to push-pull based databases (e.g., MySQL or MongoDB servers), a realtime database contains ",(0,i.jsx)(t.strong,{children:"features which make it easy to build realtime applications"}),". For example with RxDB you can not only fetch query results once, but instead you can subscribe to a query and directly update the HTML dom tree whenever the query has a new result set:"]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"await db.heroes.find({\n  selector: {\n    healthpoints: {\n      $gt: 0\n    }\n  }\n})\n.$ // The $ returns an observable that emits whenever the query's result set changes.\n.subscribe(aliveHeroes => {\n    // Refresh the HTML list each time there are new query results.\n    const newContent = aliveHeroes.map(doc => '<li>' + doc.name + '</li>');\n    document.getElementById('#myList').innerHTML = newContent;\n});\n\n// You can even subscribe to any RxDB document's fields.\nmyDocument.firstName$.subscribe(newName => console.log('name is: ' + newName));\n"})}),"\n",(0,i.jsxs)(t.p,{children:["A competent realtime application is engineered to offer feedback or results swiftly, ideally within milliseconds to microseconds. Ideally, a data modification should be processed in under ",(0,i.jsx)(t.strong,{children:"16 milliseconds"})," (since 1 second divided by 60 frames equals 16.66ms) to ensure users don't perceive any lag from input to visualization. RxDB utilizes the ",(0,i.jsx)(t.a,{href:"https://github.com/pubkey/event-reduce",children:"EventReduce algorithm"}),' to manage changes more swiftly than 16ms. However, it can never assure fixed response times as a "realtime computing database" would.']}),"\n",(0,i.jsx)(t.h2,{id:"follow-up",children:"Follow Up"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsxs)(t.li,{children:["Dive into the ",(0,i.jsx)(t.a,{href:"https://rxdb.info/quickstart.html",children:"RxDB Quickstart"})]}),"\n",(0,i.jsxs)(t.li,{children:["Discover more about the ",(0,i.jsx)(t.a,{href:"/replication.html",children:"RxDB realtime replication protocol"})]}),"\n",(0,i.jsxs)(t.li,{children:["Join the conversation at ",(0,i.jsx)(t.a,{href:"https://rxdb.info/chat.html",children:"RxDB Chat"})]}),"\n"]})]})}function h(e={}){const{wrapper:t}={...(0,s.a)(),...e.components};return t?(0,i.jsx)(t,{...e,children:(0,i.jsx)(d,{...e})}):d(e)}},1151:(e,t,a)=>{a.d(t,{Z:()=>l,a:()=>r});var i=a(7294);const s={},n=i.createContext(s);function r(e){const t=i.useContext(n);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function l(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:r(e.components),i.createElement(n.Provider,{value:t},e.children)}}}]);