"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[8306],{632:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>c,contentTitle:()=>a,default:()=>p,frontMatter:()=>r,metadata:()=>i,toc:()=>l});var o=n(5893),s=n(1151);const r={title:"RxDB TypeScript Tutorial",slug:"typescript.html"},a="Using RxDB with TypeScript",i={id:"tutorials/typescript",title:"RxDB TypeScript Tutorial",description:"In this tutorial you will learn how to use RxDB with TypeScript.",source:"@site/docs/tutorials/typescript.md",sourceDirName:"tutorials",slug:"/tutorials/typescript.html",permalink:"/tutorials/typescript.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/tutorials/typescript.md",tags:[],version:"current",frontMatter:{title:"RxDB TypeScript Tutorial",slug:"typescript.html"},sidebar:"tutorialSidebar",previous:{title:"Third Party Plugins",permalink:"/third-party-plugins.html"},next:{title:"Node.js Database",permalink:"/nodejs-database.html"}},c={},l=[{value:"Declare the types",id:"declare-the-types",level:2},{value:"Create the base document type",id:"create-the-base-document-type",level:2},{value:"Option A: Create the document type from the schema",id:"option-a-create-the-document-type-from-the-schema",level:3},{value:"Option B: Manually type the document type",id:"option-b-manually-type-the-document-type",level:3},{value:"Option C: Generate the document type from schema during build time",id:"option-c-generate-the-document-type-from-schema-during-build-time",level:3},{value:"Types for the ORM methods",id:"types-for-the-orm-methods",level:2},{value:"Using the types",id:"using-the-types",level:2},{value:"Known Problems",id:"known-problems",level:2}];function h(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",ul:"ul",...(0,s.a)(),...e.components};return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(t.h1,{id:"using-rxdb-with-typescript",children:"Using RxDB with TypeScript"}),"\n",(0,o.jsx)(t.p,{children:"In this tutorial you will learn how to use RxDB with TypeScript.\nWe will create a basic database with one collection and several ORM-methods, fully typed!"}),"\n",(0,o.jsx)(t.p,{children:"RxDB directly comes with its typings and you do not have to install anything else, however the latest version of RxDB (v9+) requires that you are using Typescript v3.8 or higher.\nOur way to go is"}),"\n",(0,o.jsxs)(t.ul,{children:["\n",(0,o.jsx)(t.li,{children:"First define what the documents look like"}),"\n",(0,o.jsx)(t.li,{children:"Then define what the collections look like"}),"\n",(0,o.jsx)(t.li,{children:"Then define what the database looks like"}),"\n"]}),"\n",(0,o.jsx)(t.h2,{id:"declare-the-types",children:"Declare the types"}),"\n",(0,o.jsx)(t.p,{children:"First you import the types from RxDB."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"import {\n    createRxDatabase,\n    RxDatabase,\n    RxCollection,\n    RxJsonSchema,\n    RxDocument,\n} from 'rxdb';\n"})}),"\n",(0,o.jsx)(t.h2,{id:"create-the-base-document-type",children:"Create the base document type"}),"\n",(0,o.jsx)(t.p,{children:"First we have to define the TypeScript type of the documents of a collection:"}),"\n",(0,o.jsx)(t.h3,{id:"option-a-create-the-document-type-from-the-schema",children:"Option A: Create the document type from the schema"}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"import {\n    toTypedRxJsonSchema,\n    ExtractDocumentTypeFromTypedRxJsonSchema,\n    RxJsonSchema\n} from 'rxdb';\nexport const heroSchemaLiteral = {\n    title: 'hero schema',\n    description: 'describes a human being',\n    version: 0,\n    keyCompression: true,\n    primaryKey: 'passportId',\n    type: 'object',\n    properties: {\n        passportId: {\n            type: 'string',\n            maxLength: 100 // <- the primary key must have set maxLength\n        },\n        firstName: {\n            type: 'string'\n        },\n        lastName: {\n            type: 'string'\n        },\n        age: {\n            type: 'integer'\n        }\n    },\n    required: ['firstName', 'lastName', 'passportId'],\n    indexes: ['firstName']\n} as const; // <- It is important to set 'as const' to preserve the literal type\nconst schemaTyped = toTypedRxJsonSchema(heroSchemaLiteral);\n\n// aggregate the document type from the schema\nexport type HeroDocType = ExtractDocumentTypeFromTypedRxJsonSchema<typeof schemaTyped>;\n\n// create the typed RxJsonSchema from the literal typed object.\nexport const heroSchema: RxJsonSchema<HeroDocType> = heroSchemaLiteral;\n"})}),"\n",(0,o.jsx)(t.h3,{id:"option-b-manually-type-the-document-type",children:"Option B: Manually type the document type"}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"export type HeroDocType = {\n    passportId: string;\n    firstName: string;\n    lastName: string;\n    age?: number; // optional\n};\n"})}),"\n",(0,o.jsx)(t.h3,{id:"option-c-generate-the-document-type-from-schema-during-build-time",children:"Option C: Generate the document type from schema during build time"}),"\n",(0,o.jsxs)(t.p,{children:["If your schema is in a ",(0,o.jsx)(t.code,{children:".json"})," file or generated from somewhere else, you might generate the typings with the ",(0,o.jsx)(t.a,{href:"https://www.npmjs.com/package/json-schema-to-typescript",children:"json-schema-to-typescript"})," module."]}),"\n",(0,o.jsx)(t.h2,{id:"types-for-the-orm-methods",children:"Types for the ORM methods"}),"\n",(0,o.jsx)(t.p,{children:"We also add some ORM-methods for the document."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"export type HeroDocMethods = {\n    scream: (v: string) => string;\n};\n"})}),"\n",(0,o.jsx)(t.p,{children:"We can merge these into our HeroDocument."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"export type HeroDocument = RxDocument<HeroDocType, HeroDocMethods>;\n"})}),"\n",(0,o.jsx)(t.p,{children:"Now we can define type for the collection which contains the documents."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"\n// we declare one static ORM-method for the collection\nexport type HeroCollectionMethods = {\n    countAllDocuments: () => Promise<number>;\n}\n\n// and then merge all our types\nexport type HeroCollection = RxCollection<HeroDocType, HeroDocMethods, HeroCollectionMethods>;\n"})}),"\n",(0,o.jsx)(t.p,{children:"Before we can define the database, we make a helper-type which contains all collections of it."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"export type MyDatabaseCollections = {\n    heroes: HeroCollection\n}\n"})}),"\n",(0,o.jsx)(t.p,{children:"Now the database."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"export type MyDatabase = RxDatabase<MyDatabaseCollections>;\n"})}),"\n",(0,o.jsx)(t.h2,{id:"using-the-types",children:"Using the types"}),"\n",(0,o.jsx)(t.p,{children:"Now that we have declare all our types, we can use them."}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-typescript",children:"\n/**\n * create database and collections\n */\nconst myDatabase: MyDatabase = await createRxDatabase<MyDatabaseCollections>({\n    name: 'mydb',\n    storage: getRxStorageDexie()\n});\n\nconst heroSchema: RxJsonSchema<HeroDocType> = {\n    title: 'human schema',\n    description: 'describes a human being',\n    version: 0,\n    keyCompression: true,\n    primaryKey: 'passportId',\n    type: 'object',\n    properties: {\n        passportId: {\n            type: 'string'\n        },\n        firstName: {\n            type: 'string'\n        },\n        lastName: {\n            type: 'string'\n        },\n        age: {\n            type: 'integer'\n        }\n    },\n    required: ['passportId', 'firstName', 'lastName']\n};\n\nconst heroDocMethods: HeroDocMethods = {\n    scream: function(this: HeroDocument, what: string) {\n        return this.firstName + ' screams: ' + what.toUpperCase();\n    }\n};\n\nconst heroCollectionMethods: HeroCollectionMethods = {\n    countAllDocuments: async function(this: HeroCollection) {\n        const allDocs = await this.find().exec();\n        return allDocs.length;\n    }\n};\n\nawait myDatabase.addCollections({\n    heroes: {\n        schema: heroSchema,\n        methods: heroDocMethods,\n        statics: heroCollectionMethods\n    }\n});\n\n// add a postInsert-hook\nmyDatabase.heroes.postInsert(\n    function myPostInsertHook(\n        this: HeroCollection, // own collection is bound to the scope\n        docData: HeroDocType, // documents data\n        doc: HeroDocument // RxDocument\n    ) {\n        console.log('insert to ' + this.name + '-collection: ' + doc.firstName);\n    },\n    false // not async\n);\n\n/**\n * use the database\n */\n\n// insert a document\nconst hero: HeroDocument = await myDatabase.heroes.insert({\n    passportId: 'myId',\n    firstName: 'piotr',\n    lastName: 'potter',\n    age: 5\n});\n\n// access a property\nconsole.log(hero.firstName);\n\n// use a orm method\nhero.scream('AAH!');\n\n// use a static orm method from the collection\nconst amount: number = await myDatabase.heroes.countAllDocuments();\nconsole.log(amount);\n\n\n/**\n * clean up\n */\nmyDatabase.destroy();\n"})}),"\n",(0,o.jsx)(t.h2,{id:"known-problems",children:"Known Problems"}),"\n",(0,o.jsxs)(t.p,{children:["RxDB uses the ",(0,o.jsx)(t.a,{href:"https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakRef",children:"WeakRef API"}),". If your typescript bundler throws the error ",(0,o.jsx)(t.code,{children:"TS2304: Cannot find name 'WeakRef'"}),", you have to add ",(0,o.jsx)(t.code,{children:"ES2021.WeakRef"})," to ",(0,o.jsx)(t.code,{children:"compilerOptions.lib"})," in your ",(0,o.jsx)(t.code,{children:"tsconfig.json"}),"."]}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-json",children:'{\n    "compilerOptions": {\n        "lib": ["ES2020", "ES2021.WeakRef"]\n    }\n}\n'})})]})}function p(e={}){const{wrapper:t}={...(0,s.a)(),...e.components};return t?(0,o.jsx)(t,{...e,children:(0,o.jsx)(h,{...e})}):h(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>i,a:()=>a});var o=n(7294);const s={},r=o.createContext(s);function a(e){const t=o.useContext(r);return o.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function i(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:a(e.components),o.createElement(r.Provider,{value:t},e.children)}}}]);