"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[8856],{3274:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>l,contentTitle:()=>s,default:()=>d,frontMatter:()=>r,metadata:()=>a,toc:()=>c});var o=t(5893),i=t(1151);const r={title:"Plugins",slug:"plugins.html"},s="Creating Plugins",a={id:"plugins",title:"Plugins",description:"Creating your own plugin is very simple. A plugin is basically a javascript-object which overwrites or extends RxDB's internal classes, prototypes, and hooks.",source:"@site/docs/plugins.md",sourceDirName:".",slug:"/plugins.html",permalink:"/plugins.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/plugins.md",tags:[],version:"current",frontMatter:{title:"Plugins",slug:"plugins.html"},sidebar:"tutorialSidebar",previous:{title:"Logger \ud83d\udc51",permalink:"/logger.html"},next:{title:"RxDB NoSQL Performance Tips",permalink:"/nosql-performance-tips.html"}},l={},c=[{value:"rxdb",id:"rxdb",level:2},{value:"prototypes",id:"prototypes",level:2},{value:"overwritable",id:"overwritable",level:2}];function p(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",p:"p",pre:"pre",...(0,i.a)(),...e.components};return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(n.h1,{id:"creating-plugins",children:"Creating Plugins"}),"\n",(0,o.jsx)(n.p,{children:"Creating your own plugin is very simple. A plugin is basically a javascript-object which overwrites or extends RxDB's internal classes, prototypes, and hooks."}),"\n",(0,o.jsx)(n.p,{children:"A basic plugin:"}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"\nconst myPlugin = {\n        rxdb: true, // this must be true so rxdb knows that this is a rxdb-plugin\n        /**\n         * (optional) init() method\n         * that is called when the plugin is added to RxDB for the first time.\n         */\n        init() {\n            // import other plugins or initialize stuff\n        },\n        /**\n         * every value in this object can manipulate the prototype of the keynames class\n         * You can manipulate every prototype in this list:\n         * @link https://github.com/pubkey/rxdb/blob/master/src/plugin.ts#L22\n         */\n        prototypes: {\n            /**\n             * add a function to RxCollection so you can call 'myCollection.hello()'\n             *\n             * @param {object} prototype of RxCollection\n             */\n            RxCollection: (proto) => {\n                proto.hello = function() {\n                    return 'world';\n                };\n            }\n        },\n        /**\n         * some methods are static and can be overwritten in the overwritable-object\n         */\n        overwritable: {\n            validatePassword: function(password) {\n                if (password && typeof password !== 'string' || password.length < 10)\n                    throw new TypeError('password is not valid');\n            }\n        },\n        /**\n         * you can add hooks to the hook-list\n         */\n        hooks: {\n            /**\n             * add a `foo` property to each document. You can then call myDocument.foo (='bar')\n             */\n            createRxDocument: {\n                /**\n                 * You can either add the hook running 'before' or 'after'\n                 * the hooks of other plugins.\n                 */\n                after: function(doc) {\n                    doc.foo = 'bar';\n                }\n            }\n        }\n};\n\n// now you can import the plugin into rxdb\naddRxPlugin(myPlugin);\n"})}),"\n",(0,o.jsx)(n.h1,{id:"properties",children:"Properties"}),"\n",(0,o.jsx)(n.h2,{id:"rxdb",children:"rxdb"}),"\n",(0,o.jsxs)(n.p,{children:["The ",(0,o.jsx)(n.code,{children:"rxdb"}),"-property signals that this plugin is an rxdb-plugin. The value should always be ",(0,o.jsx)(n.code,{children:"true"}),"."]}),"\n",(0,o.jsx)(n.h2,{id:"prototypes",children:"prototypes"}),"\n",(0,o.jsxs)(n.p,{children:["The ",(0,o.jsx)(n.code,{children:"prototypes"}),"-property contains a function for each of RxDB's internal prototype that you want to manipulate. Each function gets the prototype-object of the corresponding class as parameter and then can modify it. You can see a list of all available prototypes ",(0,o.jsx)(n.a,{href:"https://github.com/pubkey/rxdb/blob/master/src/plugin.ts",children:"here"})]}),"\n",(0,o.jsx)(n.h2,{id:"overwritable",children:"overwritable"}),"\n",(0,o.jsxs)(n.p,{children:["Some of RxDB's functions are not inside of a class-prototype but are static. You can set and overwrite them with the ",(0,o.jsx)(n.code,{children:"overwritable"}),"-object. You can see a list of all overwritables ",(0,o.jsx)(n.a,{href:"https://github.com/pubkey/rxdb/blob/master/src/overwritable.ts",children:"here"}),"."]}),"\n",(0,o.jsx)(n.h1,{id:"hooks",children:"hooks"}),"\n",(0,o.jsxs)(n.p,{children:["Sometimes you don't want to overwrite an existing RxDB-method, but extend it. You can do this by adding hooks which will be called each time the code jumps into the hooks corresponding call. You can find a list of all hooks ",(0,o.jsx)(n.a,{href:"https://github.com/pubkey/rxdb/blob/master/src/hooks.ts",children:"here"}),"."]}),"\n",(0,o.jsx)(n.h1,{id:"options",children:"options"}),"\n",(0,o.jsx)(n.p,{children:"RxDatabase and RxCollection have an additional options-parameter, which can be filled with any data required be the plugin."}),"\n",(0,o.jsx)(n.pre,{children:(0,o.jsx)(n.code,{className:"language-javascript",children:"const collection = myDatabase.addCollections({\n    foo: {\n        schema: mySchema,\n        options: { // anything can be passed into the options\n            foo: ()=>'bar'\n        }\n    }\n})\n\n// Afterwards you can use these options in your plugin.\n\ncollection.options.foo(); // 'bar'\n"})})]})}function d(e={}){const{wrapper:n}={...(0,i.a)(),...e.components};return n?(0,o.jsx)(n,{...e,children:(0,o.jsx)(p,{...e})}):p(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>a,a:()=>s});var o=t(7294);const i={},r=o.createContext(i);function s(e){const n=o.useContext(r);return o.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function a(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(i):e.components||i:s(e.components),o.createElement(r.Provider,{value:n},e.children)}}}]);