"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[5729],{43:(e,s,n)=>{n.r(s),n.d(s,{assets:()=>d,contentTitle:()=>r,default:()=>h,frontMatter:()=>i,metadata:()=>o,toc:()=>l});var t=n(5893),a=n(1151);const i={title:"RxDB Tradeoffs",slug:"rxdb-tradeoffs.html"},r="RxDB Tradeoffs",o={id:"rxdb-tradeoffs",title:"RxDB Tradeoffs",description:"RxDB is client-side, offline first Database for JavaScript applications.",source:"@site/docs/rxdb-tradeoffs.md",sourceDirName:".",slug:"/rxdb-tradeoffs.html",permalink:"/rxdb-tradeoffs.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rxdb-tradeoffs.md",tags:[],version:"current",frontMatter:{title:"RxDB Tradeoffs",slug:"rxdb-tradeoffs.html"}},d={},l=[{value:"Why not SQL syntax",id:"why-not-sql-syntax",level:2},{value:"SQL is made for database servers",id:"sql-is-made-for-database-servers",level:3},{value:"Typescript support",id:"typescript-support",level:3},{value:"Composeable queries",id:"composeable-queries",level:3},{value:"Why Document based (NoSQL)",id:"why-document-based-nosql",level:2},{value:"Javascript is made to work with objects",id:"javascript-is-made-to-work-with-objects",level:3},{value:"Caching",id:"caching",level:3},{value:"EventReduce",id:"eventreduce",level:3},{value:"Easier to use with typescript",id:"easier-to-use-with-typescript",level:3},{value:"Why no transactions",id:"why-no-transactions",level:2},{value:"Why no relations",id:"why-no-relations",level:2},{value:"Why is a schema required",id:"why-is-a-schema-required",level:2}];function c(e){const s={a:"a",code:"code",em:"em",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,a.a)(),...e.components};return(0,t.jsxs)(t.Fragment,{children:[(0,t.jsx)(s.h1,{id:"rxdb-tradeoffs",children:"RxDB Tradeoffs"}),"\n",(0,t.jsxs)(s.p,{children:[(0,t.jsx)(s.a,{href:"https://rxdb.info",children:"RxDB"})," is client-side, offline first Database for JavaScript applications.\nWhile RxDB could be used on the server side, most people use it on the client side together with an UI based application.\nTherefore RxDB was optimized for client side applications and had to take completely different tradeoffs than what a server side database would do."]}),"\n",(0,t.jsx)(s.h2,{id:"why-not-sql-syntax",children:"Why not SQL syntax"}),"\n",(0,t.jsxs)(s.p,{children:["When you ask people which database they would want for browsers, the most answer I hear is ",(0,t.jsx)(s.em,{children:"something SQL based like SQLite"}),".\nThis makes sense, SQL is a query language that most developers had learned in school/university and it is reusable across various database solutions.\nBut for RxDB (and other client side databases), using SQL is not a good option and instead it operates on document writes and the JSON based ",(0,t.jsx)(s.strong,{children:"Mango-query"})," syntax for querying."]}),"\n",(0,t.jsx)(s.pre,{children:(0,t.jsx)(s.code,{className:"language-ts",children:"// A Mango Query\nconst query = {\n    selector: {\n        age: {\n            $gt: 10\n        },\n        lastName: 'foo'\n    },\n    sort: [{ age: 'asc' }]\n};\n"})}),"\n",(0,t.jsx)(s.h3,{id:"sql-is-made-for-database-servers",children:"SQL is made for database servers"}),"\n",(0,t.jsxs)(s.p,{children:["SQL is made to be used to run operations against a database server. You send a SQL string like ",(0,t.jsx)(s.code,{children:"SELECT SUM(column_name)..."})," to the database server and the server then runs all operations required to calculate the result and only send back that result.\nThis saves performance on the application side and ensures that the application itself is not blocked."]}),"\n",(0,t.jsxs)(s.p,{children:["But RxDB is a client-side database that runs ",(0,t.jsx)(s.strong,{children:"inside"})," of the application. There is no performance difference if the ",(0,t.jsx)(s.code,{children:"SUM()"})," query is run inside of the database or at the application level where a ",(0,t.jsx)(s.code,{children:"Array.reduce()"})," call calculates the result."]}),"\n",(0,t.jsx)(s.h3,{id:"typescript-support",children:"Typescript support"}),"\n",(0,t.jsxs)(s.p,{children:["SQL is ",(0,t.jsx)(s.code,{children:"string"})," based and therefore you need additional IDE tooling to ensure that your written database code is valid.\nUsing the Mango Query syntax instead, TypeScript can be used validate the queries and to autocomplete code and knows which fields do exist and which do not. By doing so, the correctness of queries can be ensured at compile-time instead of run-time."]}),"\n",(0,t.jsx)("p",{align:"center",children:(0,t.jsx)("img",{src:"./files/typescript-query-validation.png",alt:"TypeScript Query Validation"})}),"\n",(0,t.jsx)(s.h3,{id:"composeable-queries",children:"Composeable queries"}),"\n",(0,t.jsxs)(s.p,{children:["By using JSON based Mango Queries, it is easy to compose queries in plain JavaScript.\nFor example if you have any given query and want to add the condition ",(0,t.jsx)(s.code,{children:"user MUST BE 'foobar'"}),", you can just add the condition to the selector without having to parse and understand a complex SQL string."]}),"\n",(0,t.jsx)(s.pre,{children:(0,t.jsx)(s.code,{className:"language-ts",children:"query.selector.user = 'foobar';\n"})}),"\n",(0,t.jsx)(s.p,{children:"Even merging the selectors of multiple queries is not a problem:"}),"\n",(0,t.jsx)(s.pre,{children:(0,t.jsx)(s.code,{className:"language-ts",children:"queryA.selector = {\n    $and: [\n        queryA.selector,\n        queryB.selector\n    ]\n};\n"})}),"\n",(0,t.jsx)(s.h2,{id:"why-document-based-nosql",children:"Why Document based (NoSQL)"}),"\n",(0,t.jsx)(s.p,{children:"Like other NoSQL databases, RxDB operates data on document level. It has no concept of tables, rows and columns. Instead we have collections, documents and fields."}),"\n",(0,t.jsx)(s.h3,{id:"javascript-is-made-to-work-with-objects",children:"Javascript is made to work with objects"}),"\n",(0,t.jsx)(s.h3,{id:"caching",children:"Caching"}),"\n",(0,t.jsx)(s.h3,{id:"eventreduce",children:"EventReduce"}),"\n",(0,t.jsx)(s.h3,{id:"easier-to-use-with-typescript",children:"Easier to use with typescript"}),"\n",(0,t.jsx)(s.p,{children:"Because of the document based approach, TypeScript can know the exact type of the query response while a SQL query could return anything from a number over a set of rows or a complex construct."}),"\n",(0,t.jsx)(s.h2,{id:"why-no-transactions",children:"Why no transactions"}),"\n",(0,t.jsxs)(s.ul,{children:["\n",(0,t.jsx)(s.li,{children:"Does not work with offline-first"}),"\n",(0,t.jsx)(s.li,{children:"Does not work with multi-tab"}),"\n",(0,t.jsx)(s.li,{children:"Easier conflict handling on document level"}),"\n"]}),"\n",(0,t.jsx)(s.p,{children:"-- Instead of transactions, rxdb works with revisions"}),"\n",(0,t.jsx)(s.h2,{id:"why-no-relations",children:"Why no relations"}),"\n",(0,t.jsxs)(s.ul,{children:["\n",(0,t.jsx)(s.li,{children:"Does not work with easy replication"}),"\n"]}),"\n",(0,t.jsx)(s.h2,{id:"why-is-a-schema-required",children:"Why is a schema required"}),"\n",(0,t.jsxs)(s.ul,{children:["\n",(0,t.jsx)(s.li,{children:"migration of data on clients is hard"}),"\n",(0,t.jsx)(s.li,{children:"Why jsonschema"}),"\n"]}),"\n",(0,t.jsx)(s.h2,{id:""})]})}function h(e={}){const{wrapper:s}={...(0,a.a)(),...e.components};return s?(0,t.jsx)(s,{...e,children:(0,t.jsx)(c,{...e})}):c(e)}},1151:(e,s,n)=>{n.d(s,{Z:()=>o,a:()=>r});var t=n(7294);const a={},i=t.createContext(a);function r(e){const s=t.useContext(i);return t.useMemo((function(){return"function"==typeof e?e(s):{...s,...e}}),[s,e])}function o(e){let s;return s=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:r(e.components),t.createElement(i.Provider,{value:s},e.children)}}}]);