"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[6235],{6137:(e,n,o)=>{o.r(n),o.d(n,{assets:()=>a,contentTitle:()=>i,default:()=>h,frontMatter:()=>l,metadata:()=>r,toc:()=>c});var s=o(5893),t=o(1151);const l={title:"Middleware",slug:"middleware.html"},i="Middleware",r={id:"middleware",title:"Middleware",description:"RxDB supports middleware-hooks like mongoose.",source:"@site/docs/middleware.md",sourceDirName:".",slug:"/middleware.html",permalink:"/middleware.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/middleware.md",tags:[],version:"current",frontMatter:{title:"Middleware",slug:"middleware.html"},sidebar:"tutorialSidebar",previous:{title:"Transactions, Conflicts and Revisions",permalink:"/transactions-conflicts-revisions.html"},next:{title:"Query Cache",permalink:"/query-cache.html"}},a={},c=[{value:"List",id:"list",level:2},{value:"Why is there no validate-hook?",id:"why-is-there-no-validate-hook",level:3},{value:"Use Cases",id:"use-cases",level:2},{value:"Usage",id:"usage",level:2},{value:"Insert",id:"insert",level:3},{value:"lifecycle",id:"lifecycle",level:4},{value:"preInsert",id:"preinsert",level:4},{value:"postInsert",id:"postinsert",level:4},{value:"Save",id:"save",level:3},{value:"lifecycle",id:"lifecycle-1",level:4},{value:"preSave",id:"presave",level:4},{value:"postSave",id:"postsave",level:4},{value:"Remove",id:"remove",level:3},{value:"lifecycle",id:"lifecycle-2",level:4},{value:"preRemove",id:"preremove",level:4},{value:"postRemove",id:"postremove",level:4},{value:"postCreate",id:"postcreate",level:3}];function d(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",h4:"h4",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,t.a)(),...e.components};return(0,s.jsxs)(s.Fragment,{children:[(0,s.jsx)(n.h1,{id:"middleware",children:"Middleware"}),"\n",(0,s.jsxs)(n.p,{children:["RxDB supports middleware-hooks like ",(0,s.jsx)(n.a,{href:"http://mongoosejs.com/docs/middleware.html",children:"mongoose"}),".\nMiddleware (also called pre and post hooks) are functions which are passed control during execution of asynchronous functions.\nThe hooks are specified on RxCollection-level and help to create a clear what-happens-when-structure of your code."]}),"\n",(0,s.jsx)(n.p,{children:"Hooks can be defined to run parallel or as series one after another.\nHooks can be synchronous or asynchronous when they return a Promise.\nTo stop the operation at a specific hook, throw an error."}),"\n",(0,s.jsx)(n.h2,{id:"list",children:"List"}),"\n",(0,s.jsx)(n.p,{children:"RxDB supports the following hooks:"}),"\n",(0,s.jsxs)(n.ul,{children:["\n",(0,s.jsx)(n.li,{children:"preInsert"}),"\n",(0,s.jsx)(n.li,{children:"postInsert"}),"\n",(0,s.jsx)(n.li,{children:"preSave"}),"\n",(0,s.jsx)(n.li,{children:"postSave"}),"\n",(0,s.jsx)(n.li,{children:"preRemove"}),"\n",(0,s.jsx)(n.li,{children:"postRemove"}),"\n",(0,s.jsx)(n.li,{children:"postCreate"}),"\n"]}),"\n",(0,s.jsx)(n.h3,{id:"why-is-there-no-validate-hook",children:"Why is there no validate-hook?"}),"\n",(0,s.jsxs)(n.p,{children:["Different to mongoose, the validation on document-data is running on the field-level for every change to a document.\nThis means if you set the value ",(0,s.jsx)(n.code,{children:"lastName"})," of a RxDocument, then the validation will only run on the changed field, not the whole document.\nTherefore it is not useful to have validate-hooks when a document is written to the database."]}),"\n",(0,s.jsx)(n.h2,{id:"use-cases",children:"Use Cases"}),"\n",(0,s.jsx)(n.p,{children:"Middleware are useful for atomizing model logic and avoiding nested blocks of async code.\nHere are some other ideas:"}),"\n",(0,s.jsxs)(n.ul,{children:["\n",(0,s.jsx)(n.li,{children:"complex validation"}),"\n",(0,s.jsx)(n.li,{children:"removing dependent documents"}),"\n",(0,s.jsx)(n.li,{children:"asynchronous defaults"}),"\n",(0,s.jsx)(n.li,{children:"asynchronous tasks that a certain action triggers"}),"\n",(0,s.jsx)(n.li,{children:"triggering custom events"}),"\n",(0,s.jsx)(n.li,{children:"notifications"}),"\n"]}),"\n",(0,s.jsx)(n.h2,{id:"usage",children:"Usage"}),"\n",(0,s.jsxs)(n.p,{children:["All hooks have the plain data as first parameter, and all but ",(0,s.jsx)(n.code,{children:"preInsert"})," also have the ",(0,s.jsx)(n.code,{children:"RxDocument"}),"-instance as second parameter. If you want to modify the data in the hook, change attributes of the first parameter."]}),"\n",(0,s.jsxs)(n.p,{children:["All hook functions are also ",(0,s.jsx)(n.code,{children:"this"}),"-bind to the ",(0,s.jsx)(n.code,{children:"RxCollection"}),"-instance."]}),"\n",(0,s.jsx)(n.h3,{id:"insert",children:"Insert"}),"\n",(0,s.jsx)(n.p,{children:"An insert-hook receives the data-object of the new document."}),"\n",(0,s.jsx)(n.h4,{id:"lifecycle",children:"lifecycle"}),"\n",(0,s.jsxs)(n.ul,{children:["\n",(0,s.jsx)(n.li,{children:"RxCollection.insert is called"}),"\n",(0,s.jsx)(n.li,{children:"preInsert series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"preInsert parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"schema validation runs"}),"\n",(0,s.jsx)(n.li,{children:"new document is written to database"}),"\n",(0,s.jsx)(n.li,{children:"postInsert series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"postInsert parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"event is emitted to RxDatabase and RxCollection"}),"\n"]}),"\n",(0,s.jsx)(n.h4,{id:"preinsert",children:"preInsert"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.preInsert(function(plainData){\n    // set age to 50 before saving\n    plainData.age = 50;\n}, false);\n\n// parallel\nmyCollection.preInsert(function(plainData){\n\n}, true);\n\n// async\nmyCollection.preInsert(function(plainData){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n\n// stop the insert-operation\nmyCollection.preInsert(function(plainData){\n  throw new Error('stop');\n}, false);\n"})}),"\n",(0,s.jsx)(n.h4,{id:"postinsert",children:"postInsert"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.postInsert(function(plainData, rxDocument){\n\n}, false);\n\n// parallel\nmyCollection.postInsert(function(plainData, rxDocument){\n\n}, true);\n\n// async\nmyCollection.postInsert(function(plainData, rxDocument){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n"})}),"\n",(0,s.jsx)(n.h3,{id:"save",children:"Save"}),"\n",(0,s.jsx)(n.p,{children:"A save-hook receives the document which is saved."}),"\n",(0,s.jsx)(n.h4,{id:"lifecycle-1",children:"lifecycle"}),"\n",(0,s.jsxs)(n.ul,{children:["\n",(0,s.jsx)(n.li,{children:"RxDocument.save is called"}),"\n",(0,s.jsx)(n.li,{children:"preSave series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"preSave parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"updated document is written to database"}),"\n",(0,s.jsx)(n.li,{children:"postSave series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"postSave parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"event is emitted to RxDatabase and RxCollection"}),"\n"]}),"\n",(0,s.jsx)(n.h4,{id:"presave",children:"preSave"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.preSave(function(plainData, rxDocument){\n    // modify anyField before saving\n    plainData.anyField = 'anyValue';\n}, false);\n\n// parallel\nmyCollection.preSave(function(plainData, rxDocument){\n\n}, true);\n\n// async\nmyCollection.preSave(function(plainData, rxDocument){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n\n// stop the save-operation\nmyCollection.preSave(function(plainData, rxDocument){\n  throw new Error('stop');\n}, false);\n"})}),"\n",(0,s.jsx)(n.h4,{id:"postsave",children:"postSave"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.postSave(function(plainData, rxDocument){\n\n}, false);\n\n// parallel\nmyCollection.postSave(function(plainData, rxDocument){\n\n}, true);\n\n// async\nmyCollection.postSave(function(plainData, rxDocument){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n"})}),"\n",(0,s.jsx)(n.h3,{id:"remove",children:"Remove"}),"\n",(0,s.jsx)(n.p,{children:"An remove-hook receives the document which is removed."}),"\n",(0,s.jsx)(n.h4,{id:"lifecycle-2",children:"lifecycle"}),"\n",(0,s.jsxs)(n.ul,{children:["\n",(0,s.jsx)(n.li,{children:"RxDocument.remove is called"}),"\n",(0,s.jsx)(n.li,{children:"preRemove series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"preRemove parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"deleted document is written to database"}),"\n",(0,s.jsx)(n.li,{children:"postRemove series-hooks"}),"\n",(0,s.jsx)(n.li,{children:"postRemove parallel-hooks"}),"\n",(0,s.jsx)(n.li,{children:"event is emitted to RxDatabase and RxCollection"}),"\n"]}),"\n",(0,s.jsx)(n.h4,{id:"preremove",children:"preRemove"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.preRemove(function(plainData, rxDocument){\n\n}, false);\n\n// parallel\nmyCollection.preRemove(function(plainData, rxDocument){\n\n}, true);\n\n// async\nmyCollection.preRemove(function(plainData, rxDocument){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n\n// stop the remove-operation\nmyCollection.preRemove(function(plainData, rxDocument){\n  throw new Error('stop');\n}, false);\n"})}),"\n",(0,s.jsx)(n.h4,{id:"postremove",children:"postRemove"}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"// series\nmyCollection.postRemove(function(plainData, rxDocument){\n\n}, false);\n\n// parallel\nmyCollection.postRemove(function(plainData, rxDocument){\n\n}, true);\n\n// async\nmyCollection.postRemove(function(plainData, rxDocument){\n  return new Promise(res => setTimeout(res, 100));\n}, false);\n"})}),"\n",(0,s.jsx)(n.h3,{id:"postcreate",children:"postCreate"}),"\n",(0,s.jsxs)(n.p,{children:["This hook is called whenever a ",(0,s.jsx)(n.code,{children:"RxDocument"})," is constructed.\nYou can use ",(0,s.jsx)(n.code,{children:"postCreate"})," to modify every RxDocument-instance of the collection.\nThis adds a flexible way to add specify behavior to every document. You can also use it to add custom getter/setter to documents. PostCreate-hooks cannot be ",(0,s.jsx)(n.strong,{children:"asynchronous"}),"."]}),"\n",(0,s.jsx)(n.pre,{children:(0,s.jsx)(n.code,{className:"language-js",children:"myCollection.postCreate(function(plainData, rxDocument){\n    Object.defineProperty(rxDocument, 'myField', {\n        get: () => 'foobar',\n    });\n});\n\nconst doc = await myCollection.findOne().exec();\n\nconsole.log(doc.myField);\n// 'foobar'\n"})}),"\n",(0,s.jsxs)(n.p,{children:["Notice: This hook does not run on already created or cached documents. Make sure to add ",(0,s.jsx)(n.code,{children:"postCreate"}),"-hooks before interacting with the collection."]})]})}function h(e={}){const{wrapper:n}={...(0,t.a)(),...e.components};return n?(0,s.jsx)(n,{...e,children:(0,s.jsx)(d,{...e})}):d(e)}},1151:(e,n,o)=>{o.d(n,{Z:()=>r,a:()=>i});var s=o(7294);const t={},l=s.createContext(t);function i(e){const n=s.useContext(l);return s.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function r(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(t):e.components||t:i(e.components),s.createElement(l.Provider,{value:n},e.children)}}}]);