"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[1314],{2203:(e,n,t)=>{t.r(n),t.d(n,{assets:()=>d,contentTitle:()=>o,default:()=>p,frontMatter:()=>a,metadata:()=>i,toc:()=>c});var r=t(5893),s=t(1151);const a={title:"Encryption",slug:"encryption.html",description:"Explore RxDB's \ud83d\udd12 encryption plugin for enhanced data security in web and native apps, featuring password-based encryption and secure storage."},o="\ud83d\udd12 Encrypted Local Storage with RxDB",i={id:"encryption",title:"Encryption",description:"Explore RxDB's \ud83d\udd12 encryption plugin for enhanced data security in web and native apps, featuring password-based encryption and secure storage.",source:"@site/docs/encryption.md",sourceDirName:".",slug:"/encryption.html",permalink:"/encryption.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/encryption.md",tags:[],version:"current",frontMatter:{title:"Encryption",slug:"encryption.html",description:"Explore RxDB's \ud83d\udd12 encryption plugin for enhanced data security in web and native apps, featuring password-based encryption and secure storage."},sidebar:"tutorialSidebar",previous:{title:"Migration Storage",permalink:"/migration-storage.html"},next:{title:"Key Compression",permalink:"/key-compression.html"}},d={},c=[{value:"Querying encrypted data",id:"querying-encrypted-data",level:2},{value:"Password handling",id:"password-handling",level:2},{value:"Asymmetric encryption",id:"asymmetric-encryption",level:2},{value:"Using the RxDB Encryption Plugins",id:"using-the-rxdb-encryption-plugins",level:2},{value:"Changing the password",id:"changing-the-password",level:2},{value:"Encrypted attachments",id:"encrypted-attachments",level:2}];function h(e){const n={a:"a",code:"code",h1:"h1",h2:"h2",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,r.jsxs)(r.Fragment,{children:[(0,r.jsx)(n.h1,{id:"-encrypted-local-storage-with-rxdb",children:"\ud83d\udd12 Encrypted Local Storage with RxDB"}),"\n",(0,r.jsxs)(n.p,{children:["The RxDB encryption plugin empowers developers to fortify their applications' data security. It seamlessly integrates with ",(0,r.jsx)(n.a,{href:"https://rxdb.info/",children:"RxDB"}),", allowing for the secure storage and retrieval of documents by ",(0,r.jsx)(n.strong,{children:"encrypting them with a password"}),". With encryption and decryption processes handled internally, it ensures that sensitive data remains confidential, making it a valuable tool for building robust, privacy-conscious applications. The encryption works on all RxDB supported devices types like the ",(0,r.jsx)(n.strong,{children:"browser"}),", ",(0,r.jsx)(n.strong,{children:"ReactNative"})," or ",(0,r.jsx)(n.strong,{children:"Node.js"}),"."]}),"\n",(0,r.jsx)("p",{align:"center",children:(0,r.jsx)("img",{src:"./files/icons/with-gradient/storage-layer.svg",alt:"Encryption Storage Layer",height:"60"})}),"\n",(0,r.jsx)(n.p,{children:"Encrypting client-side stored data in RxDB offers numerous advantages:"}),"\n",(0,r.jsxs)(n.ul,{children:["\n",(0,r.jsxs)(n.li,{children:[(0,r.jsx)(n.strong,{children:"Enhanced Security"}),": In the unfortunate event of a user's device being stolen, the encrypted data remains safeguarded on the hard drive, inaccessible without the correct password."]}),"\n",(0,r.jsxs)(n.li,{children:[(0,r.jsx)(n.strong,{children:"Access Control"}),": You can retain control over stored data by revoking access at any time simply by withholding the password."]}),"\n",(0,r.jsxs)(n.li,{children:[(0,r.jsx)(n.strong,{children:"Tamper proof"})," Other applications on the device cannot read out the stored data when the password is only kept in the process-specific memory"]}),"\n"]}),"\n",(0,r.jsx)(n.h2,{id:"querying-encrypted-data",children:"Querying encrypted data"}),"\n",(0,r.jsxs)(n.p,{children:["RxDB handles the encryption and decryption of data internally. This means that when you work with a RxDocument, you can access the properties of the document just like you would with normal, unencrypted data. RxDB automatically decrypts the data for you when you retrieve it, making it transparent to your application code.\nThis means the encryption works with all ",(0,r.jsx)(n.a,{href:"/rx-storage.html",children:"RxStorage"})," like ",(0,r.jsx)(n.strong,{children:"SQLite"}),", ",(0,r.jsx)(n.strong,{children:"IndexedDB"}),", ",(0,r.jsx)(n.strong,{children:"OPFS"})," and so on."]}),"\n",(0,r.jsxs)(n.p,{children:["However, there's a limitation when it comes to querying encrypted fields. ",(0,r.jsx)(n.strong,{children:"Encrypted fields cannot be used as operators in queries"}),'. This means you cannot perform queries like "find all documents where the encrypted field equals a certain value." RxDB does not expose the encrypted data in a way that allows direct querying based on the encrypted content. To filter or search for documents based on the contents of encrypted fields, you would need to first decrypt the data and then perform the query, which might not be efficient or practical in some cases.\nYou could however use the ',(0,r.jsx)(n.a,{href:"/rx-storage-memory-synced.html",children:"memory synced"})," RxStorage to replicate the encrypted documents into a non-encrypted in-memory storage and then query them like normal."]}),"\n",(0,r.jsx)(n.h2,{id:"password-handling",children:"Password handling"}),"\n",(0,r.jsx)(n.p,{children:"RxDB does not define how you should store or retrieve the encryption password. It only requires you to provide the password on database creation which grants you flexibility in how you manage encryption passwords.\nYou could ask the user on app-start to insert the password, or you can retrieve the password from your backend on app start (or revoke access by no longer providing the password)."}),"\n",(0,r.jsx)(n.h2,{id:"asymmetric-encryption",children:"Asymmetric encryption"}),"\n",(0,r.jsxs)(n.p,{children:["The encryption plugin itself uses ",(0,r.jsx)(n.strong,{children:"symmetric encryption"})," with a password to guarantee best performance when reading and storing data.\nIt is not able to do ",(0,r.jsx)(n.strong,{children:"Asymmetric encryption"})," by itself. If you need Asymmetric encryption with a private/publicKey, it is recommended to encrypted the password itself with the asymentric keys and store the encrypted password beside the other data. On app-start you can decrypt the password with the private key and use the decrypted passwort in the RxDB encryption plugin"]}),"\n",(0,r.jsx)(n.h2,{id:"using-the-rxdb-encryption-plugins",children:"Using the RxDB Encryption Plugins"}),"\n",(0,r.jsx)(n.p,{children:"RxDB currently has two plugins for encryption:"}),"\n",(0,r.jsxs)(n.ul,{children:["\n",(0,r.jsxs)(n.li,{children:["The free ",(0,r.jsx)(n.code,{children:"encryption-crypto-js"})," plugin that is based on the ",(0,r.jsx)(n.code,{children:"AES"})," algorithm of the ",(0,r.jsx)(n.a,{href:"https://www.npmjs.com/package/crypto-js",children:"crypto-js"})," library"]}),"\n",(0,r.jsxs)(n.li,{children:["The ",(0,r.jsx)(n.a,{href:"/premium",children:"\ud83d\udc51 premium"})," ",(0,r.jsx)(n.code,{children:"encryption-web-crypto"})," plugin that is based on the native ",(0,r.jsx)(n.a,{href:"https://developer.mozilla.org/en-US/docs/Web/API/Web_Crypto_API",children:"Web Crypto API"})," which makes it faster and more secure to use. Document inserts are about 10x faster compared to ",(0,r.jsx)(n.code,{children:"crypto-js"})," and it has a smaller build size because it uses the browsers API instead of bundling an npm module."]}),"\n"]}),"\n",(0,r.jsxs)(n.p,{children:["An RxDB encryption plugin is a wrapper around any other ",(0,r.jsx)(n.a,{href:"/rx-storage.html",children:"RxStorage"}),"."]}),"\n",(0,r.jsxs)(n.ul,{children:["\n",(0,r.jsx)(n.li,{children:"You first have to wrap your RxStorage with the encryption"}),"\n",(0,r.jsxs)(n.li,{children:["Then use that as ",(0,r.jsx)(n.code,{children:"RxStorage"})," when calling ",(0,r.jsx)(n.code,{children:"createRxDatabase()"})]}),"\n",(0,r.jsxs)(n.li,{children:["Also you have to set a ",(0,r.jsx)(n.strong,{children:"password"})," when creating the database. The format of the password depends on which encryption plugin is used."]}),"\n",(0,r.jsxs)(n.li,{children:["To define a field as being encrypted, you have to add it to the ",(0,r.jsx)(n.code,{children:"encrypted"})," fields list in the schema."]}),"\n"]}),"\n",(0,r.jsx)(n.pre,{children:(0,r.jsx)(n.code,{className:"language-ts",children:"import { wrappedKeyEncryptionCryptoJsStorage } from 'rxdb/plugins/encryption-crypto-js';\nimport { getRxStorageDexie } from 'rxdb/plugins/storage-dexie';\n\n\n// wrap the normal storage with the encryption plugin\nconst encryptedDexieStorage = wrappedKeyEncryptionCryptoJsStorage({\n    storage: getRxStorageDexie()\n});\n\n// create an encrypted database\nconst db = await createRxDatabase<RxStylechaseCollections>({\n    name: 'mydatabase',\n    storage: encryptedDexieStorage,\n    password: 'sudoLetMeIn'\n});\n\n\nconst schema = {\n  version: 0,\n  primaryKey: 'id',\n  type: 'object',\n  properties: {\n      id: {\n          type: 'string',\n          maxLength: 100\n      },\n      secret: {\n          type: 'string'\n      },\n  },\n  required: ['id']\n  encrypted: ['secret']\n};\n\nawait db.addCollections({\n    myDocuments: {\n        schema\n    }\n})\n/* ... */\n"})}),"\n",(0,r.jsxs)(n.p,{children:["Or with the ",(0,r.jsx)(n.code,{children:"web-crypto"})," ",(0,r.jsx)(n.a,{href:"./premium",children:"\ud83d\udc51 premium"})," plugin:"]}),"\n",(0,r.jsx)(n.pre,{children:(0,r.jsx)(n.code,{className:"language-ts",children:"import {\n    wrappedKeyEncryptionWebCryptoStorage,\n    createPassword\n} from 'rxdb-premium/plugins/encryption-web-crypto';\nimport { getRxStorageIndexedDB } from 'rxdb-premium/plugins/storage-indexeddb';\n\n// wrap the normal storage with the encryption plugin\nconst encryptedIndexedDbStorage = wrappedKeyEncryptionWebCryptoStorage({\n    storage: getRxStorageIndexedDB()\n});\n\nconst myPasswordObject = {\n    // Algorithm can be oneOf: 'AES-CTR' | 'AES-CBC' | 'AES-GCM'\n    algorithm: 'AES-CTR',\n    password: 'myRandomPasswordWithMin8Length'\n};\n\n// create an encrypted database\nconst db = await createRxDatabase({\n    name: 'mydatabase',\n    storage: encryptedIndexedDbStorage,\n    password: myPasswordObject\n});\n\n/* ... */\n"})}),"\n",(0,r.jsx)(n.h2,{id:"changing-the-password",children:"Changing the password"}),"\n",(0,r.jsx)(n.p,{children:"The password is set database specific and it is not possible to change the password of a database. Opening an existing database with a different password will throw an error. To change the password you can either:"}),"\n",(0,r.jsxs)(n.ul,{children:["\n",(0,r.jsxs)(n.li,{children:["Use the ",(0,r.jsx)(n.a,{href:"/migration-storage.html",children:"storage migration plugin"})," to migrate the database state into a new database."]}),"\n",(0,r.jsxs)(n.li,{children:["Store a randomly created meta-password in a different RxDatabase as a value of a ",(0,r.jsx)(n.a,{href:"/rx-local-document.html",children:"local document"}),". Encrypt the meta password with the actual user password and read it out before creating the actual database."]}),"\n"]}),"\n",(0,r.jsx)(n.h2,{id:"encrypted-attachments",children:"Encrypted attachments"}),"\n",(0,r.jsxs)(n.p,{children:["To store the ",(0,r.jsx)(n.a,{href:"/rx-attachment.html",children:"attachments"})," data encrypted, you have to set ",(0,r.jsx)(n.code,{children:"encrypted: true"})," in the ",(0,r.jsx)(n.code,{children:"attachments"})," property of the schema."]}),"\n",(0,r.jsx)(n.pre,{children:(0,r.jsx)(n.code,{className:"language-ts",children:"const mySchema = {\n    version: 0,\n    type: 'object',\n    properties: {\n        /* ... */\n    },\n    attachments: {\n        encrypted: true // if true, the attachment-data will be encrypted with the db-password\n    }\n};\n"})})]})}function p(e={}){const{wrapper:n}={...(0,s.a)(),...e.components};return n?(0,r.jsx)(n,{...e,children:(0,r.jsx)(h,{...e})}):h(e)}},1151:(e,n,t)=>{t.d(n,{Z:()=>i,a:()=>o});var r=t(7294);const s={},a=r.createContext(s);function o(e){const n=r.useContext(a);return r.useMemo((function(){return"function"==typeof e?e(n):{...n,...e}}),[n,e])}function i(e){let n;return n=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:o(e.components),r.createElement(a.Provider,{value:n},e.children)}}}]);